/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeline;

import java.io.IOException;
import java.util.Date;
import org.zkforge.timeline.Bandinfo;
import org.zkforge.timeline.util.TimelineUtil;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Hotzone
extends XulElement {
    private Date _start = new Date();
    private Date _end = new Date();
    private int _magnify = 7;
    private String _unit = "week";
    private int _multiple = 1;

    public Date getStart() {
        return this._start;
    }

    public void setStart(Date start) {
        if (!this._start.equals(start)) {
            this._start = start;
            this.smartUpdate("start", TimelineUtil.formatDateTime(start));
        }
    }

    public Date getEnd() {
        return this._end;
    }

    public void setEnd(Date end) {
        if (!this._end.equals(end)) {
            this._end = end;
            this.smartUpdate("end", TimelineUtil.formatDateTime(end));
        }
    }

    public int getMagnify() {
        return this._magnify;
    }

    public void setMagnify(int magnify) {
        if (this._magnify != magnify) {
            this._magnify = magnify;
            this.smartUpdate("magnify", magnify);
        }
    }

    public String getUnit() {
        return this._unit;
    }

    public void setUnit(String unit) {
        if (!Objects.equals((Object)this._unit, (Object)unit)) {
            this._unit = unit;
            this.smartUpdate("unit", unit);
        }
    }

    public int getMultiple() {
        return this._multiple;
    }

    public void setMultiple(int multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            this.smartUpdate("multiple", multiple);
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        throw new UiException("Unsupported child for timeline");
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Bandinfo)) {
            throw new UiException("Unsupported parent for hotzone: " + parent);
        }
        super.setParent(parent);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "start", TimelineUtil.formatDateTime(this._start));
        this.render(renderer, "end", TimelineUtil.formatDateTime(this._end));
        if (this._magnify != 7) {
            renderer.render("magnify", this._magnify);
        }
        if (!"week".equals(this._unit)) {
            this.render(renderer, "unit", this._unit);
        }
        if (this._multiple != 1) {
            renderer.render("multiple", this._multiple);
        }
    }
}

