/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.zk.datatable;

import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.MultiPartElement;
import org.apache.ecs.XhtmlDocument;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.style;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.tbody;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.AttachmentData;
import org.compiere.model.MAttachment;
import org.compiere.model.MColumn;
import org.compiere.model.MImage;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MStyle;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.print.IHTMLExtension;
import org.compiere.print.MPrintFont;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.InstanceAttributeColumn;
import org.compiere.print.layout.InstanceAttributeData;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.util.CLogger;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.print.renderer.HTMLReportRenderer;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.zk.datatable.DataTableOptions;
import org.idempiere.zk.datatable.DatatableReportRendererConfiguration;
import org.osgi.service.component.annotations.Component;
import org.zkoss.zk.ui.Executions;

@Component(service={IReportRenderer.class}, immediate=true)
public class DatatableReportRenderer
implements IReportRenderer<DatatableReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(DatatableReportRenderer.class);
    private static final String JS_DATA_IDENTIFIER = "JS_DataTable";

    public String getId() {
        return "Datatables";
    }

    public String getName() {
        return this.getId();
    }

    public String getContentType() {
        return MediaType.HTML_UTF_8.toString();
    }

    public String getFileExtension() {
        return "datatables.html";
    }

    public void renderReport(ReportEngine reportEngine, DatatableReportRendererConfiguration configuration) {
        try {
            Language lang = configuration.getLanguage();
            if (lang == null) {
                lang = Language.getLoginLanguage();
            }
            Writer fw = null;
            fw = configuration.getOutputFile() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(configuration.getOutputFile(), false), Ini.getCharset()) : configuration.getOutputWriter();
            this.createHTML(reportEngine, new BufferedWriter(fw), configuration.isOnlyTable(), lang, configuration.getExtension(), configuration.isExport(), configuration.getContextPath());
        }
        catch (FileNotFoundException fnfe) {
            log.log(Level.SEVERE, "(f) - " + fnfe.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(f)", (Throwable)e);
            throw new AdempiereException((Throwable)e);
        }
    }

    public boolean isBinary() {
        return false;
    }

    public Class<DatatableReportRendererConfiguration> getConfigurationType() {
        return DatatableReportRendererConfiguration.class;
    }

    /*
     * WARNING - void declaration
     */
    private void createHTML(ReportEngine reportEngine, Writer writer, boolean onlyTable, Language language, IHTMLExtension extension, boolean isExport, String contextPath) {
        MPrintFormat printFormat = reportEngine.getPrintFormat();
        PrintData printData = reportEngine.getPrintData();
        MQuery reportEngineQuery = reportEngine.getQuery();
        LayoutEngine layout = reportEngine.getLayout();
        HashMap<HTMLReportRenderer.CSSInfo, List<HTMLReportRenderer.ColumnInfo>> mapCssInfo = new HashMap<HTMLReportRenderer.CSSInfo, List<HTMLReportRenderer.ColumnInfo>>();
        try {
            String cssPrefix;
            DataTableOptions dataTableOptions = new DataTableOptions(language.getLocale().toLanguageTag());
            ArrayList<Object> columns = new ArrayList<Object>();
            ArrayList<InstanceAttributeData> asiElements = new ArrayList<InstanceAttributeData>();
            int columnCount = 0;
            int col = 0;
            while (col < printFormat.getItemCount()) {
                MPrintFormatItem item = printFormat.getItem(col);
                if (item.isPrinted()) {
                    if (item.isNextLine() && item.getBelowColumn() >= 1) {
                        columns.add(item);
                    } else if (item.isTypeField() && item.isPrintInstanceAttributes()) {
                        InstanceAttributeData asiElement = new InstanceAttributeData(item, columnCount);
                        asiElement.readAttributesData(printData);
                        asiElements.add(asiElement);
                    } else {
                        columns.add(item);
                        ++columnCount;
                    }
                }
                ++col;
            }
            if (asiElements.size() > 0) {
                int columnCreated = 0;
                for (InstanceAttributeData data : asiElements) {
                    List instanceColumns = data.getColumns();
                    int index = data.getColumnIndex() + columnCreated;
                    for (InstanceAttributeColumn c : instanceColumns) {
                        columns.add(index, c);
                        ++index;
                        ++columnCreated;
                    }
                }
            }
            String string = cssPrefix = extension != null ? extension.getClassPrefix() : null;
            if (cssPrefix != null && cssPrefix.trim().length() == 0) {
                cssPrefix = null;
            }
            table parameterTable = null;
            if (!printFormat.isForm() && reportEngineQuery != null && reportEngineQuery.isActive()) {
                int rows;
                int n = rows = reportEngineQuery.getReportProcessQuery() != null ? reportEngineQuery.getReportProcessQuery().getRestrictionCount() : reportEngineQuery.getRestrictionCount();
                if (rows > 0) {
                    parameterTable = new table();
                    if (cssPrefix != null) {
                        parameterTable.setClass(cssPrefix + "-parameter-table");
                    } else {
                        parameterTable.setClass("parameter-table");
                    }
                    parameterTable.setNeedClosingTag(false);
                }
            }
            table table2 = new table();
            if (cssPrefix != null) {
                table2.setClass("cell-border compact hover " + cssPrefix + "-table");
            }
            table2.setID(JS_DATA_IDENTIFIER);
            table2.setNeedClosingTag(false);
            PrintWriter w = new PrintWriter(writer);
            XhtmlDocument doc = null;
            boolean minify = MSysConfig.getBooleanValue((String)"HTML_REPORT_MINIFY", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            if (onlyTable) {
                w.print(HTMLReportRenderer.compress((String)table2.toString(), (boolean)minify));
            } else {
                doc = new XhtmlDocument();
                doc.getHtml().setNeedClosingTag(false);
                doc.getBody().setNeedClosingTag(false);
                doc.appendHead("<meta charset=\"UTF-8\" />");
                if (extension != null && !Util.isEmpty((String)extension.getWebFontLinks(), (boolean)true)) {
                    doc.appendHead(extension.getWebFontLinks());
                }
                if (extension != null && extension.getStyleURL() != null) {
                    String pathStyleFile = extension.getFullPathStyle();
                    Path path = Paths.get(pathStyleFile, new String[0]);
                    List<String> styleLines = Files.readAllLines(path, Ini.getCharset());
                    Files.delete(path);
                    StringBuilder styleBuild = new StringBuilder();
                    for (String styleLine : styleLines) {
                        styleBuild.append(styleLine);
                    }
                    HTMLReportRenderer.appendInlineCss((XhtmlDocument)doc, (StringBuilder)styleBuild);
                }
                if (extension != null && extension.getScriptURL() != null && !isExport) {
                    script jslink = new script();
                    jslink.setLanguage("javascript");
                    jslink.setSrc(extension.getScriptURL());
                    doc.appendHead((Element)jslink);
                }
                this.appendStyles(doc, isExport, dataTableOptions.geti18nURL());
                this.appendScripts(doc, isExport);
                if (extension != null && !isExport) {
                    extension.setWebAttribute(doc.getBody());
                }
            }
            if (doc != null) {
                MPrintFormatItem item = null;
                int printColIndex = -1;
                int col2 = 0;
                while (col2 < columns.size()) {
                    Object colobj = columns.get(col2);
                    if (colobj instanceof MPrintFormatItem) {
                        item = (MPrintFormatItem)colobj;
                    } else if (colobj instanceof InstanceAttributeColumn) {
                        item = ((InstanceAttributeColumn)colobj).getPrintFormatItem();
                    }
                    if (!(item == null || item.isNextLine() && item.getBelowColumn() >= 1)) {
                        HTMLReportRenderer.addCssInfo((MPrintFormat)printFormat, (MPrintFormatItem)item, (int)(++printColIndex), mapCssInfo);
                    }
                    ++col2;
                }
                HTMLReportRenderer.appendInlineCss((XhtmlDocument)doc, mapCssInfo);
                StringBuilder styleBuild = new StringBuilder();
                MPrintTableFormat tf = printFormat.getTableFormat();
                HTMLReportRenderer.CSSInfo cssInfo = new HTMLReportRenderer.CSSInfo(tf.getPageHeader_Font(), tf.getPageHeaderFG_Color());
                if (cssPrefix != null) {
                    if (parameterTable != null) {
                        styleBuild.append("." + cssPrefix + "-parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("." + cssPrefix + "-table th").append(cssInfo.getCssRule());
                } else {
                    if (parameterTable != null) {
                        styleBuild.append("parameter-table th").append(cssInfo.getCssRule());
                    }
                    styleBuild.append("table th").append(cssInfo.getCssRule());
                }
                cssInfo = new HTMLReportRenderer.CSSInfo(tf.getParameter_Font(), tf.getParameter_Color());
                styleBuild.append(".tr-parameter td").append(cssInfo.getCssRule());
                cssInfo = new HTMLReportRenderer.CSSInfo(tf.getFunct_Font(), tf.getFunctFG_Color());
                styleBuild.append(".tr-function td").append(cssInfo.getCssRule());
                MPrintFont printFont = MPrintFont.get((int)printFormat.getAD_PrintFont_ID());
                Font base = printFont.getFont();
                Font newFont = new Font(base.getName(), 0, base.getSize() - 1);
                cssInfo = new HTMLReportRenderer.CSSInfo(newFont, null);
                styleBuild.append(".tr-level-1 td").append(cssInfo.getCssRule());
                newFont = new Font(base.getName(), 0, base.getSize() - 2);
                cssInfo = new HTMLReportRenderer.CSSInfo(newFont, null);
                styleBuild.append(".tr-level-2 td").append(cssInfo.getCssRule());
                styleBuild = new StringBuilder(styleBuild.toString().replaceAll(";", "!important;"));
                HTMLReportRenderer.appendInlineCss((XhtmlDocument)doc, (StringBuilder)styleBuild);
                w.print(doc.toString());
                w.print("<div class='" + cssPrefix + "-flex-container'>");
                String paraWrapId = null;
                if (parameterTable != null) {
                    void var33_52;
                    paraWrapId = cssPrefix + "-para-table-wrap";
                    w.print("<details id='" + paraWrapId + "' open=true style='cursor:pointer'>");
                    w.print("<summary style='cursor:pointer'>" + Msg.getMsg((Properties)Env.getCtx(), (String)"Parameter") + "</summary>");
                    w.print(HTMLReportRenderer.compress((String)parameterTable.toString(), (boolean)minify));
                    tr tr2 = new tr();
                    tr2.setClass("tr-parameter");
                    MQuery mQuery = reportEngineQuery;
                    if (reportEngineQuery.getReportProcessQuery() != null) {
                        MQuery mQuery2 = reportEngineQuery.getReportProcessQuery();
                    }
                    int r = 0;
                    while (r < var33_52.getRestrictionCount()) {
                        if (r > 0) {
                            tr2 = new tr();
                            tr2.setClass("tr-parameter");
                        }
                        td td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(var33_52.getInfoName(r));
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(var33_52.getInfoOperator(r));
                        td2 = new td();
                        tr2.addElement((Element)td2);
                        td2.addElement(var33_52.getInfoDisplayAll(r));
                        w.print(HTMLReportRenderer.compress((String)tr2.toString(), (boolean)minify));
                        ++r;
                    }
                    w.print("</table>");
                    w.print("</details>");
                }
                StringBuilder tableWrapDiv = new StringBuilder();
                tableWrapDiv.append("<div class='").append(cssPrefix).append("-table-wrap' ");
                if (paraWrapId != null) {
                    String string2 = "document.getElementById(\"" + paraWrapId + "\")";
                    tableWrapDiv.append("onscroll='setTimeout(() => {if (this.scrollTop > 0) ").append(" if(").append(string2).append(".open) ").append(string2).append(".open=false;}, 100)'");
                }
                tableWrapDiv.append(" >");
                w.print(HTMLReportRenderer.compress((String)tableWrapDiv.toString(), (boolean)minify));
                w.print(HTMLReportRenderer.compress((String)table2.toString(), (boolean)minify));
            }
            thead thead2 = new thead();
            thead2.setClass("sticky");
            tbody tbody2 = new tbody();
            tbody2.setNeedClosingTag(false);
            Boolean[] colSuppressRepeats = layout == null || layout.colSuppressRepeats == null ? LayoutEngine.getColSuppressRepeats((MPrintFormat)printFormat) : layout.colSuppressRepeats;
            Object[] preValues = null;
            if (colSuppressRepeats != null) {
                preValues = new Object[colSuppressRepeats.length];
            }
            int printColIndex = -1;
            HashMap<Integer, th> suppressMap = new HashMap<Integer, th>();
            tr tr3 = new tr();
            int col3 = 0;
            while (col3 < printFormat.getItemCount()) {
                MPrintFormatItem item = printFormat.getItem(col3);
                if (item.isPrinted() && (!item.isNextLine() || item.getBelowColumn() < 1)) {
                    String printName = item.getPrintName(language);
                    th th2 = new th();
                    th2.addAttribute("data-dt-order", "disable");
                    tr3.addElement((Element)th2);
                    input searchInput = new input();
                    if (!Util.isEmpty((String)printName)) {
                        searchInput.addAttribute("placeholder", "Search " + printName);
                    }
                    th2.addElement((Element)searchInput);
                }
                ++col3;
            }
            thead2.addElement((Element)tr3);
            int row = -1;
            while (row < printData.getRowCount()) {
                void var33_58;
                ArrayList belowColumnMap = new ArrayList();
                HashMap<Integer, td> tdMap = new HashMap<Integer, td>();
                tr tr2 = new tr();
                if (row != -1) {
                    printData.setRowIndex(row);
                    if (extension != null && !isExport) {
                        extension.extendRowElement((ConcreteElement)tr2, printData);
                    }
                    if (printData.isFunctionRow()) {
                        tr2.setClass(cssPrefix + "-functionrow");
                    } else if (row < printData.getRowCount() && printData.isFunctionRow(row + 1)) {
                        tr2.setClass(cssPrefix + "-lastgrouprow");
                    }
                } else {
                    thead2.addElement((Element)tr2);
                }
                printColIndex = -1;
                boolean bl = false;
                while (var33_58 < columns.size()) {
                    Object colObj = columns.get((int)var33_58);
                    MPrintFormatItem item = null;
                    InstanceAttributeColumn instanceAttributeColumn = null;
                    if (colObj instanceof MPrintFormatItem) {
                        item = (MPrintFormatItem)colObj;
                    } else if (colObj instanceof InstanceAttributeColumn) {
                        instanceAttributeColumn = (InstanceAttributeColumn)colObj;
                        item = instanceAttributeColumn.getPrintFormatItem();
                    }
                    if (item != null) {
                        if (item.isNextLine() && item.getBelowColumn() >= 1) {
                            if (row != -1) {
                                int belowColumn = item.getBelowColumn() - 1;
                                if (belowColumnMap.isEmpty()) {
                                    belowColumnMap.add(new HashMap());
                                }
                                boolean added = false;
                                for (Map map : belowColumnMap) {
                                    if (map.containsKey(belowColumn)) continue;
                                    map.put(belowColumn, (int)var33_58);
                                    added = true;
                                    break;
                                }
                                if (!added) {
                                    HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                                    hashMap.put(belowColumn, (int)var33_58);
                                    belowColumnMap.add(hashMap);
                                }
                            }
                        } else {
                            ++printColIndex;
                            if (row == -1) {
                                MColumn mColumn;
                                String description;
                                MColumn mColumn2;
                                th th3 = new th();
                                tr2.addElement((Element)th3);
                                String columnHeader = instanceAttributeColumn != null ? instanceAttributeColumn.getName() : item.getPrintName(language);
                                th3.addElement(Util.maskHTML((String)columnHeader));
                                if (cssPrefix != null && instanceAttributeColumn == null && (mColumn2 = MColumn.get((Properties)Env.getCtx(), (int)item.getAD_Column_ID())) != null && mColumn2.getAD_Column_ID() > 0 && DisplayType.isNumeric((int)mColumn2.getAD_Reference_ID())) {
                                    th3.setClass(cssPrefix + "-number");
                                }
                                if (item.isSuppressNull()) {
                                    suppressMap.put(printColIndex, th3);
                                    th3.setID("report-th-" + printColIndex);
                                }
                                if (item.isGroupBy()) {
                                    dataTableOptions.setOrdering(false);
                                }
                                if (item.getAD_Column_ID() > 0 && !Util.isEmpty((String)(description = (mColumn = MColumn.get((int)item.getAD_Column_ID())).get_Translation("Description", language.getAD_Language())))) {
                                    th3.addAttribute("title", description);
                                }
                            } else {
                                td td3 = new td();
                                tr2.addElement((Element)td3);
                                tdMap.put(printColIndex, td3);
                                DatatableReportRenderer.printColumn(reportEngine, language, extension, isExport, (MultiPartElement)td3, item, instanceAttributeColumn, row, printData, colSuppressRepeats, printColIndex, preValues, suppressMap, cssPrefix, printFormat, mapCssInfo, contextPath);
                            }
                        }
                    }
                    ++var33_58;
                }
                dataTableOptions.setPrintColLastIndex(printColIndex);
                if (row == -1) {
                    w.print(HTMLReportRenderer.compress((String)thead2.toString(), (boolean)minify));
                    w.print(HTMLReportRenderer.compress((String)tbody2.toString(), (boolean)minify));
                }
                if (!belowColumnMap.isEmpty()) {
                    for (Map map : belowColumnMap) {
                        printColIndex = -1;
                        int col5 = 0;
                        while (col5 < columns.size()) {
                            if (!map.containsValue(col5) && map.containsKey(++printColIndex)) {
                                int mapTo = (Integer)map.get(printColIndex);
                                Object colObj = columns.get(mapTo);
                                MPrintFormatItem item = null;
                                Object var39_82 = null;
                                if (colObj instanceof MPrintFormatItem) {
                                    item = (MPrintFormatItem)colObj;
                                } else if (colObj instanceof InstanceAttributeColumn) {
                                    InstanceAttributeColumn instanceAttributeColumn = (InstanceAttributeColumn)colObj;
                                    item = instanceAttributeColumn.getPrintFormatItem();
                                }
                                if (item != null) {
                                    Object pde;
                                    String value;
                                    void var39_84;
                                    Object obj;
                                    Object object = obj = var39_84 != null ? var39_84.getPrintDataElement(row) : printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
                                    if (obj != null && ReportEngine.isDisplayPFItem((PrintData)printData, (MPrintFormatItem)item) && obj instanceof PrintDataElement && !Util.isEmpty((String)(value = (pde = obj).getValueDisplay(language)), (boolean)true)) {
                                        td td4 = (td)tdMap.get(printColIndex);
                                        div div2 = new div();
                                        td4.addElement((Element)div2);
                                        DatatableReportRenderer.printColumn(reportEngine, language, extension, isExport, (MultiPartElement)div2, item, (InstanceAttributeColumn)var39_84, row, printData, colSuppressRepeats, printColIndex, preValues, suppressMap, cssPrefix, printFormat, mapCssInfo, contextPath);
                                        div2.setClass("");
                                    }
                                }
                            }
                            ++col5;
                        }
                    }
                }
                if (row != -1) {
                    w.print(HTMLReportRenderer.compress((String)tr2.toString(), (boolean)minify));
                }
                ++row;
            }
            w.print("</tbody>");
            w.print("</table>");
            if (suppressMap.size() > 0) {
                StringBuilder st = new StringBuilder();
                for (th t : suppressMap.values()) {
                    if (st.length() > 0) {
                        st.append(",");
                    }
                    st.append("#").append(t.getAttribute("id"));
                }
                st.append(" {\n\t\tdisplay:none;\n\t}");
                style styleTag = new style();
                styleTag.addElement(st.toString());
                w.print(HTMLReportRenderer.compress((String)styleTag.toString(), (boolean)minify));
            }
            if (!onlyTable) {
                w.print("</div>");
                w.print("</div>");
                String dataTableOptionString = dataTableOptions.getDataTableOptions();
                if (dataTableOptionString != null) {
                    w.print("<script type=\"text/javascript\"> ");
                    String jsDataTables = "$(document).ready(function() {   let t = $('#JS_DataTable').DataTable( " + dataTableOptionString + " );  });";
                    w.print(jsDataTables);
                    w.print("</script>");
                }
                w.print("</body>");
                w.print("</html>");
            }
            w.flush();
            w.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            throw new AdempiereException((Throwable)e);
        }
    }

    private static void printColumn(ReportEngine reportEngine, Language language, IHTMLExtension extension, boolean isExport, MultiPartElement td2, MPrintFormatItem item, InstanceAttributeColumn instanceAttributeColumn, int row, PrintData printData, Boolean[] colSuppressRepeats, int printColIndex, Object[] preValues, HashMap<Integer, th> suppressMap, String cssPrefix, MPrintFormat printFormat, Map<HTMLReportRenderer.CSSInfo, List<HTMLReportRenderer.ColumnInfo>> mapCssInfo, String contextPath) {
        Object obj;
        MStyle style2 = item.getAD_FieldStyle_ID() > 0 ? MStyle.get((Properties)Env.getCtx(), (int)item.getAD_FieldStyle_ID()) : null;
        Object object = obj = instanceAttributeColumn != null ? instanceAttributeColumn.getPrintDataElement(row) : printData.getNodeByPrintFormatItemId(item.getAD_PrintFormatItem_ID());
        if (obj == null && ReportEngine.isDisplayPFItem((PrintData)printData, (MPrintFormatItem)item) && item.isTypeImage() && !item.isImageField() && !item.isImageIsAttached() && !Util.isEmpty((String)item.getImageURL(), (boolean)true)) {
            DatatableReportRenderer.printImageColumn(td2, item, null, isExport, contextPath, printData);
        } else if (obj == null || !ReportEngine.isDisplayPFItem((PrintData)printData, (MPrintFormatItem)item)) {
            td2.addElementToRegistry("&nbsp;");
            if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                preValues[printColIndex] = null;
            }
            if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                suppressMap.remove(printColIndex);
            }
        } else if (obj instanceof PrintDataElement) {
            Object pde = obj;
            String value = pde.getValueDisplay(language);
            if (colSuppressRepeats != null && colSuppressRepeats[printColIndex].booleanValue()) {
                if (value.equals(preValues[printColIndex])) {
                    td2.addElementToRegistry("&nbsp;");
                    return;
                }
                preValues[printColIndex] = value;
            }
            if (item.isSuppressNull() && obj != null && suppressMap.containsKey(printColIndex)) {
                suppressMap.remove(printColIndex);
            }
            if (item.isTypeImage()) {
                DatatableReportRenderer.printImageColumn(td2, item, (PrintDataElement)pde, isExport, contextPath, printData);
            } else if (pde.getColumnName().endsWith("_ID") && extension != null && !isExport) {
                boolean isZoom = false;
                if (item.getColumnName().equals("Record_ID")) {
                    Object tablePDE = printData.getNode("AD_Table_ID");
                    if (tablePDE != null && tablePDE instanceof PrintDataElement) {
                        int tableID = -1;
                        try {
                            tableID = Integer.parseInt(((PrintDataElement)tablePDE).getValueAsString());
                        }
                        catch (Exception exception) {
                            tableID = -1;
                        }
                        if (tableID > 0) {
                            MTable mTable = MTable.get((Properties)Env.getCtx(), (int)tableID);
                            String tableName = mTable.getTableName();
                            value = reportEngine.getIdentifier(mTable, tableName, Integer.parseInt(value));
                            String foreignColumnName = tableName + "_ID";
                            pde.setForeignColumnName(foreignColumnName);
                            isZoom = true;
                        }
                    }
                } else {
                    isZoom = true;
                }
                if (isZoom) {
                    MTable mTable = MTable.get((Properties)Env.getCtx(), (String)pde.getForeignColumnName().substring(0, pde.getForeignColumnName().length() - 3));
                    int Record_ID = -1;
                    try {
                        Record_ID = Integer.parseInt(pde.getValueAsString());
                    }
                    catch (Exception exception) {
                        Record_ID = -1;
                    }
                    Boolean canAccess = null;
                    if (Record_ID >= 0 && mTable != null) {
                        int AD_Window_ID = Env.getZoomWindowID((int)mTable.get_ID(), (int)Record_ID);
                        canAccess = MRole.getDefault().getWindowAccess(AD_Window_ID);
                    }
                    if (canAccess == null) {
                        isZoom = false;
                    }
                }
                if (isZoom) {
                    a href = new a("javascript:void(0)");
                    href.setID(pde.getColumnName() + "_" + row + "_a");
                    td2.addElementToRegistry((Element)href);
                    href.addElement(Util.maskHTML((String)value));
                    if (cssPrefix != null) {
                        href.setClass(cssPrefix + "-href");
                    }
                    if (style2 != null && style2.isWrapWithSpan()) {
                        HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)href, (MStyle)style2);
                    } else {
                        HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)td2, (MStyle)style2);
                    }
                    extension.extendIDColumn(row, (ConcreteElement)td2, href, (PrintDataElement)pde);
                } else if (style2 != null && style2.isWrapWithSpan()) {
                    span span2 = new span();
                    HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)span2, (MStyle)style2);
                    span2.addElement(Util.maskHTML((String)value));
                    td2.addElementToRegistry((Element)span2);
                } else {
                    HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)td2, (MStyle)style2);
                    td2.addElementToRegistry(Util.maskHTML((String)value));
                }
            } else if (style2 != null && style2.isWrapWithSpan()) {
                span span3 = new span();
                HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)span3, (MStyle)style2);
                span3.addElement(Util.maskHTML((String)value));
                td2.addElementToRegistry((Element)span3);
            } else {
                HTMLReportRenderer.setStyle((PrintData)printData, (MultiPartElement)td2, (MStyle)style2);
                td2.addElementToRegistry(Util.maskHTML((String)value));
            }
            if (cssPrefix != null) {
                if (item.isTypeImage()) {
                    td2.setClass(cssPrefix + "-image");
                } else if (DisplayType.isNumeric((int)pde.getDisplayType())) {
                    td2.setClass(cssPrefix + "-number");
                } else if (DisplayType.isDate((int)pde.getDisplayType())) {
                    td2.setClass(cssPrefix + "-date");
                } else {
                    td2.setClass(cssPrefix + "-text");
                }
            }
            if (row == 0) {
                HTMLReportRenderer.addCssInfo((MPrintFormat)printFormat, (MPrintFormatItem)item, (int)printColIndex, mapCssInfo);
            }
        } else if (!(obj instanceof PrintData)) {
            log.log(Level.SEVERE, "Element not PrintData(Element) " + String.valueOf(obj.getClass()));
        }
    }

    private static void printImageColumn(MultiPartElement td2, MPrintFormatItem item, PrintDataElement pde, boolean isExport, String contextPath, PrintData printData) {
        if (item.isImageField()) {
            Object data = pde.getValue();
            if (data != null) {
                if (pde.getDisplayType() == 32) {
                    if (data instanceof Number) {
                        Number number = (Number)data;
                        int id = number.intValue();
                        MImage image = MImage.get((int)id);
                        byte[] imageData = image.getBinaryData();
                        DatatableReportRenderer.createDataURLImageElement(td2, imageData, item);
                    }
                } else {
                    String url = data.toString();
                    if (MAttachment.isAttachmentURLPath((String)url)) {
                        DatatableReportRenderer.createImageElementFromAttachmentPath(td2, item, url, isExport, contextPath, printData);
                    } else if (url.indexOf("://") == -1) {
                        ClassLoader cl = HTMLReportRenderer.class.getClassLoader();
                        URL resource = cl.getResource(url);
                        if (resource != null) {
                            DatatableReportRenderer.createDataURLImageElement(td2, resource, item);
                        }
                        if ((resource = Core.getResourceFinder().getResource(url)) != null) {
                            DatatableReportRenderer.createDataURLImageElement(td2, resource, item);
                        }
                    } else {
                        img image = new img(url);
                        td2.addElementToRegistry((Element)image);
                        DatatableReportRenderer.applyHeightAndWidth(item, image);
                    }
                }
            }
        } else if (item.isImageIsAttached()) {
            MAttachment attachment = MAttachment.get((Properties)Env.getCtx(), (int)489, (int)item.get_ID(), null, null);
            if (attachment != null) {
                if (attachment.getEntryCount() != 1) {
                    log.log(Level.WARNING, "Need just 1 Attachment Entry = " + attachment.getEntryCount());
                    return;
                }
                byte[] imageData = attachment.getEntryData(0);
                DatatableReportRenderer.createDataURLImageElement(td2, imageData, item);
            }
        } else if (!Util.isEmpty((String)item.getImageURL(), (boolean)true)) {
            String url = item.getImageURL();
            if (MAttachment.isAttachmentURLPath((String)url)) {
                DatatableReportRenderer.createImageElementFromAttachmentPath(td2, item, url, isExport, contextPath, printData);
            } else {
                img image = new img(url);
                td2.addElementToRegistry((Element)image);
                DatatableReportRenderer.applyHeightAndWidth(item, image);
            }
        }
    }

    private static void createImageElementFromAttachmentPath(MultiPartElement td2, MPrintFormatItem item, String path, boolean isExport, String contextPath, PrintData printData) {
        AttachmentData imageData;
        if (path.indexOf("@") >= 0) {
            PrintDataEvaluatee.PrintDataDataProvider dp = new PrintDataEvaluatee.PrintDataDataProvider(null, printData);
            DefaultEvaluatee evaluatee = new DefaultEvaluatee((DefaultEvaluatee.DataProvider)dp);
            path = Env.parseVariable((String)path, (DefaultEvaluatee)evaluatee, (boolean)true, (boolean)false);
        }
        if ((imageData = MAttachment.getDataFromAttachmentURLPath((String)path)) != null && imageData.data() != null && imageData.data().length > 0) {
            if (isExport) {
                DatatableReportRenderer.createDataURLImageElement(td2, imageData.data(), item);
            } else {
                String url = MAttachment.getImageAttachmentURLFromPath((String)contextPath, (String)path);
                if (url != null) {
                    img image = new img(url);
                    td2.addElementToRegistry((Element)image);
                    DatatableReportRenderer.applyHeightAndWidth(item, image);
                }
            }
        } else {
            span sp = new span();
            sp.setClass("no-image");
            td2.addElementToRegistry((Element)sp);
            DatatableReportRenderer.applyHeightAndWidth(item, sp);
        }
    }

    private static void applyHeightAndWidth(MPrintFormatItem item, span sp) {
        StringBuilder style2 = new StringBuilder();
        if (item.getMaxHeight() > 0) {
            style2.append("height:").append(item.getMaxHeight()).append("px;");
        }
        if (item.getMaxWidth() > 0) {
            style2.append("width:").append(item.getMaxWidth()).append("px;");
        }
        if (style2.length() > 0) {
            style2.append("object-fit: scale-down;");
            sp.setStyle(style2.toString());
        }
    }

    private static void applyHeightAndWidth(MPrintFormatItem item, img image) {
        StringBuilder style2 = new StringBuilder();
        if (item.getMaxHeight() > 0) {
            style2.append("height:").append(item.getMaxHeight()).append("px;");
        }
        if (item.getMaxWidth() > 0) {
            style2.append("width:").append(item.getMaxWidth()).append("px;");
        }
        if (style2.length() > 0) {
            style2.append("object-fit: scale-down;");
            image.setStyle(style2.toString());
        }
    }

    private static void createDataURLImageElement(MultiPartElement td2, URL url, MPrintFormatItem item) {
        byte[] imageData = null;
        try {
            imageData = ByteStreams.toByteArray((InputStream)url.openStream());
            DatatableReportRenderer.createDataURLImageElement(td2, imageData, item);
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void createDataURLImageElement(MultiPartElement td, byte[] imageData, MPrintFormatItem item) {
        contentType = null;
        readers = null;
        try {
            readers = ImageIO.getImageReaders(ImageIO.createImageInputStream(new ByteArrayInputStream(imageData)));
            if (true) ** GOTO lbl16
        }
        catch (IOException e) {
            DatatableReportRenderer.log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
            return;
        }
        do {
            reader = readers.next();
            try {
                contentType = reader.getFormatName();
                if (Util.isEmpty((String)contentType)) continue;
                break;
            }
            catch (IOException v0) {}
lbl16:
            // 3 sources

        } while (readers.hasNext());
        if (contentType != null) {
            builder = new StringBuilder("data:").append(contentType).append(";base64,");
            builder.append(Base64.getEncoder().encodeToString(imageData));
            image = new img(builder.toString());
            td.addElementToRegistry((Element)image);
            DatatableReportRenderer.applyHeightAndWidth(item, image);
        }
    }

    private void appendScripts(XhtmlDocument doc, boolean isExport) throws IOException, URISyntaxException {
        List<String> urls = Arrays.asList("~./js/datatables/datatables.min.js");
        if (isExport) {
            for (String extraScriptPath : urls) {
                URL url = this.getClass().getResource(extraScriptPath.replace("~./", "/web/"));
                this.appendInlineScriptContent(doc, this.readResource(url));
            }
        } else {
            for (String extraScriptUrl : urls) {
                this.embedScriptLink(doc, Executions.encodeURL((String)extraScriptUrl));
            }
        }
    }

    private void appendStyles(XhtmlDocument doc, boolean isExport, String i18nURL) throws IOException, URISyntaxException {
        List<String> urls = Arrays.asList("~./js/datatables/datatables.min.css", "~./js/datatables/customization.css");
        if (isExport) {
            for (String extraStylePath : urls) {
                URL url = this.getClass().getResource(extraStylePath.replace("~./", "/web/"));
                HTMLReportRenderer.appendInlineCss((XhtmlDocument)doc, (StringBuilder)this.readResource(url));
            }
        } else {
            for (String extraStyleUrl : urls) {
                this.embedStyleLink(doc, Executions.encodeURL((String)extraStyleUrl));
                if (i18nURL == null) continue;
                link link2 = new link();
                link2.setHref(i18nURL);
                link2.setRel("prefetch");
                link2.setType("application/json");
                doc.appendHead((Element)link2);
            }
        }
    }

    private StringBuilder readResource(URL url) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        InputStream is = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder;
    }

    protected void embedScriptLink(XhtmlDocument doc, String scriptUrl) {
        script jslink = new script();
        jslink.setLanguage("javascript");
        jslink.setSrc(scriptUrl);
        doc.appendHead((Element)jslink);
    }

    protected void embedStyleLink(XhtmlDocument doc, String styleUrl) {
        link csslink = new link();
        csslink.setType("text/css");
        csslink.setRel("stylesheet");
        csslink.setHref(styleUrl);
        doc.appendHead((Element)csslink);
    }

    private void appendInlineScriptContent(XhtmlDocument doc, StringBuilder buildScriptContent) {
        if (buildScriptContent.length() > 0) {
            buildScriptContent.insert(0, "<script type=\"text/javascript\">\n");
            buildScriptContent.append("\n</script>");
            doc.appendHead(buildScriptContent.toString());
        }
    }

    protected static enum FunctionTypes {
        SUM,
        COUNT,
        MIN,
        MAX,
        AVG,
        DEVIATION,
        VARIANCE,
        GROUP_BY,
        ORDER_BY;

    }
}

