/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.websocket.EndpointConfig;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.Storage;

public final class ZKWebSocket
extends ServerEndpointConfig.Configurator {
    public static final String DESKTOP_ID_PARAM = "dtid";
    public static final String CONNECTION_UUID_PARAM = "connection_uuid";
    private static final String ZK_SESSION = ZKWebSocket.class.getName() + ".session";
    private static final String DESKTOP_ID = ZKWebSocket.class.getName() + ".dtid";

    public void modifyHandshake(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
        Session zkSession = SessionsCtrl.getSession(WebApps.getCurrent(), request.getHttpSession());
        if (zkSession == null) {
            return;
        }
        Map parameterMap = request.getParameterMap();
        String tempSessionKey = ZKWebSocket.tempSessionKey(ZKWebSocket.extractDesktopId(parameterMap), ZKWebSocket.extractConnectionUuid(request.getUserPrincipal()));
        config.getUserProperties().put(tempSessionKey, zkSession);
    }

    public static void initZkDesktop(javax.websocket.Session wsession, EndpointConfig config) {
        Map requestParameterMap = wsession.getRequestParameterMap();
        String desktopId = ZKWebSocket.extractDesktopId(requestParameterMap);
        String connectionUuid = ZKWebSocket.extractConnectionUuid(wsession.getUserPrincipal());
        Session zkSession = (Session)config.getUserProperties().remove(ZKWebSocket.tempSessionKey(desktopId, connectionUuid));
        if (zkSession == null) {
            throw new IllegalStateException("ZK Session cannot be null!");
        }
        Map wsSessUserProperties = wsession.getUserProperties();
        wsSessUserProperties.put(ZK_SESSION, zkSession);
        wsSessUserProperties.put(DESKTOP_ID, desktopId);
    }

    private static String extractDesktopId(Map<String, List<String>> requestParameterMap) {
        List<String> desktopIds = requestParameterMap.get(DESKTOP_ID_PARAM);
        if (desktopIds == null || desktopIds.isEmpty()) {
            throw new IllegalStateException("the value of the key with 'dtid' cannot be null!");
        }
        return desktopIds.get(0);
    }

    private static String extractConnectionUuid(Principal principle) {
        return principle instanceof ZKPrinciple ? ((ZKPrinciple)principle).getConnectionUuid() : "";
    }

    private static String tempSessionKey(String desktopId, String connectionUuid) {
        return desktopId + "|" + connectionUuid;
    }

    public static Storage getDesktopStorage(javax.websocket.Session wsession) {
        Desktop desktop = ZKWebSocket.getDesktop(wsession);
        return desktop == null ? null : desktop.getStorage();
    }

    public static Desktop getDesktop(javax.websocket.Session wsession) {
        String dtid = (String)wsession.getUserProperties().get(DESKTOP_ID);
        SessionCtrl sessionCtrl = (SessionCtrl)wsession.getUserProperties().get(ZK_SESSION);
        if (dtid == null || sessionCtrl == null) {
            throw new IllegalStateException("Desktop not initialized for Websocket session, call ZKWebSocket.initZkDesktop(Session, EndpointConfig) first: e.g. during onOpen");
        }
        DesktopCache desktopCache = sessionCtrl.getDesktopCache();
        return desktopCache != null ? desktopCache.getDesktopIfAny(dtid) : null;
    }

    public static class ZKPrinciple
    implements Principal {
        private final Principal _original;
        private final String _connectionUuid;

        public ZKPrinciple(Principal original, String connectionUuid) {
            this._original = original;
            this._connectionUuid = connectionUuid;
        }

        @Override
        public boolean implies(Subject subject) {
            return this._original != null && this._original.implies(subject);
        }

        @Override
        public String getName() {
            return this._original != null ? this._original.getName() : "";
        }

        public String getConnectionUuid() {
            return this._connectionUuid;
        }
    }
}

