/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au;

import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class AuRequest {
    public static final int BUSY_IGNORE = 4096;
    public static final int REPEAT_IGNORE = 16384;
    public static final int DUPLICATE_IGNORE = 8192;
    private final String _cmd;
    private final Desktop _desktop;
    private Integer _opts;
    private Page _page;
    private Component _comp;
    private final Map<String, Object> _data;
    private String _uuid;

    public AuRequest(Desktop desktop, String uuid, String cmd, Map<String, Object> data) {
        if (desktop == null || uuid == null || cmd == null) {
            throw new IllegalArgumentException();
        }
        this._desktop = desktop;
        this._uuid = uuid;
        this._cmd = cmd;
        this._data = data != null ? AuRequest.parseType(data) : Collections.emptyMap();
    }

    public AuRequest(Desktop desktop, String cmd, Map<String, Object> data) {
        if (desktop == null || cmd == null) {
            throw new IllegalArgumentException();
        }
        this._desktop = desktop;
        this._cmd = cmd;
        this._data = data != null ? AuRequest.parseType(data) : Collections.emptyMap();
    }

    private static Map<String, Object> parseType(Map<String, Object> data) {
        JSONArray dateKeys = (JSONArray)data.get("z$dateKeys");
        if (dateKeys != null) {
            for (Object key : dateKeys) {
                String strKey = (String)key;
                Object val = data.get(strKey);
                if (!(val instanceof String)) continue;
                try {
                    data.put(strKey, JSONs.j2d((String)((String)val)));
                }
                catch (ParseException ex) {
                    throw new UiException("Failed to convert the value of " + strKey + ": " + val);
                }
            }
        }
        return data;
    }

    public void activate() throws ComponentNotFoundException {
        if (this._uuid != null) {
            this._comp = this._desktop.getComponentByUuidIfAny(this._uuid);
            if (this._comp != null) {
                this._page = this._comp.getPage();
            } else {
                this._page = this._desktop.getPageIfAny(this._uuid);
                if (this._page == null) {
                    throw new ComponentNotFoundException("Component not found: " + this._uuid);
                }
            }
        }
    }

    public String getCommand() {
        return this._cmd;
    }

    public int getOptions() {
        if (this._opts == null) {
            if (this._comp != null) {
                this._opts = ((ComponentCtrl)((Object)this._comp)).getClientEvents().get(this._cmd);
            }
            if (this._opts == null) {
                this._opts = new Integer(0);
            }
        }
        return this._opts;
    }

    public Desktop getDesktop() {
        return this._desktop;
    }

    public Page getPage() {
        return this._page;
    }

    public Component getComponent() {
        return this._comp;
    }

    public String getUuid() {
        return this._uuid;
    }

    public Map<String, Object> getData() {
        return this._data;
    }

    public int hashCode() {
        int hash = 1;
        if (this._uuid != null) {
            hash = 31 * hash + this._uuid.hashCode();
        }
        if (this._comp != null) {
            hash = 31 * hash + this._comp.hashCode();
        }
        if (this._cmd != null) {
            hash = 31 * hash + this._cmd.hashCode();
        }
        return hash;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        if (this._comp != null) {
            return "[comp=" + this._comp + ", uuid=" + this._uuid + ", cmd=" + this._cmd + "]";
        }
        if (this._page != null) {
            return "[page=" + this._page + ", cmd=" + this._cmd + "]";
        }
        return "[uuid=" + this._uuid + ", cmd=" + this._cmd + "]";
    }
}

