/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPayment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CalloutPaymentAllocate
extends CalloutEngine {
    public String invoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Invoice_ID = (Integer)value;
        if (this.isCalloutActive() || C_Invoice_ID == null || C_Invoice_ID == 0) {
            return "";
        }
        int C_Payment_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_Payment_ID");
        MPayment payment = new MPayment(ctx, C_Payment_ID, null);
        if (payment.getC_Charge_ID() != 0 || payment.getC_Invoice_ID() != 0 || payment.getC_Order_ID() != 0) {
            return Msg.getMsg((Properties)ctx, (String)"PaymentIsAllocated");
        }
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        int C_InvoicePaySchedule_ID = 0;
        if (Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_Invoice_ID") == C_Invoice_ID && Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)1113, (String)"C_InvoicePaySchedule_ID");
        }
        Timestamp ts = Env.getContextAsDate((Properties)ctx, (int)WindowNo, (String)"DateTrx");
        String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_InvoicePaySchedule_ID);
                pstmt.setTimestamp(2, ts);
                pstmt.setInt(3, C_InvoicePaySchedule_ID);
                pstmt.setInt(4, C_Invoice_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    BigDecimal DiscountAmt;
                    BigDecimal InvoiceOpen = rs.getBigDecimal(3);
                    if (InvoiceOpen == null) {
                        InvoiceOpen = Env.ZERO;
                    }
                    if ((DiscountAmt = rs.getBigDecimal(4)) == null) {
                        DiscountAmt = Env.ZERO;
                    }
                    mTab.setValue("InvoiceAmt", (Object)InvoiceOpen);
                    mTab.setValue("Amount", (Object)InvoiceOpen.subtract(DiscountAmt));
                    mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                    Env.setContext((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_Invoice_ID", (String)C_Invoice_ID.toString());
                    mTab.setValue("C_Invoice_ID", (Object)C_Invoice_ID);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                String string = e.getLocalizedMessage();
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String amounts(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        String colName;
        BigDecimal OverUnderAmt;
        BigDecimal WriteOffAmt;
        BigDecimal DiscountAmt;
        if (this.isCalloutActive()) {
            return "";
        }
        int C_Invoice_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (int)mTab.getTabNo(), (String)"C_Invoice_ID");
        if (C_Invoice_ID == 0) {
            return "";
        }
        BigDecimal Amount = (BigDecimal)mTab.getValue("Amount");
        if (Amount == null) {
            Amount = Env.ZERO;
        }
        if ((DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt")) == null) {
            DiscountAmt = Env.ZERO;
        }
        if ((WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt")) == null) {
            WriteOffAmt = Env.ZERO;
        }
        if ((OverUnderAmt = (BigDecimal)mTab.getValue("OverUnderAmt")) == null) {
            OverUnderAmt = Env.ZERO;
        }
        BigDecimal InvoiceAmt = (BigDecimal)mTab.getValue("InvoiceAmt");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Amt=" + String.valueOf(Amount) + ", Discount=" + String.valueOf(DiscountAmt) + ", WriteOff=" + String.valueOf(WriteOffAmt) + ", OverUnder=" + String.valueOf(OverUnderAmt) + ", Invoice=" + String.valueOf(InvoiceAmt));
        }
        if ((colName = mField.getColumnName()).equals("Amount")) {
            OverUnderAmt = InvoiceAmt.subtract(Amount).subtract(DiscountAmt).subtract(WriteOffAmt);
            mTab.setValue("OverUnderAmt", (Object)OverUnderAmt);
        } else {
            Amount = InvoiceAmt.subtract(DiscountAmt).subtract(WriteOffAmt).subtract(OverUnderAmt);
            mTab.setValue("Amount", (Object)Amount);
        }
        return "";
    }
}

