/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.Menupopup;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.GridField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Menu;
import org.zkoss.zul.Menuitem;

public class WTimeZoneEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onChange"};
    private static final String TIME_ZONE = "TIME_ZONE";
    private static final String TIME_ZONE_ADDED = "TIME_ZONE_ADDED";
    private static final String TIME_ZONE_ITEM_ATTR = "TIME_ZONE_ITEM";
    private static final String TIME_ZONE_ID_ATTR = "TIME_ZONE_ID";
    private String oldValue;

    public WTimeZoneEditor(GridField gridField) {
        this(gridField, false);
    }

    public WTimeZoneEditor(GridField gridField, boolean tableEditor) {
        super((Component)new Combobox(), gridField);
        this.tableEditor = tableEditor;
        this.init();
    }

    public WTimeZoneEditor(String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new Combobox(), label, description, mandatory, readonly, updateable);
        this.init();
    }

    public WTimeZoneEditor(String columnName, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new Combobox(), columnName, label, description, mandatory, readonly, updateable);
        this.init();
    }

    private void init() {
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.popupMenu.addMenuListener(this);
        this.popupMenu.addEventListener("onOpen", this);
        Set<String> ids = ZoneId.getAvailableZoneIds();
        ArrayList<Integer> rawOffsets = new ArrayList<Integer>();
        HashMap map = new HashMap();
        for (String id : ids) {
            ArrayList<ValueNamePair> timezones;
            if (id.startsWith("Etc/") || id.startsWith("SystemV/") || id.indexOf("/") < 0) continue;
            TimeZone tz = TimeZone.getTimeZone(ZoneId.of(id));
            String label = this.getLabel(tz);
            int rawOffset = tz.getRawOffset();
            if (!rawOffsets.contains(rawOffset)) {
                rawOffsets.add(rawOffset);
            }
            if ((timezones = (ArrayList<ValueNamePair>)map.get(rawOffset)) == null) {
                timezones = new ArrayList<ValueNamePair>();
                map.put(rawOffset, timezones);
            }
            ValueNamePair valueNamePair = new ValueNamePair(id, label);
            timezones.add(valueNamePair);
        }
        Collections.sort(rawOffsets);
        Iterator<String> iterator = rawOffsets.iterator();
        while (iterator.hasNext()) {
            int rawOffset = (Integer)((Object)iterator.next());
            List namePairs = (List)map.get(rawOffset);
            Collections.sort(namePairs);
            for (NamePair namePair : namePairs) {
                this.getComponent().appendItem(namePair.getName(), namePair.getID());
            }
        }
        this.getComponent().addEventListener("onBlur", e -> this.onBlur());
    }

    private void onBlur() {
        String newValue;
        Comboitem item = this.getComponent().getSelectedItem();
        if (item == null) {
            this.setValue(this.oldValue);
        } else if (Util.isEmpty((String)item.getLabel(), (boolean)true) && this.isValueChange(newValue = this.getValue())) {
            try {
                if (this.gridField != null) {
                    this.gridField.setLookupEditorSettingValue(true);
                }
                ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                super.fireValueChange(changeEvent);
                this.oldValue = newValue;
            }
            finally {
                if (this.gridField != null) {
                    this.gridField.setLookupEditorSettingValue(false);
                }
            }
        }
    }

    private boolean isValueChange(String newValue) {
        return this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue);
    }

    public void onEvent(Event event) throws Exception {
        if ("onChange".equalsIgnoreCase(event.getName())) {
            String customId;
            String id = this.getComponent().getSelectedItem() != null ? (String)this.getComponent().getSelectedItem().getValue() : null;
            String newValue = null;
            if (id != null) {
                newValue = id;
            } else if (!Util.isEmpty((String)this.getComponent().getText(), (boolean)true) && this.processCustomZoneId(customId = this.getComponent().getText())) {
                newValue = customId;
            }
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        } else if ("onOpen".equals(event.getName())) {
            this.addTimeZoneMenu(this.popupMenu);
        }
    }

    private boolean processCustomZoneId(String customId) {
        TimeZone timeZone = TimeZone.getTimeZone(customId);
        if (timeZone != null && timeZone.getID().equals(customId)) {
            this.getComponent().appendItem(customId, customId);
            this.getComponent().setSelectedIndex(this.getComponent().getItemCount() - 1);
            return true;
        }
        return false;
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setReadonly(!readWrite);
    }

    @Override
    public boolean isReadWrite() {
        return !this.getComponent().isReadonly();
    }

    @Override
    public void setValue(Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            this.oldValue = null;
            this.getComponent().setValue(null);
            this.getComponent().setSelectedItem(null);
            this.getComponent().setText("");
        } else if (value instanceof TimeZone) {
            TimeZone tz = (TimeZone)value;
            this.getComponent().setValue(tz.getID());
            this.oldValue = tz.getID();
        } else {
            this.getComponent().setValue(value);
            this.oldValue = this.getComponent().getSelectedItem() != null ? (String)this.getComponent().getSelectedItem().getValue() : (this.processCustomZoneId(value.toString()) ? (String)this.getComponent().getSelectedItem().getValue() : null);
        }
    }

    @Override
    public String getValue() {
        return this.getComponent().getValue();
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getName();
    }

    @Override
    public String getDisplayTextForGridView(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof TimeZone) {
            return this.getLabel((TimeZone)value);
        }
        if (value instanceof String) {
            String id = (String)value;
            if (Util.isEmpty((String)id, (boolean)true)) {
                return (String)value;
            }
            TimeZone tz = TimeZone.getTimeZone((String)value);
            if (tz != null && tz.getID().equals((String)value)) {
                return this.getLabel(tz);
            }
            return (String)value;
        }
        return value.toString();
    }

    public Combobox getComponent() {
        return (Combobox)super.getComponent();
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if (TIME_ZONE.equals(evt.getContextEvent())) {
            Component target;
            if (this.isReadWrite() && (target = evt.getTarget()) != null && target.getAttribute(TIME_ZONE_ID_ATTR) != null) {
                String id = (String)target.getAttribute(TIME_ZONE_ID_ATTR);
                this.setTimeZoneFromContextMenu(id);
            }
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.gridField != null && this.isShowPreference()) {
            ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
        }
    }

    private void setTimeZoneFromContextMenu(String id) {
        String newValue = id;
        String currentValue = this.oldValue;
        this.setValue(id);
        if (this.getComponent().getSelectedItem() == null) {
            newValue = null;
        }
        if (newValue != null) {
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        } else if (currentValue != null) {
            this.setValue(currentValue);
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    private void addTimeZoneMenu(WEditorPopupMenu popupMenu) {
        block13: {
            block12: {
                TimeZone tz;
                if (popupMenu == null || !this.isReadWrite() || popupMenu.getAttribute(TIME_ZONE_ADDED) != null) break block12;
                ClientInfo clientInfo = SessionManager.getAppDesktop().getClientInfo();
                if (clientInfo == null || clientInfo.timeZone == null) break block13;
                TimeZone firstSameRule = null;
                TimeZone found = null;
                int i = 0;
                while (i < this.getComponent().getItemCount()) {
                    String id = (String)this.getComponent().getItemAtIndex(i).getValue();
                    TimeZone tz2 = TimeZone.getTimeZone(id);
                    if (tz2.getID().equals(clientInfo.timeZone.getID())) {
                        found = tz2;
                        break;
                    }
                    if (tz2.getRawOffset() == clientInfo.timeZone.getRawOffset() && tz2.getDSTSavings() == clientInfo.timeZone.getDSTSavings() && tz2.useDaylightTime() == clientInfo.timeZone.useDaylightTime() && firstSameRule == null) {
                        firstSameRule = tz2;
                    }
                    ++i;
                }
                TimeZone timeZone = tz = found != null ? found : firstSameRule;
                if (tz != null) {
                    Menuitem item = new Menuitem();
                    item.setLabel(this.getLabel(clientInfo.timeZone));
                    item.addEventListener("onClick", (EventListener)popupMenu);
                    item.setAttribute("EVENT", (Object)TIME_ZONE);
                    item.setAttribute(TIME_ZONE_ID_ATTR, (Object)tz.getID());
                    item.setAttribute(TIME_ZONE_ITEM_ATTR, (Object)Boolean.TRUE);
                    popupMenu.appendChild((Component)item);
                    popupMenu.setAttribute(TIME_ZONE_ADDED, Boolean.TRUE);
                }
                if (popupMenu.getAttribute(TIME_ZONE_ADDED) != null) break block13;
                ArrayList<String> labels = new ArrayList<String>();
                ArrayList<String> ids = new ArrayList<String>();
                int i2 = 0;
                while (i2 < this.getComponent().getItemCount()) {
                    String id = (String)this.getComponent().getItemAtIndex(i2).getValue();
                    tz = TimeZone.getTimeZone(id);
                    if (tz.getRawOffset() == clientInfo.timeZone.getRawOffset()) {
                        labels.add(this.getLabel(tz));
                        ids.add(id);
                    }
                    ++i2;
                }
                if (labels.size() == 1) {
                    Menuitem item = new Menuitem();
                    item.setLabel((String)labels.get(0));
                    item.addEventListener("onClick", (EventListener)popupMenu);
                    item.setAttribute("EVENT", (Object)TIME_ZONE);
                    item.setAttribute(TIME_ZONE_ID_ATTR, ids.get(0));
                    item.setAttribute(TIME_ZONE_ITEM_ATTR, (Object)Boolean.TRUE);
                    popupMenu.appendChild((Component)item);
                } else {
                    Menu menu = new Menu();
                    menu.setLabel(Msg.getElement((Properties)Env.getCtx(), (String)"TimeZone"));
                    menu.setAttribute(TIME_ZONE_ITEM_ATTR, (Object)Boolean.TRUE);
                    popupMenu.appendChild((Component)menu);
                    Menupopup subPopup = new Menupopup();
                    menu.appendChild((Component)subPopup);
                    int i3 = 0;
                    while (i3 < labels.size()) {
                        String label = (String)labels.get(i3);
                        String id = (String)ids.get(i3);
                        Menuitem item = new Menuitem();
                        item.setLabel(label);
                        item.addEventListener("onClick", (EventListener)popupMenu);
                        item.setAttribute("EVENT", (Object)TIME_ZONE);
                        item.setAttribute(TIME_ZONE_ID_ATTR, (Object)id);
                        subPopup.appendChild((Component)item);
                        ++i3;
                    }
                }
                popupMenu.setAttribute(TIME_ZONE_ADDED, Boolean.TRUE);
                break block13;
            }
            if (popupMenu != null) {
                List childs = popupMenu.getChildren();
                for (Component c : childs) {
                    if (c.getAttribute(TIME_ZONE_ITEM_ATTR) == null) continue;
                    if (this.isReadWrite()) {
                        if (c.isVisible()) continue;
                        c.setVisible(true);
                        continue;
                    }
                    if (!c.isVisible()) continue;
                    c.setVisible(false);
                }
            }
        }
    }

    private String getLabel(TimeZone tz) {
        String name = tz.getID();
        int rawOffset = tz.getRawOffset();
        int offsetMinutes = rawOffset / 60000;
        boolean negative = false;
        if (offsetMinutes < 0) {
            negative = true;
            offsetMinutes = -offsetMinutes;
        }
        int h = offsetMinutes / 60;
        int m = offsetMinutes - h * 60;
        StringBuilder fullName = new StringBuilder("UTC").append(negative ? "-" : "+").append(h < 10 ? "0" : "").append(h).append(":").append(m < 10 ? "0" : "").append(m).append(" ").append(name);
        return fullName.toString();
    }
}

