/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.adempiere.base.Core;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.model.MClient;
import org.compiere.util.CLogConsole;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogFilter;
import org.compiere.util.CLogFormatter;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;

public class CLogMgt {
    private static final CLogConsole CONSOLE_HANDLER = new CLogConsole();
    private static final CLogErrorBuffer ERROR_BUFFER_HANDLER = new CLogErrorBuffer();
    private static CLogFile fileHandler;
    private static final Map<String, Level> levelMap;
    private static final Map<String, Logger> loggerMap;
    private static final Runnable configurationListener;
    private static Logger log;
    public static final Level[] LEVELS;
    private static final String NL;
    private static Level previousLevel;

    static {
        levelMap = new ConcurrentHashMap<String, Level>();
        loggerMap = new ConcurrentHashMap<String, Logger>();
        configurationListener = new Runnable(){

            @Override
            public void run() {
                CLogMgt.reInit();
            }
        };
        log = Logger.getAnonymousLogger();
        LEVELS = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
        NL = System.getProperty("line.separator");
        previousLevel = null;
    }

    private static synchronized void reInit() {
        CLogMgt.initialize(Ini.isClient());
        if (!levelMap.isEmpty()) {
            loggerMap.clear();
            for (String key : levelMap.keySet()) {
                CLogMgt.setLevel(key, levelMap.get(key));
            }
        }
        if (fileHandler != null) {
            fileHandler.reopen();
        }
    }

    public static Level getFromLevelMap(String name) {
        return levelMap.get(name);
    }

    public static synchronized void initialize(boolean isClient) {
        int i2;
        Handler[] handlers;
        Logger rootLogger;
        ArrayList<String> handlerNames;
        LogManager mgr;
        block13: {
            mgr = LogManager.getLogManager();
            if (isClient) {
                try {
                    String fileName = "logClient.properties";
                    InputStream in = CLogMgt.class.getResourceAsStream(fileName);
                    BufferedInputStream bin = new BufferedInputStream(in);
                    mgr.readConfiguration(bin);
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            handlerNames = new ArrayList<String>();
            try {
                rootLogger = CLogMgt.getRootLogger();
                handlers = rootLogger.getHandlers();
                i2 = 0;
                while (i2 < handlers.length) {
                    handlerNames.add(handlers[i2].getClass().getName());
                    ++i2;
                }
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException) break block13;
                System.err.println(e.toString());
            }
        }
        if (!handlerNames.contains(CLogErrorBuffer.class.getName())) {
            CLogMgt.addHandler(ERROR_BUFFER_HANDLER);
        }
        if (isClient && !handlerNames.contains(CLogConsole.class.getName())) {
            CLogMgt.addHandler(CONSOLE_HANDLER);
        }
        if (!handlerNames.contains(CLogFile.class.getName())) {
            if (fileHandler == null) {
                fileHandler = new CLogFile(null, true, isClient);
            }
            CLogMgt.addHandler(fileHandler);
        }
        CLogMgt.setFormatter(CLogFormatter.get());
        CLogMgt.setFilter(CLogFilter.get());
        mgr.removeConfigurationListener(configurationListener);
        mgr.addConfigurationListener(configurationListener);
        try {
            rootLogger = CLogMgt.getRootLogger();
            handlers = rootLogger.getHandlers();
            i2 = 0;
            while (i2 < handlers.length) {
                handlers[i2].setLevel(Level.ALL);
                ++i2;
            }
        }
        catch (Exception exception) {}
    }

    protected static Handler[] getHandlers() {
        Logger rootLogger = CLogMgt.getRootLogger();
        Handler[] handlers = rootLogger.getHandlers();
        return handlers;
    }

    public static void addHandler(Handler handler) {
        if (handler == null) {
            return;
        }
        Logger rootLogger = CLogMgt.getRootLogger();
        rootLogger.addHandler(handler);
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "Handler=" + String.valueOf(handler));
        }
    }

    protected static void setFormatter(Formatter formatter) {
        Logger rootLogger = CLogMgt.getRootLogger();
        Handler[] handlers = rootLogger.getHandlers();
        int i2 = 0;
        while (i2 < handlers.length) {
            handlers[i2].setFormatter(formatter);
            ++i2;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "Formatter=" + String.valueOf(formatter));
        }
    }

    protected static void setFilter(Filter filter) {
        Logger rootLogger = CLogMgt.getRootLogger();
        Handler[] handlers = rootLogger.getHandlers();
        int i2 = 0;
        while (i2 < handlers.length) {
            handlers[i2].setFilter(filter);
            ++i2;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "Filter=" + String.valueOf(filter));
        }
    }

    public static void setLoggerLevel(Level level, String loggerNamePart) {
        if (level == null) {
            return;
        }
        LogManager mgr = LogManager.getLogManager();
        Enumeration<String> en = mgr.getLoggerNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            if (loggerNamePart != null && name.indexOf(loggerNamePart) == -1) continue;
            Logger lll = Logger.getLogger(name);
            lll.setLevel(level);
        }
    }

    public static void setLevel(Level level) {
        CLogMgt.setLevel(null, level);
    }

    public static synchronized void setLevel(String loggerName, Level level) {
        String key;
        if (level == null) {
            return;
        }
        Logger logger = loggerName == null || loggerName.trim().length() == 0 ? CLogMgt.getRootLogger() : CLogger.getCLogger(loggerName, false);
        logger.setLevel(level);
        if (loggerName == null || loggerName.trim().length() == 0) {
            Handler[] handlers = logger.getHandlers();
            if (handlers == null || handlers.length == 0) {
                CLogMgt.initialize(true);
            } else {
                Handler[] handlerArray = handlers;
                int n = handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    Handler handler = handlerArray[n2];
                    handler.setLevel(Level.ALL);
                    ++n2;
                }
            }
            CLogMgt.setJDBCDebug(level.intValue() == Level.ALL.intValue());
            LogManager mgr = LogManager.getLogManager();
            Iterator<String> ln = mgr.getLoggerNames().asIterator();
            while (ln.hasNext()) {
                String cl = ln.next();
                CLogger.getCLogger(cl, false).setLevel(level);
            }
            CLogMgt.getRootLogger().setLevel(level);
        } else if (!logger.getUseParentHandlers()) {
            logger.setUseParentHandlers(true);
        }
        String string = key = loggerName == null ? "" : loggerName;
        if (!levelMap.containsKey(key)) {
            levelMap.put(key, level);
            loggerMap.put(key, logger);
        }
    }

    public static void setLevel(int intLevel) {
        CLogMgt.setLevel(String.valueOf(intLevel));
    }

    public static void setLevel(String levelString) {
        CLogMgt.setLevel(null, levelString);
    }

    public static void setLevel(String loggerName, String levelString) {
        if (levelString == null) {
            return;
        }
        int i2 = 0;
        while (i2 < LEVELS.length) {
            if (LEVELS[i2].getName().equals(levelString)) {
                CLogMgt.setLevel(loggerName, LEVELS[i2]);
                return;
            }
            ++i2;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.log(Level.CONFIG, "Ignored: " + levelString);
        }
    }

    public static void setJDBCDebug(boolean enable) {
        if (enable) {
            DriverManager.setLogWriter(new PrintWriter(System.err));
        } else {
            DriverManager.setLogWriter(null);
        }
    }

    public static Level getLevel() {
        Logger rootLogger = CLogMgt.getRootLogger();
        return rootLogger.getLevel();
    }

    public static int getLevelAsInt() {
        Logger rootLogger = CLogMgt.getRootLogger();
        return rootLogger.getLevel().intValue();
    }

    public static boolean isLevel(Level level) {
        if (level == null) {
            return false;
        }
        return level.intValue() >= CLogMgt.getLevelAsInt();
    }

    public static boolean isLevelAll() {
        return Level.ALL.intValue() == CLogMgt.getLevelAsInt();
    }

    public static boolean isLevelFinest() {
        return Level.FINEST.intValue() >= CLogMgt.getLevelAsInt();
    }

    public static boolean isLevelFiner() {
        return Level.FINER.intValue() >= CLogMgt.getLevelAsInt();
    }

    public static boolean isLevelFine() {
        return Level.FINE.intValue() >= CLogMgt.getLevelAsInt();
    }

    public static boolean isLevelInfo() {
        return Level.INFO.intValue() >= CLogMgt.getLevelAsInt();
    }

    @Deprecated
    public static void enable(boolean enableLogging) {
        Logger rootLogger = CLogMgt.getRootLogger();
        if (enableLogging) {
            if (previousLevel != null) {
                CLogMgt.setLevel(previousLevel);
            } else {
                CLogMgt.setLevel(rootLogger.getLevel());
            }
            CLogMgt.reInit();
            previousLevel = null;
        } else {
            previousLevel = rootLogger.getLevel();
            CLogMgt.setLevel(Level.OFF);
        }
    }

    public static void shutdown() {
        LogManager mgr = LogManager.getLogManager();
        mgr.reset();
    }

    public static void printProperties(Properties p2, String description, boolean logIt) {
        if (p2 == null) {
            return;
        }
        if (logIt) {
            if (log.isLoggable(Level.INFO)) {
                log.info(description + " - Size=" + p2.size() + ", Hash=" + p2.hashCode() + "\n" + CLogMgt.getLocalHost());
            }
        } else {
            System.out.println("Log.printProperties = " + description + ", Size=" + p2.size());
        }
        Object[] pp = p2.keySet().toArray();
        Arrays.sort(pp);
        int i2 = 0;
        while (i2 < pp.length) {
            String key = pp[i2].toString();
            String value = p2.getProperty(key);
            if (logIt) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(key + "=" + value);
                }
            } else {
                System.out.println("  " + key + " = " + value);
            }
            ++i2;
        }
    }

    public static StringBuffer getInfo(StringBuffer sb) {
        IClusterService service;
        if (sb == null) {
            sb = new StringBuffer();
        }
        sb.append(CLogMgt.getMsg("Host")).append(" = ").append(CLogMgt.getServerInfo()).append(NL);
        sb.append(CLogMgt.getMsg("Database")).append(" = ").append(CLogMgt.getDatabaseInfo()).append(NL);
        sb.append(CLogMgt.getMsg("Schema")).append(" = ").append(CConnection.get().getDbUid()).append(NL);
        sb.append(CLogMgt.getMsg("AD_User_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_User_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Role_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Role_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Client_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Client_Name")).append(NL);
        sb.append(CLogMgt.getMsg("AD_Org_ID")).append(" = ").append(Env.getContext(Env.getCtx(), "#AD_Org_Name")).append(NL);
        sb.append(CLogMgt.getMsg("Date")).append(" = ").append(Env.getContext(Env.getCtx(), "#Date")).append(NL);
        sb.append(CLogMgt.getMsg("Printer")).append(" = ").append(Env.getContext(Env.getCtx(), "#Printer")).append(NL);
        sb.append(CLogMgt.getMsg("ImplementationVendor")).append(" = ").append(Adempiere.getImplementationVendor()).append(NL);
        sb.append(CLogMgt.getMsg("ImplementationVersion")).append(" = ").append(Adempiere.getImplementationVersion()).append(NL);
        sb.append("iDempiereHome = ").append(Adempiere.getAdempiereHome()).append(NL);
        sb.append("iDempiereProperties = ").append(Ini.getPropertyFileName()).append(NL);
        sb.append(Env.getLanguage(Env.getCtx())).append(NL);
        MClient client = MClient.get(Env.getCtx());
        sb.append(client).append(NL);
        sb.append(CLogMgt.getMsg("IsMultiLingualDocument")).append(" = ").append(client.isMultiLingualDocument()).append(NL);
        sb.append("BaseLanguage = ").append(Env.isBaseLanguage(Env.getCtx(), "AD_Window")).append("/").append(Env.isBaseLanguage(Env.getCtx(), "C_UOM")).append(NL);
        sb.append(Adempiere.getJavaInfo()).append(NL);
        sb.append("java.io.tmpdir=" + System.getProperty("java.io.tmpdir")).append(NL);
        sb.append(Adempiere.getOSInfo()).append(NL);
        Runtime runtime = Runtime.getRuntime();
        sb.append("Max Heap = " + CLogMgt.formatMemoryInfo(runtime.maxMemory())).append(NL);
        sb.append("Allocated Heap = " + CLogMgt.formatMemoryInfo(runtime.totalMemory())).append(NL);
        sb.append("Free Heap = " + CLogMgt.formatMemoryInfo(runtime.freeMemory())).append(NL);
        sb.append("Active Threads = " + Thread.activeCount());
        if (Env.getAD_Client_ID(Env.getCtx()) == 0 && (service = Core.getClusterService()) != null) {
            IClusterMember local = service.getLocalMember();
            Collection<IClusterMember> members = service.getMembers();
            if (!members.isEmpty()) {
                sb.append(NL).append("Cluster Nodes:").append(NL);
            }
            for (IClusterMember member : members) {
                sb.append(member.toString());
                if (local != null && member.getId().equals(local.getId())) {
                    sb.append(" *");
                }
                sb.append(NL);
            }
        }
        return sb;
    }

    private static String formatMemoryInfo(long amount) {
        String unit = "";
        long size = amount / 1024L;
        if (size > 1024L) {
            size /= 1024L;
            unit = "M";
        } else {
            unit = "K";
        }
        return size + unit;
    }

    public static StringBuffer getInfoDetail(StringBuffer sb, Properties ctx) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (ctx == null) {
            ctx = Env.getCtx();
        }
        CConnection cc = CConnection.get();
        sb.append(NL).append(NL).append("=== Environment === ").append(NL).append(Adempiere.getCheckSum()).append(NL).append(Adempiere.getSummaryAscii()).append(NL).append(CLogMgt.getLocalHost()).append(NL).append(cc.getName() + " " + cc.getDbUid() + "@" + cc.getConnectionURL()).append(NL).append(cc.getInfo()).append(NL);
        sb.append(NL).append("=== DB Connection Pool === ").append(NL).append(cc.getDatabase().getStatus().replace(" , ", NL)).append(NL);
        Object[] context = Env.getEntireContext(ctx);
        sb.append(NL).append("=== Context (%s) ===".formatted(context.length)).append(NL);
        Arrays.sort(context);
        int i2 = 0;
        while (i2 < context.length) {
            sb.append((String)context[i2]).append(NL);
            ++i2;
        }
        sb.append(NL).append("=== System ===").append(NL);
        Object[] pp = System.getProperties().keySet().toArray();
        Arrays.sort(pp);
        int i3 = 0;
        while (i3 < pp.length) {
            String key = pp[i3].toString();
            String value = System.getProperty(key);
            sb.append(key).append("=").append(value).append(NL);
            ++i3;
        }
        return sb;
    }

    private static String getMsg(String msg) {
        if (DB.isConnected()) {
            return Msg.translate(Env.getCtx(), msg);
        }
        return msg;
    }

    private static String getServerInfo() {
        StringBuilder sb = new StringBuilder();
        CConnection cc = CConnection.get();
        sb.append(cc.getAppsHost());
        return sb.toString();
    }

    private static String getDatabaseInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(CConnection.get().getDbHost()).append(":").append(CConnection.get().getDbPort()).append("/").append(CConnection.get().getDbName());
        AdempiereDatabase db = DB.getDatabase();
        sb.append(" (").append(db.getName());
        if (!DB.isOracle()) {
            sb.append(", ").append(db.isNativeMode() ? "Native Dialect" : "Oracle Dialect");
        }
        sb.append(")");
        if (CConnection.get().isViaFirewall()) {
            sb.append(CLogMgt.getMsg("via")).append(" ").append(CConnection.get().getFwHost()).append(" : ").append(CConnection.get().getFwPort());
        }
        return sb.toString();
    }

    private static String getLocalHost() {
        try {
            InetAddress id = InetAddress.getLocalHost();
            return id.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "getLocalHost", e);
            return "-no local host info -";
        }
    }

    private static Logger getRootLogger() {
        Logger rootLogger = Logger.getLogger("");
        if (rootLogger.getUseParentHandlers()) {
            rootLogger.setUseParentHandlers(false);
        }
        if (rootLogger.getLevel() == null) {
            rootLogger.setLevel(Level.WARNING);
        }
        return rootLogger;
    }
}

