/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.X_AD_PrintFormatItem;
import org.compiere.print.MPrintFormat;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOSupport;

public class MPrintFormatItem
extends X_AD_PrintFormatItem
implements ImmutablePOSupport {
    private static final long serialVersionUID = 2950704375830865408L;
    private String m_columnName = null;
    private HashMap<String, String> m_translationLabel;
    String m_newTranslationLabel = null;
    boolean m_translationLabelChanged = false;
    private HashMap<String, String> m_translationSuffix;
    private static CLogger s_log = CLogger.getCLogger(MPrintFormatItem.class);
    private static CCache<Integer, String> s_columns = new CCache("AD_PrintFormatItem", 200);

    public MPrintFormatItem(Properties ctx, String AD_PrintFormatItem_UU, String trxName) {
        super(ctx, AD_PrintFormatItem_UU, trxName);
        if (Util.isEmpty(AD_PrintFormatItem_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPrintFormatItem(Properties ctx, int AD_PrintFormatItem_ID, String trxName) {
        super(ctx, AD_PrintFormatItem_ID, trxName);
        if (AD_PrintFormatItem_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setFieldAlignmentType("D");
        this.setLineAlignmentType("X");
        this.setPrintFormatType("T");
        this.setPrintAreaType("C");
        this.setShapeType("N");
        this.setIsCentrallyMaintained(true);
        this.setIsRelativePosition(true);
        this.setIsNextLine(false);
        this.setIsNextPage(false);
        this.setIsSetNLPosition(false);
        this.setIsFilledRectangle(false);
        this.setIsImageField(false);
        this.setXSpace(0);
        this.setYSpace(0);
        this.setXPosition(0);
        this.setYPosition(0);
        this.setMaxWidth(0);
        this.setIsFixedWidth(false);
        this.setIsHeightOneLine(false);
        this.setMaxHeight(0);
        this.setLineWidth(1);
        this.setArcDiameter(0);
        this.setIsOrderBy(false);
        this.setSortNo(0);
        this.setIsGroupBy(false);
        this.setIsPageBreak(false);
        this.setIsSummarized(false);
        this.setIsAveraged(false);
        this.setIsCounted(false);
        this.setIsMinCalc(false);
        this.setIsMaxCalc(false);
        this.setIsVarianceCalc(false);
        this.setIsDeviationCalc(false);
        this.setIsRunningTotal(false);
        this.setImageIsAttached(false);
        this.setIsSuppressNull(false);
    }

    public MPrintFormatItem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPrintFormatItem(MPrintFormatItem copy) {
        this(Env.getCtx(), copy);
    }

    public MPrintFormatItem(Properties ctx, MPrintFormatItem copy) {
        this(ctx, copy, null);
    }

    public MPrintFormatItem(Properties ctx, MPrintFormatItem copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_columnName = copy.m_columnName;
        this.m_newTranslationLabel = copy.m_newTranslationLabel;
        this.m_translationLabelChanged = copy.m_translationLabelChanged;
        this.m_translationLabel = copy.m_translationLabel != null ? new HashMap<String, String>(copy.m_translationLabel) : null;
        this.m_translationSuffix = copy.m_translationSuffix != null ? new HashMap<String, String>(copy.m_translationSuffix) : null;
    }

    public String getPrintName(Language language) {
        if (language == null || Env.isBaseLanguage(language, "AD_PrintFormatItem")) {
            return this.getPrintName();
        }
        this.loadTranslations();
        String retValue = this.m_translationLabel.get(language.getAD_Language());
        if (retValue == null || retValue.length() == 0) {
            return this.getPrintName();
        }
        return retValue;
    }

    public void setPrintName(Language language, String printName) {
        if (language == null || Env.isBaseLanguage(language, "AD_PrintFormatItem")) {
            this.setPrintName(printName);
            return;
        }
        this.loadTranslations();
        String retValue = this.m_translationLabel.get(language.getAD_Language());
        if (retValue != null && !retValue.equals(printName) || retValue == null && printName != null) {
            this.m_newTranslationLabel = printName;
            this.m_translationLabelChanged = true;
            this.m_translationLabel.put(language.getAD_Language(), printName);
        }
    }

    public String getPrintNameSuffix(Language language) {
        if (language == null || Env.isBaseLanguage(language, "AD_PrintFormatItem")) {
            return this.getPrintNameSuffix();
        }
        this.loadTranslations();
        String retValue = this.m_translationSuffix.get(language.getAD_Language());
        if (retValue == null || retValue.length() == 0) {
            return this.getPrintNameSuffix();
        }
        return retValue;
    }

    private void loadTranslations() {
        block7: {
            if (this.m_translationLabel == null) {
                this.m_translationLabel = new HashMap();
                this.m_translationSuffix = new HashMap();
                String sql = "SELECT AD_Language, PrintName, PrintNameSuffix FROM AD_PrintFormatItem_Trl WHERE AD_PrintFormatItem_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.get_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            this.m_translationLabel.put(rs.getString(1), rs.getString(2));
                            this.m_translationSuffix.put(rs.getString(1), rs.getString(3));
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, "loadTrl", e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
    }

    public boolean isTypeScript() {
        return this.getPrintFormatType().equals("S");
    }

    public boolean isTypeField() {
        return this.getPrintFormatType().equals("F");
    }

    public boolean isTypeText() {
        return this.getPrintFormatType().equals("T");
    }

    public boolean isTypePrintFormat() {
        return this.getPrintFormatType().equals("P");
    }

    public boolean isTypeImage() {
        return this.getPrintFormatType().equals("I");
    }

    public boolean isTypeBox() {
        return this.getPrintFormatType().equals("L") || this.getPrintFormatType().equals("R");
    }

    public boolean isFieldCenter() {
        return this.getFieldAlignmentType().equals("C");
    }

    public boolean isFieldAlignLeading() {
        return this.getFieldAlignmentType().equals("L");
    }

    public boolean isFieldAlignTrailing() {
        return this.getFieldAlignmentType().equals("T");
    }

    public boolean isFieldAlignBlock() {
        return this.getFieldAlignmentType().equals("B");
    }

    public boolean isFieldAlignDefault() {
        return this.getFieldAlignmentType().equals("D");
    }

    public boolean isLineAlignCenter() {
        return this.getLineAlignmentType().equals("C");
    }

    public boolean isLineAlignLeading() {
        return this.getLineAlignmentType().equals("L");
    }

    public boolean isLineAlignTrailing() {
        return this.getLineAlignmentType().equals("T");
    }

    public boolean isHeader() {
        return this.getPrintAreaType().equals("H");
    }

    public boolean isContent() {
        return this.getPrintAreaType().equals("C");
    }

    public boolean isFooter() {
        return this.getPrintAreaType().equals("F");
    }

    public boolean isBarcode() {
        String s = this.getBarcodeType();
        return s != null && s.length() > 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPrintFormatItem[");
        sb.append("ID=").append(this.get_ID()).append(",Name=").append(this.getName()).append(",Print=").append(this.getPrintName()).append(", Seq=").append(this.getSeqNo()).append(",Sort=").append(this.getSortNo()).append(", Area=").append(this.getPrintAreaType()).append(", MaxWidth=").append(this.getMaxWidth()).append(",MaxHeight=").append(this.getMaxHeight()).append(",OneLine=").append(this.isHeightOneLine()).append(", Relative=").append(this.isRelativePosition());
        if (this.isRelativePosition()) {
            sb.append(",X=").append(this.getXSpace()).append(",Y=").append(this.getYSpace()).append(",LineAlign=").append(this.getLineAlignmentType()).append(",NewLine=").append(this.isNextLine()).append(",NewPage=").append(this.isPageBreak());
        } else {
            sb.append(",X=").append(this.getXPosition()).append(",Y=").append(this.getYPosition());
        }
        sb.append(",FieldAlign=").append(this.getFieldAlignmentType());
        sb.append(", Type=").append(this.getPrintFormatType());
        if (!this.isTypeText()) {
            if (this.isTypeField()) {
                sb.append(",AD_Column_ID=").append(this.getAD_Column_ID());
            } else if (this.isTypePrintFormat()) {
                sb.append(",AD_PrintFormatChild_ID=").append(this.getAD_PrintFormatChild_ID()).append(",AD_Column_ID=").append(this.getAD_Column_ID());
            } else if (this.isTypeImage()) {
                sb.append(",ImageIsAttached=").append(this.isImageIsAttached()).append(",ImageURL=").append(this.getImageURL());
            }
        }
        sb.append(", Printed=").append(this.isPrinted()).append(",SeqNo=").append(this.getSeqNo()).append(",OrderBy=").append(this.isOrderBy()).append(",SortNo=").append(this.getSortNo()).append(",Summarized=").append(this.isSummarized());
        sb.append("]");
        return sb.toString();
    }

    public String getColumnName() {
        if (this.m_columnName == null) {
            this.m_columnName = MPrintFormatItem.getColumnName(this.getAD_Column_ID());
        }
        return this.m_columnName;
    }

    private static String getColumnName(Integer AD_Column_ID) {
        String sql;
        if (AD_Column_ID == null || AD_Column_ID == 0) {
            return null;
        }
        String retValue = s_columns.get(AD_Column_ID);
        if (retValue == null && (retValue = DB.getSQLValueString(null, sql = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?", AD_Column_ID)) != null) {
            s_columns.put(AD_Column_ID, retValue);
        }
        return retValue;
    }

    public static MPrintFormatItem createFromColumn(MPrintFormat format, int AD_Column_ID, int seqNo) {
        MPrintFormatItem pfi;
        block18: {
            boolean trl;
            pfi = new MPrintFormatItem(format.getCtx(), 0, format.get_TrxName());
            pfi.setAD_PrintFormat_ID(format.getAD_PrintFormat_ID());
            pfi.setClientOrg(format);
            pfi.setAD_Column_ID(AD_Column_ID);
            pfi.setPrintFormatType("F");
            String sql = "SELECT c.ColumnName,e.Name,e.PrintName, c.AD_Reference_ID,c.IsKey,c.SeqNo FROM AD_Column c, AD_Element e WHERE c.AD_Column_ID=? AND c.AD_Element_ID=e.AD_Element_ID";
            Language language = format.getLanguage();
            boolean bl = trl = !Env.isMultiLingualDocument(format.getCtx()) && !language.isBaseLanguage();
            if (trl) {
                sql = "SELECT c.ColumnName,e.Name,e.PrintName, c.AD_Reference_ID,c.IsKey,c.SeqNo FROM AD_Column c, AD_Element_Trl e WHERE c.AD_Column_ID=? AND c.AD_Element_ID=e.AD_Element_ID AND e.AD_Language=?";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, format.get_TrxName());
                    pstmt.setInt(1, AD_Column_ID);
                    if (trl) {
                        pstmt.setString(2, language.getAD_Language());
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        String ColumnName = rs.getString(1);
                        pfi.setName(rs.getString(2));
                        pfi.setPrintName(rs.getString(3));
                        int displayType = rs.getInt(4);
                        if (DisplayType.isNumeric(displayType)) {
                            pfi.setFieldAlignmentType("T");
                        } else if (displayType == 14 || displayType == 34) {
                            pfi.setFieldAlignmentType("B");
                        } else {
                            pfi.setFieldAlignmentType("L");
                        }
                        boolean isKey = "Y".equals(rs.getString(5));
                        if (isKey || ColumnName.startsWith("Created") || ColumnName.startsWith("Updated") || ColumnName.equals("AD_Client_ID") || ColumnName.equals("AD_Org_ID") || ColumnName.equals("IsActive") || displayType == 28 || displayType == 23 || displayType == 13 || displayType == 32 || displayType == 26 || displayType == 53370 || seqNo == 0) {
                            pfi.setIsPrinted(false);
                            pfi.setSeqNo(0);
                        } else {
                            pfi.setIsPrinted(true);
                            pfi.setSeqNo(seqNo);
                        }
                        int idSeqNo = rs.getInt(6);
                        if (idSeqNo > 0) {
                            pfi.setIsOrderBy(true);
                            pfi.setSortNo(idSeqNo);
                        }
                        if (displayType == 200271) {
                            pfi.setPrintFormatType("I");
                            pfi.setIsImageField(true);
                            pfi.setMaxWidth(MSysConfig.getIntValue("ZK_THUMBNAIL_IMAGE_WIDTH", 100, Env.getAD_Client_ID(Env.getCtx())));
                            pfi.setMaxHeight(MSysConfig.getIntValue("ZK_THUMBNAIL_IMAGE_HEIGHT", 100, Env.getAD_Client_ID(Env.getCtx())));
                        }
                    } else {
                        s_log.log(Level.SEVERE, "Not Found AD_Column_ID=" + AD_Column_ID + " Trl=" + trl + " " + language.getAD_Language());
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (!pfi.save()) {
            return null;
        }
        return pfi;
    }

    public static MPrintFormatItem createFromGridField(MPrintFormat format, GridField gridField, int seqNo) {
        MPrintFormatItem pfi;
        block19: {
            boolean trl;
            if (gridField.getAD_Column_ID() <= 0) {
                return null;
            }
            pfi = new MPrintFormatItem(format.getCtx(), 0, format.get_TrxName());
            pfi.setAD_PrintFormat_ID(format.getAD_PrintFormat_ID());
            pfi.setClientOrg(format);
            pfi.setAD_Column_ID(gridField.getAD_Column_ID());
            pfi.setPrintFormatType("F");
            String sql = "SELECT c.ColumnName,e.Name,e.PrintName, c.AD_Reference_ID,c.IsKey,c.SeqNo FROM AD_Column c, AD_Element e WHERE c.AD_Column_ID=? AND c.AD_Element_ID=e.AD_Element_ID";
            Language language = format.getLanguage();
            boolean bl = trl = !Env.isMultiLingualDocument(format.getCtx()) && !language.isBaseLanguage();
            if (trl) {
                sql = "SELECT c.ColumnName,e.Name,e.PrintName, c.AD_Reference_ID,c.IsKey,c.SeqNo FROM AD_Column c, AD_Element_Trl e WHERE c.AD_Column_ID=? AND c.AD_Element_ID=e.AD_Element_ID AND e.AD_Language=?";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, format.get_TrxName());
                    pstmt.setInt(1, gridField.getAD_Column_ID());
                    if (trl) {
                        pstmt.setString(2, language.getAD_Language());
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        pfi.setName(rs.getString(2));
                        pfi.setPrintName(rs.getString(3));
                        int displayType = rs.getInt(4);
                        if (DisplayType.isNumeric(displayType)) {
                            pfi.setFieldAlignmentType("T");
                        } else if (displayType == 14 || displayType == 34) {
                            pfi.setFieldAlignmentType("B");
                        } else {
                            pfi.setFieldAlignmentType("L");
                        }
                        if (displayType == 28 || displayType == 23 || displayType == 13 || displayType == 32 || displayType == 26 || displayType == 53370 || seqNo == 0) {
                            pfi.setIsPrinted(false);
                            pfi.setSeqNo(0);
                        } else {
                            pfi.setIsPrinted(true);
                            pfi.setSeqNo(seqNo);
                        }
                        int idSeqNo = rs.getInt(6);
                        if (idSeqNo > 0) {
                            pfi.setIsOrderBy(true);
                            pfi.setSortNo(idSeqNo);
                        }
                        if (displayType == 200271) {
                            pfi.setPrintFormatType("I");
                            pfi.setIsImageField(true);
                            pfi.setMaxWidth(MSysConfig.getIntValue("ZK_THUMBNAIL_IMAGE_WIDTH", 100, Env.getAD_Client_ID(Env.getCtx())));
                            pfi.setMaxHeight(MSysConfig.getIntValue("ZK_THUMBNAIL_IMAGE_HEIGHT", 100, Env.getAD_Client_ID(Env.getCtx())));
                        }
                    } else {
                        s_log.log(Level.SEVERE, "Not Found AD_Column_ID=" + gridField.getAD_Column_ID() + " Trl=" + trl + " " + language.getAD_Language());
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (!pfi.save()) {
            return null;
        }
        return pfi;
    }

    public MPrintFormatItem copyToClient(int To_Client_ID, int AD_PrintFormat_ID) {
        return this.copyToClient(To_Client_ID, AD_PrintFormat_ID, null);
    }

    public MPrintFormatItem copyToClient(int To_Client_ID, int AD_PrintFormat_ID, String trxName) {
        MPrintFormatItem to = new MPrintFormatItem(this.p_ctx, 0, trxName);
        MPrintFormatItem.copyValues(this, to);
        to.setClientOrg(To_Client_ID, 0);
        to.setAD_PrintFormat_ID(AD_PrintFormat_ID);
        to.saveEx();
        return to;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!this.isOrderBy()) {
            this.setSortNo(0);
            this.setIsGroupBy(false);
            this.setIsPageBreak(false);
        }
        if (this.isRelativePosition()) {
            this.setXPosition(0);
            this.setYPosition(0);
        } else {
            this.setXSpace(0);
            this.setYSpace(0);
        }
        if (this.isImageField()) {
            this.setImageIsAttached(false);
            this.setImageURL(null);
        }
        if (!(this.isTypeField() || this.isTypePrintFormat() || this.isImageField())) {
            this.setAD_Column_ID(0);
        }
        if (!this.isTypeScript() && !Util.isEmpty(this.getScript())) {
            this.setScript(null);
        }
        if (!Util.isEmpty(this.getScript()) && this.is_ValueChanged("Script") && !MRole.getDefault().isAccessAdvanced()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ActionNotAllowedHere"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int no;
        Object sql;
        if (newRecord && this.getPrintName() != null && this.getPrintName().length() > 0) {
            sql = "UPDATE AD_PrintFormatItem_Trl SET PrintName = (SELECT e.PrintName FROM AD_Element_Trl e, AD_Column c WHERE e.AD_Language=AD_PrintFormatItem_Trl.AD_Language AND e.AD_Element_ID=c.AD_Element_ID AND c.AD_Column_ID=" + this.getAD_Column_ID() + ") WHERE AD_PrintFormatItem_ID = " + this.get_ID() + " AND EXISTS (SELECT * FROM AD_Element_Trl e, AD_Column c WHERE e.AD_Language=AD_PrintFormatItem_Trl.AD_Language AND e.AD_Element_ID=c.AD_Element_ID AND c.AD_Column_ID=" + this.getAD_Column_ID() + " AND AD_PrintFormatItem_Trl.AD_PrintFormatItem_ID = " + this.get_ID() + ") AND EXISTS (SELECT * FROM AD_Client WHERE AD_Client_ID=AD_PrintFormatItem_Trl.AD_Client_ID AND IsMultiLingualDocument='Y')";
            no = DB.executeUpdateEx((String)sql, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("translations updated #" + no);
            }
        }
        if (this.m_translationLabelChanged) {
            sql = "UPDATE AD_PrintFormatItem_Trl SET PrintName = ? WHERE AD_PrintFormatItem_ID = ? AND AD_Language=?";
            no = DB.executeUpdateEx((String)sql, new Object[]{this.m_newTranslationLabel, this.get_ID(), Language.getLoginLanguage().getAD_Language()}, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("translations updated #" + no);
            }
            this.m_newTranslationLabel = null;
            this.m_translationLabelChanged = false;
        }
        return success;
    }

    @Override
    public boolean is_Changed() {
        if (this.m_translationLabelChanged) {
            return true;
        }
        return super.is_Changed();
    }

    @Override
    public MPrintFormatItem markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

