/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Util;

public class POInfoColumn
implements Serializable {
    private static final long serialVersionUID = -6550300505836470875L;
    public int AD_Column_ID;
    public String ColumnName;
    public String ColumnSQL;
    public int DisplayType;
    public Class<?> ColumnClass;
    public boolean IsMandatory;
    public String DefaultLogic;
    public boolean IsUpdateable;
    public String ColumnLabel;
    public String ColumnDescription;
    public boolean IsKey;
    public boolean IsParent;
    public boolean IsTranslated;
    public boolean IsEncrypted;
    public boolean IsAllowLogging;
    public boolean IsAllowCopy;
    public int AD_Reference_Value_ID;
    public String ValidationCode;
    public int FieldLength;
    public String ValueMin;
    public String ValueMax;
    public BigDecimal ValueMin_BD = null;
    public BigDecimal ValueMax_BD = null;
    public Timestamp ValueMin_TS = null;
    public Timestamp ValueMax_TS = null;

    public POInfoColumn(int ad_Column_ID, String columnName, String columnSQL, int displayType, boolean isMandatory, boolean isUpdateable, String defaultLogic, String columnLabel, String columnDescription, boolean isKey, boolean isParent, int ad_Reference_Value_ID, String validationCode, int fieldLength, String valueMin, String valueMax, boolean isTranslated, boolean isEncrypted, boolean isAllowLogging, boolean isAllowCopy) {
        SimpleDateFormat dateFormat;
        this.AD_Column_ID = ad_Column_ID;
        this.ColumnName = columnName;
        this.ColumnSQL = columnSQL;
        this.DisplayType = displayType;
        if (columnName.equals("AD_Language") || columnName.equals("EntityType")) {
            this.DisplayType = 10;
            this.ColumnClass = String.class;
        } else if (columnName.equals("Posted") || columnName.equals("Processed") || columnName.equals("Processing")) {
            this.ColumnClass = Boolean.class;
        } else if (columnName.equals("Record_ID")) {
            this.DisplayType = 13;
            this.ColumnClass = Integer.class;
        } else {
            this.ColumnClass = displayType == 28 && columnName.endsWith("_ID") ? Integer.class : org.compiere.util.DisplayType.getClass(displayType, true);
        }
        this.IsMandatory = isMandatory;
        this.IsUpdateable = isUpdateable;
        this.DefaultLogic = defaultLogic;
        this.ColumnLabel = columnLabel;
        this.ColumnDescription = columnDescription;
        this.IsKey = isKey;
        this.IsParent = isParent;
        this.AD_Reference_Value_ID = ad_Reference_Value_ID;
        this.ValidationCode = validationCode;
        this.FieldLength = fieldLength;
        this.ValueMin = valueMin;
        if (!Util.isEmpty(this.ValueMin)) {
            try {
                this.ValueMin_BD = new BigDecimal(this.ValueMin);
            }
            catch (Exception exception) {
                this.ValueMin_BD = null;
            }
            try {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.ValueMin_TS = new Timestamp(dateFormat.parse(this.ValueMin).getTime());
            }
            catch (Exception exception) {
                this.ValueMin_TS = null;
            }
            if (this.ValueMin_BD == null && this.ValueMin_TS == null) {
                CLogger.get().log(Level.SEVERE, "ValueMin cannot be parsed to a number or date = " + this.ValueMin);
            }
        }
        this.ValueMax = valueMax;
        if (!Util.isEmpty(this.ValueMax)) {
            try {
                this.ValueMax_BD = new BigDecimal(this.ValueMax);
            }
            catch (Exception exception) {
                this.ValueMax_BD = null;
            }
            try {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                this.ValueMax_TS = new Timestamp(dateFormat.parse(this.ValueMax).getTime());
            }
            catch (Exception exception) {
                this.ValueMax_TS = null;
            }
            if (this.ValueMax_BD == null && this.ValueMax_TS == null) {
                CLogger.get().log(Level.SEVERE, "ValueMax cannot be parsed to a number or date = " + this.ValueMax);
            }
        }
        this.IsTranslated = isTranslated;
        this.IsEncrypted = isEncrypted;
        this.IsAllowLogging = isAllowLogging;
        this.IsAllowCopy = isAllowCopy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("POInfo.Column[");
        sb.append(this.ColumnName).append(",ID=").append(this.AD_Column_ID).append(",DisplayType=").append(this.DisplayType).append(",ColumnClass=").append(this.ColumnClass);
        sb.append("]");
        return sb.toString();
    }
}

