/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.Lookup;
import org.compiere.model.MAccount;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;

public final class MAccountLookup
extends Lookup
implements Serializable {
    private static final long serialVersionUID = -6307559127917670193L;
    private Properties m_ctx;
    public int C_ValidCombination_ID;
    private String Combination;
    private String Description;

    public MAccountLookup(Properties ctx, int WindowNo) {
        super(19, WindowNo);
        this.m_ctx = ctx;
    }

    @Override
    public String getDisplay(Object value) {
        if (!this.containsKey(value)) {
            StringBuilder msgreturn = new StringBuilder("<").append(value.toString()).append(">");
            return msgreturn.toString();
        }
        return this.toString();
    }

    @Override
    public NamePair get(Object value) {
        if (value == null) {
            return null;
        }
        if (!this.containsKey(value)) {
            return null;
        }
        return new KeyNamePair(this.C_ValidCombination_ID, this.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        int intValue = 0;
        if (key instanceof Integer) {
            intValue = (Integer)key;
        } else if (key != null) {
            intValue = Integer.parseInt(key.toString());
        }
        return this.load(intValue);
    }

    @Override
    public boolean containsKeyNoDirect(Object key) {
        return this.containsKey(key);
    }

    public String getDescription() {
        return this.Description;
    }

    public String toString() {
        if (this.C_ValidCombination_ID == 0) {
            return "";
        }
        return this.Combination;
    }

    public boolean load(int ID) {
        if (ID == 0) {
            this.C_ValidCombination_ID = 0;
            this.Combination = "";
            this.Description = "";
            return true;
        }
        if (ID == this.C_ValidCombination_ID) {
            return true;
        }
        MAccount account = MAccount.get(Env.getCtx(), ID);
        if (account == null || account.getC_ValidCombination_ID() != ID) {
            return false;
        }
        this.C_ValidCombination_ID = account.getC_ValidCombination_ID();
        this.Combination = account.getCombination();
        this.Description = account.getDescription();
        return true;
    }

    @Override
    public String getColumnName() {
        return "";
    }

    @Override
    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary, boolean isshortlist) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!mandatory) {
            list.add(new KeyNamePair(-1, ""));
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Env.getAD_Client_ID(this.m_ctx));
        List accounts = new Query(Env.getCtx(), "C_ValidCombination", "AD_Client_ID=?", null).setParameters(params).setOrderBy("Combination").setOnlyActiveRecords(onlyActive).list();
        for (MAccount account : accounts) {
            StringBuilder msglist = new StringBuilder().append(account.getCombination()).append(" - ").append(account.getDescription());
            list.add(new KeyNamePair(account.getC_ValidCombination_ID(), msglist.toString()));
        }
        return list;
    }
}

