/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.adempiere.base.event.EventHelper;
import org.adempiere.base.event.annotations.EventDelegate;
import org.adempiere.base.event.annotations.EventTopic;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BaseEventHandler
implements EventHandler {
    protected final Map<String, Method> eventTopicMap = new HashMap<String, Method>();
    private String filter = null;
    private Class<? extends EventDelegate> delegateClass;

    public BaseEventHandler(Class<? extends EventDelegate> delegateClass) {
        this.createTopicMap(delegateClass);
        this.delegateClass = delegateClass;
    }

    protected void createTopicMap(Class<?> delegateClass) {
        Method[] methods;
        Method[] methodArray = methods = delegateClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.isBridge()) {
                Annotation[] annotations;
                Annotation[] annotationArray = annotations = method.getAnnotations();
                int n3 = annotations.length;
                int n4 = 0;
                while (n4 < n3) {
                    String topic;
                    Annotation annotation = annotationArray[n4];
                    if (annotation.annotationType().isAnnotationPresent(EventTopic.class) && !this.eventTopicMap.containsKey(topic = annotation.annotationType().getAnnotation(EventTopic.class).topic())) {
                        method.setAccessible(true);
                        this.eventTopicMap.put(topic, method);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public String[] getTopics() {
        String[] topics = null;
        if (!this.eventTopicMap.isEmpty()) {
            topics = this.eventTopicMap.keySet().toArray(new String[0]);
        }
        return topics;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setEventPropertyFilter(String propertyName, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append("(").append(propertyName).append("=").append(value).append(")");
        this.setFilter(builder.toString());
    }

    public void handleEvent(Event event) {
        Method method = this.eventTopicMap.get(event.getTopic());
        if (method != null) {
            try {
                EventDelegate delegate = this.newEventDelegate(event);
                method.invoke((Object)delegate, new Object[0]);
            }
            catch (RuntimeException e) {
                EventHelper.addError(event, e);
                throw e;
            }
            catch (Exception e) {
                Throwable t = e;
                if (e.getCause() != null) {
                    t = e.getCause();
                }
                EventHelper.addError(event, t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            catch (Error e) {
                EventHelper.addError(event, e);
                throw e;
            }
            catch (Throwable e) {
                EventHelper.addError(event, e);
                throw new Error(e);
            }
        }
    }

    protected abstract EventDelegate newEventDelegate(Event var1);

    public Class<? extends EventDelegate> getDelegateClass() {
        return this.delegateClass;
    }
}

