/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.keikai.view;

import io.keikai.api.Importer;
import io.keikai.api.Importers;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.AuxAction;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.UserActionHandler;
import io.keikai.ui.UserActionManager;
import io.keikai.ui.impl.DefaultUserActionManagerCtrl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import org.idempiere.keikai.view.Helper;
import org.idempiere.keikai.view.SaveBookHandler;
import org.idempiere.ui.zk.media.IMediaView;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.util.media.AMedia;
import org.zkoss.zk.ui.Component;

public class CSVMediaView
implements IMediaView {
    public static final CSVMediaView INSTANCE = new CSVMediaView();

    private CSVMediaView() {
    }

    public Component renderMediaView(Component container, AMedia media, boolean readOnly) {
        Spreadsheet spreadsheet = new Spreadsheet();
        if (!readOnly) {
            spreadsheet.setShowFormulabar(true);
            spreadsheet.setShowContextMenu(true);
        }
        spreadsheet.setShowToolbar(true);
        spreadsheet.setHeight("100%");
        spreadsheet.setWidth("100%");
        container.appendChild((Component)spreadsheet);
        try {
            XSSFWorkbook xw = new XSSFWorkbook();
            xw.createSheet();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            xw.write((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            Importer importer = Importers.getImporter();
            Book book = importer.imports((InputStream)bais, media.getName());
            spreadsheet.setBook(book);
            Sheet sheet = book.getSheetAt(0);
            Reader reader = media.isBinary() ? new InputStreamReader(new ByteArrayInputStream(media.getByteData())) : media.getReaderData();
            CsvListReader csvListReader = new CsvListReader(reader, CsvPreference.STANDARD_PREFERENCE);
            List headers = csvListReader.read();
            if (headers != null) {
                int i = 0;
                while (i < headers.size()) {
                    Ranges.range((Sheet)sheet, (int)0, (int)i).setCellValue(headers.get(i));
                    ++i;
                }
            }
            List line = null;
            int row = 0;
            while ((line = csvListReader.read()) != null) {
                ++row;
                int i = 0;
                while (i < line.size()) {
                    Ranges.range((Sheet)sheet, (int)row, (int)i).setCellValue(line.get(i) != null ? line.get(i) : "");
                    ++i;
                }
            }
            csvListReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (readOnly) {
            Book book = spreadsheet.getBook();
            Helper.protectSheet(book.getSheetAt(0));
        }
        Helper.customizeToolbar(container, readOnly);
        UserActionManager actionManager = spreadsheet.getUserActionManager();
        actionManager.registerHandler(DefaultUserActionManagerCtrl.Category.AUXACTION.getName(), AuxAction.SAVE_BOOK.getAction(), (UserActionHandler)new SaveBookHandler());
        return spreadsheet;
    }
}

