/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MProcessPara;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;

@Process
public class CopyInfoWindowColumns
extends SvrProcess {
    private int p_target_AD_InfoWindow_ID = 0;
    private int p_source_AD_InfoWindow_ID = 0;
    private int m_count = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_InfoWindow_ID")) {
                    this.p_source_AD_InfoWindow_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_target_AD_InfoWindow_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInfoWindow targetInfoWindow;
        MInfoColumn[] targetColumns;
        if (this.p_target_AD_InfoWindow_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_InfoWindow_ID@ " + this.p_target_AD_InfoWindow_ID);
        }
        if (this.p_source_AD_InfoWindow_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_InfoWindow_ID@ " + this.p_source_AD_InfoWindow_ID);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Source AD_InfoWindow_ID=" + this.p_source_AD_InfoWindow_ID + ", Target AD_InfoWindow_ID=" + this.p_target_AD_InfoWindow_ID);
        }
        if ((targetColumns = (targetInfoWindow = new MInfoWindow(this.getCtx(), this.p_target_AD_InfoWindow_ID, this.get_TrxName())).getInfoColumns()).length > 0) {
            throw new AdempiereSystemError("Target info window must not have columns");
        }
        MInfoWindow sourceInfoWindow = new MInfoWindow(this.getCtx(), this.p_source_AD_InfoWindow_ID, this.get_TrxName());
        MInfoColumn[] sourceColumns = sourceInfoWindow.getInfoColumns();
        targetInfoWindow.setIsValidateEachColumn(false);
        int i = 0;
        while (i < sourceColumns.length) {
            MInfoColumn colTarget = new MInfoColumn(targetInfoWindow);
            PO.copyValues((PO)sourceColumns[i], (PO)colTarget);
            colTarget.setAD_InfoWindow_ID(targetInfoWindow.getAD_InfoWindow_ID());
            colTarget.setEntityType(targetInfoWindow.getEntityType());
            colTarget.setIsActive(sourceColumns[i].isActive());
            colTarget.saveEx(this.get_TrxName());
            ++this.m_count;
            ++i;
        }
        targetInfoWindow.validate();
        targetInfoWindow.saveEx();
        return "#" + this.m_count;
    }
}

