/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.HashMap;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.IntegerPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Intbox
extends NumberInputElement {
    private static HashMap<String, PropertyAccess> _properties = new HashMap(1);

    public Intbox() {
        this.setCols(11);
    }

    public Intbox(int value) throws WrongValueException {
        this();
        this.setValue(new Integer(value));
    }

    public Integer getValue() throws WrongValueException {
        return (Integer)this.getTargetValue();
    }

    public int intValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (Integer)val : 0;
    }

    public void setValue(Integer value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public String getZclass() {
        return this._zclass == null ? "z-intbox" : this._zclass;
    }

    @Override
    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            int v;
            int divscale;
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            for (v = Integer.parseInt(val); v != 0 && --divscale >= 0; v /= 10) {
            }
            return new Integer(v);
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    @Override
    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? value.toString() : this.formatNumber(value, null);
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        _properties.put("value", (PropertyAccess)new IntegerPropertyAccess(){

            public void setValue(Component cmp, Integer value) {
                ((Intbox)cmp).setValue(value);
            }

            public Integer getValue(Component cmp) {
                return ((Intbox)cmp).getValue();
            }
        });
    }
}

