/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.util.List;
import java.util.Set;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.model.GenericPO;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@Isolated
public class ModelClassMappingTest
extends AbstractTestCase {
    private static final String[] s_packages = new String[]{"org.compiere.model", "org.compiere.wf", "org.compiere.print", "org.compiere.impexp", "compiere.model", "adempiere.model", "org.adempiere.model"};

    @Test
    public void testModelClassMappingForCoreTables() {
        Query query = new Query(Env.getCtx(), "AD_Table", "IsView='N' AND EntityType IN ('D','EE01','EE02','EE04','EE05') AND TableName NOT Like 'I!_%' ESCAPE '!' AND TableName NOT Like 'T!_%' ESCAPE '!' AND TableName NOT Like 'W!_%' ESCAPE '!' AND TableName NOT Like '%!_Trl' ESCAPE '!'", this.getTrxName());
        List references = Service.locator().list(IModelFactory.class).getServiceReferences();
        List tables = query.setOnlyActiveRecords(true).setOrderBy("TableName").list();
        for (MTable table : tables) {
            if (table.getTableName().endsWith("_Trl")) continue;
            Class clazz = null;
            for (IServiceReferenceHolder reference : references) {
                IModelFactory service = (IModelFactory)reference.getService();
                if (service != null && (clazz = service.getClass(table.getTableName())) != null) break;
            }
            Assertions.assertNotNull(clazz, (String)("No model class found for TableName=" + table.getTableName()));
            Assertions.assertNotEquals((Object)clazz.getSimpleName(), (Object)GenericPO.class.getSimpleName(), (String)("GenericPO class is use for TableName=" + table.getTableName()));
            ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
            if (!clazz.getSimpleName().startsWith("X_")) continue;
            provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(clazz));
            String[] stringArray = s_packages;
            int n = s_packages.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                Set beans = provider.findCandidateComponents(p);
                if (beans != null && beans.size() > 0) {
                    for (BeanDefinition bean : beans) {
                        if (bean.getBeanClassName().equals(clazz.getName())) continue;
                        Assertions.fail((String)("Using " + clazz.getName() + " for table " + table.getTableName() + " instead of " + bean.getBeanClassName()));
                    }
                }
                ++n2;
            }
        }
    }
}

