/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.dunning;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MDunningRunLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DunningRunTest
extends AbstractTestCase {
    private static final int PROCESS_DUNNING_RUN_CREATE = 289;

    @Test
    public void testDunning10DaysDue() {
        MPInstancePara[] paras;
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MDunningLevel dl = new MDunningLevel(ctx, DictionaryIDs.C_DunningLevel.DUN_ALL_DUE_INVOICES.id, trxName);
        dl.setDaysAfterDue(BigDecimal.valueOf(10.0));
        dl.setIsShowAllDue(false);
        dl.setName("Dun all due invoices after 10 days due");
        dl.saveEx();
        MInvoice invoice = new MInvoice(ctx, 0, trxName);
        invoice.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.C_AND_W.id));
        invoice.setC_DocTypeTarget_ID("ARI");
        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
        invoice.setPaymentRule("S");
        invoice.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.IMMEDIATE.id);
        invoice.setDateInvoiced(TimeUtil.addDays((Timestamp)today, (int)-30));
        invoice.setDateAcct(TimeUtil.addDays((Timestamp)today, (int)-30));
        invoice.setC_PaymentTerm_ID(DictionaryIDs.C_PaymentTerm.NET_30_DAYS.id);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_USER.id);
        invoice.saveEx();
        MInvoiceLine line1 = new MInvoiceLine(invoice);
        line1.setLine(10);
        line1.setM_Product_ID(DictionaryIDs.M_Product.AZALEA_BUSH.id);
        line1.setQty(new BigDecimal("7"));
        line1.setPrice(BigDecimal.valueOf(23.75));
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(trxName, new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)("Error processing invoice: " + info.getSummary()));
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus(), (String)("Invoice document status is not completed: " + invoice.getDocStatus()));
        MDunningRun dr = new MDunningRun(ctx, 0, trxName);
        dr.setDunningDate(today);
        dr.setC_Dunning_ID(DictionaryIDs.C_Dunning.DEFAULT.id);
        dr.setC_DunningLevel_ID(DictionaryIDs.C_DunningLevel.DUN_ALL_DUE_INVOICES.id);
        dr.saveEx();
        MProcess process = MProcess.get((int)289);
        MPInstance pinstance = new MPInstance(process, 0, 0, null);
        MPInstancePara[] mPInstanceParaArray = paras = pinstance.getParameters();
        int n = paras.length;
        int n2 = 0;
        while (n2 < n) {
            MPInstancePara para = mPInstanceParaArray[n2];
            if (para.getParameterName().equals("AD_Org_ID")) {
                para.setP_Number(DictionaryIDs.AD_Org.GLOBAL.id);
                para.saveEx();
            } else if (para.getParameterName().equals("IncludeInDispute")) {
                para.setP_String("N");
                para.saveEx();
            } else if (para.getParameterName().equals("OnlySOTrx")) {
                para.setP_String("Y");
                para.saveEx();
            } else if (para.getParameterName().equals("SalesRep_ID")) {
                para.setP_Number(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
                para.saveEx();
            } else if (para.getParameterName().equals("C_Currency_ID")) {
                para.setP_Number(DictionaryIDs.C_Currency.USD.id);
                para.saveEx();
            } else if (para.getParameterName().equals("IsAllCurrencies")) {
                para.setP_String("Y");
                para.saveEx();
            } else if (para.getParameterName().equals("C_BPartner_ID")) {
                para.setP_Number(DictionaryIDs.C_BPartner.C_AND_W.id);
                para.saveEx();
            }
            ++n2;
        }
        ProcessInfo pi = new ProcessInfo(process.getName(), 289);
        pi.setAD_PInstance_ID(pinstance.getAD_PInstance_ID());
        pi.setRecord_ID(dr.getC_DunningRun_ID());
        process.processIt(pi, Trx.get((String)this.getTrxName(), (boolean)false), false);
        Assertions.assertTrue((!pi.isError() ? 1 : 0) != 0, (String)pi.getSummary());
        MDunningRunEntry[] mDunningRunEntryArray = dr.getEntries(true);
        int n3 = mDunningRunEntryArray.length;
        n = 0;
        while (n < n3) {
            MDunningRunEntry dre = mDunningRunEntryArray[n];
            MDunningRunLine[] mDunningRunLineArray = dre.getLines();
            int n4 = mDunningRunLineArray.length;
            int n5 = 0;
            while (n5 < n4) {
                MDunningRunLine drl = mDunningRunLineArray[n5];
                Assertions.assertTrue((drl.getC_Invoice_ID() != invoice.getC_Invoice_ID() ? 1 : 0) != 0);
                ++n5;
            }
            ++n;
        }
    }
}

