/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.parser;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.Grease;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.parser.BodyParser;
import org.eclipse.jetty.http3.parser.CancelPushBodyParser;
import org.eclipse.jetty.http3.parser.GoAwayBodyParser;
import org.eclipse.jetty.http3.parser.HeaderParser;
import org.eclipse.jetty.http3.parser.MaxPushIdBodyParser;
import org.eclipse.jetty.http3.parser.ParserListener;
import org.eclipse.jetty.http3.parser.SettingsBodyParser;
import org.eclipse.jetty.http3.parser.UnknownBodyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlParser {
    private static final Logger LOG = LoggerFactory.getLogger(ControlParser.class);
    private final HeaderParser headerParser;
    private final BodyParser[] bodyParsers = new BodyParser[FrameType.maxType() + 1];
    private final BodyParser unknownBodyParser;
    private State state = State.HEADER;

    public ControlParser(ParserListener listener) {
        this.headerParser = new HeaderParser();
        this.bodyParsers[FrameType.CANCEL_PUSH.type()] = new CancelPushBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.SETTINGS.type()] = new SettingsBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.GOAWAY.type()] = new GoAwayBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.MAX_PUSH_ID.type()] = new MaxPushIdBodyParser(this.headerParser, listener);
        this.unknownBodyParser = new UnknownBodyParser(this.headerParser, listener);
    }

    private void reset() {
        this.headerParser.reset();
        this.state = State.HEADER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(ByteBuffer buffer) {
        try {
            block6: while (true) {
                switch (this.state.ordinal()) {
                    case 0: {
                        if (!this.headerParser.parse(buffer)) {
                            return;
                        }
                        this.state = State.BODY;
                        continue block6;
                    }
                    case 1: {
                        BodyParser.Result result;
                        BodyParser bodyParser = null;
                        long frameType = this.headerParser.getFrameType();
                        if (frameType >= 0L && frameType < (long)this.bodyParsers.length) {
                            bodyParser = this.bodyParsers[(int)frameType];
                        }
                        if (bodyParser == null) {
                            if (FrameType.isMessage(frameType)) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("invalid message frame type {} on control stream", (Object)Long.toHexString(frameType));
                                }
                                this.sessionFailure(buffer, HTTP3ErrorCode.FRAME_UNEXPECTED_ERROR.code(), "invalid_frame_type", new IOException("invalid message frame on control stream"));
                                return;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("ignoring {} frame type {}", (Object)(Grease.isGreaseValue(frameType) ? "grease" : "unknown"), (Object)Long.toHexString(frameType));
                            }
                            if ((result = this.unknownBodyParser.parse(buffer)) == BodyParser.Result.NO_FRAME) {
                                return;
                            }
                            if (result != BodyParser.Result.WHOLE_FRAME) continue block6;
                            this.reset();
                            continue block6;
                        }
                        if (this.headerParser.getFrameLength() == 0L) {
                            bodyParser.emptyBody(buffer);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("parsed {} empty frame body from {}", (Object)FrameType.from(frameType), (Object)buffer);
                            }
                            this.reset();
                            continue block6;
                        }
                        result = bodyParser.parse(buffer);
                        if (result == BodyParser.Result.NO_FRAME) {
                            return;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("parsed {} frame body from {}", (Object)FrameType.from(frameType), (Object)buffer);
                        }
                        if (result != BodyParser.Result.WHOLE_FRAME) continue block6;
                        this.reset();
                        continue block6;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("parse failed", x);
            }
            this.sessionFailure(buffer, HTTP3ErrorCode.INTERNAL_ERROR.code(), "parser_error", x);
            return;
        }
    }

    private void sessionFailure(ByteBuffer buffer, long error, String reason, Throwable failure) {
        this.unknownBodyParser.sessionFailure(buffer, error, reason, failure);
    }

    private static enum State {
        HEADER,
        BODY;

    }
}

