/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.lifecycle;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicy;
import org.atmosphere.cpr.BroadcasterLifeCyclePolicyListener;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleHandler {
    private static final Logger logger = LoggerFactory.getLogger(LifecycleHandler.class);

    public LifecycleHandler on(final DefaultBroadcaster broadcaster) {
        ScheduledExecutorService scheduler;
        final BroadcasterLifeCyclePolicy lifeCyclePolicy = broadcaster.getBroadcasterLifeCyclePolicy();
        if (broadcaster.getID().contains("{") && broadcaster.getID().contains("}")) {
            logger.trace("Ignoring wildcard {} with lifecycle policy: {}", (Object)broadcaster.getID(), (Object)lifeCyclePolicy.getLifeCyclePolicy().name());
            return this;
        }
        BroadcasterConfig bc = broadcaster.getBroadcasterConfig();
        final AtomicBoolean recentActivity = broadcaster.recentActivity();
        if (logger.isTraceEnabled()) {
            logger.trace("{} new lifecycle policy: {}", (Object)broadcaster.getID(), (Object)lifeCyclePolicy.getLifeCyclePolicy().name());
        }
        if (broadcaster.currentLifecycleTask() != null) {
            broadcaster.currentLifecycleTask().cancel(false);
        }
        if ((scheduler = bc.getScheduledExecutorService()) == null) {
            logger.error("No Broadcaster's SchedulerExecutorService has been configured on {}. BroadcasterLifeCyclePolicy won't work.", (Object)broadcaster.getID());
            return this;
        }
        if (lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE || lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME || lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY) {
            recentActivity.set(false);
            int time = lifeCyclePolicy.getTimeout();
            if (time == -1) {
                throw new IllegalStateException("BroadcasterLifeCyclePolicy time is not set");
            }
            logger.debug("{} new lifecycle policy: {} [expire {} in {}]", new Object[]{broadcaster.getID(), lifeCyclePolicy.getLifeCyclePolicy().name(), time, lifeCyclePolicy.getLifeCyclePolicy()});
            ScheduledFuture<?> currentLifecycleTask = scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (recentActivity.getAndSet(false)) {
                            return;
                        }
                        if (lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE) {
                            LifecycleHandler.this.notifyIdleListener(broadcaster);
                            broadcaster.releaseExternalResources();
                            logger.debug("Applying BroadcasterLifeCyclePolicy IDLE policy to Broadcaster {}", (Object)broadcaster.getID());
                            if (broadcaster.currentLifecycleTask() != null) {
                                broadcaster.currentLifecycleTask().cancel(true);
                            }
                        } else if (lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_DESTROY) {
                            LifecycleHandler.this.notifyIdleListener(broadcaster);
                            this.destroy(false);
                            logger.debug("Applying BroadcasterLifeCyclePolicy IDLE_DESTROY policy to Broadcaster {}", (Object)broadcaster.getID());
                        } else if (lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.IDLE_RESUME) {
                            LifecycleHandler.this.notifyIdleListener(broadcaster);
                            this.destroy(true);
                            logger.debug("Applying BroadcasterLifeCyclePolicy IDLE_RESUME policy to Broadcaster {}", (Object)broadcaster.getID());
                        }
                    }
                    catch (Throwable t) {
                        if (broadcaster.isDestroyed()) {
                            logger.trace("Scheduled BroadcasterLifeCyclePolicy exception", t);
                        }
                        logger.warn("Scheduled BroadcasterLifeCyclePolicy exception", t);
                    }
                }

                void destroy(boolean resume) {
                    if (resume) {
                        logger.info("All AtmosphereResource will now be resumed from Broadcaster {}", (Object)broadcaster.getID());
                        broadcaster.resumeAll();
                    } else {
                        broadcaster.getAtmosphereResources().parallelStream().forEach(f -> {
                            try {
                                f.close();
                            }
                            catch (IOException e) {
                                logger.trace("", (Throwable)e);
                            }
                        });
                    }
                    broadcaster.destroy();
                    if (broadcaster.currentLifecycleTask() != null) {
                        broadcaster.currentLifecycleTask().cancel(true);
                    }
                }
            }, time, time, lifeCyclePolicy.getTimeUnit());
            broadcaster.currentLifecycleTask(currentLifecycleTask);
        }
        return this;
    }

    public LifecycleHandler offIfEmpty(DefaultBroadcaster broadcaster) {
        BroadcasterConfig bc = broadcaster.getBroadcasterConfig();
        Collection<AtmosphereResource> resources = broadcaster.getAtmosphereResources();
        BroadcasterLifeCyclePolicy lifeCyclePolicy = broadcaster.getBroadcasterLifeCyclePolicy();
        if (resources.isEmpty()) {
            this.notifyEmptyListener(broadcaster);
            if (broadcaster.getScope() != Broadcaster.SCOPE.REQUEST && lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY) {
                broadcaster.releaseExternalResources();
            } else if (broadcaster.getScope() == Broadcaster.SCOPE.REQUEST || lifeCyclePolicy.getLifeCyclePolicy() == BroadcasterLifeCyclePolicy.ATMOSPHERE_RESOURCE_POLICY.EMPTY_DESTROY) {
                bc.getAtmosphereConfig().getBroadcasterFactory().remove(broadcaster, broadcaster.getID());
                broadcaster.destroy();
            }
        }
        return this;
    }

    public LifecycleHandler off(DefaultBroadcaster broadcaster) {
        Future<?> currentLifecycleTask = broadcaster.currentLifecycleTask();
        if (currentLifecycleTask != null) {
            currentLifecycleTask.cancel(true);
        }
        this.notifyDestroyListener(broadcaster);
        return this;
    }

    protected void notifyIdleListener(DefaultBroadcaster broadcaster) {
        for (BroadcasterLifeCyclePolicyListener b : broadcaster.lifeCycleListeners()) {
            b.onIdle();
        }
    }

    protected void notifyDestroyListener(DefaultBroadcaster broadcaster) {
        for (BroadcasterLifeCyclePolicyListener b : broadcaster.lifeCycleListeners()) {
            b.onDestroy();
        }
    }

    protected void notifyEmptyListener(DefaultBroadcaster broadcaster) {
        for (BroadcasterLifeCyclePolicyListener b : broadcaster.lifeCycleListeners()) {
            b.onEmpty();
        }
    }
}

