/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.fsm;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.fsm.StateMachine;

public class StateCtx<E, C, IN> {
    protected StateMachine<E, C, IN> _machine;
    protected boolean _returnAll = false;
    protected final Set<C> _returners = new HashSet<C>();
    protected final Set<IN> _minorReturners = new HashSet<IN>();
    protected final Map<C, E> _transitions = new HashMap<C, E>();
    protected final Map<C, TransitionListener<IN, C>> _transitionListeners = new HashMap<C, TransitionListener<IN, C>>();
    protected final Map<IN, E> _minorTransitions = new HashMap<IN, E>();
    protected final Map<IN, TransitionListener<IN, C>> _minorTransitionListeners = new HashMap<IN, TransitionListener<IN, C>>();

    public StateCtx() {
        this.init();
    }

    protected StateCtx<E, C, IN> setMaster(StateMachine<E, C, IN> master) {
        this._machine = master;
        return this;
    }

    protected void init() {
    }

    public StateCtx<E, C, IN> addReturningClasses(C ... inputClasses) {
        for (C c : inputClasses) {
            this._returners.add(c);
        }
        return this;
    }

    public StateCtx<E, C, IN> addReturningClasses(Collection<C> collection) {
        this._returners.addAll(collection);
        return this;
    }

    public StateCtx<E, C, IN> addReturningInputs(IN ... inputs) {
        for (IN i : inputs) {
            this._minorReturners.add(i);
        }
        return this;
    }

    public StateCtx<E, C, IN> addReturningInputs(Collection<IN> collection) {
        this._minorReturners.addAll(collection);
        return this;
    }

    public StateCtx<E, C, IN> setReturningAll(boolean returnAll) {
        this._returnAll = returnAll;
        return this;
    }

    public StateCtx<E, C, IN> addTransition(C inputClass, E destination) {
        return this.addTransition(inputClass, destination, null);
    }

    public StateCtx<E, C, IN> addTransition(C inputClass, E destination, TransitionListener<IN, C> callback) {
        this._transitions.put(inputClass, destination);
        if (callback == null) {
            this._transitionListeners.remove(inputClass);
        } else {
            this._transitionListeners.put(inputClass, callback);
        }
        return this;
    }

    public StateCtx<E, C, IN> addTransitions(E destination, C ... inputClasses) {
        return this.addTransitions(destination, null, inputClasses);
    }

    public StateCtx<E, C, IN> addTransitions(E destination, TransitionListener<IN, C> callback, C ... inputClasses) {
        for (C c : inputClasses) {
            this.addTransition(c, destination, callback);
        }
        return this;
    }

    public StateCtx<E, C, IN> addRoute(C inputClass, E destination) {
        return this.addRoute(inputClass, destination, null);
    }

    public StateCtx<E, C, IN> addRoute(C inputClass, E destination, TransitionListener<IN, C> callback) {
        this.addTransition(inputClass, destination, callback);
        return this._machine.getState(destination);
    }

    public StateCtx<E, C, IN> addRoutes(E destination, C ... inputClasses) {
        return this.addRoutes(destination, null, inputClasses);
    }

    public StateCtx<E, C, IN> addRoutes(E destination, TransitionListener<IN, C> callback, C ... inputClasses) {
        this.addTransitions(destination, callback, inputClasses);
        return this._machine.getState(destination);
    }

    public StateCtx<E, C, IN> addMinorTransition(IN input, E destination) {
        return this.addMinorTransition(input, destination, null);
    }

    public StateCtx<E, C, IN> addMinorTransition(IN input, E destination, TransitionListener<IN, C> callback) {
        this._minorTransitions.put(input, destination);
        if (callback == null) {
            this._minorTransitionListeners.remove(input);
        } else {
            this._minorTransitionListeners.put(input, callback);
        }
        return this;
    }

    public StateCtx<E, C, IN> addMinorTransitions(E destination, IN ... inputs) {
        return this.addMinorTransitions(destination, null, inputs);
    }

    public StateCtx<E, C, IN> addMinorTransitions(E destination, TransitionListener<IN, C> callback, IN ... inputs) {
        for (IN i : inputs) {
            this.addMinorTransition(i, destination, callback);
        }
        return this;
    }

    public StateCtx<E, C, IN> addMinorRoute(IN input, E destination) {
        return this.addMinorRoute(input, destination, null);
    }

    public StateCtx<E, C, IN> addMinorRoute(IN input, E destination, TransitionListener<IN, C> callback) {
        this.addMinorTransition(input, destination, callback);
        return this._machine.getState(destination);
    }

    public StateCtx<E, C, IN> addMinorRoutes(E destination, IN ... inputs) {
        return this.addMinorRoutes(destination, null, inputs);
    }

    public StateCtx<E, C, IN> addMinorRoutes(E destination, TransitionListener<IN, C> callback, IN ... inputs) {
        this.addMinorTransitions(destination, callback, inputs);
        return this._machine.getState(destination);
    }

    public boolean isReturningAll() {
        return this._returnAll;
    }

    public boolean isReturning(IN input, C inputClass) {
        return this._returnAll || this._returners.contains(inputClass) || this._minorReturners.contains(input);
    }

    public boolean isLeaving(IN input, C inputClass) {
        return this._transitions.containsKey(inputClass) || this._minorTransitions.containsKey(input);
    }

    public E getDestination(IN input, C inputClass) {
        E result = this._minorTransitions.get(input);
        return result != null ? result : this._transitions.get(inputClass);
    }

    protected void onLand(IN input, C inputClass, E origin) {
    }

    protected void onReturn(IN input, C inputClass) {
    }

    protected void onReject(IN input, C inputClass) {
    }

    protected void onLeave(IN input, C inputClass, E destination) {
    }

    protected void onStop(boolean endOfInput) {
    }

    void doTransit(IN input, C inputClass) {
        TransitionListener<IN, C> c = this._transitionListeners.get(inputClass);
        if (c != null) {
            c.onTransit(input, inputClass);
        }
        if ((c = this._minorTransitionListeners.get(input)) != null) {
            c.onTransit(input, inputClass);
        }
    }

    public static interface TransitionListener<IN, C> {
        public void onTransit(IN var1, C var2);
    }
}

