/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.spi;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class JettyHttpExchangeDelegate
extends HttpExchange {
    private static final EnumSet<HttpHeader> SINGLE_VALUE_HEADERS = EnumSet.of(HttpHeader.AUTHORIZATION, new HttpHeader[]{HttpHeader.CONTENT_LENGTH, HttpHeader.DATE, HttpHeader.EXPIRES, HttpHeader.HOST, HttpHeader.IF_MODIFIED_SINCE, HttpHeader.IF_UNMODIFIED_SINCE, HttpHeader.IF_RANGE, HttpHeader.LAST_MODIFIED, HttpHeader.LOCATION, HttpHeader.REFERER, HttpHeader.RETRY_AFTER, HttpHeader.USER_AGENT});
    private final HttpContext _httpContext;
    private final Request _request;
    private final Response _response;
    private final Headers _responseHeaders = new Headers();
    private int _responseCode = 0;
    private InputStream _inputStream;
    private OutputStream _outputStream;
    private HttpPrincipal _httpPrincipal;

    JettyHttpExchangeDelegate(HttpContext httpSpiContext, Request request, Response response) {
        this._httpContext = httpSpiContext;
        this._request = request;
        this._response = response;
        this._inputStream = Content.Source.asInputStream((Content.Source)request);
        this._outputStream = Content.Sink.asOutputStream((Content.Sink)response);
    }

    @Override
    public Headers getRequestHeaders() {
        Headers headers = new Headers();
        for (HttpField field : this._request.getHeaders()) {
            String rawValue = field.getValue();
            if (rawValue == null) continue;
            HttpHeader header = field.getHeader();
            if (header == null || !SINGLE_VALUE_HEADERS.contains(header)) {
                QuotedCSV quotedCSV = new QuotedCSV(true, new String[]{rawValue});
                for (String value : quotedCSV.getValues()) {
                    headers.add(field.getName(), value);
                }
                continue;
            }
            headers.add(field.getName(), rawValue);
        }
        return headers;
    }

    @Override
    public Headers getResponseHeaders() {
        return this._responseHeaders;
    }

    @Override
    public URI getRequestURI() {
        return this._request.getHttpURI().toURI();
    }

    @Override
    public String getRequestMethod() {
        return this._request.getMethod();
    }

    @Override
    public HttpContext getHttpContext() {
        return this._httpContext;
    }

    @Override
    public void close() {
        try {
            this._outputStream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public InputStream getRequestBody() {
        return this._inputStream;
    }

    @Override
    public OutputStream getResponseBody() {
        return this._outputStream;
    }

    @Override
    public void sendResponseHeaders(int rCode, long responseLength) throws IOException {
        this._responseCode = rCode;
        for (Map.Entry<String, List<String>> stringListEntry : this._responseHeaders.entrySet()) {
            String name = stringListEntry.getKey();
            List<String> values = stringListEntry.getValue();
            for (String value : values) {
                this._response.getHeaders().put(name, value);
            }
        }
        if (responseLength > 0L) {
            this._response.getHeaders().put("content-length", "" + responseLength);
        }
        this._response.setStatus(rCode);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        SocketAddress remote = this._request.getConnectionMetaData().getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)remote;
            return inet;
        }
        return null;
    }

    @Override
    public int getResponseCode() {
        return this._responseCode;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        SocketAddress local = this._request.getConnectionMetaData().getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)local;
            return inet;
        }
        return null;
    }

    @Override
    public String getProtocol() {
        return this._request.getConnectionMetaData().getProtocol();
    }

    @Override
    public Object getAttribute(String name) {
        return this._request.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this._request.setAttribute(name, value);
    }

    @Override
    public void setStreams(InputStream i, OutputStream o) {
        assert (this._inputStream != null);
        if (i != null) {
            this._inputStream = i;
        }
        if (o != null) {
            this._outputStream = o;
        }
    }

    @Override
    public HttpPrincipal getPrincipal() {
        return this._httpPrincipal;
    }

    public void setPrincipal(HttpPrincipal principal) {
        this._httpPrincipal = principal;
    }
}

