/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.spi;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.spi.HttpSpiContextHandler;

public class JettyHttpContext
extends HttpContext {
    private final HttpSpiContextHandler _jettyContextHandler;
    private final HttpServer _server;
    private final Map<String, Object> _attributes = new HashMap<String, Object>();
    private final List<Filter> _filters = new ArrayList<Filter>();
    private Authenticator _authenticator;

    protected JettyHttpContext(HttpServer server, String contextPath, HttpHandler handler) {
        this._server = server;
        this._jettyContextHandler = new HttpSpiContextHandler(this, handler);
        this._jettyContextHandler.setContextPath(contextPath);
    }

    protected HttpSpiContextHandler getJettyContextHandler() {
        return this._jettyContextHandler;
    }

    @Override
    public HttpHandler getHandler() {
        return this._jettyContextHandler.getHttpHandler();
    }

    @Override
    public void setHandler(HttpHandler h) {
        this._jettyContextHandler.setHttpHandler(h);
    }

    @Override
    public String getPath() {
        return this._jettyContextHandler.getContextPath();
    }

    @Override
    public HttpServer getServer() {
        return this._server;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attributes;
    }

    @Override
    public List<Filter> getFilters() {
        return this._filters;
    }

    @Override
    public Authenticator setAuthenticator(Authenticator auth) {
        Authenticator previous = this._authenticator;
        this._authenticator = auth;
        return previous;
    }

    @Override
    public Authenticator getAuthenticator() {
        return this._authenticator;
    }
}

