/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.osgi.AbstractContextProvider;
import org.eclipse.jetty.osgi.BundleProvider;
import org.eclipse.jetty.osgi.ContextFactory;
import org.eclipse.jetty.osgi.OSGiApp;
import org.eclipse.jetty.osgi.util.Util;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.StringUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleContextProvider
extends AbstractContextProvider
implements BundleProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContextProvider.class);
    private Map<Path, App> _appMap = new HashMap<Path, App>();
    private Map<Bundle, List<App>> _bundleMap = new HashMap<Bundle, List<App>>();
    private ServiceRegistration _serviceRegForBundles;
    private BundleTracker _tracker;

    public BundleContextProvider(String environment, Server server, ContextFactory contextFactory) {
        super(environment, server, contextFactory);
    }

    protected void doStart() throws Exception {
        String serverName = (String)this.getServer().getAttribute("managedServerName");
        this._tracker = new ContextBundleTracker(FrameworkUtil.getBundle(this.getClass()).getBundleContext(), serverName);
        this._tracker.open();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", serverName);
        this._serviceRegForBundles = FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(BundleProvider.class.getName(), (Object)this, properties);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._tracker.close();
        if (this._serviceRegForBundles != null) {
            try {
                this._serviceRegForBundles.unregister();
            }
            catch (Exception e) {
                LOG.warn("Unable to unregister {}", (Object)this._serviceRegForBundles, (Object)e);
            }
        }
    }

    @Override
    public boolean bundleAdded(Bundle bundle) throws Exception {
        String[] tmp;
        if (bundle == null) {
            return false;
        }
        if (!this.isDeployable(bundle)) {
            return false;
        }
        if (bundle.getHeaders().get("Web-ContextPath") != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("BundleContextProvider ignoring bundle {} with {} set", (Object)bundle.getSymbolicName(), (Object)"Web-ContextPath");
            }
            return false;
        }
        String contextFiles = (String)bundle.getHeaders().get("Jetty-ContextFilePath");
        if (contextFiles == null) {
            return false;
        }
        String jettyHome = (String)this.getServer().getAttribute("jetty.home");
        Path jettyHomePath = StringUtil.isBlank((String)jettyHome) ? null : Paths.get(jettyHome, new String[0]);
        boolean added = false;
        for (String contextFile : tmp = contextFiles.split("[,;]")) {
            OSGiApp app = new OSGiApp(this.getDeploymentManager(), this, bundle);
            URI contextFilePath = Util.resolvePathAsLocalizedURI(contextFile, app.getBundle(), jettyHomePath);
            app.getProperties().put("Jetty-ContextFilePath", contextFilePath.toString());
            this._appMap.put(app.getPath(), app);
            List<App> apps = this._bundleMap.get(bundle);
            if (apps == null) {
                apps = new ArrayList<App>();
                this._bundleMap.put(bundle, apps);
            }
            apps.add(app);
            this.getDeploymentManager().addApp((App)app);
            added = true;
        }
        return added;
    }

    @Override
    public boolean bundleRemoved(Bundle bundle) throws Exception {
        List<App> apps = this._bundleMap.remove(bundle);
        boolean removed = false;
        if (apps != null) {
            for (App app : apps) {
                if (this._appMap.remove(app.getPath()) == null) continue;
                this.getDeploymentManager().removeApp(app);
                removed = true;
            }
        }
        return removed;
    }

    public class ContextBundleTracker
    extends BundleTracker {
        protected String _serverName;

        public ContextBundleTracker(BundleContext bundleContext, String serverName) {
            super(bundleContext, 48, null);
            this._serverName = serverName;
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            try {
                String serverName = (String)bundle.getHeaders().get("managedServerName");
                if ((StringUtil.isBlank((String)serverName) && this._serverName.equals("defaultJettyServer") || !StringUtil.isBlank((String)serverName) && serverName.equals(this._serverName)) && BundleContextProvider.this.bundleAdded(bundle)) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to add bundle {}", (Object)bundle, (Object)e);
            }
            return null;
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            try {
                BundleContextProvider.this.bundleRemoved(bundle);
            }
            catch (Exception e) {
                LOG.warn("Unable to remove bundle {}", (Object)bundle, (Object)e);
            }
        }
    }
}

