/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload2.core.AbstractFileUpload;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.FileUploadSizeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.image.AImage;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.sound.AAudio;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.media.Media;
import org.zkoss.video.AVideo;
import org.zkoss.zk.au.AuDecoder;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.ext.Uploadable;
import org.zkoss.zk.ui.sys.DiskFileItemFactory;
import org.zkoss.zk.ui.util.CharsetFinder;
import org.zkoss.zk.ui.util.Configuration;

public class AuMultipartUploader {
    private static final String FILE_DATA = AuMultipartUploader.class.getName() + ".FILE_DATA";
    private static final Logger log = LoggerFactory.getLogger(AuMultipartUploader.class);
    private static final String JAVAX_UPLOAD_CLASS = "org.apache.commons.fileupload2.javax.JavaxServletFileUpload";
    private static final String JAKARTA_UPLOAD_CLASS = "org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletFileUpload";
    private static final String JAVAX_DISK_UPLOAD_CLASS = "org.apache.commons.fileupload2.javax.JavaxServletDiskFileUpload";
    private static final String JAKARTA_DISK_UPLOAD_CLASS = "org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletDiskFileUpload";

    private static Class<?> getServletFileUploadClass() {
        try {
            return Class.forName(JAVAX_UPLOAD_CLASS);
        }
        catch (ClassNotFoundException ex0) {
            try {
                return Class.forName(JAKARTA_UPLOAD_CLASS);
            }
            catch (ClassNotFoundException ex1) {
                throw new RuntimeException("Failed to find org.apache.commons.fileupload2.javax.JavaxServletFileUpload or org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletFileUpload");
            }
        }
    }

    public static boolean isMultipartContent(HttpServletRequest request) {
        Class<?> clazz = AuMultipartUploader.getServletFileUploadClass();
        try {
            Method method = clazz.getMethod("isMultipartContent", HttpServletRequest.class);
            return (Boolean)method.invoke(null, request);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to invoke " + clazz.getName() + "#isMultipartContent(HttpServletRequest)", ex);
        }
    }

    private static AbstractFileUpload newServletDiskFileUpload(org.apache.commons.fileupload2.core.DiskFileItemFactory factory) {
        Class<?> clazz;
        try {
            clazz = Class.forName(JAVAX_DISK_UPLOAD_CLASS);
        }
        catch (ClassNotFoundException ex0) {
            try {
                clazz = Class.forName(JAKARTA_DISK_UPLOAD_CLASS);
            }
            catch (ClassNotFoundException ex1) {
                throw new RuntimeException("Failed to find org.apache.commons.fileupload2.javax.JavaxServletDiskFileUpload or org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletDiskFileUpload");
            }
        }
        try {
            return (AbstractFileUpload)clazz.getDeclaredConstructor(org.apache.commons.fileupload2.core.DiskFileItemFactory.class).newInstance(factory);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create a new instance of " + clazz.getName(), ex);
        }
    }

    public static AuDecoder parseRequest(HttpServletRequest request, AuDecoder decoder) {
        Map<String, Object> params = AuMultipartUploader.getFileuploadMetaPerWebApp(WebApps.getCurrent());
        AbstractFileUpload upload = AuMultipartUploader.newServletDiskFileUpload(((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)new DiskFileItemFactory.Builder().setBufferSize((Integer)params.get("sizeThreadHold"))).setPath(((File)params.get("repository")).toPath())).get());
        try {
            List fileItems = upload.parseRequest((Object)request);
            Map<String, Object> dataMap = new HashMap<String, Object>(fileItems.size());
            for (FileItem item : fileItems) {
                if (item.isFormField()) {
                    dataMap.put(item.getFieldName(), item.getString());
                    continue;
                }
                dataMap.put(item.getFieldName(), item);
            }
            if (!dataMap.isEmpty()) {
                request.setAttribute(FILE_DATA, dataMap);
            } else {
                Object attribute = request.getAttribute(FILE_DATA);
                if (attribute instanceof Map) {
                    dataMap = (Map)attribute;
                }
            }
            return new AuMultipartDecoder(dataMap, decoder);
        }
        catch (FileUploadException e) {
            throw UiException.Aide.wrap(e);
        }
    }

    public static Map<String, List<String>> splitQuery(String query) {
        if (Strings.isBlank((String)query)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(query.split("&")).map(AuMultipartUploader::splitQueryParameter).collect(Collectors.groupingBy(AbstractMap.SimpleImmutableEntry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    public static AbstractMap.SimpleImmutableEntry<String, String> splitQueryParameter(String it) {
        int idx = it.indexOf("=");
        String key = idx > 0 ? it.substring(0, idx) : it;
        String value = idx > 0 && it.length() > idx + 1 ? it.substring(idx + 1) : null;
        try {
            return new AbstractMap.SimpleImmutableEntry<String, String>(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw UiException.Aide.wrap(e);
        }
    }

    private static Object reconstructPacket(Object data, Map<String, Object> reqData, Desktop desktop, Map<String, Object> params) throws IOException {
        if (data instanceof List) {
            int i = 0;
            List listData = (List)data;
            for (Object v : new ArrayList(listData)) {
                listData.set(i++, AuMultipartUploader.reconstructPacket(v, reqData, desktop, params));
            }
            return listData;
        }
        if (data instanceof Map) {
            Map mapData = (Map)data;
            if (mapData.containsKey("_placeholder")) {
                int num = (Integer)mapData.get("num");
                FileItem fileItem = (FileItem)reqData.get("files_" + num);
                params.put("fileSize", (Long)params.get("fileSize") + fileItem.getSize());
                return AuMultipartUploader.processItem(desktop, fileItem, Boolean.parseBoolean(String.valueOf(params.get("native"))), (DiskFileItemFactory)params.get("diskFileItemFactory"));
            }
            for (Map.Entry me : mapData.entrySet()) {
                mapData.put((String)me.getKey(), AuMultipartUploader.reconstructPacket(me.getValue(), reqData, desktop, params));
            }
            return mapData;
        }
        return data;
    }

    private static Map<String, Object> getFileuploadMetaPerWebApp(WebApp webApp) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Configuration conf = webApp.getConfiguration();
        int thrs = conf.getFileSizeThreshold();
        int sizeThreadHold = 131072;
        if (thrs > 0) {
            sizeThreadHold = 1024 * thrs;
        }
        params.put("sizeThreadHold", sizeThreadHold);
        ServletContext context = webApp.getServletContext();
        File repository = (File)context.getAttribute("javax.servlet.context.tempdir");
        if (repository == null) {
            repository = (File)context.getAttribute("jakarta.servlet.context.tempdir");
        }
        if (conf.getFileRepository() != null) {
            repository = new File(conf.getFileRepository());
        }
        if (!repository.isDirectory()) {
            log.warn("The file repository is not a directory! [" + repository + "]");
        }
        params.put("repository", repository);
        DiskFileItemFactory dfiFactory = null;
        if (conf.getFileItemFactoryClass() != null) {
            Class<?> cls = conf.getFileItemFactoryClass();
            try {
                dfiFactory = (DiskFileItemFactory)cls.newInstance();
                params.put("diskFileItemFactory", dfiFactory);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        return params;
    }

    private static Map<String, Object> getFileuploadMetaPerComp(Map<String, Object> params, Desktop desktop, String uuid) {
        Component comp = desktop.getComponentByUuidIfAny(uuid);
        if (comp != null) {
            Integer maxsz = null;
            try {
                Integer compMaxsz = (Integer)comp.getAttribute("org.zkoss.zk.upload.maxsize");
                maxsz = compMaxsz != null ? compMaxsz.intValue() : desktop.getWebApp().getConfiguration().getMaxUploadSize();
                params.put("maxSize", maxsz);
            }
            catch (NumberFormatException e) {
                throw new UiException("The upload max size must be a number");
            }
            if (Boolean.TRUE.equals(comp.getAttribute("org.zkoss.zk.upload.native"))) {
                params.put("native", true);
            }
        }
        return params;
    }

    private static Map<String, Object> getFileuploadMeta(Desktop desktop, String uuid) {
        WebApp webApp = desktop.getWebApp();
        Map<String, Object> params = AuMultipartUploader.getFileuploadMetaPerWebApp(webApp);
        return AuMultipartUploader.getFileuploadMetaPerComp(params, desktop, uuid);
    }

    private static String uploadErrorMessage(Throwable ex) {
        log.error("Failed to upload", ex);
        if (ex instanceof FileUploadSizeException) {
            try {
                FileUploadSizeException fex = (FileUploadSizeException)ex;
                long size = fex.getActualSize();
                long limit = fex.getPermitted();
                Class msgClass = Classes.forNameByThread((String)"org.zkoss.zul.mesg.MZul");
                Field msgField = msgClass.getField("UPLOAD_ERROR_EXCEED_MAXSIZE");
                int divisor1 = 1024;
                int divisor2 = 0x100000;
                String[] units = new String[]{" Bytes", " KB", " MB"};
                int i1 = (int)(Math.log(size) / Math.log(1024.0));
                int i2 = (int)(Math.log(limit) / Math.log(1024.0));
                String sizeAuto = Math.round((double)size / Math.pow(1024.0, i1)) + units[i1];
                String limitAuto = Math.round((double)limit / Math.pow(1024.0, i2)) + units[i2];
                Object[] args = new Object[]{sizeAuto, limitAuto, size, limit, Long.valueOf(size / (long)divisor1) + units[1], Long.valueOf(limit / (long)divisor1) + units[1], Long.valueOf(size / (long)divisor2) + units[2], Long.valueOf(limit / (long)divisor2) + units[2]};
                return AuMultipartUploader.generateAlertMessage(Uploadable.Error.SIZE_LIMIT_EXCEEDED, Messages.get((int)msgField.getInt(null), (Object[])args));
            }
            catch (Throwable e) {
                log.error("Failed to parse upload error message..", e);
            }
        }
        return AuMultipartUploader.generateAlertMessage(Uploadable.Error.SERVER_EXCEPTION, Exceptions.getMessage((Throwable)ex));
    }

    private static String generateAlertMessage(Uploadable.Error type, String message) {
        return type.toString() + ":" + message;
    }

    private static final void processItems(Desktop desktop, Map<String, Object> params, Map<String, String> attrs, List<Media> meds) throws IOException {
        boolean alwaysNative = Boolean.TRUE.equals(params.get("native"));
        Object fis = params.get("file");
        if (fis instanceof FileItem) {
            meds.add(AuMultipartUploader.processItem(desktop, (FileItem)fis, alwaysNative, (DiskFileItemFactory)params.get("diskFileItemFactory")));
        } else if (fis != null) {
            Iterator it = ((List)fis).iterator();
            while (it.hasNext()) {
                meds.add(AuMultipartUploader.processItem(desktop, (FileItem)it.next(), alwaysNative, (DiskFileItemFactory)params.get("diskFileItemFactory")));
            }
        }
    }

    private static String getBaseName(FileItem fi) {
        String name = fi.getName();
        if (name == null) {
            return null;
        }
        String[] seps = new String[]{"/", "\\", "%5c", "%5C", "%2f", "%2F"};
        int j = seps.length;
        while (--j >= 0) {
            int k = name.lastIndexOf(seps[j]);
            if (k < 0) continue;
            name = name.substring(k + seps[j].length());
        }
        return name;
    }

    private static final Media processItem(Desktop desktop, FileItem fi, boolean alwaysNative, DiskFileItemFactory factory) throws IOException {
        String s;
        int j;
        String ctype;
        String ctypelc;
        int k;
        int j2;
        String name = AuMultipartUploader.getBaseName(fi);
        if (name != null && (j2 = name.lastIndexOf(59)) > 0 && (k = name.lastIndexOf(46)) >= 0 && j2 > k && k > name.lastIndexOf(47)) {
            name = name.substring(0, j2);
        }
        String string = ctypelc = (ctype = fi.getContentType()) != null ? ctype.toLowerCase(Locale.ENGLISH) : null;
        if (name != null && "application/octet-stream".equals(ctypelc) && (j = name.lastIndexOf(46)) >= 0 && (s = ContentTypes.getContentType((String)name.substring(j + 1))) != null) {
            ctypelc = ctype = s;
        }
        if (factory != null) {
            return factory.createMedia(fi, ctype, name, alwaysNative);
        }
        if (!alwaysNative && ctypelc != null) {
            if (ctypelc.startsWith("image/")) {
                try {
                    return fi.isInMemory() ? new AImage(name, fi.get()) : new AImage(name, fi.getInputStream());
                }
                catch (Throwable ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown file format: " + ctype);
                    }
                }
            } else if (ctypelc.startsWith("audio/")) {
                try {
                    return fi.isInMemory() ? new AAudio(name, fi.get()) : new StreamAudio(name, fi, ctypelc);
                }
                catch (Throwable ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown file format: " + ctype);
                    }
                }
            } else if (ctypelc.startsWith("video/")) {
                try {
                    return fi.isInMemory() ? new AVideo(name, fi.get()) : new StreamVideo(name, fi, ctypelc);
                }
                catch (Throwable ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown file format: " + ctype);
                    }
                }
            } else if (ctypelc.startsWith("text/")) {
                String charset = AuMultipartUploader.getCharset(ctype);
                if (charset == null) {
                    Configuration conf = desktop.getWebApp().getConfiguration();
                    CharsetFinder chfd = conf.getUploadCharsetFinder();
                    if (chfd != null) {
                        charset = chfd.getCharset(ctype, fi.isInMemory() ? new ByteArrayInputStream(fi.get()) : fi.getInputStream());
                    }
                    if (charset == null) {
                        charset = conf.getUploadCharset();
                    }
                }
                return fi.isInMemory() ? new AMedia(name, null, ctype, fi.getString(Charset.forName(charset))) : new ReaderMedia(name, null, ctype, fi, charset);
            }
        }
        return fi.isInMemory() ? new AMedia(name, null, ctype, fi.get()) : new StreamMedia(name, null, ctype, fi);
    }

    private static String getCharset(String ctype) {
        String ctypelc = ctype.toLowerCase(Locale.ENGLISH);
        int j = 0;
        while ((j = ctypelc.indexOf("charset", j)) >= 0) {
            int k = Strings.skipWhitespacesBackward((CharSequence)ctype, (int)(j - 1));
            if ((k < 0 || ctype.charAt(k) == ';') && (k = Strings.skipWhitespaces((CharSequence)ctype, (int)(j + 7))) <= ctype.length() && ctype.charAt(k) == '=') {
                String charset;
                if ((charset = ((j = ctype.indexOf(59, ++k)) >= 0 ? ctype.substring(k, j) : ctype.substring(k)).trim()).length() <= 0) break;
                return charset;
            }
            j += 7;
        }
        return null;
    }

    private static class MultipartRequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, List<String>> _data;

        public MultipartRequestWrapper(HttpServletRequest request, Map<String, List<String>> data) {
            super(request);
            this._data = data;
        }

        public String getParameter(String name) {
            if (this._data.containsKey(name)) {
                return this._data.get(name).get(0);
            }
            return super.getParameter(name);
        }

        public Map getParameterMap() {
            HashMap hashMap = new HashMap();
            this._data.forEach((key, value) -> hashMap.put(key, value.toArray(new String[0])));
            hashMap.putAll(super.getParameterMap());
            return hashMap;
        }

        public Enumeration getParameterNames() {
            LinkedHashSet<String> keys = new LinkedHashSet<String>(this._data.keySet());
            Enumeration parameterNames = super.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                keys.add((String)parameterNames.nextElement());
            }
            return Collections.enumeration(keys);
        }

        public String[] getParameterValues(String name) {
            if (this._data.containsKey(name)) {
                return this._data.get(name).toArray(new String[0]);
            }
            return super.getParameterValues(name);
        }
    }

    private static class StreamVideo
    extends AVideo {
        private final FileItem _fi;
        private String _format;
        private String _ctype;

        public StreamVideo(String name, FileItem fi, String ctype) throws IOException {
            super(name, DYNAMIC_STREAM);
            this._fi = fi;
            this._ctype = ctype;
        }

        public InputStream getStreamData() {
            try {
                return this._fi.getInputStream();
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }

        public String getFormat() {
            if (this._format == null) {
                this._format = ContentTypes.getFormat((String)this.getContentType());
            }
            return this._format;
        }

        public String getContentType() {
            return this._ctype != null ? this._ctype : this._fi.getContentType();
        }
    }

    private static class StreamAudio
    extends AAudio {
        private final FileItem _fi;
        private String _format;
        private String _ctype;

        public StreamAudio(String name, FileItem fi, String ctype) throws IOException {
            super(name, DYNAMIC_STREAM);
            this._fi = fi;
            this._ctype = ctype;
        }

        public InputStream getStreamData() {
            try {
                return this._fi.getInputStream();
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }

        public String getFormat() {
            if (this._format == null) {
                this._format = ContentTypes.getFormat((String)this.getContentType());
            }
            return this._format;
        }

        public String getContentType() {
            return this._ctype != null ? this._ctype : this._fi.getContentType();
        }
    }

    private static class ReaderMedia
    extends AMedia {
        private final FileItem _fi;
        private final String _charset;

        public ReaderMedia(String name, String format, String ctype, FileItem fi, String charset) {
            super(name, format, ctype, DYNAMIC_READER);
            this._fi = fi;
            this._charset = charset;
        }

        public Reader getReaderData() {
            try {
                return new InputStreamReader(this._fi.getInputStream(), this._charset);
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }

        public boolean isBinary() {
            return false;
        }

        public boolean inMemory() {
            return false;
        }
    }

    private static class StreamMedia
    extends AMedia {
        private final FileItem _fi;

        public StreamMedia(String name, String format, String ctype, FileItem fi) {
            super(name, format, ctype, DYNAMIC_STREAM);
            this._fi = fi;
        }

        public InputStream getStreamData() {
            try {
                return this._fi.getInputStream();
            }
            catch (IOException ex) {
                throw new UiException("Unable to read " + this._fi, (Throwable)ex);
            }
        }

        public boolean isBinary() {
            return true;
        }

        public boolean inMemory() {
            return false;
        }
    }

    private static class AuMultipartDecoder
    implements AuDecoder {
        private AuDecoder _origin;
        private String _desktop;
        private String _firstCommand;
        private Map<String, Object> _reqData;
        private Map<String, List<String>> _queryData;

        public AuMultipartDecoder(Map<String, Object> reqData, AuDecoder origin) {
            this._origin = origin;
            this._queryData = AuMultipartUploader.splitQuery((String)reqData.get("data"));
            this._reqData = reqData;
        }

        @Override
        public String getDesktopId(Object request) {
            return this._origin.getDesktopId((Object)new MultipartRequestWrapper((HttpServletRequest)request, this._queryData));
        }

        @Override
        public String getFirstCommand(Object request) {
            return this._origin.getFirstCommand((Object)new MultipartRequestWrapper((HttpServletRequest)request, this._queryData));
        }

        @Override
        public List<AuRequest> decode(Object request, Desktop desktop) {
            List<AuRequest> auRequests = this._origin.decode((Object)new MultipartRequestWrapper((HttpServletRequest)request, this._queryData), desktop);
            auRequests.forEach(auRequest -> {
                try {
                    Map<String, Object> params = AuMultipartUploader.getFileuploadMeta(desktop, auRequest.getUuid());
                    params.put("fileSize", 0L);
                    Integer maxSize = (Integer)params.get("maxSize");
                    Long maxSizeLong = -1L;
                    if (maxSize != null && maxSize >= 0) {
                        maxSizeLong = 1024L * (long)maxSize.intValue();
                    }
                    AuMultipartUploader.reconstructPacket(auRequest.getData(), this._reqData, desktop, params);
                    Long fileSize = (Long)params.get("fileSize");
                    if (maxSizeLong >= 0L && fileSize > maxSizeLong) {
                        String errorMessage = AuMultipartUploader.uploadErrorMessage((Throwable)new FileUploadSizeException(null, fileSize.longValue(), maxSizeLong.longValue()));
                        throw new FileUploadSizeException(errorMessage, fileSize.longValue(), maxSizeLong.longValue());
                    }
                }
                catch (Exception e) {
                    throw UiException.Aide.wrap(e);
                }
            });
            return auRequests;
        }

        @Override
        public boolean isIgnorable(Object request, WebApp wapp) {
            return this._origin.isIgnorable((Object)new MultipartRequestWrapper((HttpServletRequest)request, this._queryData), wapp);
        }
    }
}

