/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Phase;
import org.zkoss.bind.Property;
import org.zkoss.bind.impl.AbstractBindingHandler;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.impl.BindingKey;
import org.zkoss.bind.impl.InitFormBindingImpl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.InitFormBinding;
import org.zkoss.bind.sys.LoadFormBinding;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

class FormBindingHandler
extends AbstractBindingHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger _log = LoggerFactory.getLogger(FormBindingHandler.class);
    private final Map<BindingKey, List<InitFormBinding>> _initFormBindings = new HashMap<BindingKey, List<InitFormBinding>>();
    private final Map<BindingKey, List<LoadFormBinding>> _loadFormPromptBindings = new HashMap<BindingKey, List<LoadFormBinding>>();
    private final Map<String, List<LoadFormBinding>> _loadFormAfterBindings = new HashMap<String, List<LoadFormBinding>>();
    private final Map<String, List<SaveFormBinding>> _saveFormAfterBindings = new HashMap<String, List<SaveFormBinding>>();
    private final Map<String, List<LoadFormBinding>> _loadFormBeforeBindings = new HashMap<String, List<LoadFormBinding>>();
    private final Map<String, List<SaveFormBinding>> _saveFormBeforeBindings = new HashMap<String, List<SaveFormBinding>>();

    FormBindingHandler() {
    }

    void addLoadPromptBinding(BindingKey bkey, LoadFormBinding binding) {
        this.addBinding(this._loadFormPromptBindings, bkey, binding);
    }

    void addInitBinding(BindingKey bkey, InitFormBinding binding) {
        this.addBinding(this._initFormBindings, bkey, binding);
    }

    void addLoadBeforeBinding(String command, LoadFormBinding binding) {
        this.addBinding(this._loadFormBeforeBindings, command, binding);
    }

    void addLoadAfterBinding(String command, LoadFormBinding binding) {
        this.addBinding(this._loadFormAfterBindings, command, binding);
    }

    void addSaveBeforeBinding(String command, SaveFormBinding binding) {
        this.addBinding(this._saveFormBeforeBindings, command, binding);
    }

    void addSaveAfterBinding(String command, SaveFormBinding binding) {
        this.addBinding(this._saveFormAfterBindings, command, binding);
    }

    Map<String, List<SaveFormBinding>> getSaveFormBeforeBindings() {
        return this._saveFormBeforeBindings;
    }

    Map<String, List<SaveFormBinding>> getSaveFormAfterBindings() {
        return this._saveFormAfterBindings;
    }

    void doSaveBefore(Component comp, String command, Event evt, Set<Property> notifys) {
        List<SaveFormBinding> bindings = this._saveFormBeforeBindings.get(command);
        if (bindings != null) {
            for (SaveFormBinding binding : bindings) {
                this.doSaveBinding(comp, binding, command, evt, notifys);
            }
        }
    }

    private void doSaveBinding(Component comp, SaveFormBinding binding, String command, Event evt, Set<Property> notifys) {
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, true, command, binding.getComponent(), evt);
        BindContextUtil.setValidatorArgs(this._binder, binding.getComponent(), ctx, binding);
        String debugInfo = this.getSaveBindingDebugInfo("doSaveFormBinding", comp, binding, command, evt, notifys);
        try {
            if (_log.isDebugEnabled()) {
                _log.debug(debugInfo);
            }
            this.doPrePhase(Phase.SAVE_BINDING, ctx);
            binding.save(ctx);
        }
        catch (Exception ex) {
            throw new RuntimeException(debugInfo, ex);
        }
        finally {
            this.doPostPhase(Phase.SAVE_BINDING, ctx);
        }
        Set<Property> xnotifys = FormBindingHandler.getNotifys(ctx);
        if (xnotifys != null) {
            notifys.addAll(xnotifys);
        }
    }

    private void doLoadBinding(Component comp, LoadFormBinding binding, String command) {
        BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, false, command, binding.getComponent(), null);
        if (binding instanceof InitFormBindingImpl) {
            ctx.setAttribute("$IGNORE_TRACKER$", Boolean.TRUE);
        }
        String debugInfo = this.getLoadBindingDebugInfo("doLoadFormBinding", comp, binding, ctx, command);
        try {
            if (_log.isDebugEnabled()) {
                _log.debug(debugInfo);
            }
            this.doPrePhase(Phase.LOAD_BINDING, ctx);
            binding.load(ctx);
            if (((BinderImpl)binding.getBinder()).hasValidator(binding.getComponent(), binding.getFormId())) {
                this.clearValidationMessages(binding.getBinder(), binding.getComponent(), binding.getFormId());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(debugInfo, ex);
        }
        finally {
            this.doPostPhase(Phase.LOAD_BINDING, ctx);
        }
    }

    void doSaveAfter(Component comp, String command, Event evt, Set<Property> notifys) {
        List<SaveFormBinding> bindings = this._saveFormAfterBindings.get(command);
        if (bindings != null) {
            for (SaveFormBinding binding : bindings) {
                this.doSaveBinding(comp, binding, command, evt, notifys);
            }
        }
    }

    void doLoadBefore(Component comp, String command) {
        List<LoadFormBinding> bindings = this._loadFormBeforeBindings.get(command);
        if (bindings != null) {
            for (LoadFormBinding binding : bindings) {
                this.doLoadBinding(comp, binding, command);
            }
        }
    }

    void doLoadAfter(Component comp, String command) {
        List<LoadFormBinding> bindings = this._loadFormAfterBindings.get(command);
        if (bindings != null) {
            for (LoadFormBinding binding : bindings) {
                this.doLoadBinding(comp, binding, command);
            }
        }
    }

    void removeBindings(BindingKey bkey, Set<Binding> removed) {
        List<LoadFormBinding> bindingx = this._initFormBindings.remove(bkey);
        if (bindingx != null) {
            removed.addAll(bindingx);
        }
        if ((bindingx = this._loadFormPromptBindings.remove(bkey)) != null) {
            removed.addAll(bindingx);
        }
    }

    void removeBindings(Collection<Binding> removes) {
        for (List<LoadFormBinding> list : this._loadFormAfterBindings.values()) {
            list.removeAll(removes);
        }
        for (List<FormBinding> list : this._saveFormAfterBindings.values()) {
            list.removeAll(removes);
        }
        for (List<FormBinding> list : this._loadFormBeforeBindings.values()) {
            list.removeAll(removes);
        }
        for (List<FormBinding> list : this._saveFormBeforeBindings.values()) {
            list.removeAll(removes);
        }
    }

    void doLoad(Component comp, BindingKey bkey) {
        List<LoadFormBinding> formBindings = this._loadFormPromptBindings.get(bkey);
        if (formBindings != null) {
            for (LoadFormBinding binding : formBindings) {
                this.doLoadBinding(comp, binding, null);
            }
        }
    }

    void doInit(Component comp, BindingKey bkey) {
        List<InitFormBinding> initBindings = this._initFormBindings.get(bkey);
        if (initBindings != null) {
            for (InitFormBinding binding : initBindings) {
                this.doLoadBinding(comp, binding, null);
            }
        }
    }
}

