/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import com.github.kklisura.cdt.protocol.commands.Page;
import com.github.kklisura.cdt.protocol.commands.Runtime;
import com.github.kklisura.cdt.protocol.types.page.CaptureScreenshotFormat;
import com.github.kklisura.cdt.protocol.types.page.Viewport;
import com.github.kklisura.cdt.protocol.types.runtime.AwaitPromise;
import com.github.kklisura.cdt.protocol.types.runtime.Evaluate;
import com.github.kklisura.cdt.protocol.types.runtime.ExceptionDetails;
import com.github.kklisura.cdt.protocol.types.runtime.RemoteObject;
import com.github.kklisura.cdt.services.ChromeDevToolsService;
import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.util.Base64Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChromePage {
    private static final Log log = LogFactory.getLog(ChromePage.class);
    private final ChromeDevToolsService devToolsService;

    public ChromePage(ChromeDevToolsService devToolsService) {
        this.devToolsService = devToolsService;
    }

    public <T> T evaluatePromise(String promiseScript) {
        Runtime runtime = this.devToolsService.getRuntime();
        Evaluate evaluate = runtime.evaluate(promiseScript);
        this.checkException(evaluate.getExceptionDetails());
        RemoteObject evaluateResult = evaluate.getResult();
        AwaitPromise promise = runtime.awaitPromise(evaluateResult.getObjectId(), Boolean.valueOf(true), Boolean.valueOf(false));
        this.checkException(promise.getExceptionDetails());
        RemoteObject pResult = promise.getResult();
        Object result = pResult.getValue();
        return (T)result;
    }

    protected void checkException(ExceptionDetails exceptionDetails) {
        if (exceptionDetails != null) {
            String exceptionString = null;
            RemoteObject exception = exceptionDetails.getException();
            if (exception != null) {
                if (exception.getDescription() != null) {
                    exceptionString = exception.getDescription();
                } else if (exception.getValue() != null) {
                    exceptionString = exception.getValue().toString();
                }
            }
            log.error((Object)("Script error: " + exceptionDetails.getText() + ", exception: " + exceptionString));
            throw new JRRuntimeException("Script failed: " + exceptionDetails.getText());
        }
    }

    public byte[] captureScreenshot(int width, int height, double zoomFactor) {
        Viewport viewport = new Viewport();
        viewport.setX(Double.valueOf(0.0));
        viewport.setY(Double.valueOf(0.0));
        viewport.setWidth(Double.valueOf(width));
        viewport.setHeight(Double.valueOf(height));
        viewport.setScale(Double.valueOf(zoomFactor));
        Page page = this.devToolsService.getPage();
        String screenshotString = page.captureScreenshot(CaptureScreenshotFormat.PNG, Integer.valueOf(100), viewport, Boolean.valueOf(true), Boolean.valueOf(false));
        try {
            byte[] imageData = Base64Util.decode(screenshotString);
            return imageData;
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }
}

