/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeplot.event;

import java.util.Date;
import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;

public class OverPlotEvent
extends Event {
    private Date _time;
    private Float _value;
    private Map _customValues;
    private int _plotDataIndex;
    private String _format;
    public static final String ON_OVER_PLOTDATA = "onOverPlotData";

    public static OverPlotEvent getOverPlotEvent(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)request);
        }
        Map data = request.getData();
        if (data == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{data, request});
        }
        String name = request.getCommand();
        Date time = new Date(Long.parseLong(String.valueOf(data.remove("time"))));
        String valueStr = String.valueOf(data.remove("value"));
        Float value = null;
        if (!valueStr.equals("null")) {
            value = new Float(valueStr);
        }
        int plotDataIndex = Integer.parseInt(String.valueOf(data.remove("plotDataIndex")));
        String format = String.valueOf(data.remove("format"));
        return new OverPlotEvent(name, comp, time, value, data, plotDataIndex, format);
    }

    public OverPlotEvent(String name, Component target, Date time, Float value, Map customValues, int plotDataIndex, String format) {
        super(name, target);
        this._time = time;
        this._value = value;
        this._customValues = customValues;
        this._plotDataIndex = plotDataIndex;
        if (!"null".equals(format)) {
            this._format = format;
        }
    }

    public Date getTime() {
        return this._time;
    }

    public Float getValue() {
        return this._value;
    }

    public Map getCustomValues() {
        return this._customValues;
    }

    public int getPlotDataIndex() {
        return this._plotDataIndex;
    }

    public String getFormat() {
        return this._format;
    }
}

