/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.util.HashMap;
import org.zkoss.gmaps.LatLng;
import org.zkoss.gmaps.LatLngBounds;
import org.zkoss.gmaps.Mapitem;
import org.zkoss.image.Image;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Gimage
extends XulElement
implements Mapitem {
    private static final long serialVersionUID = 200801071632L;
    private LatLngBounds _bounds = new LatLngBounds(new LatLng(37.4419, -122.1419), new LatLng(37.4419, -122.1419));
    private String _src;
    private Image _image;
    private int _imgver;

    public Gimage() {
    }

    public Gimage(String src, LatLngBounds bounds) {
        this.setSrc(src);
        this.setBounds(bounds);
    }

    public Gimage(String src, double swlat, double swlng, double nelat, double nelng) {
        this(src, new LatLngBounds(new LatLng(swlat, swlng), new LatLng(nelat, nelng)));
    }

    public void setBounds(LatLngBounds bounds) {
        if (bounds == null) {
            throw new NullPointerException("bounds");
        }
        if (!Objects.equals((Object)((Object)this._bounds), (Object)((Object)bounds))) {
            this._bounds = bounds;
            this.smartUpdate("bounds", (Object)this._bounds);
        }
    }

    public LatLngBounds getBounds() {
        return this._bounds;
    }

    public double getSwlat() {
        return this._bounds.getSouthWest().getLatitude();
    }

    public void setSwlat(double swlat) {
        this.setBounds(new LatLngBounds(new LatLng(swlat, this._bounds.getSouthWest().getLongitude()), this._bounds.getNorthEast()));
    }

    public double getSwlng() {
        return this._bounds.getSouthWest().getLongitude();
    }

    public void setSwlng(double swlng) {
        this.setBounds(new LatLngBounds(new LatLng(this._bounds.getSouthWest().getLatitude(), swlng), this._bounds.getNorthEast()));
    }

    public double getNelat() {
        return this._bounds.getNorthEast().getLatitude();
    }

    public void setNelat(double nelat) {
        this.setBounds(new LatLngBounds(this._bounds.getSouthWest(), new LatLng(nelat, this._bounds.getNorthEast().getLongitude())));
    }

    public double getNelng() {
        return this._bounds.getNorthEast().getLongitude();
    }

    public void setNelng(double nelng) {
        this.setBounds(new LatLngBounds(this._bounds.getSouthWest(), new LatLng(this._bounds.getNorthEast().getLatitude(), nelng)));
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._image != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._image = null;
            this.smartRerender();
        }
    }

    public void setContent(Image image) {
        if (image != this._image) {
            this._image = image;
            if (this._image != null) {
                ++this._imgver;
            }
            this.smartRerender();
        }
    }

    public Image getContent() {
        return this._image;
    }

    public boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "src", this.getEncodedURL());
        this.render(renderer, "bounds", (Object)this._bounds);
    }

    private String getEncodedURL() {
        if (this._image != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._imgver, (String)("c/" + this._image.getName()), (String)this._image.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "";
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    private void smartRerender() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("src", this.getEncodedURL());
        info.put("bounds", (Object)this._bounds);
        this.smartUpdate("rerender_", info);
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Gimage.this);
        }

        public Media getMedia(String pathInfo) {
            return Gimage.this._image;
        }
    }
}

