/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.calendar;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.api.CalendarModel;
import org.zkoss.calendar.api.DateFormatter;
import org.zkoss.calendar.api.EventRender;
import org.zkoss.calendar.api.RenderContext;
import org.zkoss.calendar.event.CalendarDataEvent;
import org.zkoss.calendar.event.CalendarDataListener;
import org.zkoss.calendar.event.CalendarDropEvent;
import org.zkoss.calendar.event.CalendarsEvent;
import org.zkoss.calendar.impl.Util;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.impl.XulElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Calendars
extends XulElement {
    private static final long serialVersionUID = 20090331171730L;
    private static final String ATTR_ON_INIT_POSTED = "org.zkoss.calendar.Calendars.onInitLaterPosted";
    private int _firstDayOfWeek;
    private Date _curDate;
    private int _days = 7;
    private DateFormatter _dfmter;
    private Map<String, List<CalendarEvent>> _evts;
    private Map<TimeZone, String> _tzones;
    private Map<Object, Object> _ids;
    private CalendarModel _model;
    private transient CalendarDataListener _dataListener;
    private SimpleDateFormat _sdfKey = new SimpleDateFormat("yyyy/MM/dd");
    private boolean _readonly;
    private boolean _weekOfYear;
    private boolean _hasEmptyZone = false;
    private boolean _escapeXML = true;
    private List<CalendarEvent> _addEvtList;
    private List<CalendarEvent> _mdyEvtList;
    private List<CalendarEvent> _rmEvtList;
    private int _beginTime = 0;
    private int _endTime = 24;
    private int _timeslots = 2;
    private static final String ATTR_ON_ADD_EVENT_RESPONSE = "org.zkoss.calendar.Calendars.onAddEventResponse";
    private static final String ATTR_ON_REMOVE_EVENT_RESPONSE = "org.zkoss.calendar.Calendars.onRemoveEventResponse";
    private static final String ATTR_ON_MODIFY_EVENT_RESPONSE = "org.zkoss.calendar.Calendars.onModifyEventResponse";
    private static final Comparator<CalendarEvent> _defCompare = new Comparator<CalendarEvent>(){

        @Override
        public int compare(CalendarEvent o1, CalendarEvent o2) {
            return o1.getBeginDate().compareTo(o2.getBeginDate());
        }
    };

    public Calendars() {
        this.init();
        this._curDate = this.getCalendar().getTime();
    }

    private void init() {
        this._evts = new HashMap<String, List<CalendarEvent>>(32);
        this._tzones = new LinkedHashMap<TimeZone, String>();
        this._ids = new HashMap<Object, Object>(32);
        this._firstDayOfWeek = this.getCalendar().getFirstDayOfWeek();
    }

    public void setWeekOfYear(boolean weekOfYear) {
        if (this._weekOfYear != weekOfYear) {
            this._weekOfYear = weekOfYear;
            if (!"month".equals(this.getMold())) {
                return;
            }
            TimeZone timezone = this.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(timezone);
            cal.setTime(this.getBeginDate());
            this.smartUpdate("woy", String.valueOf(cal.get(3)));
        }
    }

    public boolean isWeekOfYear() {
        return this._weekOfYear;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readonly", this._readonly);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setDateFormatter(DateFormatter dfmater) {
        if (this._dfmter != dfmater) {
            this._dfmter = dfmater;
            this.reSendDateRange();
            this.smartUpdate("cd", Util.getDSTTime(this.getDefaultTimeZone(), this.getCurrentDate()));
            this.reSendEventGroup();
        }
    }

    public void setDateFormatter(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setDateFormatter((DateFormatter)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public DateFormatter getDateFormatter() {
        return this._dfmter;
    }

    public void setDays(int days) {
        if (days <= 0) {
            days = 1;
        }
        if (days != this._days) {
            this._days = days;
            if (!this.inMonthMold()) {
                this.reSendDateRange();
                this.smartUpdate("days", this._days);
                this.reSendEventGroup();
            }
        }
    }

    public int getDays() {
        return this._days;
    }

    public void setFirstDayOfWeek(int value) {
        if (this._firstDayOfWeek != value) {
            this._firstDayOfWeek = value;
            if (this._days == 7 || this.inMonthMold()) {
                this.reSendDateRange();
                this.smartUpdate("firstDayOfWeek", this._firstDayOfWeek);
                this.reSendEventGroup();
            }
        }
    }

    public void setFirstDayOfWeek(String day) {
        if ("SUNDAY".equalsIgnoreCase(day)) {
            this.setFirstDayOfWeek(1);
        } else if ("MONDAY".equalsIgnoreCase(day)) {
            this.setFirstDayOfWeek(2);
        } else if ("TUESDAY".equalsIgnoreCase(day)) {
            this.setFirstDayOfWeek(3);
        } else if ("WEDNESDAY".equalsIgnoreCase(day)) {
            this.setFirstDayOfWeek(4);
        } else if ("THURSDAY".equalsIgnoreCase(day)) {
            this.setFirstDayOfWeek(5);
        } else if ("FRIDAY".equalsIgnoreCase(day)) {
            this.setFirstDayOfWeek(6);
        } else if ("SATURDAY".equalsIgnoreCase(day)) {
            this.setFirstDayOfWeek(7);
        }
    }

    public int getFirstDayOfWeek() {
        return this._firstDayOfWeek;
    }

    public void onAddDayEventResponse() {
        this.removeAttribute(ATTR_ON_ADD_EVENT_RESPONSE);
        this.response("addEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "addDayEvent", (Object)Util.encloseEventList(this, this._addEvtList)));
    }

    public void onRemoveDayEventResponse() {
        this.removeAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE);
        this.response("removeEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "removeDayEvent", (Object)Util.encloseEventList(this, this._rmEvtList)));
    }

    public void onModifyDayEventResponse() {
        this.removeAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE);
        this.response("modifyEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "modifyDayEvent", (Object)Util.encloseEventList(this, this._mdyEvtList)));
    }

    public void addDayEvent(CalendarEvent ce) {
        if (ce == null) {
            return;
        }
        if (this._addEvtList == null) {
            this._addEvtList = new LinkedList<CalendarEvent>();
        }
        this._addEvtList.add(ce);
        if (this.getAttribute(ATTR_ON_ADD_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_ADD_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onAddDayEventResponse", (Component)this, null);
        }
    }

    public void modifyDayEvent(CalendarEvent ce) {
        if (ce == null) {
            return;
        }
        if (this._mdyEvtList == null) {
            this._mdyEvtList = new LinkedList<CalendarEvent>();
        }
        this._mdyEvtList.add(ce);
        if (this.getAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onModifyDayEventResponse", (Component)this, null);
        }
    }

    public void removeDayEvent(CalendarEvent ce) {
        if (ce == null) {
            return;
        }
        if (this._rmEvtList == null) {
            this._rmEvtList = new LinkedList<CalendarEvent>();
        }
        this._rmEvtList.add(ce);
        if (this.getAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onRemoveDayEventResponse", (Component)this, null);
        }
    }

    private void cleanEmptyZone() {
        HashMap<TimeZone, String> tzones = new HashMap<TimeZone, String>(this._tzones);
        for (Map.Entry es : tzones.entrySet()) {
            if (!((String)es.getValue()).equals("")) continue;
            this._tzones.remove(es.getKey());
        }
        this._hasEmptyZone = false;
    }

    private Calendar getCalendar() {
        return Calendar.getInstance(this.getDefaultTimeZone(), Locales.getCurrent());
    }

    public void addTimeZone(String label, TimeZone timezone) {
        if (label == null) {
            label = "";
        }
        this._tzones.put(timezone, label);
        if (this._hasEmptyZone) {
            this.cleanEmptyZone();
        }
        if (!this.inMonthMold() && this._dfmter != null) {
            Calendar cal = this.getCalendar();
            cal.set(12, 0);
            this.smartUpdate("captionByTimeOfDay", Util.encloseList(Util.packCaptionByTimeOfDay(cal, this._tzones, Locales.getCurrent(), this._dfmter)));
        }
        TimeZone tz = this.getDefaultTimeZone();
        this.smartUpdate("tz", tz.getRawOffset() / 60000);
        this.smartUpdate("bd", Util.getDSTTime(tz, this.getBeginDate()));
        this.smartUpdate("ed", Util.getDSTTime(tz, this.getEndDate()));
        this.reSendEventGroup();
    }

    public void addTimeZone(String label, String timezone) {
        this.addTimeZone(label, TimeZone.getTimeZone(timezone));
    }

    public void setTimeZone(String timezone) {
        if (timezone == null) {
            throw new IllegalArgumentException("The timezone is null!");
        }
        for (String timezoneString : timezone.trim().split(",")) {
            String[] pair = timezoneString.split("=");
            this.addTimeZone(pair[0].trim(), pair[1].trim());
        }
    }

    public boolean removeTimeZone(TimeZone timezone) {
        if (this._tzones.remove(timezone) != null) {
            TimeZone tz = this.getDefaultTimeZone();
            this.smartUpdate("bd", Util.getDSTTime(tz, this.getBeginDate()));
            this.smartUpdate("ed", Util.getDSTTime(tz, this.getEndDate()));
            this.reSendEventGroup();
            return true;
        }
        return false;
    }

    public TimeZone getDefaultTimeZone() {
        if (this._tzones.isEmpty()) {
            this._hasEmptyZone = true;
            TimeZone t = TimeZones.getCurrent();
            this._tzones.put(t, "");
            return t;
        }
        return this._tzones.keySet().iterator().next();
    }

    public Map<TimeZone, String> getTimeZones() {
        return Collections.unmodifiableMap(this._tzones);
    }

    public String getCalendarEventId(CalendarEvent ce) {
        Object o = this._ids.get(ce);
        if (o == null) {
            o = ((DesktopCtrl)this.getDesktop()).getNextUuid((Component)this);
            this._ids.put(o, ce);
            this._ids.put(ce, o);
        }
        return (String)o;
    }

    public CalendarEvent getCalendarEventById(String id) {
        return (CalendarEvent)this._ids.get(id);
    }

    protected String getEventKey(CalendarEvent evt) {
        Date begin = evt.getBeginDate();
        Date end = evt.getEndDate();
        if (begin == null) {
            throw new UiException("Begin date cannot be null: " + evt);
        }
        if (end == null) {
            throw new UiException("End date cannot be null: " + evt);
        }
        return this.getEventKey(begin);
    }

    private String getEventKey(Date date) {
        return this._sdfKey.format(date);
    }

    public List<CalendarEvent> getEvent(Date beginDate) {
        String key = this.getEventKey(beginDate);
        List<CalendarEvent> list = this._evts.get(key);
        if (list != null) {
            Collections.sort(list, Calendars.getDefaultBeginDateComparator());
        } else {
            list = Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    private static final Comparator<CalendarEvent> getDefaultBeginDateComparator() {
        return _defCompare;
    }

    public void previousPage() {
        this.movePage(-1);
    }

    public void nextPage() {
        this.movePage(1);
    }

    private void movePage(int day) {
        if (this._curDate == null) {
            return;
        }
        Calendar cal = this.getCalendar();
        cal.setTime(this._curDate);
        if (this.inMonthMold()) {
            cal.add(2, day);
        } else {
            cal.add(5, day * this._days);
        }
        this.setCurrentDate(cal.getTime());
    }

    public Date getBeginDate() {
        if (this._curDate == null) {
            return null;
        }
        Calendar cal = this.getCalendar();
        cal.setTime(this._curDate);
        boolean inMonth = this.inMonthMold();
        if (inMonth) {
            cal.set(5, 1);
        }
        if (this._days >= 7 || inMonth) {
            int index = cal.get(7);
            int offset = index - this._firstDayOfWeek;
            if (offset < 0) {
                offset += 7;
            }
            cal.add(5, -offset);
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public Date getEndDate() {
        Date beginDate = this.getBeginDate();
        if (beginDate == null) {
            return null;
        }
        Calendar cal = this.getCalendar();
        if (this.inMonthMold()) {
            int weeks = this.getWeekOfMonth();
            cal.setTime(this._curDate);
            cal.set(5, 1);
            int offset = cal.get(7) - this._firstDayOfWeek;
            if (offset < 0) {
                offset += 7;
            }
            cal.add(5, weeks * 7 - offset);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        } else {
            cal.setTime(beginDate);
            cal.add(5, this._days);
        }
        cal.set(14, 0);
        return cal.getTime();
    }

    public void setCurrentDate(Date curDate) {
        if (curDate == null) {
            throw new NullPointerException("Current Date cannot be null!");
        }
        if (!Objects.equals((Object)curDate, (Object)this._curDate)) {
            this._curDate = curDate;
            this.reSendDateRange();
            this.smartUpdate("cd", Util.getDSTTime(this.getDefaultTimeZone(), this.getCurrentDate()));
            this.reSendEventGroup();
        }
    }

    public Date getCurrentDate() {
        return this._curDate;
    }

    public void setBeginTime(int beginTime) {
        if (0 > beginTime || beginTime > 24) {
            throw new IllegalArgumentException("Illegal begin time: " + beginTime + ", time range only allows from 0 to 24");
        }
        if (beginTime > this._endTime) {
            throw new IllegalArgumentException("Illegal begin time: " + beginTime + ", begin time shall not later then end time: " + this._endTime);
        }
        if (this._beginTime != beginTime) {
            this._beginTime = beginTime;
            this.smartUpdate("bt", beginTime);
            this.reSendEventGroup();
        }
    }

    public int getBeginTime() {
        return this._beginTime;
    }

    public void setEndTime(int endTime) {
        if (0 > endTime || endTime > 24) {
            throw new IllegalArgumentException("Illegal end time: " + endTime + ", time range only allows from 0 to 24");
        }
        if (this._beginTime > endTime) {
            throw new IllegalArgumentException("Illegal end time: " + endTime + ", end time shall not early then begin time: " + this._beginTime);
        }
        if (this._endTime != endTime) {
            this._endTime = endTime;
            this.smartUpdate("et", endTime);
            this.reSendEventGroup();
        }
    }

    public int getEndTime() {
        return this._endTime;
    }

    public void setTimeslots(int timeslots) {
        if (timeslots != 2 && timeslots != 4 && timeslots != 6) {
            throw new UiException("allowed: 2 or 4 or 6");
        }
        if (this._timeslots != timeslots) {
            this._timeslots = timeslots;
            this.smartUpdate("timeslots", timeslots);
            this.reSendEventGroup();
        }
    }

    public int getTimeslots() {
        return this._timeslots;
    }

    private void reSendDateRange() {
        DateFormatter dfhandler;
        Date beginDate = this.getBeginDate();
        Date endDate = this.getEndDate();
        TimeZone timezone = this.getDefaultTimeZone();
        this.smartUpdate("bd", Util.getDSTTime(timezone, beginDate));
        this.smartUpdate("ed", Util.getDSTTime(timezone, endDate));
        Calendar cal = this.getCalendar();
        if (this.inMonthMold()) {
            this.smartUpdate("weekOfMonth", this.getWeekOfMonth());
            if (this.isWeekOfYear() && this._dfmter == null) {
                cal.setTime(beginDate);
                this.smartUpdate("woy", String.valueOf(cal.get(3)));
            }
        }
        if ((dfhandler = this.getDateFormatter()) == null) {
            return;
        }
        Locale locale = Locales.getCurrent();
        cal.setTime(beginDate);
        if (this.inMonthMold()) {
            List<List<String>> result = Util.packAllCaptionOfMonth(this, cal, locale, timezone, dfhandler);
            this.smartUpdate("captionByDayOfWeek", Util.encloseList((Collection<String>)result.get(0)));
            this.smartUpdate("captionByPopup", Util.encloseList((Collection<String>)result.get(1)));
            this.smartUpdate("captionByDateOfMonth", Util.encloseList((Collection<String>)result.get(2)));
            if (this.isWeekOfYear()) {
                this.smartUpdate("captionByWeekOfYear", Util.encloseList((Collection<String>)result.get(3)));
            }
        } else {
            this.smartUpdate("captionByDate", Util.encloseList(Util.packCaptionByDate(cal, this.getDays(), locale, timezone, dfhandler)));
        }
    }

    public int getWeekOfMonth() {
        Calendar cal = this.getCalendar();
        cal.setTime(this._curDate);
        int maximun = cal.getActualMaximum(5);
        if (cal.getFirstDayOfWeek() != this._firstDayOfWeek) {
            cal.set(5, 1);
            int beginIndex = cal.get(7);
            int offset = beginIndex - this._firstDayOfWeek;
            if (offset < 0) {
                offset += 7;
            }
            int week = 1;
            int delta = maximun - (7 - offset);
            week += delta / 7;
            if (delta % 7 != 0) {
                ++week;
            }
            return week;
        }
        cal.set(5, maximun);
        int last = cal.get(4);
        cal.set(5, 1);
        return last - cal.get(4) + 1;
    }

    protected void reSendEventGroup() {
        if (this.getAttribute(ATTR_ON_INIT_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_POSTED, Boolean.TRUE);
            Events.postEvent((int)-10100, (String)"onInitRender", (Component)this, null);
        }
    }

    public void onInitRender() {
        Date beginDate;
        List<CalendarEvent> list;
        this.removeAttribute(ATTR_ON_INIT_POSTED);
        this._evts.clear();
        this._ids.clear();
        final TimeZone tzone = this.getDefaultTimeZone();
        this.smartUpdate("zonesOffset", Util.encloseList(Util.packZonesOffset(this._tzones)));
        this.smartUpdate("zones", Util.encloseList(this._tzones.values()));
        this._sdfKey.setTimeZone(tzone);
        if (this._model != null && (list = this._model.get(beginDate = this.getBeginDate(), this.getEndDate(), new RenderContext(){

            public TimeZone getTimeZone() {
                return tzone;
            }
        })) != null) {
            for (CalendarEvent ce : list) {
                if (!ce.getBeginDate().before(ce.getEndDate())) {
                    throw new IllegalArgumentException("Illegal date: from " + ce.getBeginDate() + " to " + ce.getEndDate());
                }
                String key = ce.getBeginDate().before(beginDate) ? this.getEventKey(beginDate) : this.getEventKey(ce.getBeginDate());
                List<CalendarEvent> dayevt = this._evts.get(key);
                if (dayevt == null) {
                    dayevt = new LinkedList<CalendarEvent>();
                    this._evts.put(key, dayevt);
                }
                dayevt.add(ce);
            }
        }
        this.smartUpdate("events", Util.encloseEventMap(this, this._evts));
    }

    public Toolbar getToolbar() {
        return (Toolbar)this.getFirstChild();
    }

    public CalendarModel getModel() {
        return this._model;
    }

    public void setModel(CalendarModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeCalendarDataListener(this._dataListener);
                }
                this._model = model;
                this.initDataListener();
            }
        } else if (this._model != null) {
            this._model.removeCalendarDataListener(this._dataListener);
            this._model = null;
        }
        this.reSendEventGroup();
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new CalendarDataListener(){

                public void onChange(CalendarDataEvent event) {
                    CalendarEvent ce = event.getCalendarEvent();
                    if (ce == null) {
                        Calendars.this.reSendEventGroup();
                        return;
                    }
                    switch (event.getType()) {
                        case 1: {
                            Calendars.this.addDayEvent(event.getCalendarEvent());
                            break;
                        }
                        case 2: {
                            Calendars.this.removeDayEvent(event.getCalendarEvent());
                            break;
                        }
                        case 0: {
                            Calendars.this.modifyDayEvent(event.getCalendarEvent());
                        }
                    }
                }
            };
        }
        this._model.addCalendarDataListener(this._dataListener);
    }

    public void setMold(String mold) {
        if (mold == null || mold.length() == 0) {
            mold = "default";
        }
        if (!Objects.equals((Object)this.getMold(), (Object)mold)) {
            super.setMold(mold);
            this.reSendEventGroup();
        }
    }

    boolean inMonthMold() {
        return "month".equals(this.getMold());
    }

    public void setEscapeXML(boolean escapeXML) {
        if (this._escapeXML != escapeXML) {
            this._escapeXML = escapeXML;
            this.smartUpdate("escapeXML", escapeXML);
            this.reSendEventGroup();
        }
    }

    public boolean isEscapeXML() {
        return this._escapeXML;
    }

    public String getZclass() {
        return this._zclass == null ? "z-calendars" : this._zclass;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        Component first;
        if (newChild instanceof Toolbar) {
            first = this.getFirstChild();
            if (first instanceof Toolbar && first != newChild) {
                throw new UiException("Only one toolbar child is allowed: " + (Object)((Object)this));
            }
        } else {
            throw new UiException("Unsupported child for Calendars: " + newChild);
        }
        refChild = first;
        return super.insertBefore(newChild, refChild);
    }

    public Object clone() {
        Calendars clone = (Calendars)((Object)super.clone());
        clone.init();
        if (clone._model != null) {
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        if (this._model != null) {
            this.initDataListener();
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onEventCreate")) {
            Events.postEvent((Event)CalendarsEvent.getCreateEvent(request));
        } else if (cmd.equals("onEventEdit")) {
            Events.postEvent((Event)CalendarsEvent.getEditEvent(request));
        } else if (cmd.equals("onEventUpdate")) {
            Events.postEvent((Event)CalendarsEvent.getUpdateEvent(request));
        } else if (cmd.equals("onDayClick") || cmd.equals("onWeekClick")) {
            Events.postEvent((Event)CalendarsEvent.getClickEvent(request, cmd));
        } else if (cmd.equals("onDrop")) {
            Events.postEvent((Event)CalendarDropEvent.getCalendarDropEvent(request));
        } else if (cmd.equals("onEventTooltip")) {
            Events.postEvent((Event)CalendarsEvent.getTooltipEvent(request));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        TimeZone tz = this.getDefaultTimeZone();
        renderer.render("tz", tz.getRawOffset() / 60000);
        renderer.render("zonesOffset", Util.encloseList(Util.packZonesOffset(this._tzones)));
        renderer.render("zones", Util.encloseList(this._tzones.values()));
        if (this.inMonthMold()) {
            renderer.render("mon", true);
            renderer.render("weekOfMonth", this.getWeekOfMonth());
            if (this._weekOfYear) {
                Calendar cal = this.getCalendar();
                cal.setTime(this.getBeginDate());
                renderer.render("woy", String.valueOf(cal.get(3)));
            }
            if (this._dfmter != null) {
                this.rendererMonthData(this._dfmter, renderer);
            }
        } else {
            if (this._dfmter != null) {
                this.rendererDayData(this._dfmter, renderer);
            }
            if (this._beginTime != 0) {
                renderer.render("bt", this._beginTime);
            }
            if (this._beginTime != 24) {
                renderer.render("et", this._endTime);
            }
            if (this._timeslots != 2) {
                renderer.render("timeslots", this._timeslots);
            }
        }
        renderer.render("bd", Util.getDSTTime(tz, this.getBeginDate()));
        renderer.render("ed", Util.getDSTTime(tz, this.getEndDate()));
        renderer.render("cd", Util.getDSTTime(tz, this.getCurrentDate()));
        if (this._readonly) {
            renderer.render("readonly", true);
        }
        renderer.render("days", this._days);
        renderer.render("escapeXML", this._escapeXML);
        renderer.render("events", Util.encloseEventMap(this, this._evts));
        String pattern = ((SimpleDateFormat)DateFormat.getDateInstance(3, Locales.getCurrent())).toPattern().replaceAll("[^\\p{Alpha}]*y+[^\\p{Alpha}]*", "");
        renderer.render("weekFmt", pattern);
    }

    private void rendererDayData(DateFormatter dfhandler, ContentRenderer renderer) throws IOException {
        Locale locale = Locales.getCurrent();
        Calendar cal = this.getCalendar();
        cal.setTime(this.getBeginDate());
        renderer.render("captionByDate", Util.encloseList(Util.packCaptionByDate(cal, this.getDays(), locale, this.getDefaultTimeZone(), dfhandler)));
        cal.set(12, 0);
        renderer.render("captionByTimeOfDay", Util.encloseList(Util.packCaptionByTimeOfDay(cal, this._tzones, locale, dfhandler)));
    }

    private void rendererMonthData(DateFormatter dfhandler, ContentRenderer renderer) throws IOException {
        Calendar cal = this.getCalendar();
        cal.setTime(this.getBeginDate());
        List<List<String>> result = Util.packAllCaptionOfMonth(this, cal, Locales.getCurrent(), this.getDefaultTimeZone(), dfhandler);
        renderer.render("captionByDayOfWeek", Util.encloseList((Collection<String>)result.get(0)));
        renderer.render("captionByPopup", Util.encloseList((Collection<String>)result.get(1)));
        renderer.render("captionByDateOfMonth", Util.encloseList((Collection<String>)result.get(2)));
        if (this.isWeekOfYear()) {
            renderer.render("captionByWeekOfYear", Util.encloseList((Collection<String>)result.get(3)));
        }
    }

    public EventRender getEventRender() {
        return null;
    }

    public void setEventRender(EventRender render) {
    }

    static {
        Calendars.addClientEvent(Calendars.class, (String)"onEventCreate", (int)0);
        Calendars.addClientEvent(Calendars.class, (String)"onEventEdit", (int)0);
        Calendars.addClientEvent(Calendars.class, (String)"onEventUpdate", (int)0);
        Calendars.addClientEvent(Calendars.class, (String)"onDayClick", (int)16384);
        Calendars.addClientEvent(Calendars.class, (String)"onWeekClick", (int)16384);
        Calendars.addClientEvent(Calendars.class, (String)"onEventTooltip", (int)16384);
    }
}

