/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps.event;

import java.util.Map;
import org.zkoss.gmaps.LatLng;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;

public class CenterChangeEvent
extends Event {
    private final LatLng _center;
    private final LatLng _oldCenter;

    public static final CenterChangeEvent getCenterChangeEvent(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)request);
        }
        Map data = request.getData();
        if (data == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{data, request});
        }
        double lat = ((Number)data.get("lat")).doubleValue();
        double lng = ((Number)data.get("lng")).doubleValue();
        double oldlat = ((Number)data.get("oldlat")).doubleValue();
        double oldlng = ((Number)data.get("oldlng")).doubleValue();
        return new CenterChangeEvent(request.getCommand(), comp, new LatLng(lat, lng), new LatLng(oldlat, oldlng));
    }

    public CenterChangeEvent(String name, Component target, LatLng center, LatLng oldCenter) {
        super(name, target);
        this._center = center;
        this._oldCenter = oldCenter;
    }

    public CenterChangeEvent(String name, Component target, double lat, double lng, double oldlat, double oldlng) {
        this(name, target, new LatLng(lat, lng), new LatLng(oldlat, oldlng));
    }

    public double getLat() {
        return this._center.getLatitude();
    }

    public double getLng() {
        return this._center.getLongitude();
    }

    public double getOldLat() {
        return this._oldCenter.getLatitude();
    }

    public double getOldLng() {
        return this._oldCenter.getLongitude();
    }

    public LatLng getCenter() {
        return this._center;
    }

    public LatLng getOldCenter() {
        return this._oldCenter;
    }
}

