/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.compiere.apps.form.TreeBOM;
import org.compiere.model.MProduct;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BOMViewerFormTest
extends AbstractTestCase {
    private Function<TreeBOM.NewNodeArguments<TreeNode>, TreeNode> createNewNodeFunction = a -> {
        TreeNode child = new TreeNode(a.dataLine());
        ((TreeNode)a.parentNode()).addChild(child);
        return child;
    };

    @Test
    public void testLoadBOM() {
        TreeBOM treeBOM = new TreeBOM();
        MProduct product = MProduct.get((int)DictionaryIDs.M_Product.P_CHAIR.id);
        TreeNode root = new TreeNode("Root");
        treeBOM.loadBOM(product, (Object)root, this.createNewNodeFunction, false, false);
        Assertions.assertTrue((root.getChildCount() > 0 ? 1 : 0) != 0, (String)"Failed to load BOM tree");
        List bomLines = treeBOM.getDataBOM();
        Assertions.assertTrue((bomLines.size() > 0 ? 1 : 0) != 0, (String)"Failed to load BOM lines");
        root = new TreeNode("Root");
        treeBOM.loadBOM(product, (Object)root, this.createNewNodeFunction, true, false);
        Assertions.assertTrue((root.getChildCount() > 0 ? 1 : 0) != 0, (String)"Failed to load implosion BOM tree");
        bomLines = treeBOM.getDataBOM();
        Assertions.assertTrue((bomLines.size() > 0 ? 1 : 0) != 0, (String)"Failed to load implosion BOM lines");
    }

    private class TreeNode {
        private Object data;
        private List<TreeNode> childs;
        private TreeNode parent = null;

        public TreeNode(Object data) {
            this.data = data;
            this.childs = new ArrayList<TreeNode>();
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public void addChild(TreeNode child) {
            this.childs.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeNode child) {
            if (this.childs.remove(child)) {
                child.setParent(null);
            }
        }

        public int getChildCount() {
            return this.childs.size();
        }
    }
}

