/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.costing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetExclude;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLandedCost;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLandedCost;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MProject;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.model.X_Fact_Acct;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.ConversionRateHelper;
import org.idempiere.test.DictionaryIDs;
import org.idempiere.test.FactAcct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class AveragePOCostingTest
extends AbstractTestCase {
    @Test
    public void testMaterialReceipt() {
        MProduct product = null;
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        try {
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
            product.setName("testMaterialReceipt");
            product.setValue("testMaterialReceipt");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MInOutLine receiptLine = this.createPOAndMRForProduct(product.get_ID(), null, null);
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for material receipt line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            receiptLine = this.createPOAndMRForProduct(product.get_ID(), null, new BigDecimal("3.00"));
            cost.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)new BigDecimal("2.50"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for material receipt line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("3.00"), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            MInOut receipt = new MInOut(Env.getCtx(), receiptLine.getM_InOut_ID(), this.getTrxName());
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)receipt.getDocStatus(), (String)"Unexpected Document Status");
            MInOut reverse = new MInOut(Env.getCtx(), receipt.getReversal_ID(), this.getTrxName());
            if (!reverse.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)reverse.getAD_Client_ID(), (int)reverse.get_Table_ID(), (int)reverse.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            cost.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("0.00"), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testShipment() {
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.AZALEA_BUSH.id, this.getTrxName());
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.AZALEA_BUSH.id, null, new BigDecimal("5.00"));
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        BigDecimal currentCost = cost.getCurrentCostPrice();
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Unexpected Document Status");
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus(), (String)"Unexpected Document Status");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.get_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
        Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"RA");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"RE", (Object)shipment.getDocStatus(), (String)"Unexpected Document Status");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
        MInOut reversal = new MInOut(Env.getCtx(), shipment.getReversal_ID(), this.getTrxName());
        MInOutLine[] reversalLines = reversal.getLines();
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLines[0].get_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
    }

    @Test
    public void testInternalUse() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        Assertions.assertNotNull((Object)cost, (String)"No MCost Record");
        BigDecimal currentCost = cost.getCurrentCostPrice();
        MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.INTERNAL_USE_INVENTORY.id);
        inventory.saveEx();
        MInventoryLine line = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
        line.setM_Inventory_ID(inventory.get_ID());
        line.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        line.setQtyInternalUse(new BigDecimal("1.00"));
        line.setC_Charge_ID(DictionaryIDs.C_Charge.COMMISSIONS.id);
        line.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)line.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
        info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"RA");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MInventory reversal = new MInventory(Env.getCtx(), inventory.getReversal_ID(), this.getTrxName());
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)reversal.getLines(false)[0].getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
    }

    @Test
    public void testProjectIssue() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        Assertions.assertNotNull((Object)cost, (String)"No MCost Record");
        BigDecimal currentCost = cost.getCurrentCostPrice();
        MProject project = new MProject(Env.getCtx(), 0, this.getTrxName());
        project.setName("testProjectIssue");
        project.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        project.saveEx();
        MProjectIssue issue = new MProjectIssue(project);
        issue.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        issue.setLine(10);
        issue.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
        issue.setMovementQty(new BigDecimal("1.00"));
        issue.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)issue, (String)"CO");
        issue.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)issue.getDocStatus(), (String)"Unexpected Document Status");
        if (!issue.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)issue.getAD_Client_ID(), (int)issue.get_Table_ID(), (int)issue.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_ProjectIssue_ID=?", (int)issue.getC_ProjectIssue_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
        Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
        info = MWorkflow.runDocumentActionWorkflow((PO)issue, (String)"RA");
        issue.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)issue.getDocStatus(), (String)"Unexpected Document Status");
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_ProjectIssue_ID=?", (int)issue.getReversal_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
        Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
    }

    @Test
    public void testProduction() {
        MProduct mulch = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MProduct azb = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.AZALEA_BUSH.id, this.getTrxName());
        MProduct mulchX = new MProduct(Env.getCtx(), 0, null);
        mulchX.setName("MulchX2");
        mulchX.setIsBOM(true);
        mulchX.setIsStocked(true);
        mulchX.setC_UOM_ID(mulch.getC_UOM_ID());
        mulchX.setM_Product_Category_ID(mulch.getM_Product_Category_ID());
        mulchX.setProductType(mulch.getProductType());
        mulchX.setM_AttributeSet_ID(mulch.getM_AttributeSet_ID());
        mulchX.setC_TaxCategory_ID(mulch.getC_TaxCategory_ID());
        mulchX.saveEx();
        try {
            MClient client = MClient.get((Properties)Env.getCtx());
            MAcctSchema as = client.getAcctSchema();
            Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
            MCost cost = mulch.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
                this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
                cost = mulch.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            }
            BigDecimal mulchCost = cost.getCurrentCostPrice();
            cost = azb.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
                this.createPOAndMRForProduct(DictionaryIDs.M_Product.AZALEA_BUSH.id, null, null);
                cost = azb.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            }
            BigDecimal azbCost = cost.getCurrentCostPrice();
            MPPProductBOM bom = new MPPProductBOM(Env.getCtx(), 0, this.getTrxName());
            bom.setM_Product_ID(mulchX.get_ID());
            bom.setBOMType("A");
            bom.setBOMUse("A");
            bom.setName(mulchX.getName());
            bom.saveEx();
            MPPProductBOMLine line1 = new MPPProductBOMLine(bom);
            line1.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
            line1.setQtyBOM(new BigDecimal("1"));
            line1.saveEx();
            MPPProductBOMLine line2 = new MPPProductBOMLine(bom);
            line2.setM_Product_ID(DictionaryIDs.M_Product.AZALEA_BUSH.id);
            line2.setQtyBOM(new BigDecimal("1"));
            line2.saveEx();
            mulchX.load(null, new String[0]);
            mulchX.setIsVerified(true);
            mulchX.saveEx();
            MProduction production = new MProduction(Env.getCtx(), 0, this.getTrxName());
            production.setM_Product_ID(mulchX.get_ID());
            production.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
            production.setIsUseProductionPlan(false);
            production.setMovementDate(this.getLoginDate());
            production.setDocAction("CO");
            production.setDocStatus("DR");
            production.setIsComplete(false);
            production.setProductionQty(new BigDecimal("1"));
            production.setPP_Product_BOM_ID(bom.getPP_Product_BOM_ID());
            production.saveEx();
            int productionCreate = 53226;
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)productionCreate);
            ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setRecord_ID(production.get_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            production.load(this.getTrxName(), new String[0]);
            MProductionLine[] plines = production.getLines();
            Assertions.assertEquals((Object)"Y", (Object)production.getIsCreated(), (String)"MProduction.IsCreated != Y");
            Assertions.assertTrue((plines.length > 0 ? 1 : 0) != 0, (String)"No Production Lines");
            Assertions.assertEquals((int)3, (int)plines.length, (String)"Unexpected number of production lines");
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"CO");
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
            BigDecimal rollup = mulchCost.add(azbCost);
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)plines[0].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)rollup.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            mulchX.set_TrxName(this.getTrxName());
            cost = mulchX.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)rollup.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)plines[1].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)mulchCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost = mulch.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)mulchCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)plines[2].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)azbCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost = azb.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)azbCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
            info = MWorkflow.runDocumentActionWorkflow((PO)production, (String)"RA");
            production.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)production.getDocStatus(), (String)("Production Status=" + production.getDocStatus()));
            MProduction reversal = new MProduction(Env.getCtx(), production.getReversal_ID(), this.getTrxName());
            MProductionLine[] reversalLines = reversal.getLines();
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)reversalLines[0].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)rollup.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)reversalLines[1].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)mulchCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost = mulch.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)mulchCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_ProductionLine_ID=?", (int)reversalLines[2].getM_ProductionLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for project issue line");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)azbCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost = azb.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        catch (Throwable throwable) {
            this.rollback();
            DB.executeUpdateEx((String)"delete from m_cost where m_product_id=?", (Object[])new Object[]{mulchX.get_ID()}, null);
            mulchX.set_TrxName(null);
            mulchX.deleteEx(true);
            throw throwable;
        }
        this.rollback();
        DB.executeUpdateEx((String)"delete from m_cost where m_product_id=?", (Object[])new Object[]{mulchX.get_ID()}, null);
        mulchX.set_TrxName(null);
        mulchX.deleteEx(true);
    }

    @Test
    public void testMRAndShipmentByLot() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        MProductCategory lotLevel = new MProductCategory(Env.getCtx(), 0, null);
        lotLevel.setName("testMaterialReceiptLot");
        lotLevel.saveEx();
        MProduct product = null;
        MAttributeSetExclude exclude = null;
        MAttributeSetExclude exclude1 = null;
        try {
            MAttributeSet mas = new MAttributeSet(Env.getCtx(), DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id, this.getTrxName());
            mas.setMandatoryType("N");
            mas.saveEx();
            exclude = new MAttributeSetExclude(Env.getCtx(), 0, null);
            exclude.setM_AttributeSet_ID(mas.get_ID());
            exclude.setAD_Table_ID(260);
            exclude.setIsSOTrx(true);
            exclude.saveEx();
            exclude1 = new MAttributeSetExclude(Env.getCtx(), 0, null);
            exclude1.setM_AttributeSet_ID(mas.get_ID());
            exclude1.setAD_Table_ID(320);
            exclude1.setIsSOTrx(true);
            exclude1.saveEx();
            MProductCategoryAcct lotLevelAcct = MProductCategoryAcct.get((int)lotLevel.get_ID(), (int)as.get_ID());
            lotLevelAcct = new MProductCategoryAcct(Env.getCtx(), lotLevelAcct);
            lotLevelAcct.setCostingLevel("B");
            lotLevelAcct.saveEx();
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(lotLevel.get_ID());
            product.setName("testMaterialReceiptLot");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi1.setLot("Lot1");
            asi1.saveEx();
            MInOutLine line1 = this.createPOAndMRForProduct(product.get_ID(), asi1, new BigDecimal("2.00"));
            MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi2.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi2.setLot("Lot2");
            asi2.saveEx();
            MInOutLine line2 = this.createPOAndMRForProduct(product.get_ID(), asi2, new BigDecimal("3.00"));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line1.getC_OrderLine_ID(), (int)asi1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("2").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line2.getC_OrderLine_ID(), (int)asi2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("3").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            product.set_TrxName(this.getTrxName());
            MCost cost1 = product.getCostingRecord(as, this.getAD_Org_ID(), asi1.get_ID(), as.getCostingMethod());
            Assertions.assertNotNull((Object)cost1, (String)"MCost record not found");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost1.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP));
            MCost cost2 = product.getCostingRecord(as, this.getAD_Org_ID(), asi2.get_ID(), as.getCostingMethod());
            Assertions.assertNotNull((Object)cost2, (String)"MCost record not found");
            Assertions.assertEquals((Object)new BigDecimal("3.00"), (Object)cost2.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP));
            ProductCost pc = new ProductCost(Env.getCtx(), line1.getM_Product_ID(), line1.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount asset = pc.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)line1.getM_InOut_ID(), (String)this.getTrxName());
            doc.setC_BPartner_ID(line1.getParent().getC_BPartner_ID());
            MAccount acctNIR = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)line1.getM_InOut_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
            List fas = query.list();
            Assertions.assertTrue((fas.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve fact posting entries for shipment document");
            boolean nirFound = false;
            boolean assetFound = false;
            for (MFactAcct fa : fas) {
                if (asset.getAccount_ID() == fa.getAccount_ID()) {
                    if (line1.get_ID() == fa.getLine_ID()) {
                        Assertions.assertEquals((Object)fa.getAmtSourceDr().abs().toPlainString(), (Object)fa.getAmtSourceDr().toPlainString(), (String)"Not DR Asset");
                        Assertions.assertTrue((fa.getAmtSourceDr().signum() > 0 ? 1 : 0) != 0, (String)"Not DR Asset");
                    }
                    assetFound = true;
                    continue;
                }
                if (acctNIR.getAccount_ID() != fa.getAccount_ID()) continue;
                if (line1.get_ID() == fa.getLine_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtSourceCr().abs().toPlainString(), (Object)fa.getAmtSourceCr().toPlainString(), (String)"Not CR Not Invoiced Receipt");
                    Assertions.assertTrue((fa.getAmtSourceCr().signum() > 0 ? 1 : 0) != 0, (String)"Not CR Not Invoiced Receipt");
                }
                nirFound = true;
            }
            Assertions.assertTrue((boolean)nirFound, (String)"No Not Invoiced Receipt posting found");
            Assertions.assertTrue((boolean)assetFound, (String)"No Product Asset posting found");
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            order.setC_DocTypeTarget_ID("SO");
            order.setDeliveryRule("O");
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine ol1 = new MOrderLine(order);
            ol1.setLine(10);
            ol1.setProduct(product);
            ol1.setQty(new BigDecimal("2"));
            ol1.setDatePromised(today);
            ol1.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Unexpected document status");
            MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine = new MInOutLine(shipment);
            shipmentLine.setOrderLine(ol1, 0, new BigDecimal("2"));
            shipmentLine.setQty(new BigDecimal("2"));
            shipmentLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus(), (String)"Unexpected document status");
            MInOutLineMA[] linema = MInOutLineMA.get((Properties)Env.getCtx(), (int)shipmentLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)linema.length, (String)"Unexpected number of MInOutLineMA records");
            Assertions.assertEquals((int)linema[0].getM_AttributeSetInstance_ID(), (int)asi1.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for MInOutLineMA 1");
            Assertions.assertEquals((int)linema[1].getM_AttributeSetInstance_ID(), (int)asi2.get_ID(), (String)"Unexpected M_AttributeSetInstance_ID for MInOutLineMA 2");
            Assertions.assertEquals((int)1, (int)linema[0].getMovementQty().intValue(), (String)"Unexpected MovementQty for MInOutLineMA 1");
            Assertions.assertEquals((int)1, (int)linema[1].getMovementQty().intValue(), (String)"Unexpected MovementQty for MInOutLineMA 2");
            if (!shipment.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)shipment.getAD_Client_ID(), (int)shipment.get_Table_ID(), (int)shipment.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            pc = new ProductCost(Env.getCtx(), shipmentLine.getM_Product_ID(), shipmentLine.getM_AttributeSetInstance_ID(), this.getTrxName());
            MAccount cogs = pc.getAccount(4, as);
            asset = pc.getAccount(3, as);
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.getM_InOut_ID(), (int)as.getC_AcctSchema_ID(), (String)this.getTrxName());
            fas = query.list();
            Assertions.assertTrue((fas.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve fact posting entries for shipment document");
            boolean cogsFound = false;
            assetFound = false;
            for (MFactAcct fa : fas) {
                if (cogs.getAccount_ID() == fa.getAccount_ID()) {
                    if (shipmentLine.get_ID() == fa.getLine_ID()) {
                        Assertions.assertEquals((Object)fa.getAmtSourceDr().abs().toPlainString(), (Object)fa.getAmtSourceDr().toPlainString(), (String)"Not DR COGS");
                        Assertions.assertTrue((fa.getAmtSourceDr().signum() > 0 ? 1 : 0) != 0, (String)"Not DR COGS");
                    }
                    cogsFound = true;
                    continue;
                }
                if (asset.getAccount_ID() != fa.getAccount_ID()) continue;
                if (shipmentLine.get_ID() == fa.getLine_ID()) {
                    Assertions.assertEquals((Object)fa.getAmtSourceCr().abs().toPlainString(), (Object)fa.getAmtSourceCr().toPlainString(), (String)"Not CR Product Asset");
                    Assertions.assertTrue((fa.getAmtSourceCr().signum() > 0 ? 1 : 0) != 0, (String)"Not CR Product Asset");
                }
                assetFound = true;
            }
            Assertions.assertTrue((boolean)cogsFound, (String)"No COGS posting found");
            Assertions.assertTrue((boolean)assetFound, (String)"No Product Asset posting found");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)linema[0].getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("2").negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)linema[1].getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("3").negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)shipment.getDocStatus(), (String)"Unexpected document status");
            MInOut reversal = new MInOut(Env.getCtx(), shipment.getReversal_ID(), this.getTrxName());
            MInOutLine[] reversalLines = reversal.getLines();
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLines[0].getM_InOutLine_ID(), (int)asi1.getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("2").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLines[0].getM_InOutLine_ID(), (int)asi2.getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line1");
            Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("3").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            cost1 = product.getCostingRecord(as, this.getAD_Org_ID(), asi1.get_ID(), as.getCostingMethod());
            Assertions.assertNotNull((Object)cost1, (String)"MCost record not found");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost1.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP));
            cost2 = product.getCostingRecord(as, this.getAD_Org_ID(), asi2.get_ID(), as.getCostingMethod());
            Assertions.assertNotNull((Object)cost2, (String)"MCost record not found");
            Assertions.assertEquals((Object)new BigDecimal("3.00"), (Object)cost2.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP));
            MInOut mr2 = new MInOut(Env.getCtx(), line2.getM_InOut_ID(), this.getTrxName());
            info = MWorkflow.runDocumentActionWorkflow((PO)mr2, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            mr2.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)mr2.getDocStatus(), (String)"Unexpected document status");
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line2.getC_OrderLine_ID(), (int)asi2.getM_AttributeSetInstance_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for order line2");
            Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
            Assertions.assertEquals((Object)new BigDecimal("0").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        }
        finally {
            this.rollback();
            if (exclude != null) {
                exclude.deleteEx(true);
            }
            if (exclude1 != null) {
                exclude1.deleteEx(true);
            }
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
            lotLevel.deleteEx(true);
        }
    }

    @Test
    public void testCostAdjustment() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        if (cost == null || cost.getCurrentCostPrice().signum() == 0 || cost.getCurrentQty().signum() == 0) {
            this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        }
        Assertions.assertNotNull((Object)cost, (String)"No MCost Record");
        BigDecimal currentCost = cost.getCurrentCostPrice();
        BigDecimal adjustment = new BigDecimal("0.25");
        MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.COST_ADJUSTMENT.id);
        inventory.setC_Currency_ID(as.getC_Currency_ID());
        inventory.setCostingMethod(as.getCostingMethod());
        inventory.saveEx();
        MInventoryLine line = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
        line.setM_Inventory_ID(inventory.get_ID());
        line.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        line.setC_Charge_ID(DictionaryIDs.C_Charge.COMMISSIONS.id);
        line.setCurrentCostPrice(currentCost);
        line.setNewCostPrice(currentCost.add(adjustment));
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)line.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)adjustment.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.add(adjustment).setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
        info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"RA");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MInventory reversal = new MInventory(Env.getCtx(), inventory.getReversal_ID(), this.getTrxName());
        MInventoryLine[] reversalLines = reversal.getLines(true);
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)reversalLines[0].getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)adjustment.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
    }

    @Test
    public void testPhysicalInventory() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id, null, null);
        MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
        Assertions.assertNotNull((Object)cost, (String)"No MCost Record");
        BigDecimal currentCost = cost.getCurrentCostPrice();
        MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.MATERIAL_PHYSICAL_INVENTORY.id);
        inventory.saveEx();
        MInventoryLine line = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
        line.setM_Inventory_ID(inventory.get_ID());
        line.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
        line.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
        BigDecimal qtyOnHand = MStorageOnHand.getQtyOnHandForLocator((int)line.getM_Product_ID(), (int)line.getM_Locator_ID(), (int)0, (String)this.getTrxName());
        line.setQtyBook(qtyOnHand);
        line.setQtyCount(line.getQtyBook().add(new BigDecimal("1")));
        line.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)line.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
        info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"RA");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        MInventory reversal = new MInventory(Env.getCtx(), inventory.getReversal_ID(), this.getTrxName());
        MInventoryLine[] reversalLines = reversal.getLines(true);
        cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)reversalLines[0].getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
        Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for internal use line");
        Assertions.assertEquals((int)-1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
        Assertions.assertEquals((Object)currentCost.negate().setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
        cost.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)currentCost.setScale(2, RoundingMode.HALF_UP), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost");
    }

    @Test
    public void testLandedCostForPO() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = null;
        try {
            List cds;
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            product.setName("testLandedCostForPO");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            order.setIsSOTrx(false);
            order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(new MProduct(Env.getCtx(), product.get_ID(), this.getTrxName()));
            line1.setQty(new BigDecimal("1"));
            line1.setDatePromised(today);
            line1.setPrice(new BigDecimal("2"));
            line1.saveEx();
            MOrderLandedCost landedCost = new MOrderLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_Order_ID(order.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setAmt(new BigDecimal("0.30"));
            landedCost.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receiptLine1 = new MInOutLine(receipt1);
            receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
            receiptLine1.setQty(new BigDecimal("1"));
            receiptLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 2 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() == 0) {
                    Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                    Assertions.assertEquals((Object)new BigDecimal("2.00").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
                    continue;
                }
                if (cd.getM_CostElement_ID() != DictionaryIDs.M_CostElement.FREIGHT.id) continue;
                Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)new BigDecimal("0.30").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)new BigDecimal("2.30"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            MAccount landedCostAccount = productCost.getAccount(24, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List list = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("2.30"), 2, true), new FactAcct(nivReceiptAccount, new BigDecimal("2.00"), 2, false), new FactAcct(landedCostAccount, new BigDecimal("0.30"), 2, false));
            this.assertFactAcctEntries(list, expected);
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"RA");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"RE", (Object)receipt1.getDocStatus());
            cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertTrue((cds.size() == 2 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() == 0) {
                    Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                    Assertions.assertEquals((Object)new BigDecimal("0").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
                    continue;
                }
                if (cd.getM_CostElement_ID() != DictionaryIDs.M_CostElement.FREIGHT.id) continue;
                Assertions.assertEquals((int)0, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)new BigDecimal("0").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.getReversal_ID(), (int)as.get_ID(), (String)this.getTrxName());
            list = query.list();
            expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("2.30"), 2, false), new FactAcct(nivReceiptAccount, new BigDecimal("2.00"), 2, true), new FactAcct(landedCostAccount, new BigDecimal("0.30"), 2, true));
            this.assertFactAcctEntries(list, expected);
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testLandedCostForPOAndInvoice() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = null;
        try {
            List cds;
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            product.setName("testLandedCostForPOAndInvoice");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            order.setIsSOTrx(false);
            order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(new MProduct(Env.getCtx(), product.get_ID(), this.getTrxName()));
            line1.setQty(new BigDecimal("1"));
            line1.setDatePromised(today);
            line1.setPrice(new BigDecimal("2"));
            line1.saveEx();
            MOrderLandedCost landedCost = new MOrderLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_Order_ID(order.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setAmt(new BigDecimal("0.30"));
            landedCost.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receiptLine1 = new MInOutLine(receipt1);
            receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
            receiptLine1.setQty(new BigDecimal("1"));
            receiptLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 2 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() == 0) {
                    Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                    Assertions.assertEquals((Object)new BigDecimal("2.00").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
                    continue;
                }
                if (cd.getM_CostElement_ID() != DictionaryIDs.M_CostElement.FREIGHT.id) continue;
                Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)new BigDecimal("0.30").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)new BigDecimal("2.30"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            MAccount landedCostAccount = productCost.getAccount(24, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List list = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("2.30"), 2, true), new FactAcct(nivReceiptAccount, new BigDecimal("2.00"), 2, false), new FactAcct(landedCostAccount, new BigDecimal("0.30"), 2, false));
            this.assertFactAcctEntries(list, expected);
            MInvoice invoice = new MInvoice(receipt1, receipt1.getMovementDate());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_InOutLine_ID(receiptLine1.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(BigDecimal.ONE);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = productCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)invoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            list = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, new BigDecimal("2.00"), 2, true), new FactAcct(liabilityAccount, new BigDecimal("2.00"), 2, false));
            this.assertFactAcctEntries(list, expected);
            MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setBPartner(bp);
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setLine(10);
            invoiceLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            invoiceLine.setQty(BigDecimal.ONE);
            invoiceLine.setPrice(new BigDecimal("0.40"));
            invoiceLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            invoiceLine.saveEx();
            MLandedCost invoiceLandedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            invoiceLandedCost.setC_InvoiceLine_ID(invoiceLine.get_ID());
            invoiceLandedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            invoiceLandedCost.setM_InOut_ID(receipt1.get_ID());
            invoiceLandedCost.setM_InOutLine_ID(receiptLine1.get_ID());
            invoiceLandedCost.setLandedCostDistribution("Q");
            invoiceLandedCost.saveEx();
            String error = invoiceLandedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            MAccount landedCostClearingAccount = productCost.getAccount(24, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)invoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            list = query.list();
            expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("0.10"), 2, true), new FactAcct(landedCostClearingAccount, new BigDecimal("0.30"), 2, true), new FactAcct(apAccount, new BigDecimal("0.40"), 2, false));
            this.assertFactAcctEntries(list, expected);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)new BigDecimal("2.40"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testLandedCostWtihNoEstimateForPOAndInvoice() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct product = null;
        try {
            List cds;
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            product.setName("testLandedCostWtihNoEstimateForPOAndInvoice");
            product.setProductType("I");
            product.setIsStocked(true);
            product.setIsSold(true);
            product.setIsPurchased(true);
            product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(product.get_ID());
            pp.setPriceStd(new BigDecimal("2"));
            pp.setPriceList(new BigDecimal("2"));
            pp.saveEx();
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            order.setIsSOTrx(false);
            order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(new MProduct(Env.getCtx(), product.get_ID(), this.getTrxName()));
            line1.setQty(new BigDecimal("1"));
            line1.setDatePromised(today);
            line1.setPrice(new BigDecimal("2"));
            line1.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receiptLine1 = new MInOutLine(receipt1);
            receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
            receiptLine1.setQty(new BigDecimal("1"));
            receiptLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)line1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)1, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)new BigDecimal("2.00").setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            product.set_TrxName(this.getTrxName());
            MCost cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)cost, (String)"No MCost record found");
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List list = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("2.00"), 2, true), new FactAcct(nivReceiptAccount, new BigDecimal("2.00"), 2, false));
            this.assertFactAcctEntries(list, expected);
            MInvoice invoice = new MInvoice(receipt1, receipt1.getMovementDate());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setM_InOutLine_ID(receiptLine1.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(BigDecimal.ONE);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = productCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)invoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            list = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, new BigDecimal("2.00"), 2, true), new FactAcct(liabilityAccount, new BigDecimal("2.00"), 2, false));
            this.assertFactAcctEntries(list, expected);
            MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            invoice.setC_DocTypeTarget_ID("API");
            invoice.setBPartner(bp);
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setLine(10);
            invoiceLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            invoiceLine.setQty(BigDecimal.ONE);
            invoiceLine.setPrice(new BigDecimal("0.30"));
            invoiceLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            invoiceLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(invoiceLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receiptLine1.get_ID());
            landedCost.setLandedCostDistribution("Q");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            if (!invoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)invoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)invoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            list = query.list();
            expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("0.30"), 2, true), new FactAcct(apAccount, new BigDecimal("0.30"), 2, false));
            this.assertFactAcctEntries(list, expected);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)new BigDecimal("2.30"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"RC");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)invoice.getDocStatus());
            MInvoice reversal = new MInvoice(Env.getCtx(), invoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)invoice.getReversal_ID(), (int)reversal.get_ID(), (String)"Failed to load reversal invoice");
            if (!reversal.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)reversal.getAD_Client_ID(), (int)318, (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
                reversal.load(this.getTrxName(), new String[0]);
            }
            query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            list = query.list();
            expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("0.30"), 2, false), new FactAcct(apAccount, new BigDecimal("0.30"), 2, true));
            this.assertFactAcctEntries(list, expected);
            cost = product.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)new BigDecimal("2.00"), (Object)cost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
        }
        finally {
            this.rollback();
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testUnplannedLandedCostWtihMultipleMRAndShipment() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct p1 = null;
        MProduct p2 = null;
        try {
            List cds;
            p1 = new MProduct(Env.getCtx(), 0, null);
            p1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p1.setName("testUnplannedLandedCostWtihMultipleMRAndShipment1");
            p1.setProductType("I");
            p1.setIsStocked(true);
            p1.setIsSold(true);
            p1.setIsPurchased(true);
            p1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p1.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal p1price = new BigDecimal("36.00");
            pp.setPriceStd(p1price);
            pp.setPriceList(p1price);
            pp.saveEx();
            p2 = new MProduct(Env.getCtx(), 0, null);
            p2.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p2.setName("testUnplannedLandedCostWtihMultipleMRAndShipment2");
            p2.setProductType("I");
            p2.setIsStocked(true);
            p2.setIsSold(true);
            p2.setIsPurchased(true);
            p2.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p2.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p2.saveEx();
            pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p2.get_ID());
            BigDecimal p2price = new BigDecimal("50.00");
            pp.setPriceStd(p2price);
            pp.setPriceList(p2price);
            pp.saveEx();
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            purchaseOrder.setDateOrdered(today);
            purchaseOrder.setDatePromised(today);
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("100");
            poLine1.setQty(orderQty);
            poLine1.setDatePromised(today);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            MOrderLine poLine2 = new MOrderLine(purchaseOrder);
            poLine2.setLine(10);
            poLine2.setProduct(new MProduct(Env.getCtx(), p2.get_ID(), this.getTrxName()));
            poLine2.setQty(orderQty);
            poLine2.setDatePromised(today);
            poLine2.setPrice(p2price);
            poLine2.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receipt1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1Qty = new BigDecimal("10");
            receipt1Line1.setOrderLine(poLine1, 0, mr1Qty);
            receipt1Line1.setQty(mr1Qty);
            receipt1Line1.saveEx();
            MInOutLine receipt1Line2 = new MInOutLine(receipt1);
            receipt1Line2.setOrderLine(poLine2, 0, mr1Qty);
            receipt1Line2.setQty(mr1Qty);
            receipt1Line2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price, (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertTrue((cds.size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line2");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p2price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p2.set_TrxName(this.getTrxName());
            MCost p2mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p2mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p2price, (Object)p2mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p2ProductCost = new ProductCost(Env.getCtx(), p2.get_ID(), 0, this.getTrxName());
            assetAccount = p2ProductCost.getAccount(3, as);
            expected = Arrays.asList(new FactAcct(assetAccount, p2price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p2price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInOut receipt2 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt2.setDocStatus("DR");
            receipt2.setDocAction("CO");
            receipt2.saveEx();
            MInOutLine receipt2Line1 = new MInOutLine(receipt2);
            BigDecimal mr2Qty = new BigDecimal("90");
            receipt2Line1.setOrderLine(poLine1, 0, mr2Qty);
            receipt2Line1.setQty(mr2Qty);
            receipt2Line1.saveEx();
            MInOutLine receipt2Line2 = new MInOutLine(receipt2);
            receipt2Line2.setOrderLine(poLine2, 0, mr2Qty);
            receipt2Line2.setQty(mr2Qty);
            receipt2Line2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt2, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt2.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt2.getDocStatus());
            if (!receipt2.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt2.getAD_Client_ID(), (int)receipt2.get_Table_ID(), (int)receipt2.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            MInvoiceLine piLine2 = new MInvoiceLine(purchaseInvoice);
            piLine2.setOrderLine(poLine2);
            piLine2.setLine(10);
            piLine2.setProduct(p2);
            piLine2.setQty(poLine2.getQtyOrdered());
            piLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty), 2, true), new FactAcct(inventoryClearingAccount, p2price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty).add(p2price.multiply(orderQty)), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MBPartner customer = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
            MOrder salesOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            salesOrder.setC_DocTypeTarget_ID("SO");
            salesOrder.setBPartner(customer);
            salesOrder.setDeliveryRule("O");
            salesOrder.setDocStatus("DR");
            salesOrder.setDocAction("CO");
            salesOrder.setDatePromised(today);
            salesOrder.saveEx();
            MOrderLine soLine1 = new MOrderLine(salesOrder);
            soLine1.setLine(10);
            soLine1.setProduct(p1);
            BigDecimal p1ShipQty = new BigDecimal("76");
            soLine1.setQty(p1ShipQty);
            soLine1.setDatePromised(today);
            soLine1.setPrice(new BigDecimal("50"));
            soLine1.saveEx();
            MOrderLine soLine2 = new MOrderLine(salesOrder);
            soLine2.setLine(20);
            soLine2.setProduct(p2);
            BigDecimal p2ShipQty = new BigDecimal("82");
            soLine2.setQty(p2ShipQty);
            soLine2.setDatePromised(today);
            soLine2.setPrice(new BigDecimal("70"));
            soLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)salesOrder, (String)"CO");
            salesOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)salesOrder.getDocStatus());
            MInOut shipment = new MInOut(salesOrder, DictionaryIDs.C_DocType.MM_SHIPMENT.id, salesOrder.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine1 = new MInOutLine(shipment);
            shipmentLine1.setOrderLine(soLine1, 0, soLine1.getQtyOrdered());
            shipmentLine1.setQty(soLine1.getQtyOrdered());
            shipmentLine1.saveEx();
            MInOutLine shipmentLine2 = new MInOutLine(shipment);
            shipmentLine2.setOrderLine(soLine2, 0, soLine2.getQtyOrdered());
            shipmentLine2.setQty(soLine2.getQtyOrdered());
            shipmentLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("1000.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line2.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt2.get_ID());
            landedCost.setM_InOutLine_ID(receipt2Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt2.get_ID());
            landedCost.setM_InOutLine_ID(receipt2Line2.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal totalBase = purchaseInvoice.getGrandTotal();
            BigDecimal p1a1 = p1price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p1a2 = p1price.multiply(mr2Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p2a1 = p2price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p2a2 = p2price.multiply(mr2Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)4, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == 90) {
                    Assertions.assertEquals((Object)p1a2.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p2.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p2a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p2.get_ID() && allocation.getQty().intValue() == 90) {
                    Assertions.assertEquals((Object)p2a2.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            BigDecimal p1QtyOnHand = orderQty.subtract(p1ShipQty);
            BigDecimal p2QtyOnHand = orderQty.subtract(p2ShipQty);
            BigDecimal p1a1Qty = mr1Qty;
            BigDecimal p1a2Qty = p1QtyOnHand.subtract(p1a1Qty);
            BigDecimal p2a1Qty = mr1Qty;
            BigDecimal p2a2Qty = p2QtyOnHand.subtract(p2a1Qty);
            MAccount varianceAccount = p1ProductCost.getAccount(23, as);
            BigDecimal p1a2Asset = p1a2.divide(mr2Qty, RoundingMode.HALF_UP).multiply(p1a2Qty);
            BigDecimal p2a2Asset = p2a2.divide(mr2Qty, RoundingMode.HALF_UP).multiply(p2a2Qty);
            expected = Arrays.asList(new FactAcct(assetAccount, p1a1, 2, true), new FactAcct(assetAccount, p2a1, 2, true), new FactAcct(assetAccount, p1a2Asset, 2, true), new FactAcct(varianceAccount, p1a2.subtract(p1a2Asset), 0, true), new FactAcct(assetAccount, p2a2Asset, 2, true), new FactAcct(varianceAccount, p2a2.subtract(p2a2Asset), 0, true), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p1price.add(p1a1.divide(p1QtyOnHand, 2, RoundingMode.HALF_UP)).add(p1a2Asset.divide(p1QtyOnHand, 2, RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            p1mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p2price.add(p2a1.divide(p2QtyOnHand, 2, RoundingMode.HALF_UP)).add(p2a2Asset.divide(p2QtyOnHand, 2, RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
        }
        finally {
            this.rollback();
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
            if (p2 != null) {
                p2.set_TrxName(null);
                p2.deleteEx(true);
            }
        }
    }

    @Test
    public void testUnplannedLandedCostReversal() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct p1 = null;
        MProduct p2 = null;
        try {
            List cds;
            p1 = new MProduct(Env.getCtx(), 0, null);
            p1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p1.setName("testUnplannedLandedCostReversal1");
            p1.setProductType("I");
            p1.setIsStocked(true);
            p1.setIsSold(true);
            p1.setIsPurchased(true);
            p1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p1.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal p1price = new BigDecimal("30.00");
            pp.setPriceStd(p1price);
            pp.setPriceList(p1price);
            pp.saveEx();
            p2 = new MProduct(Env.getCtx(), 0, null);
            p2.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p2.setName("testUnplannedLandedCostReversal2");
            p2.setProductType("I");
            p2.setIsStocked(true);
            p2.setIsSold(true);
            p2.setIsPurchased(true);
            p2.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p2.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p2.saveEx();
            pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p2.get_ID());
            BigDecimal p2price = new BigDecimal("50.00");
            pp.setPriceStd(p2price);
            pp.setPriceList(p2price);
            pp.saveEx();
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            purchaseOrder.setDateOrdered(today);
            purchaseOrder.setDatePromised(today);
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("10");
            poLine1.setQty(orderQty);
            poLine1.setDatePromised(today);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            MOrderLine poLine2 = new MOrderLine(purchaseOrder);
            poLine2.setLine(10);
            poLine2.setProduct(new MProduct(Env.getCtx(), p2.get_ID(), this.getTrxName()));
            poLine2.setQty(orderQty);
            poLine2.setDatePromised(today);
            poLine2.setPrice(p2price);
            poLine2.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receipt1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1Qty = new BigDecimal("10");
            receipt1Line1.setOrderLine(poLine1, 0, mr1Qty);
            receipt1Line1.setQty(mr1Qty);
            receipt1Line1.saveEx();
            MInOutLine receipt1Line2 = new MInOutLine(receipt1);
            receipt1Line2.setOrderLine(poLine2, 0, mr1Qty);
            receipt1Line2.setQty(mr1Qty);
            receipt1Line2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price, (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertTrue((cds.size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line2");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p2price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p2.set_TrxName(this.getTrxName());
            MCost p2mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p2mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p2price, (Object)p2mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p2ProductCost = new ProductCost(Env.getCtx(), p2.get_ID(), 0, this.getTrxName());
            assetAccount = p2ProductCost.getAccount(3, as);
            expected = Arrays.asList(new FactAcct(assetAccount, p2price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p2price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            MInvoiceLine piLine2 = new MInvoiceLine(purchaseInvoice);
            piLine2.setOrderLine(poLine2);
            piLine2.setLine(10);
            piLine2.setProduct(p2);
            piLine2.setQty(poLine2.getQtyOrdered());
            piLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty), 2, true), new FactAcct(inventoryClearingAccount, p2price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty).add(p2price.multiply(orderQty)), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("200.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line2.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal totalBase = purchaseInvoice.getGrandTotal();
            BigDecimal p1a1 = p1price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p2a1 = p2price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p2.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p2a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            BigDecimal p1QtyOnHand = mr1Qty;
            BigDecimal p2QtyOnHand = mr1Qty;
            expected = Arrays.asList(new FactAcct(assetAccount, p1a1, 2, true), new FactAcct(assetAccount, p2a1, 2, true), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p1price.add(p1a1.divide(p1QtyOnHand, 2, RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            p1mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p2price.add(p2a1.divide(p2QtyOnHand, 2, RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"RC");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)freightInvoice.getDocStatus());
            Assertions.assertTrue((freightInvoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"Unexpected reversal id");
            MInvoice reversal = new MInvoice(Env.getCtx(), freightInvoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)freightInvoice.getReversal_ID(), (int)reversal.get_ID());
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            expected = new ArrayList<FactAcct>();
            for (MFactAcct factAcct : factAccts) {
                MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                if (factAcct.getAmtAcctDr().signum() != 0) {
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 2, false));
                    continue;
                }
                if (factAcct.getAmtAcctCr().signum() == 0) continue;
                expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 2, true));
            }
            this.assertFactAcctEntries(rFactAccts, expected);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            Optional<MAcctSchema> optional = Arrays.stream(ass).filter(e -> e.getC_AcctSchema_ID() != as.get_ID()).findFirst();
            if (optional.isPresent()) {
                MAcctSchema as2 = optional.get();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                rFactAccts = query.list();
                expected = new ArrayList<FactAcct>();
                for (MFactAcct factAcct : factAccts) {
                    MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                    if (factAcct.getAmtAcctDr().signum() != 0) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 2, false));
                        continue;
                    }
                    if (factAcct.getAmtAcctCr().signum() == 0) continue;
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 2, true));
                }
                this.assertFactAcctEntries(rFactAccts, expected);
            }
        }
        finally {
            this.rollback();
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
            if (p2 != null) {
                p2.set_TrxName(null);
                p2.deleteEx(true);
            }
        }
    }

    @Test
    public void testUnplannedLandedCostReversalAfterShipment1() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct p1 = null;
        MProduct p2 = null;
        try {
            List cds;
            p1 = new MProduct(Env.getCtx(), 0, null);
            p1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p1.setName("testUnplannedLandedCostReversalAfterShipment1.1");
            p1.setProductType("I");
            p1.setIsStocked(true);
            p1.setIsSold(true);
            p1.setIsPurchased(true);
            p1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p1.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal p1price = new BigDecimal("30.00");
            pp.setPriceStd(p1price);
            pp.setPriceList(p1price);
            pp.saveEx();
            p2 = new MProduct(Env.getCtx(), 0, null);
            p2.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p2.setName("testUnplannedLandedCostReversalAfterShipment1.2");
            p2.setProductType("I");
            p2.setIsStocked(true);
            p2.setIsSold(true);
            p2.setIsPurchased(true);
            p2.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p2.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p2.saveEx();
            pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p2.get_ID());
            BigDecimal p2price = new BigDecimal("50.00");
            pp.setPriceStd(p2price);
            pp.setPriceList(p2price);
            pp.saveEx();
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            purchaseOrder.setDateOrdered(today);
            purchaseOrder.setDatePromised(today);
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("10");
            poLine1.setQty(orderQty);
            poLine1.setDatePromised(today);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            MOrderLine poLine2 = new MOrderLine(purchaseOrder);
            poLine2.setLine(10);
            poLine2.setProduct(new MProduct(Env.getCtx(), p2.get_ID(), this.getTrxName()));
            poLine2.setQty(orderQty);
            poLine2.setDatePromised(today);
            poLine2.setPrice(p2price);
            poLine2.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receipt1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1Qty = new BigDecimal("10");
            receipt1Line1.setOrderLine(poLine1, 0, mr1Qty);
            receipt1Line1.setQty(mr1Qty);
            receipt1Line1.saveEx();
            MInOutLine receipt1Line2 = new MInOutLine(receipt1);
            receipt1Line2.setOrderLine(poLine2, 0, mr1Qty);
            receipt1Line2.setQty(mr1Qty);
            receipt1Line2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price, (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertTrue((cds.size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line2");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p2price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p2.set_TrxName(this.getTrxName());
            MCost p2mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p2mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p2price, (Object)p2mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p2ProductCost = new ProductCost(Env.getCtx(), p2.get_ID(), 0, this.getTrxName());
            assetAccount = p2ProductCost.getAccount(3, as);
            expected = Arrays.asList(new FactAcct(assetAccount, p2price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p2price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            MInvoiceLine piLine2 = new MInvoiceLine(purchaseInvoice);
            piLine2.setOrderLine(poLine2);
            piLine2.setLine(10);
            piLine2.setProduct(p2);
            piLine2.setQty(poLine2.getQtyOrdered());
            piLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty), 2, true), new FactAcct(inventoryClearingAccount, p2price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty).add(p2price.multiply(orderQty)), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("200.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line2.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal totalBase = purchaseInvoice.getGrandTotal();
            BigDecimal p1a1 = p1price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p2a1 = p2price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p2.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p2a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            BigDecimal p1QtyOnHand = mr1Qty;
            BigDecimal p2QtyOnHand = mr1Qty;
            expected = Arrays.asList(new FactAcct(assetAccount, p1a1, 2, true), new FactAcct(assetAccount, p2a1, 2, true), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p1price.add(p1a1.divide(p1QtyOnHand, 2, RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            p2mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p2price.add(p2a1.divide(p2QtyOnHand, 2, RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p2mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            MBPartner customer = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
            MOrder salesOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            salesOrder.setC_DocTypeTarget_ID("SO");
            salesOrder.setBPartner(customer);
            salesOrder.setDeliveryRule("O");
            salesOrder.setDocStatus("DR");
            salesOrder.setDocAction("CO");
            salesOrder.setDatePromised(today);
            salesOrder.saveEx();
            MOrderLine soLine1 = new MOrderLine(salesOrder);
            soLine1.setLine(10);
            soLine1.setProduct(p1);
            BigDecimal p1ShipQty = new BigDecimal("10");
            soLine1.setQty(p1ShipQty);
            soLine1.setDatePromised(today);
            soLine1.setPrice(new BigDecimal("50"));
            soLine1.saveEx();
            MOrderLine soLine2 = new MOrderLine(salesOrder);
            soLine2.setLine(20);
            soLine2.setProduct(p2);
            BigDecimal p2ShipQty = new BigDecimal("5");
            soLine2.setQty(p2ShipQty);
            soLine2.setDatePromised(today);
            soLine2.setPrice(new BigDecimal("70"));
            soLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)salesOrder, (String)"CO");
            salesOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)salesOrder.getDocStatus());
            MInOut shipment = new MInOut(salesOrder, DictionaryIDs.C_DocType.MM_SHIPMENT.id, salesOrder.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine1 = new MInOutLine(shipment);
            shipmentLine1.setOrderLine(soLine1, 0, soLine1.getQtyOrdered());
            shipmentLine1.setQty(soLine1.getQtyOrdered());
            shipmentLine1.saveEx();
            MInOutLine shipmentLine2 = new MInOutLine(shipment);
            shipmentLine2.setOrderLine(soLine2, 0, soLine2.getQtyOrdered());
            shipmentLine2.setQty(soLine2.getQtyOrdered());
            shipmentLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"RC");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)freightInvoice.getDocStatus());
            Assertions.assertTrue((freightInvoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"Unexpected reversal id");
            MInvoice reversal = new MInvoice(Env.getCtx(), freightInvoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)freightInvoice.getReversal_ID(), (int)reversal.get_ID());
            if (!reversal.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)318, (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            expected = Arrays.asList(new FactAcct(assetAccount, p1a1, 2, false), new FactAcct(assetAccount, p2a1, 2, false), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, true));
            this.assertFactAcctEntries(rFactAccts, expected);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            p2mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            BigDecimal p1cogs = p1mcost.getCurrentCostPrice().multiply(p1ShipQty);
            BigDecimal p2cogs = p2mcost.getCurrentCostPrice().multiply(p2ShipQty);
            ProductCost pc1 = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount cogsAccount1 = pc1.getAccount(4, as);
            ProductCost pc2 = new ProductCost(Env.getCtx(), p2.get_ID(), 0, this.getTrxName());
            MAccount cogsAccount2 = pc2.getAccount(4, as);
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount1, p1cogs, 2, true), new FactAcct(cogsAccount2, p2cogs, 2, true), new FactAcct(assetAccount, p1cogs, 2, false), new FactAcct(assetAccount, p2cogs, 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
            if (p2 != null) {
                p2.set_TrxName(null);
                p2.deleteEx(true);
            }
        }
    }

    @Test
    public void testUnplannedLandedCostReversalAfterShipment3() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct p1 = null;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.SPOT.id;
        Timestamp today = TimeUtil.getDay(null);
        Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
        BigDecimal crate1 = new BigDecimal("1.05");
        BigDecimal crate2 = new BigDecimal("1.12");
        MConversionRate cr1 = ConversionRateHelper.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, today, crate1, true);
        MConversionRate cr2 = ConversionRateHelper.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, tomorrow, crate2, true);
        try {
            List cds;
            p1 = new MProduct(Env.getCtx(), 0, null);
            p1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p1.setName("testUnplannedLandedCostReversalAfterShipment3");
            p1.setProductType("I");
            p1.setIsStocked(true);
            p1.setIsSold(true);
            p1.setIsPurchased(true);
            p1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p1.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.IMPORT.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal p1price = new BigDecimal("30.00");
            pp.setPriceStd(p1price);
            pp.setPriceList(p1price);
            pp.saveEx();
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            purchaseOrder.setDateOrdered(today);
            purchaseOrder.setDatePromised(today);
            purchaseOrder.setM_PriceList_ID(plv.getM_PriceList_ID());
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("100");
            poLine1.setQty(orderQty);
            poLine1.setDatePromised(today);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receipt1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1Qty = new BigDecimal("100");
            receipt1Line1.setOrderLine(poLine1, 0, mr1Qty);
            receipt1Line1.setQty(mr1Qty);
            receipt1Line1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)mr1Qty.intValue(), (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(mr1Qty).multiply(crate1).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price.multiply(crate1).setScale(2, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            MAccount varianceAccount = p1ProductCost.getAccount(23, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1Qty).multiply(crate1).setScale(2, RoundingMode.HALF_UP), p1price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1Qty).multiply(crate1).setScale(2, RoundingMode.HALF_UP), p1price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty).multiply(crate1), p1price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty).multiply(crate1), p1price.multiply(orderQty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            plv = MPriceList.get((int)DictionaryIDs.M_PriceList.EXPORT.id).getPriceListVersion(null);
            pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal orderPrice = new BigDecimal("100.00");
            pp.setPriceStd(orderPrice);
            pp.setPriceList(orderPrice);
            pp.saveEx();
            MBPartner customer = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
            MOrder salesOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            salesOrder.setC_DocTypeTarget_ID("SO");
            salesOrder.setBPartner(customer);
            salesOrder.setDeliveryRule("O");
            salesOrder.setDocStatus("DR");
            salesOrder.setDocAction("CO");
            salesOrder.setDatePromised(today);
            salesOrder.setM_PriceList_ID(DictionaryIDs.M_PriceList.EXPORT.id);
            salesOrder.saveEx();
            MOrderLine soLine1 = new MOrderLine(salesOrder);
            soLine1.setLine(10);
            soLine1.setProduct(p1);
            BigDecimal p1ShipQty = new BigDecimal("80");
            soLine1.setQty(p1ShipQty);
            soLine1.setDatePromised(today);
            soLine1.setPrice(orderPrice);
            soLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)salesOrder, (String)"CO");
            salesOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)salesOrder.getDocStatus());
            MInOut shipment = new MInOut(salesOrder, DictionaryIDs.C_DocType.MM_SHIPMENT.id, salesOrder.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine1 = new MInOutLine(shipment);
            shipmentLine1.setOrderLine(soLine1, 0, soLine1.getQtyOrdered());
            shipmentLine1.setQty(soLine1.getQtyOrdered());
            shipmentLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.setM_PriceList_ID(DictionaryIDs.M_PriceList.EXPORT.id);
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("200.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal p1a1 = fiLine.getLineTotalAmt();
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == orderQty.intValue()) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            BigDecimal assetAmt = p1a1.divide(orderQty, RoundingMode.HALF_UP).multiply(orderQty.subtract(p1ShipQty));
            BigDecimal varianceAmt = p1a1.subtract(assetAmt);
            expected = Arrays.asList(new FactAcct(varianceAccount, varianceAmt.multiply(crate1), varianceAmt, 2, true), new FactAcct(assetAccount, assetAmt.multiply(crate1), assetAmt, 2, true), new FactAcct(apAccount, freightInvoice.getGrandTotal().multiply(crate1), freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p1price.multiply(crate1).add(assetAmt.multiply(crate1).divide(orderQty.subtract(p1ShipQty), RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)tomorrow);
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"RC");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)freightInvoice.getDocStatus());
            Assertions.assertTrue((freightInvoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"Unexpected reversal id");
            MInvoice reversal = new MInvoice(Env.getCtx(), freightInvoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)freightInvoice.getReversal_ID(), (int)reversal.get_ID());
            if (!reversal.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)318, (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            expected = new ArrayList<FactAcct>();
            for (MFactAcct factAcct : factAccts) {
                MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                if (factAcct.getAmtAcctDr().signum() != 0) {
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 1, false));
                    continue;
                }
                if (factAcct.getAmtAcctCr().signum() == 0) continue;
                expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 1, true));
            }
            this.assertFactAcctEntries(rFactAccts, expected);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            Optional<MAcctSchema> optional = Arrays.stream(ass).filter(e -> e.getC_AcctSchema_ID() != as.get_ID()).findFirst();
            if (optional.isPresent()) {
                MAcctSchema as2 = optional.get();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.getReversal_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                rFactAccts = query.list();
                expected = new ArrayList<FactAcct>();
                for (MFactAcct factAcct : factAccts) {
                    MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                    if (factAcct.getAmtAcctDr().signum() != 0) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 1, false));
                        continue;
                    }
                    if (factAcct.getAmtAcctCr().signum() == 0) continue;
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 1, true));
                }
                this.assertFactAcctEntries(rFactAccts, expected);
            }
        }
        finally {
            this.rollback();
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
            ConversionRateHelper.deleteConversionRate(cr1);
            ConversionRateHelper.deleteConversionRate(cr2);
        }
    }

    @Test
    public void testUnplannedLandedCostReversalAfterShipment2() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct p1 = null;
        MProduct p2 = null;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.SPOT.id;
        Timestamp today = TimeUtil.getDay(null);
        Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
        MConversionRate cr1 = ConversionRateHelper.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, today, new BigDecimal("0.91"), true);
        MConversionRate cr2 = ConversionRateHelper.createConversionRate(usd.getC_Currency_ID(), euro.getC_Currency_ID(), C_ConversionType_ID, tomorrow, new BigDecimal("0.85"), true);
        try {
            List cds;
            p1 = new MProduct(Env.getCtx(), 0, null);
            p1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p1.setName("testUnplannedLandedCostReversalAfterShipment2.1");
            p1.setProductType("I");
            p1.setIsStocked(true);
            p1.setIsSold(true);
            p1.setIsPurchased(true);
            p1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p1.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal p1price = new BigDecimal("30.00");
            pp.setPriceStd(p1price);
            pp.setPriceList(p1price);
            pp.saveEx();
            p2 = new MProduct(Env.getCtx(), 0, null);
            p2.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p2.setName("testUnplannedLandedCostReversalAfterShipment2.2");
            p2.setProductType("I");
            p2.setIsStocked(true);
            p2.setIsSold(true);
            p2.setIsPurchased(true);
            p2.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p2.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p2.saveEx();
            pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p2.get_ID());
            BigDecimal p2price = new BigDecimal("50.00");
            pp.setPriceStd(p2price);
            pp.setPriceList(p2price);
            pp.saveEx();
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            purchaseOrder.setDateOrdered(today);
            purchaseOrder.setDatePromised(today);
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("10");
            poLine1.setQty(orderQty);
            poLine1.setDatePromised(today);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            MOrderLine poLine2 = new MOrderLine(purchaseOrder);
            poLine2.setLine(10);
            poLine2.setProduct(new MProduct(Env.getCtx(), p2.get_ID(), this.getTrxName()));
            poLine2.setQty(orderQty);
            poLine2.setDatePromised(today);
            poLine2.setPrice(p2price);
            poLine2.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receipt1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1Qty = new BigDecimal("10");
            receipt1Line1.setOrderLine(poLine1, 0, mr1Qty);
            receipt1Line1.setQty(mr1Qty);
            receipt1Line1.saveEx();
            MInOutLine receipt1Line2 = new MInOutLine(receipt1);
            receipt1Line2.setOrderLine(poLine2, 0, mr1Qty);
            receipt1Line2.setQty(mr1Qty);
            receipt1Line2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price, (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            MAccount varianceAccount = p1ProductCost.getAccount(23, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertTrue((cds.size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line2");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p2price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p2.set_TrxName(this.getTrxName());
            MCost p2mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p2mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p2price, (Object)p2mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p2ProductCost = new ProductCost(Env.getCtx(), p2.get_ID(), 0, this.getTrxName());
            assetAccount = p2ProductCost.getAccount(3, as);
            expected = Arrays.asList(new FactAcct(assetAccount, p2price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p2price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            MInvoiceLine piLine2 = new MInvoiceLine(purchaseInvoice);
            piLine2.setOrderLine(poLine2);
            piLine2.setLine(10);
            piLine2.setProduct(p2);
            piLine2.setQty(poLine2.getQtyOrdered());
            piLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty), 2, true), new FactAcct(inventoryClearingAccount, p2price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty).add(p2price.multiply(orderQty)), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MBPartner customer = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
            MOrder salesOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            salesOrder.setC_DocTypeTarget_ID("SO");
            salesOrder.setBPartner(customer);
            salesOrder.setDeliveryRule("O");
            salesOrder.setDocStatus("DR");
            salesOrder.setDocAction("CO");
            salesOrder.setDatePromised(today);
            salesOrder.saveEx();
            MOrderLine soLine1 = new MOrderLine(salesOrder);
            soLine1.setLine(10);
            soLine1.setProduct(p1);
            BigDecimal p1ShipQty = new BigDecimal("10");
            soLine1.setQty(p1ShipQty);
            soLine1.setDatePromised(today);
            soLine1.setPrice(new BigDecimal("50"));
            soLine1.saveEx();
            MOrderLine soLine2 = new MOrderLine(salesOrder);
            soLine2.setLine(20);
            soLine2.setProduct(p2);
            BigDecimal p2ShipQty = new BigDecimal("5");
            soLine2.setQty(p2ShipQty);
            soLine2.setDatePromised(today);
            soLine2.setPrice(new BigDecimal("70"));
            soLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)salesOrder, (String)"CO");
            salesOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)salesOrder.getDocStatus());
            MInOut shipment = new MInOut(salesOrder, DictionaryIDs.C_DocType.MM_SHIPMENT.id, salesOrder.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine1 = new MInOutLine(shipment);
            shipmentLine1.setOrderLine(soLine1, 0, soLine1.getQtyOrdered());
            shipmentLine1.setQty(soLine1.getQtyOrdered());
            shipmentLine1.saveEx();
            MInOutLine shipmentLine2 = new MInOutLine(shipment);
            shipmentLine2.setOrderLine(soLine2, 0, soLine2.getQtyOrdered());
            shipmentLine2.setQty(soLine2.getQtyOrdered());
            shipmentLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("200.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line2.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal totalBase = purchaseInvoice.getGrandTotal();
            BigDecimal p1a1 = p1price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p2a1 = p2price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p2.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p2a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, p1a1, 2, true), new FactAcct(assetAccount, p2a1.divide(new BigDecimal("2"), RoundingMode.HALF_UP), 2, true), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p1price.setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            p1mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p2price.add(p2a1.divide(new BigDecimal("2"), 2, RoundingMode.HALF_UP).divide(new BigDecimal("5"), RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)tomorrow);
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"RC");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)freightInvoice.getDocStatus());
            Assertions.assertTrue((freightInvoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"Unexpected reversal id");
            MInvoice reversal = new MInvoice(Env.getCtx(), freightInvoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)freightInvoice.getReversal_ID(), (int)reversal.get_ID());
            if (!reversal.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)318, (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, p1a1, 2, false), new FactAcct(assetAccount, p2a1.divide(new BigDecimal(2), RoundingMode.HALF_UP), 2, false), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, true));
            this.assertFactAcctEntries(rFactAccts, expected);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            Optional<MAcctSchema> optional = Arrays.stream(ass).filter(e -> e.getC_AcctSchema_ID() != as.get_ID()).findFirst();
            if (optional.isPresent()) {
                MAcctSchema as2 = optional.get();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.getReversal_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                rFactAccts = query.list();
                expected = new ArrayList<FactAcct>();
                for (MFactAcct factAcct : factAccts) {
                    MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                    if (factAcct.getAmtAcctDr().signum() != 0) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 1, false));
                        continue;
                    }
                    if (factAcct.getAmtAcctCr().signum() == 0) continue;
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 1, true));
                }
                this.assertFactAcctEntries(rFactAccts, expected);
            }
        }
        finally {
            this.rollback();
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
            if (p2 != null) {
                p2.set_TrxName(null);
                p2.deleteEx(true);
            }
            ConversionRateHelper.deleteConversionRate(cr1);
            ConversionRateHelper.deleteConversionRate(cr2);
        }
    }

    @Test
    public void testUnplannedLandedCostReversalAfterInventoryUseASI() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct p1 = null;
        MProduct p2 = null;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.SPOT.id;
        Timestamp today = TimeUtil.getDay(null);
        Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
        BigDecimal crate1 = new BigDecimal("1.05");
        BigDecimal crate2 = new BigDecimal("1.12");
        MConversionRate cr1 = ConversionRateHelper.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, today, crate1, true);
        MConversionRate cr2 = ConversionRateHelper.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, tomorrow, crate2, true);
        try {
            p1 = new MProduct(Env.getCtx(), 0, null);
            p1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p1.setName("testUnplannedLandedCostReversalAfterInventoryUseASI.1");
            p1.setProductType("I");
            p1.setIsStocked(true);
            p1.setIsSold(true);
            p1.setIsPurchased(true);
            p1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            p1.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.IMPORT.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal p1price = new BigDecimal("30.00");
            pp.setPriceStd(p1price);
            pp.setPriceList(p1price);
            pp.saveEx();
            p2 = new MProduct(Env.getCtx(), 0, null);
            p2.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p2.setName("testUnplannedLandedCostReversalAfterInventoryUseASI.2");
            p2.setProductType("I");
            p2.setIsStocked(true);
            p2.setIsSold(true);
            p2.setIsPurchased(true);
            p2.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p2.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p2.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            p2.saveEx();
            pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p2.get_ID());
            BigDecimal p2price = new BigDecimal("50.00");
            pp.setPriceStd(p2price);
            pp.setPriceList(p2price);
            pp.saveEx();
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            purchaseOrder.setDateOrdered(today);
            purchaseOrder.setDatePromised(today);
            purchaseOrder.setM_PriceList_ID(plv.getM_PriceList_ID());
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("100");
            poLine1.setQty(orderQty);
            poLine1.setDatePromised(today);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            MOrderLine poLine2 = new MOrderLine(purchaseOrder);
            poLine2.setLine(10);
            poLine2.setProduct(new MProduct(Env.getCtx(), p2.get_ID(), this.getTrxName()));
            poLine2.setQty(orderQty);
            poLine2.setDatePromised(today);
            poLine2.setPrice(p2price);
            poLine2.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine mr1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1l1Qty = new BigDecimal("25");
            mr1Line1.setOrderLine(poLine1, 0, mr1l1Qty);
            mr1Line1.setQty(mr1l1Qty);
            MAttributeSetInstance mr1l1asi = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            mr1l1asi.setM_AttributeSet_ID(p1.getM_AttributeSet_ID());
            mr1l1asi.setLot("mr1l1asi");
            mr1l1asi.setDescription();
            mr1l1asi.saveEx();
            mr1Line1.setM_AttributeSetInstance_ID(mr1l1asi.get_ID());
            mr1Line1.saveEx();
            MInOutLine mr1Line2 = new MInOutLine(receipt1);
            BigDecimal mr1l2Qty = new BigDecimal("100");
            mr1Line2.setOrderLine(poLine2, 0, mr1l2Qty);
            mr1Line2.setQty(mr1l2Qty);
            MAttributeSetInstance mr1l2asi = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            mr1l2asi.setM_AttributeSet_ID(p2.getM_AttributeSet_ID());
            mr1l2asi.setLot("mr1l2asi");
            mr1l2asi.setDescription();
            mr1l2asi.saveEx();
            mr1Line2.setM_AttributeSetInstance_ID(mr1l2asi.get_ID());
            mr1Line2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            MInOut receipt2 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt2.setDocStatus("DR");
            receipt2.setDocAction("CO");
            receipt2.saveEx();
            MInOutLine mr2Line1 = new MInOutLine(receipt2);
            BigDecimal mr2l1Qty = new BigDecimal("75");
            mr2Line1.setOrderLine(poLine1, 0, mr2l1Qty);
            mr2Line1.setQty(mr2l1Qty);
            MAttributeSetInstance mr2l1asi = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            mr2l1asi.setM_AttributeSet_ID(p1.getM_AttributeSet_ID());
            mr2l1asi.setLot("mr2l1asi");
            mr2l1asi.setDescription();
            mr2l1asi.saveEx();
            mr2Line1.setM_AttributeSetInstance_ID(mr2l1asi.get_ID());
            mr2Line1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt2, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt2.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt2.getDocStatus());
            if (!receipt2.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt2.getAD_Client_ID(), (int)receipt2.get_Table_ID(), (int)receipt2.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            List cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)mr1l1asi.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)cds.size(), (String)"Unexpected number of MCostDetail records for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)mr1Line1.getMovementQty().intValue(), (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(mr1Line1.getMovementQty()).multiply(crate1).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price.multiply(crate1).setScale(2, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            MAccount varianceAccount = p1ProductCost.getAccount(23, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1l1Qty).multiply(crate1).setScale(2, RoundingMode.HALF_UP), p1price.multiply(mr1l1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1l1Qty).multiply(crate1).setScale(2, RoundingMode.HALF_UP), p1price.multiply(mr1l1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            MInvoiceLine piLine2 = new MInvoiceLine(purchaseInvoice);
            piLine2.setOrderLine(poLine2);
            piLine2.setLine(20);
            piLine2.setProduct(p2);
            piLine2.setQty(poLine2.getQtyOrdered());
            piLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty).multiply(crate1), p1price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty).multiply(crate1).add(p2price.multiply(orderQty).multiply(crate1)), p1price.multiply(orderQty).add(p2price.multiply(orderQty)), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
            inventory.setC_DocType_ID(DictionaryIDs.C_DocType.INTERNAL_USE_INVENTORY.id);
            inventory.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
            inventory.setMovementDate(today);
            inventory.saveEx();
            MInventoryLine inventoryLine1 = new MInventoryLine(inventory, DictionaryIDs.M_Locator.HQ.id, p1.get_ID(), 0, null, null, new BigDecimal("25"));
            inventoryLine1.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            inventoryLine1.setM_AttributeSetInstance_ID(mr2l1asi.get_ID());
            inventoryLine1.saveEx();
            MInventoryLine inventoryLine2 = new MInventoryLine(inventory, DictionaryIDs.M_Locator.HQ.id, p2.get_ID(), 0, null, null, new BigDecimal("100"));
            inventoryLine2.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            inventoryLine2.setM_AttributeSetInstance_ID(mr1l2asi.get_ID());
            inventoryLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            inventory.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus());
            if (!inventory.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)inventory.getAD_Client_ID(), (int)inventory.get_Table_ID(), (int)inventory.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.setM_PriceList_ID(DictionaryIDs.M_PriceList.STANDARD.id);
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("1000.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(mr1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(mr1Line2.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(mr2Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal totalBase = purchaseOrder.getGrandTotal();
            BigDecimal p1a1 = p1price.multiply(mr1l1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p1a2 = p1price.multiply(mr2l1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p2a1 = p2price.multiply(mr1l2Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)3, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == mr1l1Qty.intValue()) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == mr2l1Qty.intValue()) {
                    Assertions.assertEquals((Object)p1a2.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p2.get_ID() && allocation.getQty().intValue() == mr1l2Qty.intValue()) {
                    Assertions.assertEquals((Object)p2a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            BigDecimal p1OnHand = orderQty.add(inventoryLine1.getMovementQty());
            BigDecimal p1a1assetAmt = p1a1;
            BigDecimal p1a2assetAmt = p1a2.divide(mr2l1Qty, RoundingMode.HALF_UP).multiply(p1OnHand.subtract(mr1l1Qty));
            BigDecimal p1a2varianceAmt = p1a2.subtract(p1a2assetAmt);
            BigDecimal p2varianceAmt = p2a1;
            expected = Arrays.asList(new FactAcct(varianceAccount, p1a2varianceAmt, p1a2varianceAmt, 2, true), new FactAcct(assetAccount, p1a1assetAmt, p1a1assetAmt, 2, true), new FactAcct(assetAccount, p1a2assetAmt, p1a2assetAmt, 2, true), new FactAcct(varianceAccount, p2varianceAmt, p2varianceAmt, 2, true), new FactAcct(varianceAccount, p1a2varianceAmt, p1a2varianceAmt, 2, true), new FactAcct(apAccount, freightInvoice.getGrandTotal(), freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            BigDecimal p1assetAmt = p1a1assetAmt.add(p1a2assetAmt);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p1price.multiply(crate1).add(p1assetAmt.divide(p1OnHand, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)tomorrow);
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"RC");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)freightInvoice.getDocStatus());
            Assertions.assertTrue((freightInvoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"Unexpected reversal id");
            MInvoice reversal = new MInvoice(Env.getCtx(), freightInvoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)freightInvoice.getReversal_ID(), (int)reversal.get_ID());
            if (!reversal.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)318, (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            expected = new ArrayList<FactAcct>();
            for (MFactAcct factAcct : factAccts) {
                MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                if (factAcct.getAmtAcctDr().signum() != 0) {
                    fa = null;
                    for (FactAcct t : expected) {
                        if (t.account().getAccount_ID() != acct.getAccount_ID() || t.account().getM_Product_ID() != acct.getM_Product_ID() || t.debit()) continue;
                        fa = t;
                        break;
                    }
                    if (fa == null) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 1, false));
                    } else {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr().add(fa.accountedAmount()), 1, false));
                        expected.remove(fa);
                    }
                } else if (factAcct.getAmtAcctCr().signum() != 0) {
                    fa = null;
                    for (FactAcct t : expected) {
                        if (t.account().getAccount_ID() != acct.getAccount_ID() || t.account().getM_Product_ID() != acct.getM_Product_ID() || !t.debit()) continue;
                        fa = t;
                        break;
                    }
                    if (fa == null) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 1, true));
                    } else {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctCr().add(fa.accountedAmount()), 1, true));
                        expected.remove(fa);
                    }
                }
                MAllocationHdr[] allocationHdrs = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)freightInvoice.getC_Invoice_ID(), (String)this.getTrxName());
                Assertions.assertEquals((int)1, (int)allocationHdrs.length, (String)"Unexpected number of allocations for freight invoice");
                if (!allocationHdrs[0].isPosted()) {
                    String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)735, (int)allocationHdrs[0].get_ID(), (boolean)false, (String)this.getTrxName());
                    Assertions.assertNull((Object)msg, (String)msg);
                }
                Assertions.assertTrue((boolean)allocationHdrs[0].isPosted(), (String)"Allocation of freight invoice not posted");
                query = MFactAcct.createRecordIdQuery((int)735, (int)allocationHdrs[0].get_ID(), (int)as.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                Assertions.assertEquals((int)0, (int)factAccts.size(), (String)"Unexpected number of fact entries generated by invoice reversal allocation");
            }
            this.assertFactAcctEntries(rFactAccts, expected);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            Optional<MAcctSchema> optional = Arrays.stream(ass).filter(e -> e.getC_AcctSchema_ID() != as.get_ID()).findFirst();
            if (optional.isPresent()) {
                MAcctSchema as2 = optional.get();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.getReversal_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                rFactAccts = query.list();
                expected = new ArrayList<FactAcct>();
                for (MFactAcct factAcct : factAccts) {
                    FactAcct fa;
                    MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                    if (factAcct.getAmtAcctDr().signum() != 0) {
                        fa = null;
                        for (FactAcct t : expected) {
                            if (t.account().getAccount_ID() != acct.getAccount_ID() || t.account().getM_Product_ID() != acct.getM_Product_ID() || t.debit()) continue;
                            fa = t;
                            break;
                        }
                        if (fa == null) {
                            expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 1, false));
                            continue;
                        }
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr().add(fa.accountedAmount()), 1, false));
                        expected.remove(fa);
                        continue;
                    }
                    if (factAcct.getAmtAcctCr().signum() == 0) continue;
                    fa = null;
                    for (FactAcct t : expected) {
                        if (t.account().getAccount_ID() != acct.getAccount_ID() || t.account().getM_Product_ID() != acct.getM_Product_ID() || !t.debit()) continue;
                        fa = t;
                        break;
                    }
                    if (fa == null) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 1, true));
                        continue;
                    }
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctCr().add(fa.accountedAmount()), 1, true));
                    expected.remove(fa);
                }
                this.assertFactAcctEntries(rFactAccts, expected);
            }
        }
        finally {
            this.rollback();
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
            ConversionRateHelper.deleteConversionRate(cr1);
            ConversionRateHelper.deleteConversionRate(cr2);
        }
    }

    @Test
    public void testUnplannedLandedCostReversalAfterInventoryUse() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct p1 = null;
        MProduct p2 = null;
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        MCurrency euro = MCurrency.get((int)DictionaryIDs.C_Currency.EUR.id);
        int C_ConversionType_ID = DictionaryIDs.C_ConversionType.SPOT.id;
        Timestamp today = TimeUtil.getDay(null);
        Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
        BigDecimal crate1 = new BigDecimal("1.05");
        BigDecimal crate2 = new BigDecimal("1.12");
        MConversionRate cr1 = ConversionRateHelper.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, today, crate1, true);
        MConversionRate cr2 = ConversionRateHelper.createConversionRate(euro.getC_Currency_ID(), usd.getC_Currency_ID(), C_ConversionType_ID, tomorrow, crate2, true);
        try {
            List cds;
            p1 = new MProduct(Env.getCtx(), 0, null);
            p1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p1.setName("testUnplannedLandedCostReversalAfterInventoryUse.1");
            p1.setProductType("I");
            p1.setIsStocked(true);
            p1.setIsSold(true);
            p1.setIsPurchased(true);
            p1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p1.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.IMPORT.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal p1price = new BigDecimal("30.00");
            pp.setPriceStd(p1price);
            pp.setPriceList(p1price);
            pp.saveEx();
            p2 = new MProduct(Env.getCtx(), 0, null);
            p2.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p2.setName("testUnplannedLandedCostReversalAfterInventoryUse.2");
            p2.setProductType("I");
            p2.setIsStocked(true);
            p2.setIsSold(true);
            p2.setIsPurchased(true);
            p2.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p2.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p2.saveEx();
            pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p2.get_ID());
            BigDecimal p2price = new BigDecimal("50.00");
            pp.setPriceStd(p2price);
            pp.setPriceList(p2price);
            pp.saveEx();
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            purchaseOrder.setDateOrdered(today);
            purchaseOrder.setDatePromised(today);
            purchaseOrder.setM_PriceList_ID(plv.getM_PriceList_ID());
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("100");
            poLine1.setQty(orderQty);
            poLine1.setDatePromised(today);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            MOrderLine poLine2 = new MOrderLine(purchaseOrder);
            poLine2.setLine(10);
            poLine2.setProduct(new MProduct(Env.getCtx(), p2.get_ID(), this.getTrxName()));
            poLine2.setQty(orderQty);
            poLine2.setDatePromised(today);
            poLine2.setPrice(p2price);
            poLine2.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine mr1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1l1Qty = new BigDecimal("25");
            mr1Line1.setOrderLine(poLine1, 0, mr1l1Qty);
            mr1Line1.setQty(mr1l1Qty);
            mr1Line1.saveEx();
            MInOutLine mr1Line2 = new MInOutLine(receipt1);
            BigDecimal mr1l2Qty = new BigDecimal("100");
            mr1Line2.setOrderLine(poLine2, 0, mr1l2Qty);
            mr1Line2.setQty(mr1l2Qty);
            mr1Line2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            MInOut receipt2 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt2.setDocStatus("DR");
            receipt2.setDocAction("CO");
            receipt2.saveEx();
            MInOutLine mr2Line1 = new MInOutLine(receipt2);
            BigDecimal mr2l1Qty = new BigDecimal("75");
            mr2Line1.setOrderLine(poLine1, 0, mr2l1Qty);
            mr2Line1.setQty(mr2l1Qty);
            mr2Line1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt2, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt2.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt2.getDocStatus());
            if (!receipt2.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt2.getAD_Client_ID(), (int)receipt2.get_Table_ID(), (int)receipt2.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)poLine1.getQtyOrdered().intValue(), (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(orderQty).multiply(crate1).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price.multiply(crate1).setScale(2, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            MAccount varianceAccount = p1ProductCost.getAccount(23, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1l1Qty).multiply(crate1).setScale(2, RoundingMode.HALF_UP), p1price.multiply(mr1l1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1l1Qty).multiply(crate1).setScale(2, RoundingMode.HALF_UP), p1price.multiply(mr1l1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            MInvoiceLine piLine2 = new MInvoiceLine(purchaseInvoice);
            piLine2.setOrderLine(poLine2);
            piLine2.setLine(20);
            piLine2.setProduct(p2);
            piLine2.setQty(poLine2.getQtyOrdered());
            piLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty).multiply(crate1), p1price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty).multiply(crate1).add(p2price.multiply(orderQty).multiply(crate1)), p1price.multiply(orderQty).add(p2price.multiply(orderQty)), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
            inventory.setC_DocType_ID(DictionaryIDs.C_DocType.INTERNAL_USE_INVENTORY.id);
            inventory.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
            inventory.setMovementDate(today);
            inventory.saveEx();
            MInventoryLine inventoryLine1 = new MInventoryLine(inventory, DictionaryIDs.M_Locator.HQ.id, p1.get_ID(), 0, null, null, new BigDecimal("25"));
            inventoryLine1.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            inventoryLine1.saveEx();
            MInventoryLine inventoryLine2 = new MInventoryLine(inventory, DictionaryIDs.M_Locator.HQ.id, p2.get_ID(), 0, null, null, new BigDecimal("100"));
            inventoryLine2.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            inventoryLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            inventory.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus());
            if (!inventory.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)inventory.getAD_Client_ID(), (int)inventory.get_Table_ID(), (int)inventory.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.setM_PriceList_ID(DictionaryIDs.M_PriceList.STANDARD.id);
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("1000.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(mr1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(mr1Line2.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(mr2Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal totalBase = purchaseOrder.getGrandTotal();
            BigDecimal p1a1 = p1price.multiply(mr1l1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p1a2 = p1price.multiply(mr2l1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p2a1 = p2price.multiply(mr1l2Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)3, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == mr1l1Qty.intValue()) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == mr2l1Qty.intValue()) {
                    Assertions.assertEquals((Object)p1a2.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p2.get_ID() && allocation.getQty().intValue() == mr1l2Qty.intValue()) {
                    Assertions.assertEquals((Object)p2a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            BigDecimal p1OnHand = orderQty.add(inventoryLine1.getMovementQty());
            BigDecimal p1a1assetAmt = p1a1;
            BigDecimal p1a2assetAmt = p1a2.divide(mr2l1Qty, RoundingMode.HALF_UP).multiply(p1OnHand.subtract(mr1l1Qty));
            BigDecimal p1a2varianceAmt = p1a2.subtract(p1a2assetAmt);
            BigDecimal p2varianceAmt = p2a1;
            expected = Arrays.asList(new FactAcct(varianceAccount, p1a2varianceAmt, p1a2varianceAmt, 2, true), new FactAcct(assetAccount, p1a1assetAmt, p1a1assetAmt, 2, true), new FactAcct(assetAccount, p1a2assetAmt, p1a2assetAmt, 2, true), new FactAcct(varianceAccount, p2varianceAmt, p2varianceAmt, 2, true), new FactAcct(varianceAccount, p1a2varianceAmt, p1a2varianceAmt, 2, true), new FactAcct(apAccount, freightInvoice.getGrandTotal(), freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            BigDecimal p1assetAmt = p1a1assetAmt.add(p1a2assetAmt);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p1price.multiply(crate1).add(p1assetAmt.divide(p1OnHand, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)tomorrow);
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"RC");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)freightInvoice.getDocStatus());
            Assertions.assertTrue((freightInvoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"Unexpected reversal id");
            MInvoice reversal = new MInvoice(Env.getCtx(), freightInvoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)freightInvoice.getReversal_ID(), (int)reversal.get_ID());
            if (!reversal.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)318, (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            expected = new ArrayList<FactAcct>();
            for (MFactAcct factAcct : factAccts) {
                MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                if (factAcct.getAmtAcctDr().signum() != 0) {
                    fa = null;
                    for (FactAcct t : expected) {
                        if (t.account().getAccount_ID() != acct.getAccount_ID() || t.account().getM_Product_ID() != acct.getM_Product_ID() || t.debit()) continue;
                        fa = t;
                        break;
                    }
                    if (fa == null) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 1, false));
                    } else {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr().add(fa.accountedAmount()), 1, false));
                        expected.remove(fa);
                    }
                } else if (factAcct.getAmtAcctCr().signum() != 0) {
                    fa = null;
                    for (FactAcct t : expected) {
                        if (t.account().getAccount_ID() != acct.getAccount_ID() || t.account().getM_Product_ID() != acct.getM_Product_ID() || !t.debit()) continue;
                        fa = t;
                        break;
                    }
                    if (fa == null) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 1, true));
                    } else {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctCr().add(fa.accountedAmount()), 1, true));
                        expected.remove(fa);
                    }
                }
                MAllocationHdr[] allocationHdrs = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)freightInvoice.getC_Invoice_ID(), (String)this.getTrxName());
                Assertions.assertEquals((int)1, (int)allocationHdrs.length, (String)"Unexpected number of allocations for freight invoice");
                if (!allocationHdrs[0].isPosted()) {
                    String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)735, (int)allocationHdrs[0].get_ID(), (boolean)false, (String)this.getTrxName());
                    Assertions.assertNull((Object)msg, (String)msg);
                }
                Assertions.assertTrue((boolean)allocationHdrs[0].isPosted(), (String)"Allocation of freight invoice not posted");
                query = MFactAcct.createRecordIdQuery((int)735, (int)allocationHdrs[0].get_ID(), (int)as.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                Assertions.assertEquals((int)0, (int)factAccts.size(), (String)"Unexpected number of fact entries generated by invoice reversal allocation");
            }
            this.assertFactAcctEntries(rFactAccts, expected);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            Optional<MAcctSchema> optional = Arrays.stream(ass).filter(e -> e.getC_AcctSchema_ID() != as.get_ID()).findFirst();
            if (optional.isPresent()) {
                MAcctSchema as2 = optional.get();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.getReversal_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                rFactAccts = query.list();
                expected = new ArrayList<FactAcct>();
                for (MFactAcct factAcct : factAccts) {
                    FactAcct fa;
                    MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                    if (factAcct.getAmtAcctDr().signum() != 0) {
                        fa = null;
                        for (FactAcct t : expected) {
                            if (t.account().getAccount_ID() != acct.getAccount_ID() || t.account().getM_Product_ID() != acct.getM_Product_ID() || t.debit()) continue;
                            fa = t;
                            break;
                        }
                        if (fa == null) {
                            expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 1, false));
                            continue;
                        }
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr().add(fa.accountedAmount()), 1, false));
                        expected.remove(fa);
                        continue;
                    }
                    if (factAcct.getAmtAcctCr().signum() == 0) continue;
                    fa = null;
                    for (FactAcct t : expected) {
                        if (t.account().getAccount_ID() != acct.getAccount_ID() || t.account().getM_Product_ID() != acct.getM_Product_ID() || !t.debit()) continue;
                        fa = t;
                        break;
                    }
                    if (fa == null) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 1, true));
                        continue;
                    }
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctCr().add(fa.accountedAmount()), 1, true));
                    expected.remove(fa);
                }
                this.assertFactAcctEntries(rFactAccts, expected);
            }
        }
        finally {
            this.rollback();
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
            ConversionRateHelper.deleteConversionRate(cr1);
            ConversionRateHelper.deleteConversionRate(cr2);
        }
    }

    @Test
    public void testUnplannedLandedCostReversalWithZeroOnHand() {
        MClient client = MClient.get((Properties)Env.getCtx());
        MAcctSchema as = client.getAcctSchema();
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        MProduct p1 = null;
        try {
            List cds;
            p1 = new MProduct(Env.getCtx(), 0, null);
            p1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
            p1.setName("testUnplannedLandedCostReversalWithZeroOnHand");
            p1.setProductType("I");
            p1.setIsStocked(true);
            p1.setIsSold(true);
            p1.setIsPurchased(true);
            p1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            p1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            p1.saveEx();
            MPriceListVersion plv = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
            MProductPrice pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(plv.getM_PriceList_Version_ID());
            pp.setM_Product_ID(p1.get_ID());
            BigDecimal p1price = new BigDecimal("30.00");
            pp.setPriceStd(p1price);
            pp.setPriceList(p1price);
            pp.saveEx();
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            purchaseOrder.setDateOrdered(today);
            purchaseOrder.setDatePromised(today);
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("10");
            poLine1.setQty(orderQty);
            poLine1.setDatePromised(today);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receipt1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1Qty = new BigDecimal("10");
            receipt1Line1.setOrderLine(poLine1, 0, mr1Qty);
            receipt1Line1.setQty(mr1Qty);
            receipt1Line1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price, (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            MAccount varianceAccount = p1ProductCost.getAccount(23, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MBPartner customer = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
            MOrder salesOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            salesOrder.setC_DocTypeTarget_ID("SO");
            salesOrder.setBPartner(customer);
            salesOrder.setDeliveryRule("O");
            salesOrder.setDocStatus("DR");
            salesOrder.setDocAction("CO");
            salesOrder.setDatePromised(today);
            salesOrder.saveEx();
            MOrderLine soLine1 = new MOrderLine(salesOrder);
            soLine1.setLine(10);
            soLine1.setProduct(p1);
            BigDecimal p1ShipQty = new BigDecimal("10");
            soLine1.setQty(p1ShipQty);
            soLine1.setDatePromised(today);
            soLine1.setPrice(new BigDecimal("50"));
            soLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)salesOrder, (String)"CO");
            salesOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)salesOrder.getDocStatus());
            MInOut shipment = new MInOut(salesOrder, DictionaryIDs.C_DocType.MM_SHIPMENT.id, salesOrder.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine1 = new MInOutLine(shipment);
            shipmentLine1.setOrderLine(soLine1, 0, soLine1.getQtyOrdered());
            shipmentLine1.setQty(soLine1.getQtyOrdered());
            shipmentLine1.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("200.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal totalBase = purchaseInvoice.getGrandTotal();
            BigDecimal p1a1 = p1price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, p1a1, 2, true), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"RC");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)freightInvoice.getDocStatus());
            Assertions.assertTrue((freightInvoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"Unexpected reversal id");
            MInvoice reversal = new MInvoice(Env.getCtx(), freightInvoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)freightInvoice.getReversal_ID(), (int)reversal.get_ID());
            if (!reversal.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)318, (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.getReversal_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            expected = new ArrayList<FactAcct>();
            for (MFactAcct factAcct : factAccts) {
                MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                if (factAcct.getAmtAcctDr().signum() != 0) {
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 2, false));
                    continue;
                }
                if (factAcct.getAmtAcctCr().signum() == 0) continue;
                expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 2, true));
            }
            this.assertFactAcctEntries(rFactAccts, expected);
            MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            Optional<MAcctSchema> optional = Arrays.stream(ass).filter(e -> e.getC_AcctSchema_ID() != as.get_ID()).findFirst();
            if (optional.isPresent()) {
                MAcctSchema as2 = optional.get();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                factAccts = query.list();
                query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.getReversal_ID(), (int)as2.get_ID(), (String)this.getTrxName());
                rFactAccts = query.list();
                expected = new ArrayList<FactAcct>();
                for (MFactAcct factAcct : factAccts) {
                    MAccount acct = MAccount.get((X_Fact_Acct)factAcct, (String)this.getTrxName());
                    if (factAcct.getAmtAcctDr().signum() != 0) {
                        expected.add(new FactAcct(acct, factAcct.getAmtAcctDr(), 2, false));
                        continue;
                    }
                    if (factAcct.getAmtAcctCr().signum() == 0) continue;
                    expected.add(new FactAcct(acct, factAcct.getAmtAcctCr(), 2, true));
                }
                this.assertFactAcctEntries(rFactAccts, expected);
            }
        }
        finally {
            this.rollback();
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
        }
    }

    private MInOutLine createPOAndMRForProduct(int productId, MAttributeSetInstance asi, BigDecimal price) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(new MProduct(Env.getCtx(), productId, this.getTrxName()));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        if (price != null) {
            line1.setPrice(price);
        }
        if (asi != null) {
            line1.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        if (asi != null) {
            receiptLine1.setM_AttributeSetInstance_ID(asi.get_ID());
        }
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        if (!receipt1.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
        return receiptLine1;
    }
}

