/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.compiere.grid.CreateFromShipment;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateFromShipmentFormTest
extends AbstractTestCase {
    @Test
    public void testCreateFromOrderLine() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.HOLLY_BUSH.id));
        orderLine.setQty(new BigDecimal("1"));
        orderLine.setDatePromised(today);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)184);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Material Receipt");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("M_InOut");
        query.addRestriction("M_InOut_ID", "=", receipt.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)receipt.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong Material Receipt record id");
        CreateFromShipmentImpl form = new CreateFromShipmentImpl(gridTab);
        form.setTrxName(this.getTrxName());
        ArrayList<KeyNamePair> orders = form.getOrders(order.getC_BPartner_ID());
        Assertions.assertNotNull(orders, (String)"Can't load Orders for BP");
        Assertions.assertTrue((orders.size() > 0 ? 1 : 0) != 0, (String)"Can't load Orders for BP");
        boolean found = false;
        for (KeyNamePair knp : orders) {
            if (knp.getKey() != order.get_ID()) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found, (String)"Fail to load Order");
        form.loadOrderLines(order.get_ID());
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i = 0;
        while (i < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i, 6);
            if (pp.getKey() == orderLine.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i, 0);
                form.minitable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find order line record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        receipt.load(this.getTrxName(), new String[0]);
        MInOutLine[] receiptLines = receipt.getLines(true);
        Assertions.assertEquals((int)1, (int)receiptLines.length, (String)"Unexpected number of Material Receipt Line records");
        Assertions.assertEquals((int)orderLine.get_ID(), (int)receiptLines[0].getC_OrderLine_ID(), (String)"Order line not match to material receipt line");
    }

    @Test
    public void testCreateFromInvoiceLine() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.HOLLY_BUSH.id));
        orderLine.setQty(new BigDecimal("1"));
        orderLine.setDatePromised(today);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInvoice invoice = new MInvoice(order, DictionaryIDs.C_DocType.AP_INVOICE.id, today);
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(orderLine);
        invoiceLine.setQty(new BigDecimal("1"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)184);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Material Receipt");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("M_InOut");
        query.addRestriction("M_InOut_ID", "=", receipt.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)receipt.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong Material Receipt record id");
        CreateFromShipmentImpl form = new CreateFromShipmentImpl(gridTab);
        form.setTrxName(this.getTrxName());
        ArrayList<KeyNamePair> invoices = form.getInvoices(order.getC_BPartner_ID());
        Assertions.assertNotNull(invoices, (String)"Can't load Invoices for BP");
        Assertions.assertTrue((invoices.size() > 0 ? 1 : 0) != 0, (String)"Can't load Invoices for BP");
        boolean found = false;
        for (KeyNamePair knp : invoices) {
            if (knp.getKey() != invoice.get_ID()) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found, (String)"Fail to load Invoice");
        form.loadInvoiceLines(invoice.get_ID());
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i = 0;
        while (i < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i, 8);
            if (pp.getKey() == invoiceLine.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i, 0);
                form.minitable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find invoice line record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        receipt.load(this.getTrxName(), new String[0]);
        MInOutLine[] receiptLines = receipt.getLines(true);
        Assertions.assertEquals((int)1, (int)receiptLines.length, (String)"Unexpected number of Material Receipt Line records");
        invoiceLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)invoiceLine.getM_InOutLine_ID(), (int)receiptLines[0].get_ID(), (String)"Invoice line not match to material receipt line");
    }

    @Test
    public void testCreateFromCustomerRMALines() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.setSalesRep_ID(this.getAD_User_ID());
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Unexpected Document Status");
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus(), (String)"Unexpected Document Status");
        MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
        rma.setC_BPartner_ID(order.getC_BPartner_ID());
        rma.setM_InOut_ID(shipment.getM_InOut_ID());
        rma.setC_DocType_ID(DictionaryIDs.C_DocType.CUSTOMER_RETURN_MATERIAL.id);
        rma.setC_Currency_ID(order.getC_Currency_ID());
        rma.setName("testCreateFromCustomerRMALines");
        rma.setIsSOTrx(true);
        rma.setSalesRep_ID(order.getSalesRep_ID());
        rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
        rma.saveEx();
        MRMALine rmaLine = new MRMALine(Env.getCtx(), 0, this.getTrxName());
        rmaLine.setM_RMA_ID(rma.get_ID());
        rmaLine.setM_InOutLine_ID(shipmentLine.get_ID());
        rmaLine.setM_Product_ID(shipmentLine.getM_Product_ID());
        rmaLine.setQty(new BigDecimal("1"));
        rmaLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)rma, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        rma.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)rma.getDocStatus(), (String)"Unexpected Document Status");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)184);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Material Receipt");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("M_InOut");
        query.addRestriction("M_InOut_ID", "=", receipt.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)receipt.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong Material Receipt record id");
        CreateFromShipmentImpl form = new CreateFromShipmentImpl(gridTab);
        form.setTrxName(this.getTrxName());
        ArrayList<KeyNamePair> RMAs = form.getRMAs(order.getC_BPartner_ID());
        Assertions.assertNotNull(RMAs, (String)"Can't load RMAs for BP");
        Assertions.assertTrue((RMAs.size() > 0 ? 1 : 0) != 0, (String)"Can't load RMAsfor BP");
        boolean found = false;
        for (KeyNamePair knp : RMAs) {
            if (knp.getKey() != rma.get_ID()) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found, (String)"Fail to load RMA");
        form.loadRMALines(rma.get_ID());
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i = 0;
        while (i < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i, 7);
            if (pp.getKey() == rmaLine.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i, 0);
                form.minitable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find RMA line record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        receipt.load(this.getTrxName(), new String[0]);
        MInOutLine[] receiptLines = receipt.getLines(true);
        Assertions.assertEquals((int)1, (int)receiptLines.length, (String)"Unexpected number of Material Receipt Line records");
        rmaLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)rmaLine.get_ID(), (int)receiptLines[0].getM_RMALine_ID(), (String)"RMA line not match to material receipt line");
    }

    private static class CreateFromShipmentImpl
    extends CreateFromShipment {
        private MiniTableImpl minitable = null;

        public CreateFromShipmentImpl(GridTab mTab) {
            super(mTab);
            try {
                this.dynInit();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Object getWindow() {
            return null;
        }

        protected boolean dynInit() throws Exception {
            super.dynInit();
            this.minitable = new MiniTableImpl();
            for (String column : this.getOISColumnNames()) {
                this.minitable.addColumn(column);
            }
            this.configureMiniTable((IMiniTable)this.minitable);
            return true;
        }

        public ArrayList<KeyNamePair> getOrders(int C_BPartner_ID) {
            return super.loadOrderData(C_BPartner_ID, false, true, false);
        }

        public void loadOrderLines(int C_Order_ID) {
            Vector datas = super.getOrderData(C_Order_ID, false, MLocator.getDefault((MWarehouse)MWarehouse.get((int)this.getM_Warehouse_ID())).getM_Locator_ID());
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }

        public ArrayList<KeyNamePair> getInvoices(int C_BPartner_ID) {
            return super.loadInvoiceData(C_BPartner_ID);
        }

        public void loadInvoiceLines(int C_Invoice_ID) {
            Vector datas = super.getInvoiceData(C_Invoice_ID, MLocator.getDefault((MWarehouse)MWarehouse.get((int)this.getM_Warehouse_ID())).getM_Locator_ID());
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }

        public ArrayList<KeyNamePair> getRMAs(int C_BPartner_ID) {
            return super.loadRMAData(C_BPartner_ID);
        }

        public void loadRMALines(int M_RMA_ID) {
            Vector datas = super.getRMAData(M_RMA_ID, MLocator.getDefault((MWarehouse)MWarehouse.get((int)this.getM_Warehouse_ID())).getM_Locator_ID());
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }
    }
}

