/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.costing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLandedCost;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.idempiere.test.FactAcct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class BackDateAveragePOCostingTest
extends AbstractTestCase {
    @Test
    public void testBackDateLandedCostZeroStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateLandedCostZeroStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, backDate2, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateLandedCostInsufficientStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateLandedCostInsufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6.5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, backDate2, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("6.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("4.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment2 = shipmentLine2.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("67.50"), 2, true), new FactAcct(assetAccount, new BigDecimal("67.50"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateLandedCostSufficientStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateLandedCostSufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6.5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, backDate2, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment1 = shipmentLine1.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("36.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("36.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInOut shipment2 = shipmentLine2.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("67.50"), 2, true), new FactAcct(assetAccount, new BigDecimal("67.50"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateLandedCostZeroStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateLandedCostZeroStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            this.createLandedCostForMR(receiptLine1, backDate2, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateLandedCostInsufficientStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateLandedCostInsufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6.5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, backDate2, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateLandedCostSufficientStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateLandedCostSufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6.5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, backDate2, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateReceiptAfterShipmentInventory() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateReceiptAfterShipmentInventory", new BigDecimal(10));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(2), new BigDecimal(10));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("10.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("10.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(1), new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("10.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(2), new BigDecimal(16));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("14.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(16));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("14.00"));
            MInventoryLine inventoryLine = this.createInventoryUse(today, product.getM_Product_ID(), new BigDecimal(1));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)inventoryLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for inventory line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, inventoryLine.getParent().getMovementDate(), false, new BigDecimal("14.00"));
            MInOutLine receiptLine3 = this.createPOAndMRForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(1), new BigDecimal(13));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine3.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine3.getParent().getDateAcct(), true, new BigDecimal("11.00"));
            MInvoiceLine invoiceLine3 = this.createInvoiceForMR(receiptLine3, new BigDecimal(13));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine3.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine3.getParent().getDateAcct(), true, new BigDecimal("11.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("11.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("13.50"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("13.50"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)inventoryLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for inventory line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, inventoryLine.getParent().getMovementDate(), false, new BigDecimal("13.50"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("11.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("11.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInventory inventory = inventoryLine.getParent();
            MAccount invDiffAccount = MCharge.getAccount((int)inventoryLine.getC_Charge_ID(), (MAcctSchema)as);
            query = MFactAcct.createRecordIdQuery((int)321, (int)inventory.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(invDiffAccount, new BigDecimal("13.50"), 2, true), new FactAcct(assetAccount, new BigDecimal("13.50"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateReceiptBeforeLandedCostZero2InsufficientStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateReceiptBeforeLandedCostZero2InsufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine receiptLine3 = this.createPOAndMRForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(4), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine3.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine3 = this.createInvoiceForMR(receiptLine3, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine3.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("6.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("4.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment2 = shipmentLine2.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("67.50"), 2, true), new FactAcct(assetAccount, new BigDecimal("67.50"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateReceiptBeforeLandedCostZero2InsufficientStock2() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateReceiptBeforeLandedCostZero2InsufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInventoryLine inventoryLine = this.createInventoryUse(today, product.getM_Product_ID(), new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)inventoryLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for inventory line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, inventoryLine.getParent().getMovementDate(), false, new BigDecimal("7.00"));
            MInOutLine receiptLine3 = this.createPOAndMRForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(4), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine3.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine3 = this.createInvoiceForMR(receiptLine3, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine3.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)inventoryLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for inventory line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, inventoryLine.getParent().getMovementDate(), false, new BigDecimal("6.75"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("6.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("4.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInventory inventory = inventoryLine.getParent();
            MAccount invDiffAccount = MCharge.getAccount((int)inventoryLine.getC_Charge_ID(), (MAcctSchema)as);
            query = MFactAcct.createRecordIdQuery((int)321, (int)inventory.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(invDiffAccount, new BigDecimal("67.50"), 2, true), new FactAcct(assetAccount, new BigDecimal("67.50"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateReceiptBeforeLandedCostZero2SufficientStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateReceiptBeforeLandedCostZero2SufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine receiptLine3 = this.createPOAndMRForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine3.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine3 = this.createInvoiceForMR(receiptLine3, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine3.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.55"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.55"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.55"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment2 = shipmentLine2.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("65.45"), 2, true), new FactAcct(assetAccount, new BigDecimal("65.45"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateReceiptBeforeLandedCostInsufficient2SufficientStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateReceiptBeforeLandedCostInsufficient2SufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6.75));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            MInOutLine receiptLine3 = this.createPOAndMRForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine3.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine3 = this.createInvoiceForMR(receiptLine3, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine3.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("5.71"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.31"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.31"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.31"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment2 = shipmentLine2.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("63.08"), 2, true), new FactAcct(assetAccount, new BigDecimal("63.08"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateReceiptBeforeLandedCostZero2InsufficientStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateReceiptBeforeLandedCostZero2InsufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine receiptLine3 = this.createPOAndMRForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(4), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine3.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine3 = this.createInvoiceForMR(receiptLine3, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine3.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateReceiptBeforeLandedCostZero2SufficientStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateReceiptBeforeLandedCostZero2SufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine receiptLine3 = this.createPOAndMRForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine3.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine3 = this.createInvoiceForMR(receiptLine3, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine3.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.45"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.55"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.55"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateReceiptBeforeLandedCostInsufficient2SufficientStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateReceiptBeforeLandedCostInsufficient2SufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(12), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.25"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6.75));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.75"));
            MInOutLine receiptLine3 = this.createPOAndMRForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine3.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine3 = this.createInvoiceForMR(receiptLine3, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine3.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine3.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("5.71"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.38"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.31"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.31"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateShipmentBeforeReceiptShipment() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateShipmentBeforeReceiptShipment", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(4), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment2 = shipmentLine2.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("20.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("20.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInOut shipment1 = shipmentLine1.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("62.50"), 2, true), new FactAcct(assetAccount, new BigDecimal("62.50"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateShipmentBeforeLandedCostSufficient2ZeroStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateShipmentBeforeLandedCostSufficient2ZeroStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment2 = shipmentLine2.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("50.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("50.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInOut shipment1 = shipmentLine1.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("70.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("70.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateShipmentBeforeLandedCostInsufficient2ZeroStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateShipmentBeforeLandedCostInsufficient2ZeroStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(16), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(4), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment2 = shipmentLine2.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("20.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("20.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInOut shipment1 = shipmentLine1.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("100.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("100.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateShipmentBeforeLandedCostSufficient2InsufficientStock() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateShipmentBeforeLandedCostSufficient2InsufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.43"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment2 = shipmentLine2.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInOut shipment1 = shipmentLine1.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("64.29"), 2, true), new FactAcct(assetAccount, new BigDecimal("64.29"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("6.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("4.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateShipmentBeforeLandedCostSufficient2ZeroStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateShipmentBeforeLandedCostSufficient2ZeroStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateShipmentBeforeLandedCostInsufficient2ZeroStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateShipmentBeforeLandedCostInsufficient2ZeroStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(16), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(4), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.25"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.25"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateShipmentBeforeLandedCostSufficient2InsufficientStockWithPV() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateShipmentBeforeLandedCostSufficient2InsufficientStock", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -2);
            Timestamp backDate1 = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate2 = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate1, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(backDate2, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("7.43"));
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testPostDateShipment() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testPostDateShipment", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, 1);
            Timestamp postDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(postDate, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("36.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("36.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testPostDateShipment2() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testPostDateShipment", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, 1);
            Timestamp postDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            MInventoryLine inventoryLine = this.createInventoryUse(postDate, product.getM_Product_ID(), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)inventoryLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for inventory line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, inventoryLine.getParent().getMovementDate(), false, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)inventoryLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for inventory line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, inventoryLine.getParent().getMovementDate(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInventory inventory = inventoryLine.getParent();
            MAccount invDiffAccount = MCharge.getAccount((int)inventoryLine.getC_Charge_ID(), (MAcctSchema)as);
            Query query = MFactAcct.createRecordIdQuery((int)321, (int)inventory.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(invDiffAccount, new BigDecimal("36.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("36.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectReceiptAfterShipment() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectReceiptAfterShipment", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.71"));
            MInOutLine reversalReceiptLine = this.reverseInOut(receiptLine2, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)reversalReceiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalReceiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine reversalInvoiceLine = this.reverseInvoice(invoiceLine2, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalInvoiceLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("6.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("4.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectReceiptAfterShipment2() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectReceiptAfterShipment21", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.71"));
            MInOutLine reversalReceiptLine = this.reverseInOut(receiptLine2, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)reversalReceiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalReceiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine reversalInvoiceLine = this.reverseInvoice(invoiceLine2, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalInvoiceLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("6.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("4.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectShipmentAfterAVGCostMoved() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectShipmentAfterAVGCostMoved", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(backDate, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6.43));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            MInOutLine reversalLine = this.reverseInOut(shipmentLine1, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment1 = reversalLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, false), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, true));
            this.assertFactAcctEntries(factAccts, expected);
            MInOut shipment2 = shipmentLine2.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("60.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("60.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectShipmentAfterAVGCostMoved2() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectShipmentAfterAVGCostMoved", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine1 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine1.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine1.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            MInOutLine shipmentLine2 = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(6.43));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.43"));
            MInOutLine reversalLine = this.reverseInOut(shipmentLine1, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine2.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine2.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment1 = reversalLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, false), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, true));
            this.assertFactAcctEntries(factAccts, expected);
            MInOut shipment2 = shipmentLine2.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment2.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("60.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("60.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectShipmentAfterAVGCostMoved3() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectShipmentAfterAVGCostMoved", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine reversalLine = this.reverseInOut(shipmentLine, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectLandedCost() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectLandedCost", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine, backDate, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine reversalLine = this.reverseLandedCost(landedCostLine, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)reversalLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInvoice landedCost = reversalLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, false), new FactAcct(apAccount, landedCost.getGrandTotal().negate(), 2, true));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectLandedCost2() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectLandedCost", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine reversalLine = this.reverseLandedCost(landedCostLine, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)reversalLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInvoice landedCost = reversalLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, false), new FactAcct(apAccount, landedCost.getGrandTotal().negate(), 2, true));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectProductInvoice() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectProductInvoice", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine = this.createInvoiceForMR(receiptLine, new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine reversalLine = this.reverseInvoice(invoiceLine, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectProductInvoice2() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectProductInvoice", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine = this.createInvoiceForMR(receiptLine, today, new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine reversalLine = this.reverseInvoice(invoiceLine, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("30.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("30.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectInternalUseAfterAVGCostMoved() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectInternalUseAfterAVGCostMoved", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInventoryLine inventoryLine = this.createInventoryUse(backDate, product.getM_Product_ID(), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)inventoryLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for inventory line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, inventoryLine.getParent().getMovementDate(), true, new BigDecimal("5.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInventoryLine reversalLine = this.reverseInventory(inventoryLine, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)reversalLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getMovementDate(), true, new BigDecimal("5.00"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectInternalUseAfterAVGCostMoved2() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectInternalUseAfterAVGCostMoved2", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInventoryLine inventoryLine = this.createInventoryUse(today, product.getM_Product_ID(), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)inventoryLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for inventory line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, inventoryLine.getParent().getMovementDate(), false, new BigDecimal("5.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInventoryLine reversalLine = this.reverseInventory(inventoryLine, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InventoryLine_ID=?", (int)reversalLine.getM_InventoryLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getMovementDate(), true, new BigDecimal("5.00"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseCorrectReceiptAfterLandedCost() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseCorrectReceiptAfterLandedCost", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, today, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.71"));
            MInOutLine reversalReceiptLine = this.reverseInOut(receiptLine1, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)reversalReceiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalReceiptLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine reversalInvoiceLine = this.reverseInvoice(invoiceLine1, false);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalInvoiceLine.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("7.00"));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("8.00"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = shipmentLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("42.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("42.00"), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("6.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("4.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseAccrualShipmentAfterShipment() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseAccrualShipmentAfterShipment", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, 1);
            Timestamp postDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(backDate, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, postDate, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.71"));
            MInOutLine reversalLine = this.reverseInOut(shipmentLine, true);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)reversalLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.50"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount cogsAccount = productCost.getAccount(4, as);
            MInOut shipment = reversalLine.getParent();
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)shipment.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(cogsAccount, new BigDecimal("36.00"), 2, false), new FactAcct(assetAccount, new BigDecimal("36.00"), 2, true));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(assetAccount, new BigDecimal("10.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testReverseAccrualReceiptAfterShipment() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testReverseAccrualReceiptAfterShipment", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            cal.setTimeInMillis(today.getTime());
            cal.add(5, 1);
            Timestamp postDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine1 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInvoiceLine invoiceLine1 = this.createInvoiceForMR(receiptLine1, new BigDecimal(5));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine1.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine1.getParent().getDateAcct(), true, new BigDecimal("5.00"));
            MInOutLine receiptLine2 = this.createPOAndMRForProduct(backDate, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            int Ref_CostDetail_ID = cd.getM_CostDetail_ID();
            MInvoiceLine invoiceLine2 = this.createInvoiceForMR(receiptLine2, new BigDecimal(7));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)invoiceLine2.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, invoiceLine2.getParent().getDateAcct(), true, new BigDecimal("6.00"));
            MInOutLine shipmentLine = this.createSOAndSHForProduct(today, product.getM_Product_ID(), new BigDecimal(6), new BigDecimal(6));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"M_InOutLine_ID=?", (int)shipmentLine.getM_InOutLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for shipment line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, shipmentLine.getParent().getDateAcct(), false, new BigDecimal("6.00"));
            MInvoiceLine landedCostLine = this.createLandedCostForMR(receiptLine1, postDate, new BigDecimal(10));
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("6.71"));
            MInOutLine reversalLine = this.reverseInOut(receiptLine2, true);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)("C_OrderLine_ID=? AND TRUNC(DateAcct)=" + DB.TO_DATE((Timestamp)reversalLine.getParent().getDateAcct(), (boolean)true)), (int)reversalLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, reversalLine.getParent().getDateAcct(), true, new BigDecimal("3.50"));
            Assertions.assertEquals((int)cd.getRef_CostDetail_ID(), (int)Ref_CostDetail_ID);
            cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_InvoiceLine_ID=?", (int)landedCostLine.getC_InvoiceLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for invoice line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, landedCostLine.getParent().getDateAcct(), false, new BigDecimal("4.50"));
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = productCost.getAccount(3, as);
            MAccount varianceAccount = productCost.getAccount(23, as);
            MInvoice landedCost = landedCostLine.getParent();
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)landedCost.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            Query query = MFactAcct.createRecordIdQuery((int)318, (int)landedCost.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(varianceAccount, new BigDecimal("6.00"), 2, true), new FactAcct(assetAccount, new BigDecimal("4.00"), 2, true), new FactAcct(apAccount, landedCost.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    @Test
    public void testUnplannedLandedCostReversalAfterShipment1() {
        MProduct p1 = null;
        MProduct p2 = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            List cds;
            this.configureAcctSchema(as);
            BigDecimal p1price = new BigDecimal("30.00");
            p1 = this.createProduct("testUnplannedLandedCostReversalAfterShipment1.1", p1price);
            BigDecimal p2price = new BigDecimal("50.00");
            p2 = this.createProduct("testUnplannedLandedCostReversalAfterShipment1.2", p2price);
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MOrder purchaseOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            purchaseOrder.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
            purchaseOrder.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
            purchaseOrder.setIsSOTrx(false);
            purchaseOrder.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            purchaseOrder.setDocStatus("DR");
            purchaseOrder.setDocAction("CO");
            purchaseOrder.setDateAcct(backDate);
            purchaseOrder.setDateOrdered(backDate);
            purchaseOrder.saveEx();
            MOrderLine poLine1 = new MOrderLine(purchaseOrder);
            poLine1.setLine(10);
            poLine1.setProduct(new MProduct(Env.getCtx(), p1.get_ID(), this.getTrxName()));
            BigDecimal orderQty = new BigDecimal("10");
            poLine1.setQty(orderQty);
            poLine1.setPrice(p1price);
            poLine1.saveEx();
            MOrderLine poLine2 = new MOrderLine(purchaseOrder);
            poLine2.setLine(10);
            poLine2.setProduct(new MProduct(Env.getCtx(), p2.get_ID(), this.getTrxName()));
            poLine2.setQty(orderQty);
            poLine2.setPrice(p2price);
            poLine2.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)purchaseOrder, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            purchaseOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)purchaseOrder.getDocStatus());
            MInOut receipt1 = new MInOut(purchaseOrder, DictionaryIDs.C_DocType.MM_RECEIPT.id, purchaseOrder.getDateOrdered());
            receipt1.setDocStatus("DR");
            receipt1.setDocAction("CO");
            receipt1.saveEx();
            MInOutLine receipt1Line1 = new MInOutLine(receipt1);
            BigDecimal mr1Qty = new BigDecimal("10");
            receipt1Line1.setOrderLine(poLine1, 0, mr1Qty);
            receipt1Line1.setQty(mr1Qty);
            receipt1Line1.saveEx();
            MInOutLine receipt1Line2 = new MInOutLine(receipt1);
            receipt1Line2.setOrderLine(poLine2, 0, mr1Qty);
            receipt1Line2.setQty(mr1Qty);
            receipt1Line2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt1.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
            if (!receipt1.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)error, (String)error);
            }
            Assertions.assertTrue(((cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine1.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName())).size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line1");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p1price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p1.set_TrxName(this.getTrxName());
            MCost p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p1mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p1price, (Object)p1mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p1ProductCost = new ProductCost(Env.getCtx(), p1.get_ID(), 0, this.getTrxName());
            MAccount assetAccount = p1ProductCost.getAccount(3, as);
            Doc doc = DocManager.getDocument((MAcctSchema)as, (int)319, (int)receipt1.get_ID(), (String)this.getTrxName());
            MAccount nivReceiptAccount = doc.getAccount(51, as);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt1.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            List<FactAcct> expected = Arrays.asList(new FactAcct(assetAccount, p1price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p1price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            cds = MCostDetail.list((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)poLine2.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertTrue((cds.size() == 1 ? 1 : 0) != 0, (String)"MCostDetail not found for order line2");
            for (MCostDetail cd : cds) {
                if (cd.getM_CostElement_ID() != 0) continue;
                Assertions.assertEquals((int)10, (int)cd.getQty().intValue(), (String)"Unexpected MCostDetail Qty");
                Assertions.assertEquals((Object)p2price.multiply(mr1Qty).setScale(2, RoundingMode.HALF_UP), (Object)cd.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected MCostDetail Amt");
            }
            p2.set_TrxName(this.getTrxName());
            MCost p2mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertNotNull((Object)p2mcost, (String)"No MCost record found");
            Assertions.assertEquals((Object)p2price, (Object)p2mcost.getCurrentCostPrice().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            ProductCost p2ProductCost = new ProductCost(Env.getCtx(), p2.get_ID(), 0, this.getTrxName());
            assetAccount = p2ProductCost.getAccount(3, as);
            expected = Arrays.asList(new FactAcct(assetAccount, p2price.multiply(mr1Qty), 2, true), new FactAcct(nivReceiptAccount, p2price.multiply(mr1Qty), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MInvoice purchaseInvoice = new MInvoice(purchaseOrder, DictionaryIDs.C_DocType.AP_INVOICE.id, purchaseOrder.getDateOrdered());
            purchaseInvoice.setDocStatus("DR");
            purchaseInvoice.setDocAction("CO");
            purchaseInvoice.saveEx();
            MInvoiceLine piLine1 = new MInvoiceLine(purchaseInvoice);
            piLine1.setOrderLine(poLine1);
            piLine1.setLine(10);
            piLine1.setProduct(p1);
            piLine1.setQty(poLine1.getQtyOrdered());
            piLine1.saveEx();
            MInvoiceLine piLine2 = new MInvoiceLine(purchaseInvoice);
            piLine2.setOrderLine(poLine2);
            piLine2.setLine(10);
            piLine2.setProduct(p2);
            piLine2.setQty(poLine2.getQtyOrdered());
            piLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)purchaseInvoice, (String)"CO");
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)purchaseInvoice.getDocStatus());
            if (!purchaseInvoice.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)purchaseInvoice.getAD_Client_ID(), (int)318, (int)purchaseInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0);
            }
            purchaseInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)purchaseInvoice.isPosted());
            Doc invoiceDoc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)purchaseInvoice.get_ID(), (String)this.getTrxName());
            MAccount liabilityAccount = invoiceDoc.getAccount(2, as);
            MAccount inventoryClearingAccount = p1ProductCost.getAccount(10, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)purchaseInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            expected = Arrays.asList(new FactAcct(inventoryClearingAccount, p1price.multiply(orderQty), 2, true), new FactAcct(inventoryClearingAccount, p2price.multiply(orderQty), 2, true), new FactAcct(liabilityAccount, p1price.multiply(orderQty).add(p2price.multiply(orderQty)), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            MBPartner freightBP = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MInvoice freightInvoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            freightInvoice.setC_DocTypeTarget_ID("API");
            freightInvoice.setBPartner(freightBP);
            freightInvoice.setDateAcct(backDate);
            freightInvoice.setDateInvoiced(backDate);
            freightInvoice.setDocStatus("DR");
            freightInvoice.setDocAction("CO");
            freightInvoice.saveEx();
            MInvoiceLine fiLine = new MInvoiceLine(freightInvoice);
            fiLine.setLine(10);
            fiLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
            fiLine.setQty(BigDecimal.ONE);
            BigDecimal freightPrice = new BigDecimal("200.00");
            fiLine.setPrice(freightPrice);
            fiLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            fiLine.saveEx();
            MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line1.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
            landedCost.setC_InvoiceLine_ID(fiLine.get_ID());
            landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
            landedCost.setM_InOut_ID(receipt1.get_ID());
            landedCost.setM_InOutLine_ID(receipt1Line2.get_ID());
            landedCost.setLandedCostDistribution("C");
            landedCost.saveEx();
            String error = landedCost.allocateCosts();
            Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
            BigDecimal totalBase = purchaseInvoice.getGrandTotal();
            BigDecimal p1a1 = p1price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            BigDecimal p2a1 = p2price.multiply(mr1Qty).multiply(fiLine.getLineNetAmt()).divide(totalBase, 6, RoundingMode.HALF_UP);
            MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine((Properties)Env.getCtx(), (int)fiLine.get_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)2, (int)allocations.length, (String)"Unexpected number of landed cost allocation line");
            MLandedCostAllocation[] mLandedCostAllocationArray = allocations;
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                MLandedCostAllocation allocation = mLandedCostAllocationArray[n2];
                if (allocation.getM_Product_ID() == p1.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p1a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else if (allocation.getM_Product_ID() == p2.get_ID() && allocation.getQty().intValue() == 10) {
                    Assertions.assertEquals((Object)p2a1.setScale(2, RoundingMode.HALF_UP), (Object)allocation.getAmt().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected landed cost allocation amount");
                } else {
                    Assertions.fail((String)("Unknown landed cost allocation line: " + String.valueOf(allocation)));
                }
                ++n2;
            }
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"CO");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)freightInvoice.getDocStatus());
            if (!freightInvoice.isPosted()) {
                error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)freightInvoice.getAD_Client_ID(), (int)318, (int)freightInvoice.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)freightInvoice.isPosted());
            doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)freightInvoice.get_ID(), (String)this.getTrxName());
            MAccount apAccount = doc.getAccount(2, as);
            query = MFactAcct.createRecordIdQuery((int)318, (int)freightInvoice.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            factAccts = query.list();
            BigDecimal p1QtyOnHand = mr1Qty;
            BigDecimal p2QtyOnHand = mr1Qty;
            expected = Arrays.asList(new FactAcct(assetAccount, p1a1, 2, true), new FactAcct(assetAccount, p2a1, 2, true), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, false));
            this.assertFactAcctEntries(factAccts, expected);
            p1mcost = p1.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p1price.add(p1a1.divide(p1QtyOnHand, 2, RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            p1mcost = p2.getCostingRecord(as, this.getAD_Org_ID(), 0, as.getCostingMethod());
            Assertions.assertEquals((Object)p2price.add(p2a1.divide(p2QtyOnHand, 2, RoundingMode.HALF_UP)).setScale(1, RoundingMode.HALF_UP), (Object)p1mcost.getCurrentCostPrice().setScale(1, RoundingMode.HALF_UP), (String)"Unexpected current cost price");
            MBPartner customer = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
            MOrder salesOrder = new MOrder(Env.getCtx(), 0, this.getTrxName());
            salesOrder.setC_DocTypeTarget_ID("SO");
            salesOrder.setBPartner(customer);
            salesOrder.setDeliveryRule("O");
            salesOrder.setDocStatus("DR");
            salesOrder.setDocAction("CO");
            salesOrder.setDateAcct(today);
            salesOrder.setDateOrdered(today);
            salesOrder.saveEx();
            MOrderLine soLine1 = new MOrderLine(salesOrder);
            soLine1.setLine(10);
            soLine1.setProduct(p1);
            BigDecimal p1ShipQty = new BigDecimal("10");
            soLine1.setQty(p1ShipQty);
            soLine1.setPrice(new BigDecimal("50"));
            soLine1.saveEx();
            MOrderLine soLine2 = new MOrderLine(salesOrder);
            soLine2.setLine(20);
            soLine2.setProduct(p2);
            BigDecimal p2ShipQty = new BigDecimal("5");
            soLine2.setQty(p2ShipQty);
            soLine2.setPrice(new BigDecimal("70"));
            soLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)salesOrder, (String)"CO");
            salesOrder.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)salesOrder.getDocStatus());
            MInOut shipment = new MInOut(salesOrder, DictionaryIDs.C_DocType.MM_SHIPMENT.id, salesOrder.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine1 = new MInOutLine(shipment);
            shipmentLine1.setOrderLine(soLine1, 0, soLine1.getQtyOrdered());
            shipmentLine1.setQty(soLine1.getQtyOrdered());
            shipmentLine1.saveEx();
            MInOutLine shipmentLine2 = new MInOutLine(shipment);
            shipmentLine2.setOrderLine(soLine2, 0, soLine2.getQtyOrdered());
            shipmentLine2.setQty(soLine2.getQtyOrdered());
            shipmentLine2.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            shipment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
            info = MWorkflow.runDocumentActionWorkflow((PO)freightInvoice, (String)"RA");
            freightInvoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"RE", (Object)freightInvoice.getDocStatus());
            Assertions.assertTrue((freightInvoice.getReversal_ID() > 0 ? 1 : 0) != 0, (String)"Unexpected reversal id");
            MInvoice reversal = new MInvoice(Env.getCtx(), freightInvoice.getReversal_ID(), this.getTrxName());
            Assertions.assertEquals((int)freightInvoice.getReversal_ID(), (int)reversal.get_ID());
            if (!reversal.isPosted()) {
                String msg = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)318, (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertNull((Object)msg, (String)msg);
            }
            query = MFactAcct.createRecordIdQuery((int)318, (int)reversal.get_ID(), (int)as.get_ID(), (String)this.getTrxName());
            List rFactAccts = query.list();
            MAccount varianceAccount = p1ProductCost.getAccount(23, as);
            expected = Arrays.asList(new FactAcct(varianceAccount, p1a1, 2, false), new FactAcct(assetAccount, p2a1.divide(new BigDecimal(2), RoundingMode.HALF_UP), 2, false), new FactAcct(apAccount, freightInvoice.getGrandTotal(), 2, true));
            this.assertFactAcctEntries(rFactAccts, expected);
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (p1 != null) {
                p1.set_TrxName(null);
                p1.deleteEx(true);
            }
            if (p2 != null) {
                p2.set_TrxName(null);
                p2.deleteEx(true);
            }
        }
    }

    @Test
    public void testBackDateShipmentBeforeReceipt() {
        MProduct product = null;
        MClientInfo ci = MClientInfo.get((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (String)this.getTrxName());
        MAcctSchema as = ci.getMAcctSchema1();
        try {
            this.configureAcctSchema(as);
            product = this.createProduct("testBackDateShipmentBeforeReceipt", new BigDecimal(5));
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(today.getTime());
            cal.add(5, -1);
            Timestamp backDate = new Timestamp(cal.getTimeInMillis());
            MInOutLine receiptLine = this.createPOAndMRForProduct(today, product.getM_Product_ID(), new BigDecimal(10), new BigDecimal(5));
            MCostDetail cd = MCostDetail.get((Properties)Env.getCtx(), (String)"C_OrderLine_ID=?", (int)receiptLine.getC_OrderLine_ID(), (int)0, (int)as.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)cd, (String)"MCostDetail not found for receipt line");
            BackDateAveragePOCostingTest.validateCostDetail(cd, receiptLine.getParent().getDateAcct(), false, new BigDecimal("5.00"));
            Timestamp acctDate = backDate;
            int productId = product.getM_Product_ID();
            BigDecimal qty = new BigDecimal(6);
            BigDecimal price = new BigDecimal(6);
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.STANDARD_ORDER.id);
            order.setIsSOTrx(true);
            order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.setDateAcct(acctDate);
            order.setDateOrdered(acctDate);
            order.setDatePromised(acctDate);
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(new MProduct(Env.getCtx(), productId, this.getTrxName()));
            orderLine.setQty(qty);
            orderLine.setDatePromised(acctDate);
            if (price != null) {
                orderLine.setPrice(price);
            }
            orderLine.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
            shipment.setDocStatus("DR");
            shipment.setDocAction("CO");
            shipment.saveEx();
            MInOutLine shipmentLine = new MInOutLine(shipment);
            shipmentLine.setOrderLine(orderLine, 0, qty);
            shipmentLine.setQty(qty);
            shipmentLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
            Assertions.assertTrue((boolean)info.isError(), (String)info.getSummary());
        }
        finally {
            this.rollback();
            as.load(this.getTrxName(), new String[0]);
            if (product != null) {
                product.set_TrxName(null);
                product.deleteEx(true);
            }
        }
    }

    private MProduct createProduct(String name, BigDecimal price) {
        MProduct product = new MProduct(Env.getCtx(), 0, null);
        product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.STANDARD.id);
        product.setName(name);
        product.setProductType("I");
        product.setIsStocked(true);
        product.setIsSold(true);
        product.setIsPurchased(true);
        product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        product.saveEx();
        product.set_TrxName(this.getTrxName());
        MPriceListVersion plv1 = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id).getPriceListVersion(null);
        MProductPrice pp1 = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
        pp1.setM_PriceList_Version_ID(plv1.getM_PriceList_Version_ID());
        pp1.setM_Product_ID(product.get_ID());
        pp1.setPriceStd(price);
        pp1.setPriceList(price);
        pp1.saveEx();
        MPriceListVersion plv2 = MPriceList.get((int)DictionaryIDs.M_PriceList.STANDARD.id).getPriceListVersion(null);
        MProductPrice pp2 = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
        pp2.setM_PriceList_Version_ID(plv2.getM_PriceList_Version_ID());
        pp2.setM_Product_ID(product.get_ID());
        pp2.setPriceStd(price);
        pp2.setPriceList(price);
        pp2.saveEx();
        return product;
    }

    private MInOutLine createPOAndMRForProduct(Timestamp acctDate, int productId, BigDecimal qty, BigDecimal price) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDateAcct(acctDate);
        order.setDateOrdered(acctDate);
        order.setDatePromised(acctDate);
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(new MProduct(Env.getCtx(), productId, this.getTrxName()));
        orderLine.setQty(qty);
        orderLine.setDatePromised(acctDate);
        if (price != null) {
            orderLine.setPrice(price);
        }
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, 0, qty);
        receiptLine.setQty(qty);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)receipt.get_Table_ID(), (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        return receiptLine;
    }

    private MInOutLine createSOAndSHForProduct(Timestamp acctDate, int productId, BigDecimal qty, BigDecimal price) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.STANDARD_ORDER.id);
        order.setIsSOTrx(true);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDateAcct(acctDate);
        order.setDateOrdered(acctDate);
        order.setDatePromised(acctDate);
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(new MProduct(Env.getCtx(), productId, this.getTrxName()));
        orderLine.setQty(qty);
        orderLine.setDatePromised(acctDate);
        if (price != null) {
            orderLine.setPrice(price);
        }
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(orderLine, 0, qty);
        shipmentLine.setQty(qty);
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        if (!shipment.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)shipment.getAD_Client_ID(), (int)shipment.get_Table_ID(), (int)shipment.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)shipment.isPosted());
        return shipmentLine;
    }

    private MInvoiceLine createLandedCostForMR(MInOutLine receiptLine, Timestamp acctDate, BigDecimal price) {
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.setDateAcct(acctDate);
        invoice.setDateInvoiced(acctDate);
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setLine(10);
        invoiceLine.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
        invoiceLine.setQty(BigDecimal.ONE);
        invoiceLine.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        invoiceLine.setPrice(price);
        invoiceLine.saveEx();
        MLandedCost landedCost = new MLandedCost(Env.getCtx(), 0, this.getTrxName());
        landedCost.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
        landedCost.setM_CostElement_ID(DictionaryIDs.M_CostElement.FREIGHT.id);
        landedCost.setM_InOut_ID(receiptLine.getM_InOut_ID());
        landedCost.setM_InOutLine_ID(receiptLine.getM_InOutLine_ID());
        landedCost.setLandedCostDistribution("L");
        landedCost.saveEx();
        String error = landedCost.allocateCosts();
        Assertions.assertTrue((boolean)Util.isEmpty((String)error, (boolean)true), (String)error);
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        return invoiceLine;
    }

    private MInventoryLine createInventoryUse(Timestamp acctDate, int productId, BigDecimal qty) {
        MInventory inventory = new MInventory(Env.getCtx(), 0, this.getTrxName());
        inventory.setC_DocType_ID(DictionaryIDs.C_DocType.INTERNAL_USE_INVENTORY.id);
        inventory.setMovementDate(acctDate);
        inventory.saveEx();
        MInventoryLine inventoryLine = new MInventoryLine(Env.getCtx(), 0, this.getTrxName());
        inventoryLine.setM_Inventory_ID(inventory.get_ID());
        inventoryLine.setM_Product_ID(productId);
        inventoryLine.setQtyInternalUse(qty);
        inventoryLine.setC_Charge_ID(DictionaryIDs.C_Charge.COMMISSIONS.id);
        inventoryLine.setM_Locator_ID(DictionaryIDs.M_Locator.HQ.id);
        inventoryLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inventory, (String)"CO");
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)inventory.getDocStatus(), (String)"Unexpected Document Status");
        if (!inventory.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)inventory.getAD_Client_ID(), (int)inventory.get_Table_ID(), (int)inventory.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        inventory.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)inventory.isPosted());
        return inventoryLine;
    }

    private MInOutLine reverseInOut(MInOutLine iol, boolean accrual) {
        MInOut io = new MInOut(Env.getCtx(), iol.getM_InOut_ID(), this.getTrxName());
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)io, (String)(accrual ? "RA" : "RC"));
        io.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)io.getDocStatus(), (String)"Unexpected Document Status");
        MInOut reversal = new MInOut(Env.getCtx(), io.getReversal_ID(), this.getTrxName());
        if (!reversal.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)reversal.getAD_Client_ID(), (int)reversal.get_Table_ID(), (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        reversal.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)reversal.isPosted());
        MInOutLine[] reversalLines = reversal.getLines();
        return reversalLines[0];
    }

    private MInvoiceLine reverseLandedCost(MInvoiceLine il, boolean accrual) {
        MInvoice i = new MInvoice(Env.getCtx(), il.getC_Invoice_ID(), this.getTrxName());
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)i, (String)(accrual ? "RA" : "RC"));
        i.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)i.getDocStatus(), (String)"Unexpected Document Status");
        MInvoice reversal = new MInvoice(Env.getCtx(), i.getReversal_ID(), this.getTrxName());
        if (!reversal.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)reversal.getAD_Client_ID(), (int)reversal.get_Table_ID(), (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        reversal.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)reversal.isPosted());
        MInvoiceLine[] reversalLines = reversal.getLines();
        return reversalLines[0];
    }

    private MInventoryLine reverseInventory(MInventoryLine il, boolean accrual) {
        MInventory i = new MInventory(Env.getCtx(), il.getM_Inventory_ID(), this.getTrxName());
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)i, (String)(accrual ? "RA" : "RC"));
        i.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)i.getDocStatus(), (String)"Unexpected Document Status");
        MInventory reversal = new MInventory(Env.getCtx(), i.getReversal_ID(), this.getTrxName());
        if (!reversal.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)reversal.getAD_Client_ID(), (int)reversal.get_Table_ID(), (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        reversal.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)reversal.isPosted());
        MInventoryLine[] reversalLines = reversal.getLines(false);
        return reversalLines[0];
    }

    private MInvoiceLine createInvoiceForMR(MInOutLine receiptLine, BigDecimal price) {
        MInOut receipt = receiptLine.getParent();
        return this.createInvoiceForMR(receiptLine, receipt.getMovementDate(), price);
    }

    private MInvoiceLine createInvoiceForMR(MInOutLine receiptLine, Timestamp invoiceDate, BigDecimal price) {
        MMatchInv[] miList;
        MInOut receipt = receiptLine.getParent();
        MInvoice invoice = new MInvoice(receipt, invoiceDate);
        invoice.setC_DocTypeTarget_ID("API");
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setM_InOutLine_ID(receiptLine.get_ID());
        invoiceLine.setLine(10);
        invoiceLine.setProduct(receiptLine.getProduct());
        invoiceLine.setQty(receiptLine.getMovementQty());
        invoiceLine.setPrice(price);
        invoiceLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        int n = miList.length;
        int n2 = 0;
        while (n2 < n) {
            MMatchInv mi = mMatchInvArray[n2];
            if (!mi.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            mi.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)mi.isPosted());
            ++n2;
        }
        return invoiceLine;
    }

    private MInvoiceLine reverseInvoice(MInvoiceLine il, boolean accrual) {
        MMatchInv[] miList;
        MInvoice inv = new MInvoice(Env.getCtx(), il.getC_Invoice_ID(), this.getTrxName());
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)inv, (String)(accrual ? "RA" : "RC"));
        inv.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"RE", (Object)inv.getDocStatus(), (String)"Unexpected Document Status");
        MInvoice reversal = new MInvoice(Env.getCtx(), inv.getReversal_ID(), this.getTrxName());
        if (!reversal.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)reversal.getAD_Client_ID(), (int)reversal.get_Table_ID(), (int)reversal.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        reversal.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)reversal.isPosted());
        MMatchInv[] mMatchInvArray = miList = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)reversal.get_ID(), (String)this.getTrxName());
        int n = miList.length;
        int n2 = 0;
        while (n2 < n) {
            MMatchInv mi = mMatchInvArray[n2];
            if (!mi.isPosted()) {
                String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)mi.getAD_Client_ID(), (int)472, (int)mi.get_ID(), (boolean)false, (String)this.getTrxName());
                Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
            }
            mi.load(this.getTrxName(), new String[0]);
            Assertions.assertTrue((boolean)mi.isPosted());
            ++n2;
        }
        MInvoiceLine[] reversalLines = reversal.getLines();
        return reversalLines[0];
    }

    public static void validateCostDetail(MCostDetail cd, Timestamp dateAcct, boolean isBackDate, BigDecimal currentCostPrice) {
        Assertions.assertEquals((Object)cd.getDateAcct(), (Object)dateAcct, (String)"Unexpected MCostDetail DateAcct");
        Assertions.assertEquals((Object)cd.isBackDate(), (Object)isBackDate, (String)"Unexpected MCostDetail IsBackDate");
        if (currentCostPrice != null) {
            Assertions.assertEquals((Object)cd.getCurrentCostPrice().setScale(currentCostPrice.scale(), RoundingMode.HALF_UP), (Object)currentCostPrice, (String)"Unexpected MCostDetail CurrentCostPrice");
        }
        if (isBackDate) {
            Assertions.assertNotNull((Object)cd.getBackDateProcessedOn(), (String)"Unexpected MCostDetail DateBackDateProcess");
        }
    }

    private void configureAcctSchema(MAcctSchema as) {
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)"A", (String)"Default costing method not Average PO");
        if (as.getBackDateDay() < 3) {
            String sql = "UPDATE C_AcctSchema SET BackDateDay=? WHERE C_AcctSchema_ID=?";
            DB.executeUpdate((String)sql, (Object[])new Object[]{3, as.getC_AcctSchema_ID()}, (boolean)false, (String)this.getTrxName());
            as.load(this.getTrxName(), new String[0]);
        }
        Assertions.assertTrue((as.getBackDateDay() >= 3 ? 1 : 0) != 0, (String)"Unexpected MAcctSchema BackDateDay");
    }
}

