/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.net.URI;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Uris;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractUriAssert<SELF extends AbstractUriAssert<SELF>>
extends AbstractAssert<SELF, URI> {
    @VisibleForTesting
    protected Uris uris = Uris.instance();

    protected AbstractUriAssert(URI actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF hasPath(String expected) {
        this.uris.assertHasPath(this.info, (URI)this.actual, expected);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoPath() {
        this.uris.assertHasPath(this.info, (URI)this.actual, null);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasPort(int expected) {
        this.uris.assertHasPort(this.info, (URI)this.actual, expected);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoPort() {
        this.uris.assertHasPort(this.info, (URI)this.actual, -1);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasHost(String expected) {
        this.uris.assertHasHost(this.info, (URI)this.actual, expected);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoHost() {
        this.uris.assertHasNoHost(this.info, (URI)this.actual);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasAuthority(String expected) {
        this.uris.assertHasAuthority(this.info, (URI)this.actual, expected);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasFragment(String expected) {
        this.uris.assertHasFragment(this.info, (URI)this.actual, expected);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoFragment() {
        this.uris.assertHasFragment(this.info, (URI)this.actual, null);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasQuery(String expected) {
        this.uris.assertHasQuery(this.info, (URI)this.actual, expected);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoQuery() {
        this.uris.assertHasQuery(this.info, (URI)this.actual, null);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasScheme(String expected) {
        this.uris.assertHasScheme(this.info, (URI)this.actual, expected);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasUserInfo(String expected) {
        this.uris.assertHasUserInfo(this.info, (URI)this.actual, expected);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoUserInfo() {
        this.uris.assertHasUserInfo(this.info, (URI)this.actual, null);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasParameter(String name) {
        this.uris.assertHasParameter(this.info, (URI)this.actual, name);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasParameter(String name, String value) {
        this.uris.assertHasParameter(this.info, (URI)this.actual, name, value);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoParameters() {
        this.uris.assertHasNoParameters(this.info, (URI)this.actual);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoParameter(String name) {
        this.uris.assertHasNoParameter(this.info, (URI)this.actual, name);
        return (SELF)((AbstractUriAssert)this.myself);
    }

    public SELF hasNoParameter(String name, String value) {
        this.uris.assertHasNoParameter(this.info, (URI)this.actual, name, value);
        return (SELF)((AbstractUriAssert)this.myself);
    }
}

