/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.impl.LabelImageElement;

public class Listcell
extends LabelImageElement {
    private Object _value;
    private AuxInfo _auxinf;

    public Listcell() {
    }

    public Listcell(String label) {
        super(label);
    }

    public Listcell(String label, String src) {
        super(label, src);
    }

    public Listbox getListbox() {
        Component comp = this.getParent();
        return comp != null ? (Listbox)comp.getParent() : null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-listcell" : this._zclass;
    }

    @Override
    public Object clone() {
        Listcell clone = (Listcell)((Object)super.clone());
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    public Listheader getListheader() {
        List lcschs;
        int j;
        Listhead lcs;
        Listbox listbox = this.getListbox();
        if (listbox != null && (lcs = listbox.getListhead()) != null && (j = this.getColumnIndex()) < (lcschs = lcs.getChildren()).size()) {
            return (Listheader)((Object)lcschs.get(j));
        }
        return null;
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    public int getMaxlength() {
        Listbox listbox = this.getListbox();
        if (listbox == null) {
            return 0;
        }
        if (listbox.inSelectMold()) {
            return listbox.getMaxlength();
        }
        Listheader lc = this.getListheader();
        return lc != null ? lc.getMaxlength() : 0;
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        this._value = value;
    }

    public int getSpan() {
        return this._auxinf != null ? this._auxinf.span : 1;
    }

    public void setSpan(int span) {
        if (this.getSpan() != span) {
            this.initAuxInfoForListcell().span = span;
            this.smartUpdate("span", this.getSpan());
        }
    }

    public void setHflex(String flex) {
    }

    public void setWidth(String width) {
        throw new UnsupportedOperationException("Set listheader's width instead");
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this.getSpan() > 1) {
            renderer.render("span", this.getSpan());
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Listitem)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    private AuxInfo initAuxInfoForListcell() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private int span = 1;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

