/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.AsynchronousFilllListener;
import net.sf.jasperreports.engine.fill.FillHandle;
import net.sf.jasperreports.engine.fill.FillListener;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncJasperPrintAccessor
implements JasperPrintAccessor,
AsynchronousFilllListener,
FillListener {
    private static final Log log = LogFactory.getLog(AsyncJasperPrintAccessor.class);
    public static final String EXCEPTION_MESSAGE_KEY_LOCK_ATTEMPT_INTERRUPTED = "web.servlets.lock.attempt.interrupted";
    public static final String EXCEPTION_MESSAGE_KEY_NO_JASPERPRINT_GENERATED = "web.servlets.no.jasperprint.generated";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_CANCELLED = "web.servlets.report.generation.cancelled";
    public static final String EXCEPTION_MESSAGE_KEY_ASYNC_REPORT_GENERATION_ERROR = "web.servlets.async.report.generation.error";
    private FillHandle fillHandle;
    private final Lock lock;
    private final Condition pageCondition;
    private final Map<Integer, Long> trackedPages = new HashMap<Integer, Long>();
    private volatile boolean done;
    private boolean cancelled;
    private Throwable error;
    private volatile JasperPrint jasperPrint;
    private int pageCount;

    public AsyncJasperPrintAccessor(FillHandle fillHandle) {
        this.fillHandle = fillHandle;
        this.lock = new ReentrantLock(true);
        this.pageCondition = this.lock.newCondition();
        fillHandle.addListener(this);
        fillHandle.addFillListener(this);
    }

    protected void lock() {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_LOCK_ATTEMPT_INTERRUPTED, null, e);
        }
    }

    protected void unlock() {
        this.lock.unlock();
    }

    @Override
    public ReportPageStatus pageStatus(int pageIdx, Long pageTimestamp) {
        boolean modified;
        long timestamp;
        if (!this.done) {
            this.lock();
            try {
                while (!this.done && pageIdx >= this.pageCount) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("waiting for page " + pageIdx));
                    }
                    this.pageCondition.await();
                }
            }
            catch (InterruptedException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                this.unlock();
            }
        }
        if (pageIdx >= this.pageCount) {
            return ReportPageStatus.NO_SUCH_PAGE;
        }
        if (this.done || this.fillHandle.isPageFinal(pageIdx)) {
            this.trackedPages.remove(pageIdx);
            return ReportPageStatus.PAGE_FINAL;
        }
        Long lastUpdate = this.trackedPages.get(pageIdx);
        if (lastUpdate == null) {
            timestamp = System.currentTimeMillis();
            modified = true;
        } else {
            timestamp = lastUpdate;
            modified = pageTimestamp == null || pageTimestamp < lastUpdate;
        }
        ReportPageStatus status = ReportPageStatus.nonFinal(timestamp, modified);
        this.trackedPages.put(pageIdx, timestamp);
        return status;
    }

    @Override
    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForFinalJasperPrint(int milliseconds) {
        if (!this.done) {
            this.lock();
            try {
                long waitNanos = TimeUnit.MILLISECONDS.toNanos(milliseconds);
                while (!this.done && waitNanos > 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"waiting for report end");
                    }
                    waitNanos = this.pageCondition.awaitNanos(waitNanos);
                }
            }
            catch (InterruptedException e) {
                log.error((Object)"Error while waiting for final JasperPrint", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return this.done;
    }

    @Override
    public JasperPrint getFinalJasperPrint() {
        if (!this.done) {
            this.lock();
            try {
                while (!this.done) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"waiting for report end");
                    }
                    this.pageCondition.await();
                }
            }
            catch (InterruptedException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                this.unlock();
            }
        }
        if (this.error != null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_ASYNC_REPORT_GENERATION_ERROR, null, this.error);
        }
        if (this.jasperPrint == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NO_JASPERPRINT_GENERATED, (Object[])null);
        }
        return this.jasperPrint;
    }

    @Override
    public void reportFinished(JasperPrint jasperPrint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"report finished");
        }
        this.lock();
        try {
            if (this.jasperPrint == null) {
                this.jasperPrint = jasperPrint;
            }
            this.pageCount = jasperPrint.getPages().size();
            this.done = true;
            this.fillHandle = null;
            this.trackedPages.clear();
            this.pageCondition.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void reportCancelled() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"report cancelled");
        }
        this.lock();
        try {
            this.cancelled = true;
            this.done = true;
            this.pageCount = this.jasperPrint == null ? 0 : this.jasperPrint.getPages().size();
            this.error = new JRRuntimeException(EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_CANCELLED, (Object[])null);
            this.fillHandle = null;
            this.pageCondition.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void reportFillError(Throwable t) {
        log.error((Object)"Error during report execution", t);
        this.lock();
        try {
            this.error = t;
            this.done = true;
            this.pageCount = this.jasperPrint == null ? 0 : this.jasperPrint.getPages().size();
            this.fillHandle = null;
            this.pageCondition.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void pageGenerated(JasperPrint jasperPrint, int pageIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("page " + pageIndex + " generated"));
        }
        this.lock();
        try {
            if (this.jasperPrint == null) {
                this.jasperPrint = jasperPrint;
            }
            this.pageCount = pageIndex + 1;
            this.pageCondition.signalAll();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pageUpdated(JasperPrint jasperPrint, int pageIndex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("page " + pageIndex + " updated"));
        }
        this.lock();
        try {
            if (this.trackedPages.containsKey(pageIndex)) {
                long timestamp = System.currentTimeMillis();
                this.trackedPages.put(pageIndex, timestamp);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public ReportExecutionStatus getReportStatus() {
        if (!this.done) {
            return ReportExecutionStatus.running(this.pageCount);
        }
        if (this.cancelled) {
            return ReportExecutionStatus.canceled(this.pageCount);
        }
        if (this.error != null) {
            return ReportExecutionStatus.error(this.pageCount, this.error);
        }
        return ReportExecutionStatus.finished(this.jasperPrint.getPages().size());
    }
}

