/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.ClasspathAwareDataAdapter;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.util.CompositeClassloader;

public abstract class AbstractClasspathAwareDataAdapterService
extends AbstractDataAdapterService {
    public static final String CURRENT_CLASS_LOADER = "CURRENT_CLASS_LOADER";

    public AbstractClasspathAwareDataAdapterService(ParameterContributorContext paramContribContext, ClasspathAwareDataAdapter dataAdapter) {
        super(paramContribContext, (DataAdapter)dataAdapter);
    }

    protected ClassLoader getClassLoader(ClassLoader cloader) {
        URL[] localURLs;
        Object obj = this.getJasperReportsContext().getValue(CURRENT_CLASS_LOADER);
        if (obj != null && obj instanceof ClassLoader) {
            cloader = (ClassLoader)obj;
        }
        if ((localURLs = this.getPathClassloader()) == null || localURLs.length == 0) {
            return cloader;
        }
        return new CompositeClassloader(new URLClassLoader(localURLs), cloader);
    }

    protected URL[] getPathClassloader() {
        ClasspathAwareDataAdapter dataAdapter = (ClasspathAwareDataAdapter)this.getDataAdapter();
        List<String> classpath = dataAdapter.getClasspath();
        if (classpath.isEmpty()) {
            return null;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath) {
            if (path == null || path.isEmpty()) continue;
            try {
                if (path.startsWith("\\w+?://")) {
                    urls.add(new URL(path));
                    continue;
                }
                urls.add(new URL("file", "", path));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (urls.isEmpty()) {
            return null;
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

