/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.imageprovider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.chrome.BrowserService;
import net.sf.jasperreports.chrome.Chrome;
import net.sf.jasperreports.chrome.ResourceManager;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.MapUtils;
import net.sf.jasperreports.components.map.imageprovider.AbstractMapElementImageProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.SimpleDataRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;

public class ChromeMapElementImageProvider
extends AbstractMapElementImageProvider {
    private static final Log log = LogFactory.getLog(ChromeMapElementImageProvider.class);
    private static final String PAGE_TEMPLATE_RESOURCE = "net/sf/jasperreports/components/map/resources/templates/ChromeMapPage.vm";
    private Boolean isEnabled = null;

    public boolean isEnabled(JasperReportsContext jasperReportsContext) {
        if (this.isEnabled == null) {
            Chrome chrome = Chrome.instance(jasperReportsContext);
            this.isEnabled = chrome.isEnabled();
        }
        return this.isEnabled;
    }

    @Override
    protected Renderable createRenderable(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) throws JRException {
        Renderable cachedRenderable = (Renderable)element.getParameterValue("cacheRenderer");
        if (cachedRenderable == null) {
            try {
                byte[] imageData = this.getImageData(jasperReportsContext, element);
                cachedRenderable = new SimpleDataRenderer(imageData, null);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Generating Chrome image for Map element failed!", (Throwable)e);
                }
                OnErrorTypeEnum onErrorType = element.getParameterValue("onErrorType") == null ? MapComponent.DEFAULT_ON_ERROR_TYPE : OnErrorTypeEnum.getByName((String)element.getParameterValue("onErrorType"));
                cachedRenderable = RendererUtil.getInstance(jasperReportsContext).handleImageError(e, onErrorType);
            }
            element.setParameterValue("cacheRenderer", cachedRenderable);
        }
        return cachedRenderable;
    }

    public byte[] getImageData(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) throws JRException {
        ResourceManager resourceManager = ResourceManager.instance();
        File tempFolder = resourceManager.getTempFolder(jasperReportsContext);
        File mapPageTempFile = null;
        try {
            byte[] data;
            mapPageTempFile = File.createTempFile("map_", ".html", tempFolder);
            String mapPage = this.getMapHtmlPage(jasperReportsContext, element);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(mapPageTempFile), StandardCharsets.UTF_8);){
                writer.write(mapPage);
            }
            Chrome chrome = Chrome.instance(jasperReportsContext);
            BrowserService service = chrome.getService();
            byte[] byArray = data = service.evaluateInPage(mapPageTempFile.toURI().toString(), null, page -> {
                Object resultValue = page.evaluatePromise("renderResult()");
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Got result from evaluating map page promise: " + resultValue));
                }
                byte[] imageData = null;
                if (resultValue != null) {
                    Map resultMap = (Map)resultValue;
                    int width = (Integer)resultMap.get("width");
                    int height = (Integer)resultMap.get("height");
                    float zoomFactor = 1.0f;
                    imageData = page.captureScreenshot(width, height, zoomFactor);
                }
                return imageData;
            });
            return byArray;
        }
        catch (IOException e) {
            throw new JRRuntimeException("Failed to create map page in temp folder " + tempFolder, e);
        }
        finally {
            boolean deleted;
            if (mapPageTempFile != null && !(deleted = mapPageTempFile.delete()) && log.isWarnEnabled()) {
                log.warn((Object)("Failed to delete map temp page " + mapPageTempFile));
            }
        }
    }

    public String getMapHtmlPage(JasperReportsContext jasperReportsContext, JRGenericPrintElement element) {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("elementWidth", element.getWidth());
        velocityContext.put("elementHeight", element.getHeight());
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            velocityContext.put("backgroundColor", JRColorUtil.getColorHexa(element.getBackcolor()));
        }
        velocityContext.put("jasperreportsMapApiScript", VelocityUtil.processTemplate("net/sf/jasperreports/components/map/resources/scripts/jasperreportsMapApi.js", (VelocityContext)null));
        MapUtils.prepareContextForVelocityTemplate(velocityContext, jasperReportsContext, element);
        return VelocityUtil.processTemplate(PAGE_TEMPLATE_RESOURCE, velocityContext);
    }
}

