/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmt;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;
import org.zkoss.poi.ss.usermodel.BuiltinFormats;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.DxfCellStyle;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.HorizontalAlignment;
import org.zkoss.poi.ss.usermodel.IndexedColors;
import org.zkoss.poi.ss.usermodel.VerticalAlignment;
import org.zkoss.poi.xssf.model.StylesTable;
import org.zkoss.poi.xssf.model.ThemesTable;
import org.zkoss.poi.xssf.usermodel.XSSFColor;
import org.zkoss.poi.xssf.usermodel.XSSFDataFormat;
import org.zkoss.poi.xssf.usermodel.XSSFFont;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellFill;

public class XSSFDxfCellStyle
implements DxfCellStyle {
    private int _dxfId;
    private StylesTable _stylesSource;
    private CTDxf _ctDxf;
    private XSSFFont _font;
    private XSSFCellAlignment _cellAlignment;
    private ThemesTable _theme;

    public XSSFDxfCellStyle(int dxfId, StylesTable stylesSource, ThemesTable theme) {
        this._dxfId = dxfId;
        this._stylesSource = stylesSource;
        this._ctDxf = stylesSource.getDxfAt(dxfId);
        this._theme = theme;
        if (this._ctDxf.isSetFont()) {
            this._font = new XSSFFont(this._ctDxf.getFont());
        }
        if (this._ctDxf.isSetAlignment()) {
            this._cellAlignment = new XSSFCellAlignment(this._ctDxf.getAlignment());
        }
    }

    public void setIndex(int dxfId) {
        this._dxfId = dxfId;
    }

    public XSSFDxfCellStyle(StylesTable stylesSource, ThemesTable theme) {
        this._stylesSource = stylesSource;
        this._ctDxf = CTDxf.Factory.newInstance();
        this._theme = theme;
    }

    public XSSFDxfCellStyle(StylesTable stylesSource) {
        this._stylesSource = stylesSource;
        this._ctDxf = CTDxf.Factory.newInstance();
    }

    public CTDxf getDxf() {
        return this._ctDxf;
    }

    @Override
    public int getIndex() {
        return this._dxfId;
    }

    @Override
    public void setDataFormat(short fmt) {
        if (this._ctDxf.isSetNumFmt()) {
            this._ctDxf.unsetNumFmt();
        }
        if (fmt >= 0) {
            CTNumFmt numFmt = this._ctDxf.addNewNumFmt();
            numFmt.setNumFmtId((long)fmt);
            numFmt.setFormatCode(new XSSFDataFormat(this._stylesSource).getRawFormat(fmt));
        }
    }

    @Override
    public short getDataFormat() {
        if (this._ctDxf.isSetNumFmt()) {
            return (short)this._ctDxf.getNumFmt().getNumFmtId();
        }
        return 0;
    }

    @Override
    public String getDataFormatString() {
        short idx = this.getDataFormat();
        return new XSSFDataFormat(this._stylesSource).getFormat(idx);
    }

    @Override
    public String getRawDataFormatString() {
        String val = null;
        if (this._ctDxf.isSetNumFmt()) {
            val = this._ctDxf.getNumFmt().getFormatCode();
        }
        return val;
    }

    @Override
    public boolean isBuiltinDataFormat() {
        short idx = this.getDataFormat();
        return this._stylesSource.getNumberFormatAt(idx) == null && BuiltinFormats.getBuiltinFormat(idx) != null;
    }

    @Override
    public void setFont(Font font) {
        if (this._ctDxf.isSetFont()) {
            this._ctDxf.unsetFont();
        }
        if (font != null) {
            XSSFFont font0 = (XSSFFont)font;
            this._ctDxf.setFont((CTFont)font0.getCTFont().copy());
        }
    }

    public XSSFFont getOrCreateFont() {
        if (this._font == null) {
            CTFont font = this._ctDxf.addNewFont();
            this._font = new XSSFFont(font);
        }
        return this._font;
    }

    @Override
    public short getFontIndex() {
        return -1;
    }

    @Override
    public void setHidden(boolean hidden) {
        if (!this._ctDxf.isSetProtection()) {
            this._ctDxf.addNewProtection();
        }
        this._ctDxf.getProtection().setHidden(hidden);
    }

    @Override
    public boolean getHidden() {
        if (this._ctDxf.isSetProtection() && this._ctDxf.getProtection().isSetHidden()) {
            return this._ctDxf.getProtection().getHidden();
        }
        return false;
    }

    @Override
    public void setLocked(boolean locked) {
        if (!this._ctDxf.isSetProtection()) {
            this._ctDxf.addNewProtection();
        }
        this._ctDxf.getProtection().setLocked(locked);
    }

    @Override
    public boolean getLocked() {
        if (this._ctDxf.isSetProtection() && this._ctDxf.getProtection().isSetLocked()) {
            return this._ctDxf.getProtection().getLocked();
        }
        return true;
    }

    @Override
    public void setAlignment(short align) {
        this.getCellAlignment().setHorizontal(HorizontalAlignment.values()[align]);
    }

    @Override
    public short getAlignment() {
        return (short)this.getAlignmentEnum().ordinal();
    }

    @Override
    public void setWrapText(boolean wrapped) {
        this.getCellAlignment().setWrapText(wrapped);
    }

    @Override
    public boolean getWrapText() {
        if (this._ctDxf.isSetAlignment()) {
            CTCellAlignment align = this._ctDxf.getAlignment();
            return align != null && align.getWrapText();
        }
        return false;
    }

    @Override
    public void setVerticalAlignment(short align) {
        this.getCellAlignment().setVertical(VerticalAlignment.values()[align]);
    }

    @Override
    public short getVerticalAlignment() {
        return (short)this.getVerticalAlignmentEnum().ordinal();
    }

    @Override
    public void setRotation(short rotation) {
        this.getCellAlignment().setTextRotation(rotation);
    }

    @Override
    public short getRotation() {
        if (this._ctDxf.isSetAlignment()) {
            CTCellAlignment align = this._ctDxf.getAlignment();
            return (short)(align == null ? 0L : align.getTextRotation());
        }
        return 0;
    }

    @Override
    public void setIndention(short indent) {
        this.getCellAlignment().setIndent(indent);
    }

    @Override
    public short getIndention() {
        if (this._ctDxf.isSetAlignment()) {
            CTCellAlignment align = this._ctDxf.getAlignment();
            return (short)(align == null ? 0L : align.getIndent());
        }
        return 0;
    }

    @Override
    public void setBorderLeft(short border) {
        if (border != 0 && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == 0) {
                if (ct.isSetLeft()) {
                    ct.unsetLeft();
                }
            } else {
                CTBorderPr pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
            }
        }
    }

    @Override
    public short getBorderLeft() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public void setBorderRight(short border) {
        if (border != 0 && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == 0) {
                if (ct.isSetRight()) {
                    ct.unsetRight();
                }
            } else {
                CTBorderPr pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
            }
        }
    }

    @Override
    public short getBorderRight() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetRight() ? ct.getRight().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public void setBorderTop(short border) {
        if (border != 0 && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == 0) {
                if (ct.isSetTop()) {
                    ct.unsetTop();
                }
            } else {
                CTBorderPr pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
            }
        }
    }

    @Override
    public short getBorderTop() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetTop() ? ct.getTop().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public void setBorderBottom(short border) {
        if (border != 0 && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == 0) {
                if (ct.isSetBottom()) {
                    ct.unsetBottom();
                }
            } else {
                CTBorderPr pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
            }
        }
    }

    @Override
    public short getBorderBottom() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetBottom() ? ct.getBottom().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public void setLeftBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setLeftBorderColor(clr);
    }

    @Override
    public short getLeftBorderColor() {
        XSSFColor clr = this.getLeftBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public void setRightBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setRightBorderColor(clr);
    }

    @Override
    public short getRightBorderColor() {
        XSSFColor clr = this.getRightBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public void setTopBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setTopBorderColor(clr);
    }

    @Override
    public short getTopBorderColor() {
        XSSFColor clr = this.getTopBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public void setBottomBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setBottomBorderColor(clr);
    }

    @Override
    public short getBottomBorderColor() {
        XSSFColor clr = this.getBottomBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public void setFillPattern(short fp) {
        CTFill ct;
        CTPatternFill ptrn;
        if (!this._ctDxf.isSetFill()) {
            if (fp == 0) {
                return;
            }
            this._ctDxf.addNewFill();
        }
        CTPatternFill cTPatternFill = ptrn = (ct = this._ctDxf.getFill()).isSetPatternFill() ? ct.getPatternFill() : ct.addNewPatternFill();
        if (fp == 0 && ptrn.isSetPatternType()) {
            ptrn.unsetPatternType();
        } else {
            ptrn.setPatternType(STPatternType.Enum.forInt((int)(fp + 1)));
        }
    }

    @Override
    public short getFillPattern() {
        CTFill fill;
        if (this._ctDxf.isSetFill() && (fill = this._ctDxf.getFill()).isSetPatternFill()) {
            CTPatternFill pf = fill.getPatternFill();
            STPatternType.Enum ptrn = pf.getPatternType();
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public void setFillBackgroundColor(short bg) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(bg);
        this.setFillBackgroundColor(clr);
    }

    @Override
    public short getFillBackgroundColor() {
        XSSFColor clr = this.getFillBackgroundXSSFColor();
        return clr == null ? IndexedColors.AUTOMATIC.getIndex() : clr.getIndexed();
    }

    @Override
    public Color getFillBackgroundColorColor() {
        return this.getFillBackgroundXSSFColor();
    }

    @Override
    public void setFillForegroundColor(short bg) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(bg);
        this.setFillForegroundColor(clr);
    }

    @Override
    public short getFillForegroundColor() {
        XSSFColor clr = this.getFillForegroundXSSFColor();
        return clr == null ? IndexedColors.AUTOMATIC.getIndex() : clr.getIndexed();
    }

    @Override
    public Color getFillForegroundColorColor() {
        return this.getFillForegroundXSSFColor();
    }

    @Override
    public void cloneStyleFrom(CellStyle source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Color getTopBorderColorColor() {
        return this.getTopBorderXSSFColor();
    }

    @Override
    public Color getBottomBorderColorColor() {
        return this.getBottomBorderXSSFColor();
    }

    @Override
    public Color getRightBorderColorColor() {
        return this.getRightBorderXSSFColor();
    }

    @Override
    public Color getLeftBorderColorColor() {
        return this.getLeftBorderXSSFColor();
    }

    @Override
    public void setFontColorColor(Color fontColor) {
        this.setFontColorColor((XSSFColor)fontColor);
    }

    private void setFontColorColor(XSSFColor color) {
        this.getOrCreateFont().setColor(color);
    }

    private void setBorderStyle(CTBorderPr bpr, short ordinal) {
        if (bpr != null) {
            if (ordinal != 0) {
                bpr.setStyle(STBorderStyle.Enum.forInt((int)(ordinal + 1)));
            } else if (bpr.isSetStyle()) {
                bpr.unsetStyle();
            }
        }
    }

    private void setBorderColor(CTBorderPr bpr, XSSFColor color) {
        if (bpr != null) {
            if (color == null) {
                if (bpr.isSetColor()) {
                    bpr.unsetColor();
                }
            } else {
                bpr.setColor(color.getCTColor());
            }
        }
    }

    @Override
    public void setBorder(short left, Color leftColor, short top, Color topColor, short right, Color rightColor, short bottom, Color bottomColor) {
        CTBorder ct;
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr lbpr = (ct = this._ctDxf.getBorder()).isSetLeft() ? ct.getLeft() : (left != 0 ? ct.addNewLeft() : null);
        this.setBorderStyle(lbpr, left);
        CTBorderPr tbpr = ct.isSetTop() ? ct.getTop() : (top != 0 ? ct.addNewTop() : null);
        this.setBorderStyle(tbpr, top);
        CTBorderPr rbpr = ct.isSetRight() ? ct.getRight() : (right != 0 ? ct.addNewRight() : null);
        this.setBorderStyle(rbpr, right);
        CTBorderPr bbpr = ct.isSetBottom() ? ct.getBottom() : (bottom != 0 ? ct.addNewBottom() : null);
        this.setBorderStyle(bbpr, bottom);
        this.setBorderColor(lbpr, (XSSFColor)leftColor);
        this.setBorderColor(tbpr, (XSSFColor)topColor);
        this.setBorderColor(rbpr, (XSSFColor)rightColor);
        this.setBorderColor(bbpr, (XSSFColor)bottomColor);
    }

    @Override
    public void setFill(Color fillColor, Color backColor, short patternType) {
        if (!this._ctDxf.isSetFill()) {
            this._ctDxf.addNewFill();
        }
        CTFill ct = this._ctDxf.getFill();
        XSSFCellFill fill = new XSSFCellFill(ct);
        XSSFColor fc = (XSSFColor)fillColor;
        XSSFColor bc = (XSSFColor)backColor;
        if (fc != null) {
            fill.setFillForegroundColor(fc);
        }
        if (bc != null) {
            fill.setFillBackgroundColor(bc);
        }
        if (patternType >= 0) {
            fill.setPatternType(STPatternType.Enum.forInt((int)(patternType + 1)));
        }
    }

    @Override
    @Deprecated
    public void setCellAlignment(short hAlign, short vAlign, boolean wrapText) {
        this.setCellAlignment(hAlign, vAlign, wrapText, (short)0);
    }

    @Override
    public void setCellAlignment(short hAlign, short vAlign, boolean wrapText, short rotation) {
        short defaultHAlign = 0;
        short defaultVAlign = 2;
        boolean defaultWrapText = false;
        short defaultRotation = 0;
        if (defaultHAlign != hAlign && hAlign != 0) {
            this.setAlignment(hAlign);
        }
        if (defaultVAlign != vAlign && vAlign != 2) {
            this.setVerticalAlignment(vAlign);
        }
        if (defaultWrapText != wrapText && wrapText) {
            this.setWrapText(wrapText);
        }
        if (defaultRotation != rotation && rotation != 0) {
            this.setRotation(rotation);
        }
    }

    @Override
    public void setProtection(boolean locked, boolean hidden) {
        boolean defaultLocked = true;
        boolean defaultHidden = false;
        if (locked != defaultLocked && !locked) {
            this.setLocked(locked);
        }
        if (hidden != defaultHidden && !hidden) {
            this.setHidden(hidden);
        }
    }

    protected XSSFCellAlignment getCellAlignment() {
        if (this._cellAlignment == null) {
            CTCellAlignment ctAlign = this._ctDxf.addNewAlignment();
            this._cellAlignment = new XSSFCellAlignment(ctAlign);
        }
        return this._cellAlignment;
    }

    protected HorizontalAlignment getAlignmentEnum() {
        CTCellAlignment align;
        if (this._ctDxf.isSetAlignment() && (align = this._ctDxf.getAlignment()).isSetHorizontal()) {
            return HorizontalAlignment.values()[align.getHorizontal().intValue() - 1];
        }
        return HorizontalAlignment.GENERAL;
    }

    public VerticalAlignment getVerticalAlignmentEnum() {
        CTCellAlignment align;
        if (this._ctDxf.isSetAlignment() && (align = this._ctDxf.getAlignment()).isSetVertical()) {
            return VerticalAlignment.values()[align.getVertical().intValue() - 1];
        }
        return VerticalAlignment.BOTTOM;
    }

    @Override
    public void setBorderHorizontal(short border) {
        if (border != 0 && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == 0) {
                if (ct.isSetHorizontal()) {
                    ct.unsetHorizontal();
                }
            } else {
                CTBorderPr pr = ct.isSetHorizontal() ? ct.getHorizontal() : ct.addNewHorizontal();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
            }
        }
    }

    @Override
    public short getBorderHorizontal() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetHorizontal() ? ct.getHorizontal().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public Color getHorizontalBorderColorColor() {
        return this.getHorizontalBorderXSSFColor();
    }

    @Override
    public void setHorizontalBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setHorizontalBorderColor(clr);
    }

    @Override
    public short getHorizontalBorderColor() {
        XSSFColor clr = this.getHorizontalBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public void setBorderVertical(short border) {
    }

    @Override
    public short getBorderVertical() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetVertical() ? ct.getVertical().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public Color getVerticalBorderColorColor() {
        return this.getVerticalBorderXSSFColor();
    }

    @Override
    public void setVerticalBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setVerticalBorderColor(clr);
    }

    @Override
    public short getVerticalBorderColor() {
        XSSFColor clr = this.getVerticalBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public void setBorderDiagonal(short border) {
        if (border != 0 && !this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            if (border == 0) {
                if (ct.isSetDiagonal()) {
                    ct.unsetDiagonal();
                }
            } else {
                CTBorderPr pr = ct.isSetDiagonal() ? ct.getDiagonal() : ct.addNewDiagonal();
                pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
            }
        }
    }

    @Override
    public short getBorderDiagonal() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder ct = this._ctDxf.getBorder();
            STBorderStyle.Enum ptrn = ct.isSetDiagonal() ? ct.getDiagonal().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public Color getDiagonalBorderColorColor() {
        return this.getDiagonalBorderXSSFColor();
    }

    @Override
    public void setDiagonalBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setDiagonalBorderColor(clr);
    }

    @Override
    public short getDiagonalBorderColor() {
        XSSFColor clr = this.getDiagonalBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    @Override
    public boolean isShowDiagonalUpBorder() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder border = this._ctDxf.getBorder();
            return border.getDiagonalUp();
        }
        return false;
    }

    @Override
    public boolean isShowDiagonalDownBorder() {
        if (this._ctDxf.isSetBorder()) {
            CTBorder border = this._ctDxf.getBorder();
            return border.getDiagonalDown();
        }
        return false;
    }

    @Override
    public void setShowDiagonalUpBorder(boolean up) {
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorder border = this._ctDxf.getBorder();
        border.setDiagonalUp(up);
    }

    @Override
    public void setShowDiagonalDownBorder(boolean down) {
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorder border = this._ctDxf.getBorder();
        border.setDiagonalDown(down);
    }

    public void setLeftBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetLeft())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setTopBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetTop())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetTop() ? ct.getTop() : ct.addNewTop();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setRightBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetRight())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetRight() ? ct.getRight() : ct.addNewRight();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setBottomBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetBottom())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setHorizontalBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetHorizontal())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetHorizontal() ? ct.getHorizontal() : ct.addNewHorizontal();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setVerticalBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetVertical())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetVertical() ? ct.getVertical() : ct.addNewVertical();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public void setDiagonalBorderColor(XSSFColor color) {
        CTBorder ct;
        CTBorderPr pr;
        if (!(color != null || this._ctDxf.isSetBorder() && this._ctDxf.getBorder().isSetDiagonal())) {
            return;
        }
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorderPr cTBorderPr = pr = (ct = this._ctDxf.getBorder()).isSetDiagonal() ? ct.getDiagonal() : ct.addNewDiagonal();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
    }

    public XSSFColor getLeftBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetLeft() && (pr = ct.getLeft()).isSetColor()) {
            CTColor color = pr.getColor();
            return new XSSFColor(color);
        }
        return null;
    }

    public XSSFColor getTopBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetTop() && (pr = ct.getTop()).isSetColor()) {
            CTColor color = pr.getColor();
            return new XSSFColor(color);
        }
        return null;
    }

    public XSSFColor getRightBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetRight() && (pr = ct.getRight()).isSetColor()) {
            CTColor color = pr.getColor();
            return new XSSFColor(color);
        }
        return null;
    }

    public XSSFColor getBottomBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetBottom() && (pr = ct.getBottom()).isSetColor()) {
            CTColor color = pr.getColor();
            return new XSSFColor(color);
        }
        return null;
    }

    public XSSFColor getHorizontalBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetHorizontal() && (pr = ct.getHorizontal()).isSetColor()) {
            CTColor color = pr.getColor();
            return new XSSFColor(color);
        }
        return null;
    }

    public XSSFColor getVerticalBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetVertical() && (pr = ct.getVertical()).isSetColor()) {
            CTColor color = pr.getColor();
            return new XSSFColor(color);
        }
        return null;
    }

    public XSSFColor getDiagonalBorderXSSFColor() {
        CTBorderPr pr;
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetDiagonal() && (pr = ct.getDiagonal()).isSetColor()) {
            CTColor color = pr.getColor();
            return new XSSFColor(color);
        }
        return null;
    }

    public void setFillForegroundColor(XSSFColor color) {
        if (!this._ctDxf.isSetFill()) {
            this._ctDxf.addNewFill();
        }
        CTFill ct = this._ctDxf.getFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetFgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setFgColor(color.getCTColor());
        }
    }

    public void setFillBackgroundColor(XSSFColor color) {
        if (!this._ctDxf.isSetFill()) {
            this._ctDxf.addNewFill();
        }
        CTFill ct = this._ctDxf.getFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetBgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setBgColor(color.getCTColor());
        }
    }

    public XSSFColor getFillBackgroundXSSFColor() {
        CTPatternFill pf;
        CTFill fill;
        if (this._ctDxf.isSetFill() && (fill = this._ctDxf.getFill()).isSetPatternFill() && (pf = fill.getPatternFill()).isSetBgColor()) {
            CTColor color = pf.getBgColor();
            return new XSSFColor(color);
        }
        return null;
    }

    public XSSFColor getFillForegroundXSSFColor() {
        CTPatternFill pf;
        CTFill fill;
        if (this._ctDxf.isSetFill() && (fill = this._ctDxf.getFill()).isSetPatternFill() && (pf = fill.getPatternFill()).isSetFgColor()) {
            CTColor color = pf.getFgColor();
            return new XSSFColor(color);
        }
        return null;
    }

    @Override
    public void setBorder(short left, Color leftColor, short top, Color topColor, short right, Color rightColor, short bottom, Color bottomColor, short diagonal, Color diagonalColor, short horizontal, Color horizontalColor, short vertical, Color verticalColor, boolean diaUp, boolean diaDown) {
        if (!this._ctDxf.isSetBorder()) {
            this._ctDxf.addNewBorder();
        }
        CTBorder ct = this._ctDxf.getBorder();
        if (diagonal >= 0) {
            ct.setDiagonalUp(diaUp);
            ct.setDiagonalDown(diaDown);
        }
        CTBorderPr lbpr = ct.isSetLeft() ? ct.getLeft() : (left >= 0 ? ct.addNewLeft() : null);
        this.setBorderStyle(lbpr, left);
        CTBorderPr tbpr = ct.isSetTop() ? ct.getTop() : (top >= 0 ? ct.addNewTop() : null);
        this.setBorderStyle(tbpr, top);
        CTBorderPr rbpr = ct.isSetRight() ? ct.getRight() : (right >= 0 ? ct.addNewRight() : null);
        this.setBorderStyle(rbpr, right);
        CTBorderPr bbpr = ct.isSetBottom() ? ct.getBottom() : (bottom >= 0 ? ct.addNewBottom() : null);
        this.setBorderStyle(bbpr, bottom);
        CTBorderPr dbpr = ct.isSetDiagonal() ? ct.getDiagonal() : (diagonal >= 0 ? ct.addNewDiagonal() : null);
        this.setBorderStyle(dbpr, diagonal);
        CTBorderPr vbpr = ct.isSetVertical() ? ct.getVertical() : (vertical >= 0 ? ct.addNewVertical() : null);
        this.setBorderStyle(vbpr, vertical);
        CTBorderPr hbpr = ct.isSetHorizontal() ? ct.getHorizontal() : (horizontal >= 0 ? ct.addNewHorizontal() : null);
        this.setBorderStyle(hbpr, horizontal);
        this.setBorderColor(lbpr, (XSSFColor)leftColor);
        this.setBorderColor(tbpr, (XSSFColor)topColor);
        this.setBorderColor(rbpr, (XSSFColor)rightColor);
        this.setBorderColor(bbpr, (XSSFColor)bottomColor);
        this.setBorderColor(hbpr, (XSSFColor)horizontalColor);
        this.setBorderColor(vbpr, (XSSFColor)verticalColor);
        this.setBorderColor(dbpr, (XSSFColor)diagonalColor);
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    @Override
    public short getRawFillPattern() {
        CTFill fill;
        if (this._ctDxf.isSetFill() && (fill = this._ctDxf.getFill()).isSetPatternFill()) {
            CTPatternFill pf = fill.getPatternFill();
            STPatternType.Enum ptrn = pf.getPatternType();
            return ptrn == null ? (short)-1 : (short)(ptrn.intValue() - 1);
        }
        return -1;
    }

    @Override
    public Color getRawFillForegroundColor() {
        return this.getFillForegroundXSSFColor();
    }

    @Override
    public Color getRawFillBackgroundColor() {
        return this.getFillBackgroundXSSFColor();
    }

    @Override
    public short getRawBorderLeft() {
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetLeft()) {
            STBorderStyle.Enum ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return -1;
    }

    @Override
    public short getRawBorderTop() {
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetTop()) {
            STBorderStyle.Enum ptrn = ct.isSetTop() ? ct.getTop().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return -1;
    }

    @Override
    public short getRawBorderRight() {
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetRight()) {
            STBorderStyle.Enum ptrn = ct.isSetRight() ? ct.getRight().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return -1;
    }

    @Override
    public short getRawBorderBottom() {
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetBottom()) {
            STBorderStyle.Enum ptrn = ct.isSetBottom() ? ct.getBottom().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return -1;
    }

    @Override
    public short getRawBorderDiagonal() {
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetDiagonal()) {
            STBorderStyle.Enum ptrn = ct.isSetDiagonal() ? ct.getDiagonal().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return -1;
    }

    @Override
    public short getRawBorderHorizontal() {
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetHorizontal()) {
            STBorderStyle.Enum ptrn = ct.isSetHorizontal() ? ct.getHorizontal().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return -1;
    }

    @Override
    public short getRawBorderVertical() {
        CTBorder ct;
        if (this._ctDxf.isSetBorder() && (ct = this._ctDxf.getBorder()).isSetVertical()) {
            STBorderStyle.Enum ptrn = ct.isSetVertical() ? ct.getVertical().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return -1;
    }

    @Override
    public Color getRawBorderLeftColor() {
        return this.getLeftBorderXSSFColor();
    }

    @Override
    public Color getRawBorderTopColor() {
        return this.getTopBorderXSSFColor();
    }

    @Override
    public Color getRawBorderRightColor() {
        return this.getRightBorderXSSFColor();
    }

    @Override
    public Color getRawBorderBottomColor() {
        return this.getBottomBorderXSSFColor();
    }

    @Override
    public Color getRawBorderDiagonalColor() {
        return this.getDiagonalBorderXSSFColor();
    }

    @Override
    public Color getRawBorderVerticalColor() {
        return this.getVerticalBorderXSSFColor();
    }

    @Override
    public Color getRawBorderHorizontalColor() {
        return this.getHorizontalBorderXSSFColor();
    }

    @Override
    public boolean isOverrideBorder() {
        return this._ctDxf.isSetBorder();
    }
}

