/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractUndoableAction;

public class ResizeHeaderAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = -4685070960700584779L;
    int[] _oldSizes;
    final Type _type;
    final int _size;
    boolean _isCustom = true;

    public ResizeHeaderAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, Type type, int size, boolean isCustom) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._type = type;
        this._size = size;
        this._isCustom = isCustom;
    }

    @Override
    public void doAction() {
        if (this.isSheetProtected()) {
            return;
        }
        if (this._type == Type.ROW) {
            this._oldSizes = new int[this._lastRow - this._row + 1];
            for (int i = this._row; i <= this._lastRow; ++i) {
                this._oldSizes[i - this._row] = this._sheet.getRowHeight(i);
            }
            CellOperationUtil.setRowHeight(Ranges.range(this._sheet, this._row, 0, this._lastRow, 0).toRowRange(), this._size, this._isCustom);
        } else {
            this._oldSizes = new int[this._lastColumn - this._column + 1];
            for (int i = this._column; i <= this._lastColumn; ++i) {
                this._oldSizes[i - this._column] = this._sheet.getColumnWidth(i);
            }
            CellOperationUtil.setColumnWidth(Ranges.range(this._sheet, 0, this._column, 0, this._lastColumn).toColumnRange(), this._size);
        }
    }

    @Override
    public boolean isUndoable() {
        return this._oldSizes != null && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public boolean isRedoable() {
        return this._oldSizes == null && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public void undoAction() {
        if (this.isSheetProtected()) {
            return;
        }
        if (this._oldSizes != null) {
            if (this._type == Type.ROW) {
                for (int i = this._row; i <= this._lastRow; ++i) {
                    CellOperationUtil.setRowHeight(Ranges.range(this._sheet, i, 0, i, 0).toRowRange(), this._oldSizes[i - this._row], this._isCustom);
                }
            } else {
                for (int i = this._column; i <= this._lastColumn; ++i) {
                    CellOperationUtil.setColumnWidth(Ranges.range(this._sheet, 0, i, 0, i).toColumnRange(), this._oldSizes[i - this._column]);
                }
            }
            this._oldSizes = null;
        }
    }

    @Override
    protected boolean isSheetProtected() {
        Range range = Ranges.range(this._sheet);
        return !(!super.isSheetProtected() || this._type == Type.COLUMN && range.getSheetProtection().isFormatColumnsAllowed() || this._type == Type.ROW && range.getSheetProtection().isFormatRowsAllowed());
    }

    public static enum Type {
        ROW,
        COLUMN;

    }
}

