/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.model.SSheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.AuDataUtil;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.au.in.Commands;
import io.keikai.ui.event.HeaderMouseEvent;
import io.keikai.ui.event.HeaderType;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class HeaderMouseCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        Map data = request.getData();
        if (data == null || data.size() != 9) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        String sheetId = (String)data.get("sheetId");
        SSheet sheet = ((Spreadsheet)comp).getSelectedSSheet();
        if (!sheet.getId().equals(sheetId)) {
            return;
        }
        String type = (String)data.get("type");
        int shx = AuDataUtil.getInt(data, "shx");
        int shy = AuDataUtil.getInt(data, "shy");
        int key = Commands.parseKeys((String)data.get("key"));
        int row = (Integer)data.get("row");
        int col = (Integer)data.get("col");
        int mx = AuDataUtil.getInt(data, "mx");
        int my = AuDataUtil.getInt(data, "my");
        if ("lc".equals(type)) {
            type = "onHeaderClick";
        } else if ("rc".equals(type)) {
            type = "onHeaderRightClick";
        } else if ("dbc".equals(type)) {
            type = "onHeaderDoubleClick";
        } else {
            throw new UiException("unknow type : " + type);
        }
        HeaderType htype = row == -1 ? HeaderType.COLUMN : HeaderType.ROW;
        int index = row == -1 ? col : row;
        Events.postEvent((Event)new HeaderMouseEvent(type, comp, shx, shy, key, sheet, htype, index, mx, my));
    }
}

