/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.impl.RangeImpl;
import io.keikai.api.model.EditableCellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.range.SRange;
import io.keikai.range.impl.PasteRangeImpl;
import io.keikai.ui.impl.undo.Abstract2DCellDataStyleAction;

public class CutCellAction
extends Abstract2DCellDataStyleAction {
    private static final long serialVersionUID = -7964993492937174380L;
    protected final int _reservedDestLastRow;
    protected final int _reservedDestLastColumn;
    private Range _pastedRange;

    public CutCellAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, boolean srcWholeColumn, boolean srcWholeRow, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, boolean destWholeColumn, boolean destWholeRow) {
        super(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, srcWholeColumn, srcWholeRow, destSheet, destRow, destColumn, destLastRow, destLastColumn, destWholeColumn, destWholeRow, 7);
        this._reservedDestLastRow = this._destRow + Math.max(destLastRow - destRow, srcLastRow - srcRow);
        this._reservedDestLastColumn = this._destColumn + Math.max(destLastColumn - destColumn, srcLastColumn - srcColumn);
    }

    @Deprecated
    public CutCellAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, boolean srcWholeColumn, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, boolean destWholeColumn) {
        this(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, srcWholeColumn, false, destSheet, destRow, destColumn, destLastRow, destLastColumn, destWholeColumn, false);
    }

    @Deprecated
    public CutCellAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn) {
        this(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, false, false, destSheet, destRow, destColumn, destLastRow, destLastColumn, false, false);
    }

    @Override
    protected int getReservedDestLastRow() {
        return this._reservedDestLastRow;
    }

    @Override
    protected int getReservedDestLastColumn() {
        return this._reservedDestLastColumn;
    }

    @Override
    protected void applyAction() {
        RangeImpl src = new RangeImpl((SRange)new PasteRangeImpl(this._sheet.getInternalSheet(), this._row, this._column, this._lastRow, this._lastColumn, this._wholeRow, this._wholeColumn), this._sheet);
        RangeImpl dest = new RangeImpl((SRange)new PasteRangeImpl(this._destSheet.getInternalSheet(), this._destRow, this._destColumn, this._destLastRow, this._destLastColumn, this._wholeRow, this._destWholeColumn), this._destSheet);
        this._pastedRange = CellOperationUtil.cut(src, dest);
        if (this.isSrcSheetProtected()) {
            EditableCellStyle recoveredStyle = src.getCellStyleHelper().createCellStyle(src.getCellStyle());
            recoveredStyle.setLocked(false);
            src.setCellStyle(recoveredStyle);
        }
        CellOperationUtil.fitFontHeightPoints(Ranges.range(this._destSheet, dest.getRow(), dest.getColumn(), dest.getRow() + (this._lastRow - this._row), dest.getColumn() + (this._lastColumn - this._column)));
    }

    @Override
    public AreaRef getUndoSelection() {
        return this._pastedRange == null ? super.getUndoSelection() : new AreaRef(this._pastedRange.getRow(), this._pastedRange.getColumn(), this._pastedRange.getLastRow(), this._pastedRange.getLastColumn());
    }

    @Override
    public AreaRef getRedoSelection() {
        return this._pastedRange == null ? super.getRedoSelection() : new AreaRef(this._pastedRange.getRow(), this._pastedRange.getColumn(), this._pastedRange.getLastRow(), this._pastedRange.getLastColumn());
    }
}

