/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.IllegalFormulaException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.CellData;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractUndoableAction;

public abstract class AbstractEditTextAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = -6522834005902486990L;
    private String[][] oldTexts = null;
    private boolean[][] isRichTexts = null;
    private boolean[][] isWrapTexts = null;

    public AbstractEditTextAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn) {
        super(label, sheet, row, column, lastRow, lastColumn);
    }

    protected Sheet getReservedSheet() {
        return this._sheet;
    }

    protected int getReservedRow() {
        return this._row;
    }

    protected int getReservedColumn() {
        return this._column;
    }

    protected int getReservedLastRow() {
        return this._lastRow;
    }

    protected int getReservedLastColumn() {
        return this._lastColumn;
    }

    @Override
    public void doAction() {
        int row = this.getReservedRow();
        int column = this.getReservedColumn();
        int lastRow = this.getReservedLastRow();
        int lastColumn = this.getReservedLastColumn();
        Sheet sheet = this.getReservedSheet();
        this.oldTexts = new String[lastRow - row + 1][lastColumn - column + 1];
        this.isRichTexts = new boolean[lastRow - row + 1][lastColumn - column + 1];
        this.isWrapTexts = new boolean[lastRow - row + 1][lastColumn - column + 1];
        for (int i = row; i <= lastRow; ++i) {
            for (int j = column; j <= lastColumn; ++j) {
                Range r = Ranges.range(sheet, i, j);
                CellData d = r.getCellData();
                if (d.isBlank()) {
                    this.oldTexts[i - row][j - column] = null;
                    continue;
                }
                String richText = d.getRichText();
                this.isWrapTexts[i - row][j - column] = r.getCellStyle().isWrapText();
                if (richText != null) {
                    this.isRichTexts[i - row][j - column] = true;
                    this.oldTexts[i - row][j - column] = richText;
                    continue;
                }
                this.oldTexts[i - row][j - column] = d.getEditText();
            }
        }
        this.applyAction();
    }

    protected boolean isRangeProtected() {
        boolean protect = this.isSheetProtected();
        if (!protect) {
            return false;
        }
        for (int i = this._row; i <= this._lastRow; ++i) {
            for (int j = this._column; j <= this._lastColumn; ++j) {
                Range r = Ranges.range(this._sheet, i, j);
                boolean lock = r.getCellStyle().isLocked();
                if (!lock) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract void applyAction();

    @Override
    public boolean isUndoable() {
        return this.oldTexts != null && this.isSheetAvailable() && !this.isRangeProtected();
    }

    @Override
    public boolean isRedoable() {
        return this.oldTexts == null && this.isSheetAvailable() && !this.isRangeProtected();
    }

    @Override
    public void undoAction() {
        if (this.isRangeProtected()) {
            return;
        }
        int row = this.getReservedRow();
        int column = this.getReservedColumn();
        int lastRow = this.getReservedLastRow();
        int lastColumn = this.getReservedLastColumn();
        Sheet sheet = this.getReservedSheet();
        for (int i = row; i <= lastRow; ++i) {
            for (int j = column; j <= lastColumn; ++j) {
                Range r = Ranges.range(sheet, i, j);
                try {
                    CellOperationUtil.applyWrapText(r, this.isWrapTexts[i - row][j - column]);
                    if (this.isRichTexts[i - row][j - column]) {
                        r.setCellRichText(this.oldTexts[i - row][j - column]);
                        continue;
                    }
                    r.setCellEditText(this.oldTexts[i - row][j - column]);
                    continue;
                }
                catch (IllegalFormulaException illegalFormulaException) {
                    // empty catch block
                }
            }
        }
        this.oldTexts = null;
        this.isRichTexts = null;
    }
}

