/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range;

import io.keikai.model.CellRegion;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.SBook;
import io.keikai.model.SName;
import io.keikai.model.SSheet;
import io.keikai.model.SheetRegion;
import io.keikai.range.SRange;
import io.keikai.range.impl.RangeImpl;

public class SRanges {
    public static SRange range(SSheet sheet) {
        return new RangeImpl(sheet);
    }

    public static SRange range(SSheet sheet, String areaReference) {
        SheetRegion region = new SheetRegion(sheet, areaReference);
        return new RangeImpl(sheet, region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
    }

    public static SRange range(SSheet sheet, CellRegion region) {
        return new RangeImpl(sheet, region);
    }

    public static SRange rangeByName(SSheet sheet, String name) {
        SBook book = sheet.getBook();
        SName n = book.getNameByName(name, sheet.getSheetName());
        if (n == null) {
            n = book.getNameByName(name, null);
        }
        if (n == null) {
            throw new InvalidModelOpException("can't find name " + name);
        }
        sheet = book.getSheetByName(n.getRefersToSheetName());
        CellRegion region = n.getRefersToCellRegion();
        if (sheet == null || region == null) {
            throw new InvalidModelOpException("bad name " + name + " : " + n.getRefersToFormula());
        }
        return new RangeImpl(sheet, region.row, region.column, region.lastRow, region.lastColumn);
    }

    public static SRange range(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        return new RangeImpl(sheet, tRow, lCol, bRow, rCol);
    }

    public static SRange range(SSheet sheet, int row, int col) {
        return new RangeImpl(sheet, row, col);
    }

    public static SRange range(SBook book) {
        return new RangeImpl(book);
    }
}

