/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractCellStyleAdv;
import io.keikai.model.impl.AbstractRowAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.CellImpl;
import io.keikai.model.impl.CellProxy;
import io.keikai.model.impl.CellStyleImpl;
import io.keikai.model.impl.IndexPool;
import io.keikai.model.impl.ModelUpdateUtil;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.util.Validations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class RowImpl
extends AbstractRowAdv {
    private static final long serialVersionUID = 1L;
    private AbstractSheetAdv _sheet;
    private int _index;
    private final IndexPool<SCell> cells = new IndexPool<SCell>(){
        private static final long serialVersionUID = 1L;

        @Override
        void resetIndex(int newidx, SCell obj) {
            ((AbstractCellAdv)obj).setIndex(newidx);
        }
    };
    private AbstractCellStyleAdv cellStyle;
    private Integer height;
    private boolean hidden = false;
    private boolean customHeight = false;

    public RowImpl(AbstractSheetAdv sheet, int index) {
        this._sheet = sheet;
        this._index = index;
    }

    @Override
    public SSheet getSheet() {
        this.checkOrphan();
        return this._sheet;
    }

    @Override
    public int getIndex() {
        this.checkOrphan();
        return this._index;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public AbstractCellAdv getCell(int columnIdx, boolean proxy) {
        AbstractCellAdv cellObj = (AbstractCellAdv)this.cells.get(columnIdx);
        if (cellObj != null) {
            return cellObj;
        }
        this.checkOrphan();
        return proxy ? new CellProxy(this._sheet, this.getIndex(), columnIdx) : null;
    }

    @Override
    AbstractCellAdv getOrCreateCell(int columnIdx) {
        AbstractCellAdv cellObj = (AbstractCellAdv)this.cells.get(columnIdx);
        if (cellObj == null) {
            this.checkOrphan();
            if (columnIdx > this.getSheet().getBook().getMaxColumnIndex()) {
                throw new IllegalStateException("can't create the cell that exceeds max column size " + this.getSheet().getBook().getMaxColumnIndex());
            }
            cellObj = new CellImpl(this, columnIdx);
            this.cells.put(columnIdx, cellObj);
        }
        return cellObj;
    }

    @Override
    public int getStartCellIndex() {
        return this.cells.firstKey();
    }

    @Override
    public int getEndCellIndex() {
        return this.cells.lastKey();
    }

    @Override
    public void clearCell(int start, int end) {
        for (SCell cell : this.cells.subValues(start, end)) {
            ((AbstractCellAdv)cell).destroy();
        }
        this.cells.clear(start, end);
    }

    @Override
    public void insertCell(int cellIdx, int size) {
        if (size <= 0) {
            return;
        }
        this.cells.insert(cellIdx, size);
        int maxSize = this.getSheet().getBook().getMaxColumnSize();
        ArrayList<SCell> exceeds = new ArrayList<SCell>(this.cells.subValues(maxSize, Integer.MAX_VALUE));
        if (exceeds.size() > 0) {
            this.cells.trim(maxSize);
        }
        for (SCell cell : exceeds) {
            ((AbstractCellAdv)cell).destroy();
        }
    }

    @Override
    public void deleteCell(int cellIdx, int size) {
        if (size <= 0) {
            return;
        }
        for (SCell cell : this.cells.subValues(cellIdx, cellIdx + size - 1)) {
            ((AbstractCellAdv)cell).destroy();
        }
        this.cells.delete(cellIdx, size);
    }

    @Override
    public void checkOrphan() {
        if (this._sheet == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        for (SCell cell : this.cells.values()) {
            ((AbstractCellAdv)cell).destroy();
        }
        this._sheet = null;
    }

    @Override
    public SCellStyle getCellStyle() {
        return this.getCellStyle(false);
    }

    @Override
    public SCellStyle getCellStyle(boolean local) {
        if (local || this.cellStyle != null) {
            return this.cellStyle;
        }
        this.checkOrphan();
        return this._sheet.getBook().getDefaultCellStyle();
    }

    @Override
    public void setCellStyle(SCellStyle cellStyle) {
        Validations.argInstance(cellStyle, CellStyleImpl.class);
        this.cellStyle = (CellStyleImpl)cellStyle;
    }

    @Override
    public int getHeight() {
        if (this.height != null) {
            return this.height;
        }
        this.checkOrphan();
        return this.getSheet().getDefaultRowHeight();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public void setHidden(boolean hidden) {
        if (this.hidden == hidden) {
            return;
        }
        this.hidden = hidden;
        SBook book = this._sheet.getBook();
        int col1 = this.getStartCellIndex();
        int col2 = this.getEndCellIndex();
        if (col1 >= 0 && col2 >= 0) {
            boolean includePrecedent = false;
            if (!((AbstractBookAdv)book).isPostProcessing()) {
                ModelUpdateUtil.handlePrecedentUpdate(book.getBookSeries(), new RefImpl(book.getBookName(), this._sheet.getSheetName(), this.getIndex(), col1, this.getIndex(), col2), false);
            }
        }
    }

    @Override
    public boolean isCustomHeight() {
        return this.customHeight;
    }

    @Override
    public void setCustomHeight(boolean custom) {
        this.customHeight = custom;
    }

    @Override
    public Iterator<SCell> getCellIterator(boolean reverse) {
        return Collections.unmodifiableCollection(reverse ? this.cells.descendingValues() : this.cells.values()).iterator();
    }

    @Override
    public Iterator<SCell> getCellIterator(boolean reverse, int start, int end) {
        return Collections.unmodifiableCollection(reverse ? this.cells.descendingSubValues(start, end) : this.cells.subValues(start, end)).iterator();
    }

    @Override
    void setIndex(int newidx) {
        int oldIdx = this._index;
        this._index = newidx;
        for (SCell cell : this.cells.values()) {
            ((AbstractCellAdv)cell).setRow(oldIdx, this);
        }
    }

    @Override
    void moveCellTo(AbstractRowAdv target, int start, int end, int offset) {
        if (!(target instanceof RowImpl)) {
            throw new IllegalStateException("not RowImpl, is " + target);
        }
        if (this.getSheet() != target.getSheet()) {
            throw new IllegalStateException("not in the same sheet");
        }
        if (target != this) {
            Collection<SCell> toReplace = ((RowImpl)target).cells.clear(start + offset, end + offset);
            for (SCell cell : toReplace) {
                ((AbstractCellAdv)cell).destroy();
            }
        }
        Collection<SCell> toMove = this.cells.clear(start, end);
        int oldRowIdx = this.getIndex();
        for (SCell cell : toMove) {
            int newidx = cell.getColumnIndex() + offset;
            SCell old = ((RowImpl)target).cells.put(newidx, cell);
            ((AbstractCellAdv)cell).setIndex(newidx);
            ((AbstractCellAdv)cell).setRow(oldRowIdx, target);
            if (old == null) continue;
            ((AbstractCellAdv)old).destroy();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row:").append(this.getIndex()).append(this.cells.keySet());
        return sb.toString();
    }

    @Override
    AbstractRowAdv cloneRow(AbstractSheetAdv sheet) {
        return this.cloneRow(sheet, null);
    }

    @Override
    public Iterator<SCell> getCellIterator() {
        return Collections.unmodifiableCollection(this.cells.values()).iterator();
    }

    @Override
    AbstractRowAdv cloneRow(AbstractSheetAdv sheet, SBook tgtBook) {
        RowImpl tgt = new RowImpl(sheet, this._index);
        for (SCell cell : this.cells.values()) {
            tgt.cells.put(cell.getColumnIndex(), ((CellImpl)cell).cloneCell(tgt, sheet));
        }
        AbstractCellStyleAdv style = this.cellStyle;
        tgt.cellStyle = (AbstractCellStyleAdv)(style == null ? null : style.cloneCellStyle(tgtBook));
        tgt.height = this.height;
        tgt.hidden = this.hidden;
        tgt.customHeight = this.customHeight;
        return tgt;
    }
}

