/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SComment;
import io.keikai.model.SHyperlink;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractColumnArrayAdv;
import io.keikai.model.impl.AbstractRowAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.CellValue;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.FormulaExpression;
import java.lang.ref.WeakReference;
import java.util.Locale;
import org.zkoss.poi.ss.formula.eval.ValueEval;

class CellProxy
extends AbstractCellAdv {
    private static final long serialVersionUID = 1L;
    private WeakReference<AbstractSheetAdv> _sheetRef;
    private int _rowIdx;
    private int _columnIdx;
    AbstractCellAdv _proxy;

    public CellProxy(AbstractSheetAdv sheet, int row, int column) {
        this._sheetRef = new WeakReference<AbstractSheetAdv>(sheet);
        this._rowIdx = row;
        this._columnIdx = column;
    }

    @Override
    public SSheet getSheet() {
        if (this._proxy != null) {
            return this._proxy.getSheet();
        }
        AbstractSheetAdv sheet = (AbstractSheetAdv)this._sheetRef.get();
        if (sheet == null) {
            throw new IllegalStateException("proxy sheet target lost, you should't keep this instance");
        }
        return sheet;
    }

    private void loadProxy() {
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getCell(this._rowIdx, this._columnIdx, false);
        }
    }

    @Override
    public boolean isNull() {
        this.loadProxy();
        if (this._proxy == null) {
            return true;
        }
        return this._proxy.isNull();
    }

    @Override
    public SCell.CellType getType() {
        this.loadProxy();
        if (this._proxy == null) {
            return SCell.CellType.BLANK;
        }
        return this._proxy.getType();
    }

    @Override
    public int getRowIndex() {
        this.loadProxy();
        return this._proxy == null ? this._rowIdx : this._proxy.getRowIndex();
    }

    @Override
    public int getColumnIndex() {
        this.loadProxy();
        return this._proxy == null ? this._columnIdx : this._proxy.getColumnIndex();
    }

    @Override
    public void setFormulaValue(String formula) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
            this._proxy.setFormulaValue(formula);
        } else if (this._proxy != null) {
            this._proxy.setFormulaValue(formula);
        }
    }

    @Override
    public void setFormulaValue(String formula, Locale locale) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
            this._proxy.setFormulaValue(formula, locale);
        } else if (this._proxy != null) {
            this._proxy.setFormulaValue(formula, locale);
        }
    }

    @Override
    public void setValue(Object value) {
        this.loadProxy();
        if (this._proxy == null && value != null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
            this._proxy.setValue(value);
        } else if (this._proxy != null) {
            this._proxy.setValue(value);
        }
    }

    @Override
    protected void setValue(Object value, boolean aString) {
        this.loadProxy();
        if (this._proxy == null && value != null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
            this._proxy.setValue(value, aString);
        } else if (this._proxy != null) {
            this._proxy.setValue(value, aString);
        }
    }

    @Override
    public Object getValue() {
        this.loadProxy();
        if (this._proxy == null) {
            return null;
        }
        return this._proxy.getValue();
    }

    @Override
    public String getReferenceString() {
        this.loadProxy();
        return this._proxy == null ? new CellRegion(this._rowIdx, this._columnIdx).getReferenceString() : this._proxy.getReferenceString();
    }

    @Override
    public SCellStyle getCellStyle() {
        return this.getCellStyle(false);
    }

    @Override
    public SCellStyle getCellStyle(boolean local) {
        AbstractColumnArrayAdv carr;
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getCellStyle(local);
        }
        if (local) {
            return null;
        }
        AbstractSheetAdv sheet = (AbstractSheetAdv)this.getSheet();
        AbstractRowAdv row = sheet.getRow(this._rowIdx, false);
        SCellStyle style = null;
        if (row != null) {
            style = row.getCellStyle(true);
        }
        if (style == null && (carr = (AbstractColumnArrayAdv)sheet.getColumnArray(this._columnIdx)) != null) {
            style = carr.getCellStyle(true);
        }
        if (style == null) {
            style = sheet.getBook().getDefaultCellStyle();
        }
        return style;
    }

    @Override
    public void setCellStyle(SCellStyle cellStyle) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
        }
        this._proxy.setCellStyle(cellStyle);
    }

    @Override
    public SCell.CellType getFormulaResultType() {
        this.loadProxy();
        return this._proxy == null ? null : this._proxy.getFormulaResultType();
    }

    @Override
    public void clearValue() {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.clearValue();
        }
    }

    @Override
    public void clearFormulaResultCache() {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.clearFormulaResultCache();
        }
    }

    @Override
    protected void evalFormula() {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.evalFormula();
        }
    }

    @Override
    protected Object getValue(boolean eval) {
        this.loadProxy();
        return this._proxy == null ? null : this._proxy.getValue(eval);
    }

    @Override
    public void destroy() {
        throw new IllegalStateException("never link proxy object and call it's release");
    }

    @Override
    public void checkOrphan() {
    }

    @Override
    public SHyperlink getHyperlink() {
        this.loadProxy();
        return this._proxy == null ? null : this._proxy.getHyperlink();
    }

    @Override
    public void setHyperlink(SHyperlink hyperlink) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
        }
        this._proxy.setHyperlink(hyperlink);
    }

    @Override
    public SComment getComment() {
        this.loadProxy();
        return this._proxy == null ? null : this._proxy.getComment();
    }

    @Override
    public void setComment(SComment comment) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._rowIdx).getOrCreateCell(this._columnIdx);
        }
        this._proxy.setComment(comment);
    }

    @Override
    public boolean isFormulaParsingError() {
        this.loadProxy();
        return this._proxy == null ? false : this._proxy.isFormulaParsingError();
    }

    @Override
    void setIndex(int newidx) {
        throw new UnsupportedOperationException("readonly");
    }

    @Override
    void setRow(int oldRowIdx, AbstractRowAdv row) {
        throw new UnsupportedOperationException("readonly");
    }

    @Override
    protected Ref getRef() {
        return new RefImpl(this);
    }

    @Override
    AbstractCellAdv cloneCell(AbstractRowAdv row) {
        if (this._proxy == null) {
            return new CellProxy((AbstractSheetAdv)row.getSheet(), row.getIndex(), this.getColumnIndex());
        }
        return this._proxy.cloneCell(row);
    }

    @Override
    public void setFormulaResultValue(ValueEval value) {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.setFormulaResultValue(value);
        }
    }

    @Override
    public void deleteComment() {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.deleteComment();
        }
    }

    @Override
    public FormulaExpression getFormulaExpression() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getFormulaExpression();
        }
        return null;
    }

    @Override
    public void setTextHeight(int height) {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.setTextHeight(height);
        }
    }

    @Override
    public int getTextHeight() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getTextHeight();
        }
        return this.getSheet().getDefaultRowHeight();
    }

    @Override
    public boolean isCalcAutoHeight() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.isCalcAutoHeight();
        }
        return false;
    }

    @Override
    public void setCalcAutoHeight(boolean b) {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.setCalcAutoHeight(b);
        }
    }

    @Override
    public void setTextWidth(int width) {
        this.loadProxy();
        if (this._proxy != null) {
            this._proxy.setTextWidth(width);
        }
    }

    @Override
    public int getTextWidth() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getTextWidth();
        }
        return -1;
    }

    @Override
    AbstractCellAdv cloneCell(AbstractRowAdv row, SSheet sheet) {
        if (!this.isNull()) {
            return this._proxy.cloneCell(row, sheet);
        }
        return null;
    }

    @Override
    public CellValue getEvalCellValue(boolean evaluatedVal) {
        this.loadProxy();
        if (this._proxy == null) {
            return new CellValue();
        }
        return this._proxy.getEvalCellValue(evaluatedVal);
    }
}

