/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractRowAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;

class RowProxy
extends AbstractRowAdv {
    private static final long serialVersionUID = 1L;
    private final WeakReference<AbstractSheetAdv> _sheetRef;
    private final int _index;
    AbstractRowAdv _proxy;

    public RowProxy(AbstractSheetAdv sheet, int index) {
        this._sheetRef = new WeakReference<AbstractSheetAdv>(sheet);
        this._index = index;
    }

    @Override
    public SSheet getSheet() {
        AbstractSheetAdv sheet = (AbstractSheetAdv)this._sheetRef.get();
        if (sheet == null) {
            throw new IllegalStateException("proxy target lost, you should't keep this instance");
        }
        return sheet;
    }

    protected void loadProxy() {
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getRow(this._index, false);
        }
    }

    @Override
    public int getIndex() {
        this.loadProxy();
        return this._proxy == null ? this._index : this._proxy.getIndex();
    }

    @Override
    public boolean isNull() {
        this.loadProxy();
        return this._proxy == null ? true : this._proxy.isNull();
    }

    @Override
    public int getStartCellIndex() {
        this.loadProxy();
        return this._proxy == null ? -1 : this._proxy.getStartCellIndex();
    }

    @Override
    public int getEndCellIndex() {
        this.loadProxy();
        return this._proxy == null ? -1 : this._proxy.getEndCellIndex();
    }

    @Override
    public SCellStyle getCellStyle() {
        return this.getCellStyle(false);
    }

    @Override
    public SCellStyle getCellStyle(boolean local) {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getCellStyle(local);
        }
        return local ? null : this.getSheet().getBook().getDefaultCellStyle();
    }

    @Override
    public void setCellStyle(SCellStyle cellStyle) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._index);
        }
        this._proxy.setCellStyle(cellStyle);
    }

    @Override
    public AbstractCellAdv getCell(int columnIdx, boolean proxy) {
        throw new UnsupportedOperationException("readonly");
    }

    @Override
    AbstractCellAdv getOrCreateCell(int columnIdx) {
        throw new UnsupportedOperationException("readonly");
    }

    @Override
    void clearCell(int start, int end) {
        throw new UnsupportedOperationException("readonly");
    }

    @Override
    void insertCell(int start, int size) {
        throw new UnsupportedOperationException("readonly");
    }

    @Override
    void deleteCell(int start, int size) {
        throw new UnsupportedOperationException("readonly");
    }

    @Override
    public void destroy() {
        throw new IllegalStateException("never link proxy object and call it's release");
    }

    @Override
    public void checkOrphan() {
    }

    @Override
    public int getHeight() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getHeight();
        }
        return this.getSheet().getDefaultRowHeight();
    }

    @Override
    public boolean isHidden() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.isHidden();
        }
        return false;
    }

    @Override
    public void setHeight(int width) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._index);
        }
        this._proxy.setHeight(width);
    }

    @Override
    public void setHidden(boolean hidden) {
        this.loadProxy();
        if (this._proxy == null) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrCreateRow(this._index);
        }
        this._proxy.setHidden(hidden);
    }

    @Override
    public boolean isCustomHeight() {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.isCustomHeight();
        }
        return false;
    }

    @Override
    public void setCustomHeight(boolean custom) {
        this.loadProxy();
        this._proxy.setCustomHeight(custom);
    }

    @Override
    public Iterator<SCell> getCellIterator(boolean reverse) {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getCellIterator(reverse);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    void setIndex(int newidx) {
        throw new UnsupportedOperationException("readonly");
    }

    @Override
    void moveCellTo(AbstractRowAdv target, int start, int end, int offset) {
        throw new UnsupportedOperationException("readonly");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row:").append(this.getIndex());
        return sb.toString();
    }

    @Override
    AbstractRowAdv cloneRow(AbstractSheetAdv sheet) {
        if (this._proxy == null) {
            return new RowProxy(sheet, this._index);
        }
        return this._proxy.cloneRow(sheet);
    }

    @Override
    public Iterator<SCell> getCellIterator(boolean reverse, int start, int end) {
        this.loadProxy();
        if (this._proxy != null) {
            return this._proxy.getCellIterator(reverse, start, end);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public Iterator<SCell> getCellIterator() {
        return this.getCellIterator(false);
    }

    @Override
    AbstractRowAdv cloneRow(AbstractSheetAdv sheet, SBook book) {
        if (!this.isNull()) {
            return this._proxy.cloneRow(sheet, book);
        }
        return null;
    }
}

