/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SBook;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SConditionalFormattingRule;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.ConditionalFormattingRuleImpl;
import io.keikai.model.impl.ConditionalRefImpl;
import io.keikai.model.impl.ModelUpdateUtil;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.impl.SheetImpl;
import io.keikai.model.impl.sys.DependencyTableAdv;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.util.Validations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ConditionalFormattingImpl
implements SConditionalFormatting,
Serializable {
    private static final long serialVersionUID = -2075561905182660069L;
    private SSheet _sheet;
    private LinkedHashSet<CellRegion> _regions;
    private List<SConditionalFormattingRule> rules;
    private int _id;

    public ConditionalFormattingImpl(SSheet sheet) {
        this._sheet = sheet;
        this._id = ((SheetImpl)sheet).nextConditionalId();
    }

    @Override
    public SSheet getSheet() {
        return this._sheet;
    }

    @Override
    public Set<CellRegion> getRegions() {
        return this._regions;
    }

    @Override
    public List<SConditionalFormattingRule> getRules() {
        return this.rules;
    }

    public void addRule(SConditionalFormattingRule rule) {
        if (this.rules == null) {
            this.rules = new ArrayList<SConditionalFormattingRule>();
        }
        this.rules.add(rule);
    }

    private Ref getRef() {
        return new ConditionalRefImpl(this);
    }

    @Override
    public void addRegion(CellRegion region) {
        Validations.argNotNull(region);
        if (this._regions == null) {
            this._regions = new LinkedHashSet(2);
        }
        for (CellRegion regn : this._regions) {
            if (!regn.contains(region)) continue;
            return;
        }
        this._regions.add(region);
        Ref dependent = this.getRef();
        SBook book = this._sheet.getBook();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        Ref rgnRef = this.newDummyRef(this._sheet.getSheetName(), region);
        dt.add(dependent, rgnRef);
        dt.add(rgnRef, dependent);
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    @Override
    public void removeRegion(CellRegion region) {
        Validations.argNotNull(region);
        if (this._regions == null || this._regions.isEmpty()) {
            return;
        }
        ArrayList<CellRegion> newRegions = new ArrayList<CellRegion>();
        ArrayList<CellRegion> delRegions = new ArrayList<CellRegion>();
        CellRegion leftop = (CellRegion)this._regions.iterator().next();
        for (CellRegion cellRegion : this._regions) {
            if (!cellRegion.overlaps(region)) continue;
            List<CellRegion> diff = cellRegion.diff(region);
            newRegions.addAll(diff);
            delRegions.add(cellRegion);
        }
        if (newRegions.isEmpty() && delRegions.isEmpty()) {
            return;
        }
        for (CellRegion cellRegion : delRegions) {
            this._regions.remove(cellRegion);
        }
        for (CellRegion cellRegion : newRegions) {
            this._regions.add(cellRegion);
        }
        if (this._regions.isEmpty()) {
            this._regions = null;
        }
        CellRegion target = null;
        if (this._regions != null) {
            for (CellRegion diff0 : this._regions) {
                if (target == null) {
                    target = diff0;
                    continue;
                }
                if (diff0.row < target.row) {
                    target = diff0;
                    continue;
                }
                if (diff0.row != target.row || diff0.column >= target.column) continue;
                target = diff0;
            }
        }
        int n = target == null ? 0 : target.row - leftop.row;
        int colOff = target == null ? 0 : target.column - leftop.column;
        String sheetName = this._sheet.getSheetName();
        Ref dependent = this.getRef();
        SBook book = this._sheet.getBook();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        dt.clearDependents(dependent);
        for (CellRegion regn : delRegions) {
            dt.del(this.newDummyRef(sheetName, regn), dependent);
        }
        for (SConditionalFormattingRule rule : this.getRules()) {
            rule.shiftFormulas(n, colOff);
            rule.clearFormulaResultCache();
        }
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private Ref newDummyRef(String sheetName, CellRegion regn) {
        return new RefImpl(this._sheet.getBook().getBookName(), sheetName, regn.row, regn.column, regn.lastRow, regn.lastColumn);
    }

    @Override
    public void renameSheet(String oldName, String newName) {
        Validations.argNotNull(oldName);
        Validations.argNotNull(newName);
        if (oldName.equals(newName)) {
            return;
        }
        for (SConditionalFormattingRule rule : this.getRules()) {
            Ref dependent = ((ConditionalFormattingRuleImpl)rule).getRef(oldName);
            SBook book = this._sheet.getBook();
            DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
            Set<Ref> precedents = ((DependencyTableAdv)dt).getDirectPrecedents(dependent);
            if (precedents != null && this._regions != null) {
                for (CellRegion regn : this._regions) {
                    precedents.remove(this.newDummyRef(oldName, regn));
                }
            }
            dt.clearDependents(dependent);
            dependent = ((ConditionalFormattingRuleImpl)rule).getRef(newName);
            if (this._regions != null) {
                for (CellRegion regn : this._regions) {
                    dt.add(dependent, this.newDummyRef(newName, regn));
                }
            }
            if (precedents == null) continue;
            for (Ref precedent : precedents) {
                dt.add(dependent, precedent);
            }
        }
    }

    @Override
    public void destroy() {
        for (SConditionalFormattingRule rule : this.getRules()) {
            rule.destroy();
        }
        this._sheet = null;
    }

    @Override
    public void copyFrom(SConditionalFormatting src, int rowOff, int colOff) {
        Validations.argInstance(src, ConditionalFormattingImpl.class);
        ConditionalFormattingImpl srcImpl = (ConditionalFormattingImpl)src;
        for (SConditionalFormattingRule rule : src.getRules()) {
            this.addConditionalFormattingRule(rule, rowOff, colOff);
        }
    }

    @Override
    public void setRegions(Set<CellRegion> regions) {
        this._regions = new LinkedHashSet(regions.size() * 4 / 3 + 1);
        for (CellRegion rgn : regions) {
            this.addRegion(rgn);
        }
    }

    public SConditionalFormattingRule addConditionalFormattingRule(SConditionalFormattingRule src, int rowOff, int colOff) {
        Validations.argInstance(src, ConditionalFormattingRuleImpl.class);
        ConditionalFormattingRuleImpl dstrule = new ConditionalFormattingRuleImpl(this);
        this.addRule(dstrule);
        if (src != null) {
            dstrule.copyFrom((ConditionalFormattingRuleImpl)src, rowOff, colOff);
        }
        return dstrule;
    }

    @Override
    public int getId() {
        return this._id;
    }

    @Override
    public void clearFormulaResultCache() {
        for (SConditionalFormattingRule rule : this.getRules()) {
            rule.clearFormulaResultCache();
        }
    }
}

