/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.List;
import org.zkoss.poi.hssf.model.RecordStream;
import org.zkoss.poi.hssf.record.AutoFilter12Record;
import org.zkoss.poi.hssf.record.AutoFilterInfoRecord;
import org.zkoss.poi.hssf.record.AutoFilterRecord;
import org.zkoss.poi.hssf.record.ContinueFrt12Record;
import org.zkoss.poi.hssf.record.Record;
import org.zkoss.poi.hssf.record.aggregates.RecordAggregate;

public class AutoFilterInfoRecordAggregate
extends RecordAggregate {
    private final List<Record> records = new ArrayList<Record>();

    public AutoFilterInfoRecordAggregate() {
    }

    public AutoFilterInfoRecordAggregate(RecordStream rs) {
        this();
        if (rs.peekNextSid() == 157) {
            this.records.add(rs.getNext());
            while (rs.peekNextSid() == 158 || rs.peekNextSid() == 2175 || rs.peekNextSid() == 2174) {
                this.records.add(rs.getNext());
            }
        }
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        int nItems = this.records.size();
        if (nItems < 1) {
            return;
        }
        for (int i = 0; i < nItems; ++i) {
            rv.visitRecord(this.records.get(i));
        }
    }

    public void setNumEntries(short numEntries) {
        if (this.records.size() == 0) {
            AutoFilterInfoRecord r = new AutoFilterInfoRecord();
            r.setNumEntries(numEntries);
            this.records.add(r);
        } else {
            AutoFilterInfoRecord r = (AutoFilterInfoRecord)this.records.get(0);
            r.setNumEntries(numEntries);
        }
    }

    public List<String> getValuesOfFilter(int column) {
        ArrayList<String> result = new ArrayList<String>();
        int nItems = this.records.size();
        int startPosition = 0;
        boolean found = false;
        for (int i = 0; i < nItems; ++i) {
            AutoFilterRecord afRecord;
            if (!(this.records.get(i) instanceof AutoFilterRecord) || (afRecord = (AutoFilterRecord)this.records.get(i)).getColEntries() != column) continue;
            startPosition = i;
            found = true;
            break;
        }
        found = false;
        if (false) {
            return null;
        }
        if (this.records.get(startPosition + 1) instanceof AutoFilter12Record) {
            AutoFilter12Record af12Record = (AutoFilter12Record)this.records.get(startPosition + 1);
            int count = af12Record.getCCriteria();
            for (int i = 0; i < count; ++i) {
                ContinueFrt12Record cfrt12Record = (ContinueFrt12Record)this.records.get(startPosition + 2 + i);
                result.add(cfrt12Record.getStr());
            }
        } else {
            AutoFilterRecord afRecord = (AutoFilterRecord)this.records.get(startPosition);
            if (afRecord.getStr1() != null) {
                result.add(afRecord.getStr1());
            }
            if (afRecord.getStr2() != null) {
                result.add(afRecord.getStr2());
            }
        }
        return result;
    }
}

