/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractUndoableAction;
import io.keikai.ui.impl.undo.ReserveUtil;

public abstract class AbstractCellDataStyleAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = 8871042158772358009L;
    public static final int RESERVE_CONTENT = 1;
    public static final int RESERVE_STYLE = 2;
    public static final int RESERVE_MERGE = 4;
    public static final int RESERVE_ALL = 7;
    private final int _reserveType;
    ReserveUtil.ReservedResult _oldReserve;
    ReserveUtil.ReservedResult _newReserve;

    public AbstractCellDataStyleAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, boolean wholeColumn, boolean wholeRow, int reserveType) {
        super(label, sheet, row, column, lastRow, lastColumn, wholeColumn, wholeRow);
        this._reserveType = reserveType;
    }

    @Deprecated
    public AbstractCellDataStyleAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, boolean wholeColumn, int reserveType) {
        this(label, sheet, row, column, lastRow, lastColumn, wholeColumn, false, reserveType);
    }

    public AbstractCellDataStyleAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, int reserveType) {
        this(label, sheet, row, column, lastRow, lastColumn, false, false, reserveType);
    }

    protected int getReservedRow() {
        return this._row;
    }

    protected int getReservedColumn() {
        return this._column;
    }

    protected int getReservedLastRow() {
        return this._lastRow;
    }

    protected int getReservedLastColumn() {
        return this._lastColumn;
    }

    protected Sheet getReservedSheet() {
        return this._sheet;
    }

    @Override
    public void doAction() {
        if (this.isSheetProtected()) {
            return;
        }
        int row = this.getReservedRow();
        int column = this.getReservedColumn();
        int lastRow = this.getReservedLastRow();
        int lastColumn = this.getReservedLastColumn();
        Sheet sheet = this.getReservedSheet();
        this._oldReserve = ReserveUtil.reserve(sheet.getInternalSheet(), row, column, lastRow, lastColumn, this._reserveType);
        if (this._newReserve != null) {
            this._newReserve.restore();
            this._newReserve = null;
        } else {
            this.applyAction();
        }
    }

    protected abstract void applyAction();

    @Override
    public boolean isUndoable() {
        return this._oldReserve != null && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public boolean isRedoable() {
        return this._oldReserve == null && this.isSheetAvailable() && !this.isSheetProtected();
    }

    @Override
    public void undoAction() {
        if (this.isSheetProtected()) {
            return;
        }
        int row = this.getReservedRow();
        int column = this.getReservedColumn();
        int lastRow = this.getReservedLastRow();
        int lastColumn = this.getReservedLastColumn();
        Sheet sheet = this.getReservedSheet();
        this._newReserve = ReserveUtil.reserve(sheet.getInternalSheet(), row, column, lastRow, lastColumn, this._reserveType);
        this._oldReserve.restore();
        this._oldReserve = null;
    }

    @Override
    protected boolean isSheetProtected() {
        return super.isSheetProtected() && !Ranges.range(this._sheet).getSheetProtection().isFormatCellsAllowed();
    }
}

